<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 28.08.14

 */
use App\Forms\SubDepartmentForm;
use App\Models\Department;
use App\Models\SubDepartment;


class SubDepartmentController extends Controller
{

    /**
     * Index action
     * @return \Illuminate\View\View
     */
    public function getIndex()
    {
        $department = Department::find(\request("department_id"));
        if (!$department)
        {
            return redirect()->to("department")
                ->with("message", [
                    "text" => "Error occurred while getting department subdivisions",
                    "type" => MESSAGE_DANGER
                ]);
        }
        $subDepartments = $department->subDepartment()
            ->get();

        return view("subdepartment/index", [
            "department"     => $department,
            "subDepartments" => $subDepartments
        ]);
    }

    /**
     * Add action
     * @return \Illuminate\View\View
     */
    public function anyAdd()
    {
        $department = Department::findOrFail(\request("department_id"));

        if ($this->isPostRequest())
        {
            $form = new SubDepartmentForm;
            if ($form->isValidAdd())
            {
                $subDepartment       = new SubDepartment;
                $subDepartment->name = \request("name");
                $subDepartment->lang = createLangString(\request("name"));

                $subDepartment       = $department->subDepartment()
                    ->save($subDepartment);
                return redirect()->to("subdepartment/index?department_id=" . $department->id)
                    ->with("message", [
                        "type" => MESSAGE_SUCCESS,
                        "text" => "New subdivision \"$subDepartment->name\" was successfully saved"
                    ]);
            }
        }
        return view("subdepartment/add", [
            "department" => $department
        ]);
    }

    /**
     * Edit sub Department action
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function anyEdit()
    {
        $subDepartment = SubDepartment::find(\request("id"));
        if ($this->isPostRequest())
        {
            $form = new SubDepartmentForm();
            if ($form->isValidAdd())
            {
                $subDepartment->name = \request("name");
                $subDepartment->lang = createLangString(\request("name"));
                $subDepartment->save();
                return redirect()->to("subdepartment/index?department_id=" . $subDepartment->department_id)
                    ->with("message", [
                        "type" => MESSAGE_SUCCESS,
                        "text" => "Subdivision \"$subDepartment->name\" was successfully updated"
                    ]);
            }
        }
        return view("subdepartment/edit", [
            "subDepartment" => $subDepartment,
            "departmentId"  => $subDepartment->department_id
        ]);
    }

    /**
     * Delete sub department action
     */
    public function getDelete()
    {
        $subDepartment        = SubDepartment::findOrFail(\request("id"));
        $deletedSubDepartment = clone $subDepartment;

        // Audit Deleted
        auditDeleted($subDepartment);
//        $subDepartment->delete();

        return redirect()->to("subdepartment/index?department_id=" . $deletedSubDepartment->department_id)
            ->with("message", [
                "text" => "Subdivision was successfully deleted",
                "type"    => MESSAGE_SUCCESS
            ]);
    }
}
