<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 02.09.14

 */

use App\Forms\StandbyForm;
use App\Models\Airport;
use App\Models\FlightCrew;
use App\Models\Location;
use App\Models\StandbyCrew;
use App\Models\User;
use App\Models\City;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\URL;

class StandbyController extends Controller
{

    /**
     * Render list of standby people
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $fcm = StandbyCrew::with(['user', 'position', 'airport'])
                                ->join("crew__flight", "crew__flight.user_id", "=", "flights__standby_crew.user_id")
                                ->orderBy('start_date', 'DESC')
                                ->get([
                                    "flights__standby_crew.*",
                                ]);

        $ccm = StandbyCrew::with(['user', 'position', 'airport'])
                                ->join("crew__cabin", "crew__cabin.user_id", "=", "flights__standby_crew.user_id")
                                ->orderBy('start_date', 'DESC')
                                ->get([
                                    "flights__standby_crew.*",
                                ]);

        debug($fcm);

        $this->viewData = [
            'fcm'       => $fcm,
            'ccm'       => $ccm,
        ];

        return view("standby/index", $this->viewData);
    }

    /**
     * @param $standby_crew
     * @return \Illuminate\Http\RedirectResponse
     */
    public function delete($standby_crew){

        $fCrew = FlightCrew::where('flights_standby_crew_id', $standby_crew->id)
                            ->get();
        // Audit Deleted
        auditDeleted($fCrew);

        // Audit Deleted
        auditDeleted($standby_crew);
//        $standby_crew->delete();

        return redirect()->to("standby")
            ->with("message", [
                "type" => MESSAGE_SUCCESS,
                "text" => "Standby Crew Was Successfully Deleted"
            ]);

    }

    /**
     * @param Request $request
     * @param $standby_crew
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function edit(Request $request, $standby_crew){

        if ($this->isPostRequest()){
            $userId = $request->get("user_id");
            $standby_crew->user_id     = $userId;
            $standby_crew->position_id = User::find($userId)->position[0]->id;
            $standby_crew->start_date  = $request->get("start_date");
            $standby_crew->end_date    = $request->get("end_date");
            $standby_crew->airport_id  = $request->get("airport_id");
            $standby_crew->save();

            FlightCrew::deleteStandbyCrew($standby_crew->id);
            FlightCrew::saveStandbyCrew($standby_crew);

            return redirect()->to("standby")
                ->with("message", [
                    "type" => MESSAGE_SUCCESS,
                    "text" => "Standby Crew Was Successfully Edited"
                ]);
        }

        $crewType = User::getSpecificCrewType($standby_crew->user_id);

        $this->viewData = [
           'start_date'  => $standby_crew->start_date,
           'end_date'    => $standby_crew->end_date,
           'airport'     => $standby_crew->airport_id,
           'crew'        => $standby_crew->user_id,
           'airports'    => ["" => "Select"] + Location::locationAirports(),
        ];

        switch($crewType){
            case CAPTAIN:
                $this->viewData["crewList"] = ["" => "Select Captain"] + User::getFlightCrewList(CAPTAIN);
                $this->viewData["crewType"] = 'Captain';
                break;
            case FIRST_OFFICER:
                $this->viewData["crewList"] = ["" => "Select First Officer"] + User::getFlightCrewList(FIRST_OFFICER);
                $this->viewData["crewType"] = 'First Officer';
                break;
            case ($crewType == CABIN_CREW || $crewType == PURSER):
                $this->viewData["crewList"] = ["" => "Select Flight Attendant"] + User::getCabinCrewList();
                $this->viewData["crewType"] = 'Cabin Crew';
                break;
        }

        return view('standby.edit', $this->viewData);
    }

    /**
     * @param Request $request
     * @return $this|\Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function addFcm(Request $request)
    {
        if ($this->isPostRequest()) {

            $url = URL::full();

            $form = new StandbyForm();

            if ($form->isValidAddCaptainAndFirstOfficer()) {

                if ($request->get("captain_id")) {
                    $standbyCaptain = new StandbyCrew;
                    $standbyCaptain->user_id = $request->get("captain_id");
                    $standbyCaptain->position_id = USER_CAPTAIN_POSITION_ID;
                    $standbyCaptain->start_date = $request->get("start_date");
                    $standbyCaptain->end_date = $request->get("end_date");
                    $standbyCaptain->airport_id = $request->get("airport_id");
                    $standbyCaptain->created_by = Auth::user()->id;
                    $standbyCaptain->save();
                    FlightCrew::saveStandbyCrew($standbyCaptain);
                }

                if ($request->get("first_officer_id")) {
                    $standbyFirstOfficer = new StandbyCrew;
                    $standbyFirstOfficer->user_id = $request->get("first_officer_id");
                    $standbyFirstOfficer->position_id = USER_FIRST_OFFICER_POSITION_ID;
                    $standbyFirstOfficer->start_date = $request->get("start_date");
                    $standbyFirstOfficer->end_date = $request->get("end_date");
                    $standbyFirstOfficer->airport_id = $request->get("airport_id");
                    $standbyFirstOfficer->created_by = Auth::user()->id;
                    $standbyFirstOfficer->save();
                    FlightCrew::saveStandbyCrew($standbyFirstOfficer);
                }

                return redirect()->to("standby")
                    ->with("message", [
                        "type" => MESSAGE_SUCCESS,
                        "text" => "Standby Flight Crew Was Successfully Added"
                    ]);
            }

            return redirect()->to($url)
                ->withInput()
                ->withErrors($form->getErrors());
        }

        $user = new User();
        return view("standby/add-fcm", [
            "captains"      => ["" => "Select Captain"] + User::getFlightCrew(FCM_CP_CREW),
            "firstOfficers" => ["" => "Select First Officer"] + User::getFlightCrew(FCM_FO_CREW),
            "location"      => Location::locationAirports()
        ]);

    }

    /**
     * @param Request $request
     * @return $this|\Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function addCcm(Request $request)
    {
        if ($this->isPostRequest()) {
            $form = new StandbyForm();
            $url = URL::full();
            if ($form->isValidAddCabinCrew()) {
                $userId = $request->get("flight_attendant_id");
                $user = User::find($userId);

                if (!$user) {
                    return redirect()->to($url)
                        ->withInput()
                        ->withErrors(['User Not Found']);
                }
                // Get User Position
                $positionId = $user->position[0]->id;

                $cabinCrew = new StandbyCrew;
                $cabinCrew->user_id = $userId;
                $cabinCrew->position_id = $positionId;
                $cabinCrew->start_date = $request->get("start_date");
                $cabinCrew->end_date = $request->get("end_date");
                $cabinCrew->airport_id = $request->get("airport_id");
                $cabinCrew->created_by = Auth::user()->id;
                $cabinCrew->save();

                FlightCrew::saveStandbyCrew($cabinCrew);

                return redirect()->to("standby")
                    ->with("message", [
                        "type" => MESSAGE_SUCCESS,
                        "text" => "Standby Cabin Crew Was Successfully Added"
                    ]);
            }

            return redirect()->to($url)
                ->withInput()
                ->withErrors($form->getErrors());
        }

        $user = new User();
        return view("standby/add-ccm", [
            "flightAttendants"  => ["" => "Select Flight Attendant"] + User::getFlightCrew(CCM_CREW),
            "location"          => Location::locationAirports()
        ]);
    }
}
