<?php namespace App\Http\Controllers;

use App\Classes\FlightStaff\StaffFilter;
use App\Classes\FlightStaff\StaffFilterWatch;
use App\Models\AircraftType;
use App\Models\Airline;
use App\Models\AirlineService;
use App\Models\FlightStaff;
use App\Models\Location;
use App\Models\Service;
use App\Models\StaffAirline;
use App\Models\StaffStation;
use App\Models\User;
use App\Models\UserHistory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Flight;
use App\Models\Aircraft;
use App\Models\FlightNumber;
use App\Models\Delay;
use App\Models\Airport;
use App\Models\FlightType;
use Jenssegers\Agent\Agent;

class StaffWatchController extends Controller
{
    const MAX_EXECUTION_TIME = 60;

    static function emptyFlights($staffAirlines = null, $staffAirports = null){
        if (ghaModule()){

            if (!$staffAirlines){
                $staffAirlines = StaffAirline::currentStaffAirlinesList();
            }

            if (!$staffAirports){
                $staffAirports = StaffStation::currentStaffStationsList();
            }

            if (!count($staffAirports) || !count($staffAirlines)){
                return true;
            }
        }
        return false;
    }

    public function index(Request $request)
    {
        $date = time();
        $airlineModule = airlineModule();

        $selectedAirportIds = Airport::getSelectedAirportIds($request);
        $selectedAirlineIds = Airline::getSelectedAirlineIds($request);

        $staffAirlines = StaffAirline::currentStaffAirlinesList();
        $staffAirports = StaffStation::currentStaffStationsList();
//        $selectedAirlineIds = $request->get("airline_id") ? $request->get("airline_id") : ($request->get("airline_ids") ? $request->get("airline_ids") : $staffAirlines);

        $selectedAirportIds = (!$selectedAirportIds || !count($selectedAirportIds)) ? (isset($staffAirports[0]) ? $staffAirports[0] : null) : $selectedAirportIds[0];

        $emptyFlights = self::emptyFlights($staffAirlines, $staffAirports);

//        }
//        else{
//            $selectedAirline = $request->get("go_to_airline_id");
//            $selectedAirport = $request->get("go_to_airport_id");
//        }

        if ($request->has("start_time") && $request->has("end_time") && $request->get("start_time") && $request->get("end_time"))
        {
            $timelineStart = $startDate = date("Y-m-d", strtotime("-14 hours", strtotime($request->get("start_time"))));
            $timelineEnd   = $endDate   = date("Y-m-d", strtotime("+14 hours", strtotime($request->get("end_time"))));
        }
        elseif ($request->has("go_to_date") || $request->has("airline_id"))
        {
            $date = $request->get("go_to_date") ? strtotime($request->get("go_to_date")." 12:00:00") : strtotime(date("Y-m-d H:i:s"));

            $startDate = date("Y-m-d H:i:s", strtotime("-14 hours", $date));
            $endDate   = date("Y-m-d H:i:s", strtotime("+14 hours", $date));

            if (strtotime($request->get("go_to_date")) == strtotime(date("Y-m-d"))){
                $now = strtotime("now");
                $timelineStart = date("Y-m-d H:i:s", strtotime("- 6 hours", $now));
                $timelineEnd = date("Y-m-d H:i:s", strtotime("+ 6 hours", $now));
            }
            else {
                $timelineStart = $request->get("go_to_date")." 06:00:00";
                $timelineEnd = $request->get("go_to_date")." 18:00:00";
            }

//            debug($startDate." - ".$endDate);
//            debug("TIMELINE: ".$timelineStart." - ".$timelineEnd);

            $flightTables = [
                DEPARTURE   => null,
                ARRIVAL     => null,
                ALL         => null,
            ];

            if ($emptyFlights){
                $flights = $jsonData = [];

            }
            else {
                list ($jsonData, $flights) = self::getStaffFlightsByLocation($request, $timelineStart, $timelineEnd, $startDate, $endDate,
                    $staffAirlines, $staffAirports, $selectedAirlineIds, $selectedAirportIds);
            }

            // Get JSON Ready
            return response()->json([
                "start_visible_period"  => $timelineStart,
                "end_visible_period"    => $timelineEnd,
                "jsonData"              => $jsonData,
                "flights"               => $flights,
                "flightTables"          => $flightTables,
                "success"               => TRUE
            ]);
        }
        else {
            $timelineStart = $startDate = date("Y-m-d H:i:s", strtotime("-6 hours", $date));
            $timelineEnd   = $endDate   = date("Y-m-d H:i:s", strtotime("+6 hours", $date));
        }

        debug($startDate." - ".$endDate);

        if ($emptyFlights){
            $flights = $jsonData = [];

            $flightsOPS = [
                DEPARTURE   => null,
                ARRIVAL     => null,
                ALL         => null,
            ];
        }
        else {
            list ($jsonData, $flights) = self::getStaffFlightsByLocation($request, $timelineStart, $timelineEnd, $startDate, $endDate,
                $staffAirlines, $staffAirports, $selectedAirlineIds, $selectedAirportIds);
        }

        // Aircraft List
        $aircraftList = Aircraft::getList();
        // AC Type List
        $aircraftTypeList = AircraftType::getList();

        $agent = new Agent();
        $isMobile = $agent->isMobile();

        $flightNumbersObj = FlightNumber::getArrayFlightNumbersWithSector(false, false, false, null, true);

        $flightNumbers = [];
        foreach ($flightNumbersObj as $each) {
            $flightNumbers[$each->id] = $each->sector;
        }

        $this->viewData = [
            "sla"                       => Service::where("display", 1)->orderBy("abbr")->pluck("abbr")->all(),
            "airlineModule"             => $airlineModule,
            "airlineName"               => env(AIRLINE),

            "isMobile"                  => $isMobile,
            "staffAirlines"             => $staffAirlines,
            "staffStations"             => $staffAirports,

            "flightsOPS"                => isset($flightsOPS) ? $flightsOPS : null, //->sortBy("std")->all(),

//            "flightsOPSYesterday"       => Flight::handlingFlightsRange($startDate, date("Y-m-d", strtotime($startDate))." 23:59:59", $selectedAirline, $selectedAirport),
//            "flightsOPSToday"           => Flight::handlingFlightsRange(date("Y-m-d"). " 00:00:00", date("Y-m-d")." 23:59:59", $selectedAirline, $selectedAirport),
//            "flightsOPSTomorrow"        => Flight::handlingFlightsRange(date("Y-m-d", strtotime($endDate))." 00:00:00", $endDate, $selectedAirline, $selectedAirport),

            "json"                      => json_encode($jsonData),

//            "supCrew"                   => $supCrew->listModelVariable(['type', 'id'], true),
            "handlingAirports"          => Airport::getHandlingStations($airlineModule ? "icao" : "iata", "id"),
            "handlingAirlines"          => Airline::listHandlingAirlines("picture", "id"),
            "selectedAirportIds"        => $selectedAirportIds,

            "airlines"            => StaffAirline::currentStaffAirlinesList(NAME_IATA),
            "locationsAirports"   => Airport::listHandlingAirports($selectedAirlineIds),
            "flights"             => $flights,
            "flightTypes"         => ["" => "Select"] + FlightType::pluck('type', 'id')->all(),
            "airports"            => Airport::listAirportsWithCode(),
            "diversionAirports"   => Airport::listDiversionAirportsWithCode(),
            "aircraft"            => ["" => "Select Aircraft"] + $aircraftList,
            "aircraftTypes"       => ["" => "Select AC Type"] + $aircraftTypeList,
            "delays"              => Delay::GetDelayWithAirlineList(),
            "reasons"             => ['' => "Select", 'head_order' => 'Head Order', 'roster_not_received' => 'Roster Not Received', 'sick' => 'Sick', 'no_show' => 'No Show'],

//            "flightNumbers"       => ["" => "Select Flight Number"] + FlightNumber::getArrayFlightNumbersWithSector(),
            "flightNumbers"       => ["" => "Select Flight Number"] + $flightNumbers,

            "flightNumbersObj"    => $flightNumbersObj,
            "aircraftByAirline"   => Aircraft::getAircraftByAirline($selectedAirlineIds),
            "acTypesByAirline"    => AircraftType::byAirline($selectedAirlineIds),
            "aircraftByType"      => Aircraft::byType($selectedAirlineIds),

            "captains"            => ["" => "Select Captain"] + User::getFlightCrew(FCM_CP_CREW),
            "firstOfficers"       => ["" => "Select First Officer"] + User::getFlightCrew(FCM_FO_CREW),
            "cabinCrew"           => ["" => "Select Flight Attendant"] + User::getFlightCrew(CCM_CREW),
        ];

        if (airlineModule()){
            $this->viewData["staff"]  = User::listUsers();
        }
        else {
            $this->viewData["staff"] = User::listUsers(false);
        }

        return view("staff-watch/index", $this->viewData);
    }

    static function airlineFilterSelected($staffAirlines = [], $selectedAirlineIds = []){

        if ($staffAirlines && is_array($staffAirlines)) {
            sort($staffAirlines);
        }

        if ($selectedAirlineIds && is_array($selectedAirlineIds)){
            sort($selectedAirlineIds);
        }

        debug($staffAirlines);
        debug($selectedAirlineIds);
        return $staffAirlines!=$selectedAirlineIds;
    }

    static function getStaffFlightsByLocation(Request $request, $timelineStart, $timelineEnd, $startDate, $endDate,
                                              $staffAirlines, $staffAirports, $selectedAirlineIds, $selectedAirportIds){
        $occ = $request->get("occ");


        $ap = is_array($selectedAirportIds) && count($selectedAirportIds) ? $selectedAirportIds[0] : $selectedAirportIds;

        $flights =  Flight::handlingFlightsRange($startDate, $endDate, $selectedAirlineIds,
            $occ ? $staffAirports : $selectedAirportIds);
        $processedFlightIDs = $flights->pluck("id")->all();

        $locationFlights = Flight::getAirportStaffFlights($timelineStart, $timelineEnd, $processedFlightIDs, $selectedAirportIds, $staffAirports, $selectedAirlineIds, $occ);
        if (count($locationFlights)){
            foreach ($locationFlights as $each){
                $flights->push($each);
            }
        }

//        debug("AP: {$ap}");
//        debug("Flight IDs:");
//        debug($flights->pluck("id")->all());

        $staffFilter = new StaffFilterWatch($ap, null, true, true, $occ);
        $flights = $staffFilter->getStaffData($flights);

        // Get JSON Ready
        $jsonData = self::getJsonDataForFlightWatchTimeLine($flights, $timelineStart, $timelineEnd, $startDate, $endDate, $selectedAirportIds, self::airlineFilterSelected($staffAirlines, $selectedAirlineIds), $occ, $ap);

        /*
        $flightsOPS = self::getFlightTrackerPanelFlights($flights);
        $tableLayout = airlineModule() ? "flights-list-airline" : "flights-list";

        $flightTables = [
            DEPARTURE   => view("flight-tracker/layouts/{$tableLayout}", ["flightsOPS" => $flightsOPS[DEPARTURE], "tableId" => "tableFltDepartures"])->render(),
            ARRIVAL     => view("flight-tracker/layouts/{$tableLayout}", ["flightsOPS" => $flightsOPS[ARRIVAL],   "tableId" => "tableFltArrivals"])->render(),
            ALL         => view("flight-tracker/layouts/{$tableLayout}", ["flightsOPS" => $flightsOPS[ALL],       "tableId" => "tableFltAll"])->render(),
        ];
        */

        return [$jsonData, $flights];
    }


    public static function getJsonDataForFlightWatchTimeLine(&$flights, $timelineStart, $timelineEnd, $startDate, $endDate, $airportID = null, $airlineFilterSelected = false, $occStaffOnly = null, $staffAirportID = null)
    {
        $json = $processedUserIDs =[];

        $userIDs = User::getStaffWithService($occStaffOnly);
        $leavesRequests = UserHistory::getStaffLeaveRequests($startDate, $endDate, $userIDs, $airportID);

        $users = User::with([
            "location",
            "location.airport",
        ])  ->leftJoin("locations", "locations.id", "=", "users.location_id")
//            ->whereIn("users.id", $userIDs);
            ->whereNull("users.vs")
//        ->whereNull("users.deleted_at")
//        ->whereNull("users.resigned_date")
            ->get([
                "users.*",
                "locations.airport_id"
            ])
            ->keyBy("id");

        foreach ($flights as &$flightItem) {

            $flightNumber = $flightItem->flightNumber;
//            if ($flightNumber->airline_id == 225){
//                debug($flightItem);
//                debug($flightItem->std);
//            }

            // For delay to be colored in staff-watch
            $airline = $flightNumber ? $flightNumber->airline : null;

            $fNo = $flightNumber->airline ? ($flightNumber->airline->iata ? $flightNumber->airline->iata : $flightNumber->airline->icao )." " : "";
            $fNo .= $flightNumber->flight_number;

            if(!$flightItem->serviceData){
                continue;
            }

            if ($flightItem->serviceData["serviceType"] == ARRIVAL_SERVICE){
                $typeClass = "arr";
                $station = getFlightArrivalAirport($flightItem, false, true);
            }
            else {
                $typeClass = "dep";
                $station = getFlightDepartureAirport($flightItem, false, true);
            }

            foreach ($flightItem->serviceData["services"] as $airlineService) {

                /**
                $airlineServices[$j]->sla = $sla;
                $airlineServices[$j]->req = $req;
                $airlineServices[$j]->report_time = $plannedReport;
                $airlineServices[$j]->release_time = $plannedRelease;
                $airlineServices[$j]->duration = $duration;
                 */

                $count = 0;
                foreach ($airlineService->rosteredStaff as $flightStaff){

                    if (!isset($users[$flightStaff->user_id])){
                        continue;
                    }

//                    $userStation = getUserLocation($users[$flightStaff->user_id]);
                    $count++;
                    $each = self::getFlightBoxItem($flightItem, $timelineStart, $timelineEnd, $station, $airlineService, $typeClass, $fNo, $flightStaff, $airline, $users);
                    if ($each){
                        $json[] = $each;
                        $processedUserIDs[$flightStaff->user_id] = 1;
                    }

                }

                if ($staffAirportID && !$airlineService->another_airport_type) {
                    debug($airlineService->service->name. ": ".$airlineService->req);
                    for ($k = $count; $k < $airlineService->req; $k++) {
                        $each = self::getFlightBoxItem($flightItem, $timelineStart, $timelineEnd, $station, $airlineService, $typeClass, $fNo, null, $airline);
                        if ($each) {
                            $json[] = $each;
                        }
                    }
                }
            }
        }

//        usort($json, array(StaffWatchController::class, "compareByStation"));

        $userIDsInFlights = array_keys($processedUserIDs);

        foreach ($leavesRequests as $userID => $leaves) {
            foreach ($leaves as $item) {
                // From - $item[0], To - [1], Leave Name = [2]
                $from = $item[0];
                $to = $item[1];

                // Not in timeline skip
                if (strtotime($to) < strtotime($timelineStart) || strtotime($from) > strtotime($timelineEnd)){
                    continue;
                }

                // If Not in Flights array -> then put to bottom
                $putToBottom = !in_array($userID, $userIDsInFlights) &&
                    ($item[6] || (strtotime($item[0]) < strtotime($startDate) && strtotime($item[1]) > strtotime($endDate)));

                $json[] = self::getLeaveBoxItem($users, $userID, $from, $to, $item[2], $item[4], $item[5], false, $putToBottom, $item[7], $item[8]);
                $processedUserIDs[$userID] = 1;
            }
        }

//        return $json;

//        $start = date("Y-m-d H:i:s", strtotime("+8 hours", strtotime($startDate)));
//        $end   = date("Y-m-d H:i:s", strtotime("-8 hours", strtotime($endDate)));

        if (!$airlineFilterSelected) {
            $processedUserIDs = array_keys($processedUserIDs);

            $j = 0;
            foreach ($userIDs as $userID) {
                if (in_array($userID, $processedUserIDs)) {
                    continue;
                }

                if (!isset($users[$userID])) {
                    continue;
                }

                if ($users[$userID]->airport_id != $airportID) {
                    continue;
                }

                $json[] = self::getLeaveBoxItem($users, $userID, $timelineStart, $timelineEnd, "Unassigned Staff", null, null, ++$j);
            }
        }

        return $json;
    }


    public static function getFlightTrackerPanelFlights($flights){

        $flights = $flights->sortBy("std")->all();

        $data = [
            ALL         => [],
            DEPARTURE   => [],
            ARRIVAL     => [],
        ];

        //$today = date("Y-m-d");
        $handlingStations = Airport::getHandlingStationsIdAndObject();

        foreach ($flights as $flight) {
            //$date = date("Y-m-d", strtotime(getFlightDepartureDate($flight)));

            //if ($date == $today){
            $data[ALL][] = $flight;

            $type = getFlightsDepArrType($flight, $handlingStations);
            if ($type){
                $data[$type][] = $flight;
            }
            //}
        }

        return $data;
    }

    public function setStaffAirlines($airline){
        $user = Auth::user();

        if ($airline) {

            $staffAirline = StaffAirline::where("user_id", $user->id)
                ->where("airline_id", $airline)
                ->first();

            if ($staffAirline){
                // Audit Deleted
                auditDeleted($staffAirline);
//                $staffAirline->delete();
            }
            else {
                $staffAirline = new StaffAirline();
                $staffAirline->user_id = $user->id;
                $staffAirline->airline_id = $airline;
                $staffAirline->save();
            }
        }
        else {
            $sAirlines = StaffAirline::where("user_id", $user->id)
                ->get();
            // Audit Deleted
            auditDeleted($sAirlines);

        }
    }

    public function setStaffStations($airport){
        $user = Auth::user();

        if ($airport) {
            $staffStation = StaffStation::where("user_id", $user->id)
                ->where("airport_id", $airport)
                ->first();

            if ($staffStation){
                // Audit Deleted
                auditDeleted($staffStation);
//                $staffStation->delete();
            }
            else {
                $staffStation = new StaffStation();
                $staffStation->user_id = $user->id;
                $staffStation->airport_id = $airport;
                $staffStation->save();
            }

        }
        else {
            $sStations = StaffStation::where("user_id", $user->id)
                ->get();
            // Audit Deleted
            auditDeleted($sStations);

        }
    }

    public static function ajaxGetRange(Request $request, $datetime = null)
    {
        if (!$datetime){
            $datetime = date("Y-m-d H:i:s");
        }

        if ($request->get("start_date") && $request->get("end_date")) {
            $timelineStart = $request->get("start_date");
            $timelineEnd = $request->get("end_date");
            $startDate  = date("Y-m-d H:i:s", strtotime("-10 hours", strtotime($request->get("start_date"))));
            $endDate    = date("Y-m-d H:i:s", strtotime("+10 hours", strtotime($request->get("end_date"))));
        }
        else {
            $timelineStart = date("Y-m-d H:i:s", strtotime("- 6 hours", strtotime($datetime)));
            $timelineEnd = date("Y-m-d H:i:s", strtotime("+ 6 hours", strtotime($datetime)));

            $startDate  = date("Y-m-d H:i:s", strtotime("-10 hours", strtotime($datetime)));
            $endDate    = date("Y-m-d H:i:s", strtotime("+10 hours", strtotime($datetime)));
        }

        debug("TIMELINE: ".$timelineStart." - ".$timelineEnd);

        $selectedAirportIds = Airport::getSelectedAirportIds($request);
        $selectedAirlineIds = Airline::getSelectedAirlineIds($request);

        $staffAirlines = StaffAirline::currentStaffAirlinesList();
        $staffAirports = StaffStation::currentStaffStationsList();

//        $selectedAirlineIds = $request->get("airline_id") ? $request->get("airline_id") : ($request->get("airline_ids") ? $request->get("airline_ids") : $staffAirlines);
        $selectedAirportIds = (!$selectedAirportIds || !count($selectedAirportIds)) ? $staffAirports[0] : $selectedAirportIds[0];

        $emptyFlights = self::emptyFlights();

        if ($emptyFlights){
            $flights = $jsonData = [];

            $flightsOPS = $flightTables = [
                DEPARTURE   => null,
                ARRIVAL     => null,
                ALL         => null,
            ];
        }
        else {
            // Load Flights
            list ($jsonData, $flights) = self::getStaffFlightsByLocation($request, $timelineStart, $timelineEnd, $startDate, $endDate,
                $staffAirlines, $staffAirports, $selectedAirlineIds, $selectedAirportIds);
        }

        $flightNumbersObj = FlightNumber::getArrayFlightNumbersWithSector(false, false, false, null, true);

        return response()->json([
            "jsonData"                  => $jsonData,
            "flights"                   => $flights,

            "aircraftByAirline"   => Aircraft::getAircraftByAirline($selectedAirlineIds),
            "acTypesByAirline"    => AircraftType::byAirline($selectedAirlineIds),
            "aircraftByType"      => Aircraft::byType($selectedAirlineIds),


            "flightsOPS"                => isset($flightsOPS) ? $flightsOPS : null,
            "flightTables"              => isset($flightTables) ? $flightTables : null,
            "success"                   => TRUE,

            // ADDED FOR UPDATE
            "airlines"                  => Airline::getHandlingAirlinesAndOperatorsWithCode(),
            "flightNumbersObj"          => $flightNumbersObj,
        ]);
    }


    public function quickLink(Request $request){
        $timelineStart = $request->get("start_visible_time");
        $timelineEnd = $request->get("end_visible_time");

        $startDate = date("Y-m-d H:i:s", strtotime("-10 hours",  strtotime($timelineStart)));
        $endDate   = date("Y-m-d H:i:s", strtotime("+10 hours",  strtotime($timelineEnd)));

        $selectedAirportIds = $request->get("airport_id"); // Airport::getSelectedAirportIds($request);
        $selectedAirlineIds = Airline::getSelectedAirlineIds($request);

        $staffAirlines = StaffAirline::currentStaffAirlinesList();
        $staffAirports = StaffStation::currentStaffStationsList();

//        $selectedAirlineIds = $request->get("airline_id") ? $request->get("airline_id") : ($request->get("airline_ids") ? $request->get("airline_ids") : $staffAirlines);
        $selectedAirportIds = $selectedAirportIds ? $selectedAirportIds : $staffAirports[0];

        debug($timelineStart." - ".$timelineEnd);

        // Load Flights
        list ($jsonData, $flights) = self::getStaffFlightsByLocation($request, $timelineStart, $timelineEnd, $startDate, $endDate,
            $staffAirlines, $staffAirports,  $selectedAirlineIds, $selectedAirportIds);

        // Get JSON Ready
        return response()->json([
            "start_visible_period"  => $timelineStart,
            "end_visible_period"    => $timelineEnd,
            "jsonData"              => $jsonData,
            "flights"               => $flights,
            "success"               => TRUE
        ]);
    }


    public function cancel(Request $request){

        $datetime = date("Y-m-d H:i:s");

        if ($request->get("remove_reason")){

            $flight = Flight::find($request->get("flight_id"));
            if (!$flight){
                return redirect()->to("staff-watch");
            }

            $flight->remark         = $request->get("remove_reason");
            $flight->deleted_at     = date("Y-m-d H:i:s");
            $flight->updated_by     = Auth::user()->id;
            $flight->save();

            flash()->success('Flight Successfully Removed');

            $datetime = $this->getFlightDate($flight);
        }
        else if ($request->get("cancel_reason")){

            $flight = Flight::find($request->get("flight_id"));
            if (!$flight){
                return redirect()->to("staff-watch");
            }

            $flight->remark         = $request->get("cancel_reason");
            $flight->cancelled_at   = date("Y-m-d H:i:s");
            $flight->updated_by     = Auth::user()->id;
            $flight->save();

            flash()->success('Flight Successfully Cancelled');

            $datetime = $this->getFlightDate($flight);
        }

        return $this::ajaxGetRange($request, $datetime);
    }

    protected $depTimings = [
        STD,
        PTD,
        ETD,
        ATD,
        ABN,
    ];

    protected $arrTimings = [
        STA,
        PTA,
        ETA,
        ATA,
        TDN,
    ];

    function depArrTimingsExists(Request $request){
        $depExists = $arrExists = false;
        foreach ($this->depTimings as $timing) {
            if ($request->get($timing)){
                $depExists = true;
            }
        }

        foreach ($this->arrTimings as $timing) {
            if ($request->get($timing)){
                $arrExists = true;
            }
        }

        return $depExists && $arrExists;
    }

    public function edit(Request $request, $flight_staff)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '64M');

        $flight = Flight::find($request->get("flight_id"));
        $airlineService = AirlineService::find($request->get("airline_service_id"));

        if ($request->get("all")){
            // Update Flight Staff
            FlightStaff::updateFlightsStaffByStation($request, $flight, null, true);
        }
        else {
            FlightStaff::setFlightsStaff($request, $flight, $airlineService, $flight_staff, null, true);
        }
        // Update Flight Staff

        $datetime = $flight ? $this->getFlightDate($flight) : null;

        debug($request->all());

        return $this::ajaxGetRange($request, $datetime);
    }

    public function create(Request $request)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '64M');

        $flightStaffID = $request->get("id");
        $flight = Flight::find($request->get("flight_id"));
        $airlineService = AirlineService::find($request->get("airline_service_id"));

        if ($request->get("all")){
            // Update Flight Staff
            FlightStaff::updateFlightsStaff($request, $flight);
        }
        else {
            FlightStaff::setFlightsStaff($request, $flight, $airlineService, $flightStaffID);

        }

        $datetime = $flight ? $this->getFlightDate($flight) : null;

        debug($request->all());

        return $this::ajaxGetRange($request, $datetime);
    }


    public function saveLine(Request $request){

        $airlineModule = airlineModule();

        $airline = $request->get("airline");
        $flightIDs = $request->get("flight_ids");

        $aircraftType = null;
        if ($manualAcType = $request->get("ac_type")) {
            $aircraftType = AircraftType::where(function($sql) use ($manualAcType){
                $sql->where("iata_name", $manualAcType)
                    ->orWhere("icao", $manualAcType)
                    ->orWhere("name", $manualAcType);
            });

            if ($airline){
                $aircraftType->where(function($sql) use ($airline){
                    $sql->whereNull("airline_id");
                    if ($airline){
                        $sql->orWhere("airline_id", $airline->id);
                    }
                });
            }

            $aircraftType = $aircraftType->orderByDesc("airline_id")
                ->first();

            if (!$aircraftType){
                $aircraftType = new AircraftType();
                if ($airlineModule) {
                    $aircraftType->icao = $manualAcType;
                }
                else {
                    $aircraftType->iata_name = $manualAcType;
                }
                $aircraftType->name = $manualAcType;
                $aircraftType->airline_id = $airline ? $airline->id : null;
                $aircraftType->created_by = Auth::user()->id;
                $aircraftType->save();
            }
        }
        elseif ($request->get("aircraft_type_id")) {
            $aircraftType = AircraftType::find($request->get("aircraft_type_id"));
        }

        if ($manualAc = $request->get("ac")) {
            $aircraft = self::getAircraft($manualAc, $airline, $aircraftType);
        }
        else {
            $aircraft = Aircraft::find($request->get("aircraft_id"));
        }

        if (!$aircraft && !$aircraftType){
            return response()->json([
                "message"   => "Please select Aircraft Type or Aircraft Registration",
                "error"     => true,
                "success"   => false,
            ]);
        }

        $flight = null;
        foreach ($flightIDs as $flightID) {
            $flight = Flight::find($flightID);

            if ($manualAc){
                $flight->aircraft_id = $aircraft->id;
                $flight->aircraft_type_id = $aircraftType->id;
            }
            else if ($manualAcType){
                $flight->aircraft_id = null;
                $flight->aircraft_type_id = $aircraftType->id;
            }
            else {
                if ($aircraft){
                    $flight->aircraft_id = $aircraft->id;
                }
                else {
                    $flight->aircraft_type_id = $aircraftType->id;
                }
            }

            $flight->save();
        }

        $datetime = $flight ? $this->getFlightDate($flight) : null;

        return $this::ajaxGetRange($request, $datetime);

    }

    public static function getAircraft($acReg, $airline = null, $aircraftType = null){
        $mvtName = str_replace("-","", $acReg);

        $aircraft = Aircraft::whereNull("deleted_at")
            ->where(function($sql) use ($mvtName, $acReg){
                $sql->where("mvt_name", $mvtName)
                    ->orWhere("name", $acReg);
            });

        if ($airline){
            $aircraft->where("airline_id", $airline->id);
        }

        $aircraft = $aircraft->first();

        if (!$aircraft){
            $aircraft = new Aircraft();

            $aircraft->mvt_name = contains($mvtName, "-") ? str_replace("-", "", $mvtName) : $mvtName;
            $aircraft->name =     contains($acReg, "-") ? $acReg : partitionAircraftCode($acReg);

            if ($airline){
                $aircraft->airline_id = $airline->id;
            }

            $aircraft->created_by = Auth::user()->id;

            if ($aircraftType){
                if (airlineModule()){
                    if (!$airline || !$aircraftType->airline_id){
                        $aircraft->aircraft_type_id = $aircraftType->id;
                    }
                }
                else {
                    if (!$aircraftType->airline_id || ($airline && $aircraftType->airline_id == $airline->id)){
                        $aircraft->aircraft_type_id = $aircraftType->id;
                    }
                }
            }
        }
        $aircraft->deleted_at = null;
        $aircraft->save();

        return $aircraft;
    }

    public function processDiversion(Request $request, $flight){

        if ($request->has("is_diversion")){
            // Get Airport
            $divertedAirport = $this->getOrCreateAirport($request->get("diversion_airport"));

            // Flight to original destination
            $flightToOriginalDestination = $this->createFlightToOriginalDestination($request, $divertedAirport, $flight);

            // Update Current Flight
            $flight->is_diversion = true;
            $flight->arrival_airport_id = $divertedAirport->id;
            $flight->diverted_airport_id = $divertedAirport->id;
            $flight->next_flight_id = $flightToOriginalDestination ? $flightToOriginalDestination->id : null;
        }
        elseif ($request->get("diverted_flight") && $flight->departure_airport_id) {
            // DONT DO ANYTHING
        }
        else {

            if ($flight->nextFlight){
                $flight->next_flight_id = null;
                $flight->nextFlight->deleted_at = date("Y-m-d H:i:s");
                $flight->nextFlight->save();
            }

            $flight->is_diversion = null;
            $flight->diverted_airport_id = null;
            $flight->arrival_airport_id = null;
        }

        $flight->save();
    }

    public function createFlightToOriginalDestination(Request $request, $divertedAirport, $divertedFlight){

        $departures = [ PTD, ETD, ATD, ABN ];
        $arrivals =   [ PTA, ETA, TDN, ATA ];

        $foundDeparture = $foundArrival = false;

        $flight = Flight::where("prev_flight_id", $divertedFlight->id)
            ->first();

        // Create if not found
        if (!$flight) {
            $flight = new Flight();
        }

        // Update key fields
        $flight->flight_number_id = $divertedFlight->flight_number_id;
        $flight->aircraft_id = $divertedFlight->aircraft_id;
        $flight->aircraft_type_id = $divertedFlight->aircraft_type_id;

        $flight->is_diversion = true;
        $flight->departure_airport_id = $divertedAirport->id;
        $flight->diverted_airport_id = $divertedAirport->id;
        $flight->prev_flight_id = $divertedFlight->id;

        // Departure info
        foreach ($departures as $each) {
            if ($request->get("diversion_{$each}")){
                $flight->{$each} = $request->get("diversion_{$each}");
                $foundDeparture = true;
            }
        }

        foreach ($arrivals as $each) {
            if ($request->get("diversion_{$each}")){
                $flight->{$each} = $request->get("diversion_{$each}");
                $foundArrival = true;
            }
        }

        if (!$foundDeparture){
            $flight->etd = Add_Minutes_To_DateTime(getFlightArrivalDate($divertedFlight), 30);
        }

        if (!$foundArrival){
            $flight->eta = Add_Minutes_To_DateTime(getFlightDepartureDate($flight), 120);
        }

        setFlightDepartureDate($flight);
        setFlightArrivalDate($flight);

        $flight->deleted_at = null;
        $flight->save();

        return $flight;
    }

    public function updateOrCreateNextFlight(){

    }

    public function getOrCreateAirport($diversionAirportIATA){

        $diversionAirport = Airport::where("iata", strtoupper($diversionAirportIATA))
            ->first();

        if (!$diversionAirport){
            $diversionAirport = new Airport();
            $diversionAirport->iata = strtoupper($diversionAirportIATA);
            $diversionAirport->save();
        }

        return $diversionAirport;
    }

    public function getFlightDate($flight){
        if ($flight->atd && $flight->atd != EMPTY_DATETIME){
            $date = $flight->atd;
        }
        elseif ($flight->etd && $flight->etd != EMPTY_DATETIME){
            $date = $flight->etd;
        }
        elseif ($flight->ptd && $flight->ptd != EMPTY_DATETIME){
            $date = $flight->ptd;
        }
        else {
            $date = $flight->std;
        }

        return $date;
    }


    public function ajaxGetFlightStaff(Request $request, $flight_staff = null)
    {
        $airlineService = AirlineService::find($request->get("airline_service_id"));

        $flight = Flight::with("flightParent")->find($request->get("flight_id"));

        $staffAirports = StaffStation::currentStaffStationsList();
        $selectedAirportIds = Airport::getSelectedAirportIds($request);
        $selectedAirportIds = (!$selectedAirportIds || !count($selectedAirportIds)) ? $staffAirports[0] : $selectedAirportIds[0];
        debug("SEL AP ID:{$selectedAirportIds}");
        $staffData = null;

        if ($request->get("all")){

            $staffFilter = new StaffFilterWatch($selectedAirportIds, null, true, true);
            $serviceType = $staffFilter->getServiceType($flight);
            debug("Service: {$serviceType}");

            // Staff List
            $staffList = Flight::getFlightStaff($flight);
            if ($serviceType != ANOTHER_AIRPORT_SERVICE){
                $staffData = $staffFilter->getFlightServiceData($flight);
            }
        }
        else {
            $serviceType = $request->get("service_type");
            $staffFilter = new StaffFilterWatch($selectedAirportIds, null, true, true);
            $staffData = $staffFilter->getFlightAirlineService($flight, $airlineService,  $serviceType);
            // Staff List
            $staffList = [];
            if ($flight_staff){

                $staffList[$flight_staff->service->abbr] = [];

                $flight_staff->location = Location::getUserLocationAirport($flight_staff->user->location_id);

                $staffList[$flight_staff->service->abbr][] = $flight_staff;
            }
        }

        // Details
        $this->setFlightDetails($flight, $staffList);

        return response()->json([
            "success"        => 1,
            "serviceData"    => $staffData,
            "user"           => Auth::user(),
            "flight"         => $flight,
            "departure_city" => isset($departureCity) ? $departureCity : "",
            "arrival_city"   => isset($arrivalCity) ? $arrivalCity : "",
        ]);
    }

    function setFlightDetails(&$flight, $staffList){
        $flight->staffList = $staffList;

        $flightNumber = $flight->flightNumber;
        $flight->departure_date_type = getFlightDepartureTimeType($flight, true);
        $flight->arrival_date_type = getFlightArrivalTimeType($flight, true);

        if ($flightNumber) {
            if ($flightNumber->departureAirport && $timezone = $flightNumber->departureAirport->timezone) {
                $depDateTime = getFlightDepartureDate($flight);
                if ($depDateTime && $depDateTime != EMPTY_DATETIME) {
                    $flight->departure_local_date = getLocalDateTime($depDateTime, $timezone, "D d M Y");
                    $flight->departure_local_time = getLocalDateTime($depDateTime, $timezone, "H:i"); }

            }

            if ($flightNumber->arrivalAirport && $timezone = $flightNumber->arrivalAirport->timezone) {
                $arrDateTime = getFlightArrivalDate($flight);
                if ($arrDateTime && $arrDateTime != EMPTY_DATETIME){
                    $flight->arrival_local_date = getLocalDateTime($arrDateTime, $timezone, "D d M Y");
                    $flight->arrival_local_time = getLocalDateTime($arrDateTime, $timezone, "H:i");
                }
            }
        }

        $flight->fn = getFlightNumberFull($flightNumber);
        $flight->sector = getFlightNumberSector($flightNumber);
    }

    public static function compareByStation($arrayA, $arrayB)
    {
        return strcmp($arrayA["station"], $arrayB["station"]);
    }

    public static function getLeaveBoxItem($users, $userID, $from, $to, $leaveName, $notes = null, $airline = null, $unassignedStaffCount = null,
                                           $leaveRequest = false, $bgClass = null, $textClass = null){

        $report = new \DateTime($from);
        $release = new \DateTime($to);

        $duration = $release->diff($report);
        $durationMinutes = $duration->h * 60 + $duration->i;

        $group = self::getFlightPositionGroup(null, null, null, $userID, $users, $leaveName, $unassignedStaffCount, $leaveRequest);

        $class = $unassignedStaffCount ? "unassigned" : ($bgClass ? $bgClass : "leave");
        $textClass = $unassignedStaffCount ? "" : ($textClass ? $textClass : "");

        $user = $users[$userID];
        $station =  getUserLocation($user);

        $data = [
//            "station"    => $station,
            "start_date" => [
                $report->format("Y"),
                (int)$report->format("n") - 1,
                $report->format("j"),
                $report->format("G"),
                (int)$report->format("i"),
                (int)$report->format("s")
            ],
            "end_date" => [
                $release->format("Y"),
                (int)$release->format("n") - 1,
                $release->format("j"),
                $release->format("G"),
                (int)$release->format("i"),
                (int)$release->format("s")
            ],
            "group"     => $group,
            "className" => $class,
        ];

        $notes = ($notes ? $notes : "-");

        if ($unassignedStaffCount){
            $data["content"] = "<div class='row fw-flight-item'>".
                "<div class='col-sm-12 flightStandard'>" .
//            "<span class='staff_watch_box_left'></span>" .
                "<span class='staff_watch_box_center_100 {$textClass}'>{$leaveName}</span>" .
//            "<span class='staff_watch_box_right'></span>" .
                "</div>";
        }
        else {
            $data["content"] = "<div class='row fw-flight-item' data-location='{$station}' " .($leaveRequest ? "data-u " : ""). "data-staff='".getUserName($user)."' data-leave='{$leaveName}' data-from='{$from}' data-to='{$to}' data-rmks='{$notes}' data-airline='{$airline}'>".
                "<div class='col-sm-12 flightStandard'>" .
//            "<span class='staff_watch_box_left'></span>" .
                "<span class='staff_watch_box_center_100 {$textClass}'>{$leaveName}</span>" .
//            "<span class='staff_watch_box_right'></span>" .
                "</div>";
        }

        return $data;
    }

    public static function getFlightBoxItem($flight, $timelineStart, $timelineEnd, $station, $airlineService, $typeClass, $fNo,
                                            $flightStaff = null, $airline = null, $users = []){

        if ($flightStaff){
            $report = new \DateTime($flightStaff->report_time ? $flightStaff->report_time : $flightStaff->planned_report_time);
            $release = new \DateTime($flightStaff->release_time ? $flightStaff->release_time : $flightStaff->planned_release_time);
        }
        else {
            $report = new \DateTime($airlineService->report_time);
            $release = new \DateTime($airlineService->release_time);
        }

        $duration = $release->diff($report);
        $durationMinutes = $duration->h * 60 + $duration->i;

        $group = self::getFlightPositionGroup($airlineService, $flightStaff, $airline, null, $users);

        $class = $flightStaff && $flightStaff->sod_updated_at ? "sod_updated" : $airlineService->sla; //."-".($flight->serviceData["serviceType"] == ARRIVAL_SERVICE ? "arrival" : "departure");

        $report = new \DateTime(date("Y-m-d H:i:s", strtotime("+ 1 minute", strtotime($report->format("Y-m-d H:i:s")))));

        if ($durationMinutes <= 0){
            $release = new \DateTime(date("Y-m-d H:i:s", strtotime("+ 5 minutes", strtotime($report->format("Y-m-d H:i:s")))));
        }

        if (strtotime($release->format("Y-m-d H:i:s")) < strtotime($timelineStart) || strtotime($report->format("Y-m-d H:i:s")) > strtotime($timelineEnd)){
            return null;
        }

        $data = [
//            "station"    => $userStation,
            "start_date" => [
                $report->format("Y"),
                (int)$report->format("n") - 1,
                $report->format("j"),
                $report->format("G"),
                (int)$report->format("i"),
                (int)$report->format("s")
            ],
            "end_date" => [
                $release->format("Y"),
                (int)$release->format("n") - 1,
                $release->format("j"),
                $release->format("G"),
                (int)$release->format("i"),
                (int)$release->format("s")
            ],
            "group"     => $group,
            "className" => $class,
        ];

        $acType = getFlightAircraftType($flight);

        if ($durationMinutes < 100) {
            $data["content"] = "<div class='row fw-flight-item' data-id=".($flightStaff ? $flightStaff->id : 0).
                " data-service_type='{$airlineService->serviceType}'" .
                " data-airline_service_id={$airlineService->id} data-sla='{$airlineService->sla}' data-flight_id={$flight->id} >".
                "<div class='col-sm-12 flightStandard {$typeClass}'>" .
                "<span class='staff_watch_box_left'>{$airlineService->sla}</span>" .
                "<span class='staff_watch_box_center_empty'></span>" .
                "<span class='staff_watch_box_right'>{$fNo}</span>" .
                "</div>";
        }
        else {
            $data["content"] = "<div class='row fw-flight-item' data-id=".($flightStaff ? $flightStaff->id : 0).
                " data-service_type='{$airlineService->serviceType}'" .
                " data-airline_service_id={$airlineService->id} data-sla='{$airlineService->sla}' data-flight_id={$flight->id} >".
                "<div class='col-sm-12 flightStandard {$typeClass}'>" .
                "<span class='staff_watch_box_left_30'>{$airlineService->sla}</span>" .
                "<span class='staff_watch_box_center'>{$acType}</span>" .
                "<span class='staff_watch_box_right_30'>{$fNo}</span>" .
            "</div>";
        }

        return $data;
    }

    public static function getFlightPositionGroup($airlineService = null, $flightStaff = null, $airline = null, $userID = null, $users = [], $condition = null, $unassignedStaffCount = false, $leaveRequest = false){
        if ($flightStaff){
            $user = $users[$flightStaff->user_id];
            $userStation = getUserLocation($user);
            $name= getUserName($user);

            $group = "<a data-id='".$flightStaff->user_id."' target='_blank' href='".route("homepage")."#staff/{$flightStaff->user_id}/edit?tab=services'>" .
                "{$userStation} | {$name}</a>";
        }
        else if ($airlineService){
            $pos = $airlineService->service->position ? $airlineService->service->position : 9;
            $group = "<a data-pos='{$pos}' data-sla='{$airlineService->sla}' target='_blank' class='color-red'>{$airlineService->sla}";
            $group .= "</a>";
        }
        else if ($userID){
            $user = $users[$userID];
            $userStation = getUserLocation($user);
            $name= getUserName($user);

            if ($unassignedStaffCount){
                $group = "<a data-uname='{$name}' data-id='{$userID}' target='_blank' class='color-green' href='".route("homepage")."#staff/{$userID}/edit?tab=services'>" .
                    "{$userStation} | {$name}</a>";
            }
            else {
                if ($leaveRequest){
                    $group = "<a data-ureq='{$name}' data-id='{$userID}' target='_blank' href='".route("homepage")."#staff/{$userID}/edit?tab=services'>" .
                        "{$userStation} | {$name}</a>";
                }
                else{
                    $group = "<a data-id='{$userID}' target='_blank' href='".route("homepage")."#staff/{$userID}/edit?tab=services'>" .
                        "{$userStation} | {$name}</a>";
                }
//                $group = "<a data-text='".$condition."' data-staff='{$userID}' target='_blank' href='".route("homepage")."#staff/{$userID}/edit?tab=services'>";
            }
        }
        else {
            $picture = $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png");

            $group = "<a data-airline='".$airline->airline."' target='_blank' href='".route("homepage")."#". url("/airline/{$airline->id}") ."'>";

            $group .= "<img class='fleetwatch-airline-logo' src='".$picture."' />";

            $group .= "</a>";
//            $group = "<span data-airline='".$airlineID."' class='header-cancel'>-Unassigned-</span>";
        }

        return $group;
    }
}
