<?php

namespace App\Http\Controllers;

use App\Classes\FlightStaff\StaffFilter;
use App\Classes\FlightStaff\StaffFilterWatch;
use App\Classes\Staff\Roster\Roster;
use App\Classes\Staff\Roster\RosterOperations;
use App\Classes\Staff\Roster\Settings\RosterSettings;
use App\Classes\Staff\Roster\Settings\RosterSettingsAssignedFlight;
use App\Classes\Staff\Roster\Staff\Staff;
use App\Models\Airline;
use App\Models\AirlineService;
use App\Models\Airport;
use App\Models\Condition;
use App\Models\Flight;
use App\Models\FlightStaff;
use App\Models\Service;
use App\Models\StaffAirline;
use App\Models\StaffService;
use App\Models\StaffStation;
use App\Models\User;
use App\Models\UserHistory;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Session;

class StaffRosterController extends Controller
{
    const MAX_EXECUTION_TIME = 120;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $showLogo = false;

        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '512M');

        debug($request->all());

        if ($request->has("generate")){

            // Generate
            $fromDate = $request->get("dateFrom");
            $toDate   = $request->get("dateTo");

            $airport = $request->get("airport");
            $airlines = $request->get("airline") ? $request->get("airline") : StaffAirline::currentStaffAirlinesList(AIRLINE_IDS);

            $roster = new Roster();
            $roster->init([
                'from'      => $fromDate." 00:00:00",
                'to'        => $toDate." 23:59:59",
                'airport'   => $airport,
                'airlines'  => $airlines,
                'type'      => $request->get("roster_type"),
                'timing'    => $request->get("timing"),
            ]);

            // Initial Setup
            $roster->initialSetup();

            $rosterSettings = new RosterSettings($roster);
            $rosterSettings->setShiftMaxHours($request->get("shift_max_hours"));
            $rosterSettings->setShiftMinHours($request->get("shift_min_hours"));
            $rosterSettings->setShiftMinRestTime($request->get("shift_min_rest_time"));
            $rosterSettings->setStaffAssignment($request->get("staff_assignment"));
            $rosterSettings->setAirlineLicenseCheck($request->get("airline_license_check"));
            $rosterSettings->setAirportLicenseCheck($request->get("airport_license_check"));


            try {
                $roster->uploadSettings($rosterSettings);

                if ($this->LoadAssignedFlightsAndStaff($roster))
                {
                    debug("Assigned flights loaded");
                }
                elseif ($request->get("include_rostered_staff")) {
                    debug("Manually rostered flights loaded");
                    $roster->setupManuallyRosteredStaff();
                }

                $roster->start(2);

                $roster->getOperations()->saveRoster(GENERATED);

                $servicesByFlight = $this->getServicesByFlights($roster);
            }
            catch (\Exception $e){
                debug("ERROR DETECTED");
                debug($e);
            }

            flash()->success("Roster Generated Successfully");

            // Save Roster Object
//            session(['roster' => $roster]);
//            session(['roster_obj' => $roster]);
        }
        elseif($request->has("save") && $request->get("roster_id")){

            debug("SAVED Roster id:". $request->get("roster_id"));

            // Save
            $rosterObj = Roster::find($request->get("roster_id"));

            if ($rosterObj){
                $rosterObj->status = SAVED;
                $rosterObj->save();

                flash()->success("Successfully saved");
            }
            else {

                flash()->success("Error! Roster not found!");
            }

        }
        elseif($request->has("load")){
            // Load

            $rosterId = \request("roster");

            /* @var Roster $loadRoster*/
            $loadRoster = Roster::find($rosterId);

            if ($loadRoster){
                $rosterOperations = new RosterOperations($loadRoster);
                $rosterOperations->loadRoster();
            }

        }
        elseif($request->has("publish")){
            // Load
            $rosterId = \request("roster");

            $publishRoster = Roster::find($rosterId);

            if ($publishRoster){
                $rosterOperations = new RosterOperations($publishRoster);
                $rosterOperations->publishRoster();
            }
        }
        else {
            $showLogo = true;
        }

        $handlingAirlines = StaffAirline::currentStaffAirlinesList(NAME);
        $handlingAirports = StaffStation::currentStaffStationsList(IATA, null, true);

        $dateFrom = \request("dateFrom") ? \request("dateFrom") : date("Y-m-d", strtotime(" + 1 days"));
        $dateTo = \request("dateTo") ? \request("dateTo") : date("Y-m-d", strtotime(" + 1 days"));


        $this->viewData = [
            'conditions'        => ['' => 'Select'] + Condition::where("type", ROSTER_TYPE)
                                                ->orderBy("name")
                                                ->pluck('name', 'id')
                                                ->all(),

            "periodStr"         => getPeriodStr($dateFrom, $dateTo),
            "showLogo"          => $showLogo,
            "dateFrom"          => $dateFrom,
            "dateTo"            => $dateTo,
            "periodMultiply"    => ( 1 + (strtotime($dateTo) - strtotime($dateFrom)) / (60 * 60 * 24)),

            "selectedAirport"   => \request("airport") ? \request("airport") : 7761,
            "shiftMaxHours"     => 10,
            "shiftMinHours"     => 3,
            "shiftMinRestTime"  => 10.5,
            "staffHistory"      => UserHistory::getCurrentUserHistory(true, $handlingAirports),

            "staffList"         => User::listUsers(false, true),
            "loadRoster"        => isset($loadRoster) ? $loadRoster : null,
            "roster"            => isset($roster) ? $roster : null,
            "servicesByFlight"  => isset($servicesByFlight) ? $servicesByFlight : null,
            "charts"            => isset($roster) ? $roster->getCharts() : null,
            "staffCharts"       => isset($roster) ? $roster->getStaffCharts() : null,
            "staffRosteredCounter"   => isset($roster) ? $roster->getStaffRosteredCounter() : 0,

            "airlines"          => $handlingAirlines,
            "airports"          => $handlingAirports,

            "handingAirlines"   =>  Airline::listHandlingAirlines(),

            "rostersList"       => self::getList(),
        ];

        return view("staff-roster.index", $this->viewData);
    }

    /**
     * @param Roster $roster
     * @return array
     */
    public function getServicesByFlights(Roster $roster){
        $data = [];
         if ($roster->getStaffList()) {

             foreach ($roster->getFlightHandlers() as $i => $flightHandler) {
                 if (!count($flightHandler->getServiceList())){
                     continue;
                 }

                 $serviceType = $flightHandler->getServiceType();

                 if (!isset($data[$flightHandler->getFlight()->id])){
                     $data[$flightHandler->getFlight()->id] = [];
                 }

                 foreach ($flightHandler->getServiceList() as $j => $service) {
                     $req = $service->getStaffReq();
                     $min = $service->getStaffMin();
                     $act = $service->getStaffActual();
                     $staffClass = staffRequirementClass($req, $min, $act, true);

                     if (!$service->getDuration() || !$req){
                         continue;
                     }

                     if (!isset($data[$flightHandler->getFlight()->id][$service->getServiceId()])){
                         $data[$flightHandler->getFlight()->id][$service->getServiceId()] = [];
                     }

                     if (count($service->getJobsList())) {
                         foreach ($service->getJobsList() as $k => $job) {
//                             $addClass = $job->staffType == ASSIGNED_TYPE ? "bg-assigned" : ($job->staffType == MANUALLY_ROSTERED_TYPE ? "bg-manually-rostered" : "");
                             $user = $job->getShift()->getStaff()->getUser();

                             if ($user){
                                 $data[$flightHandler->getFlight()->id][$service->getServiceId()][] = $user->id;
                             }
//                             $job->staffType == ASSIGNED_TYPE;
//                             $job->staffType == MANUALLY_ROSTERED_TYPE;
                         }
                     }
                 }
             }
         }

         return $data;
    }

    public function ajaxGetFlights(Request $request)
    {
        $airport = $request->get("airport_id");

        if ($request->get("date_from") && $request->get("date_to")){
            $startDate = $request->get("date_from")." 00:00:00";
            $endDate = $request->get("date_to")." 23:59:59";
        }
        else {
            $startDate = $request->get("date")." 00:00:00";
            $endDate = $request->get("date")." 23:59:59";
        }

        // Load Flights
        $flights = Flight::handlingFlightsRange($startDate, $endDate, $request->get("airline_id"), $airport, null, [
            'off_order_by_airline_id' => TRUE
        ]);

        $filter = new StaffFilterWatch($airport, null, $request->get("include_rostered_staff"), true);
        $jsonData = $filter->getRosterFlightStaffData($flights);

//        $jsonData = Flight::getFlightsStaffServiceData($flights, null, true, $request->get("include_rostered_staff"));
        $this->prioritiesDepArrTime($jsonData);

        return response()->json([
            "jsonData"      => $jsonData,
            "success"       => TRUE
        ]);
    }


    public static function getList(){
        $handlingAirports = StaffStation::currentStaffStationsList();

        try {
            $rosters = Roster::with("airport")
                    ->whereIn("status", [SAVED, PUBLISHED]);

            if ($handlingAirports && count($handlingAirports)) {
                $rosters->whereIn("airport_id", $handlingAirports);
            }

            $rosters = $rosters->where("created_at", ">=", date("Y-m-d", strtotime("-1 month")))
                ->orderBy("created_at", 'DESC')
                ->get();

            $list = [];

            foreach ($rosters as $each) {
//                $airport = Airport::find($each->airport_id);
                $list[$each->id] = " " . $each->airport->iata . " | " . $each->status
                    . " on: ". baseDateFormat($each->created_at, false, "/")
                    . " | From: " . baseDateFormat($each->from, false, '/')
                    . " To: " . baseDateFormat($each->to, false, '/');
            }

            return $list;
        }
        catch (\Exception $exception){
            debug($exception->getMessage());
        }

        return [];
    }


    public function prioritiesDepArrTime(&$list){

        if ($list && count($list)) {
            usort($list, array($this, "compareDepArrTime"));
        }
    }

    function compareDepArrTime($objA, $objB)
    {
        return $objA["depArrTime"] >= $objB["depArrTime"];
    }

    /**
     * @param Roster $roster
     * @return bool
     */
    public function LoadAssignedFlightsAndStaff(&$roster){

        $services = Service::pluck("id")->all();

        $staffAssigned = false;

        $flightsData = [];
        $userIDsArray = [];
        // instead of 100 put max
        for($i = 1; $i <= 300; $i++) {

            $flightInput = "f_".$i;

            if ($flightID = \request()->get($flightInput)) {

                // Service And Staff
                $serviceAndStaff = [];
                foreach ($services as $serviceID) {
                    $serviceInput = "s_" . $i . "_" . $serviceID;

                    if ($userIDs = \request()->get($serviceInput)) {
                        $serviceAndStaff[$serviceID] = $userIDs;

                        foreach ($userIDs as $id) {
                            if (!in_array($id, $userIDsArray)){
                                $userIDsArray[] = $id;
                            }
                        }
                    }
                }

                if (count($serviceAndStaff)) {
                    // Add Services And Staff
//                        $rosterSettings->addAssignedFlight($flightId, $serviceAndStaff);
                    $flightsData[$flightID] = $serviceAndStaff;

                    $staffAssigned = true;
                }
            }
        }

        debug($flightsData);

        $roster->setupAssignedVariables($flightsData, $userIDsArray);

        return $staffAssigned;
    }

    public function staff(Request $request){

        $authUserID = Auth::user()->id;
        $services = Service::pluck("id")->all();

        $flightsData = [];
        $userIDsArray = [];
        // instead of 100 put max
        for($i = 1; $i <= 300; $i++) {

            $flightInput = "f_".$i;

            if ($flightID = \request()->get($flightInput)) {

                // Service And Staff
                $serviceAndStaff = [];
                foreach ($services as $serviceId) {
                    $serviceInput = "s_" . $i . "_" . $serviceId;

                    if ($userIDs = \request()->get($serviceInput)) {
                        $serviceAndStaff[$serviceId] = $userIDs;

                        foreach ($userIDs as $userId) {
                            $flightStaff = FlightStaff::where("flight_id", $flightID)
                                ->where("user_id", $userId)
                                ->where("service_id", $serviceId)
                                ->whereNull("deleted_at")
                                ->orderBy("deleted_at")
                                ->first();

                            if (!$flightStaff){
                                $createNew = true;
                                $flightStaff = new FlightStaff();
                                $flightStaff->flight_id = $flightID;
                                $flightStaff->user_id = $userId;
                                $flightStaff->service_id = $serviceId;
//                                $flightStaff->service_type = $serviceType;
                                $flightStaff->created_by = $authUserID;
                            }

                            $flightStaff->deleted_at = null;
                            $flightStaff->updated_by = $authUserID;
                            $flightStaff->save();

                            $processedFlightStaffIds[] = $flightStaff->id;

//                            if (!in_array($id, $userIDsArray)){
//                                $userIDsArray[] = $id;
//                            }
                        }
                    }
                }

                if (count($serviceAndStaff)) {
                    // Add Services And Staff
//                        $rosterSettings->addAssignedFlight($flightId, $serviceAndStaff);
                    $flightsData[$flightID] = $serviceAndStaff;
                }
            }
        }

//        $roster->setupAssignedVariables($flightsData, $userIDsArray);
    }

    public function fill(){

        if (\request("key") != "allow"){
            return "NOT ALLOWED";
        }

        $users = User::getUsersByLocation();
        $services = Service::pluck("id", "id")->all();
        $handlingAirlines = Airline::where("handling_airline", true)->pluck("id", "id")->all();


        for ($i = 15; $i <= 90; $i += 5){
            $depReportTimes[$i] = $i;
        }

        for ($i = -45; $i < 10; $i += 5){
            $depReleaseTimes[$i] = $i;
        }

        for ($i = 0; $i <= 30; $i += 5){
            $arrReportTimes[$i] = $i;
        }

        for ($i = 10; $i <= 60; $i += 5){
            $arrReleaseTimes[$i] = $i;
        }

        AirlineService::truncate();
        $data = [];
        $airlineServices = $handlingAirports = [];
        foreach ($handlingAirlines as $airline) {
            $airlineServices[$airline] = [];
            $handlingAirports[$airline] = Airport::getAirlinesHandlingAirports($airline);
            foreach ($handlingAirports[$airline] as $airport) {
                $airlineServices[$airline][$airport] = array_rand($services, rand(4, 8));

                foreach ($airlineServices[$airline][$airport] as $service) {
                    $arrService = 1; //rand(0, 1) ? 1 : null;

                    $record = [
                        'airline_id'            => $airline,
                        'airport_id'            => $airport,
                        'service_id'            => $service,
                        'service_timings'       => 1,
                        /*
                        'departure_service'     => 1,
                        'dep_staff_req'         => rand(1, 3),
                        'dep_staff_min'         => rand(1, 3),
                        'dep_report_time'       => array_rand($depReportTimes, 1),
                        'dep_release_time'      => array_rand($depReleaseTimes, 1),
                        'arrival_service'       => $arrService,
                        'arr_staff_req'         => $arrService ? rand(1, 3) : null,
                        'arr_staff_min'         => $arrService ? rand(1, 3) : null,
                        'arr_report_time'       => $arrService ? array_rand($arrReportTimes, 1) : null,
                        'arr_release_time'      => $arrService ? array_rand($arrReleaseTimes, 1) : null,
                        */
                    ];


                    /*
                    if ($record['dep_staff_min'] > $record['dep_staff_req']){
                        $record['dep_staff_min'] = $record['dep_staff_req'];
                    }

                    if ($arrService && $record['arr_staff_min'] > $record['arr_staff_req']){
                        $record['arr_staff_min'] = $record['arr_staff_req'];
                    }
                    */

                    $data[] = $record;
                }
            }
        }

        AirlineService::insert($data);

//        return 1;

        StaffService::truncate();
        $data = [];
        foreach ($users as $i => $user) {
            $userAirport = $user->location->airport_id;
            if ($userAirport){
                foreach ($handlingAirlines as $airline) {
                    if (isset($airlineServices[$airline][$userAirport])) {
                        //$randomServices = array_rand($airlineServices[$airline][$userAirport], rand(4, count($airlineServices[$airline][$userAirport])));
                        foreach ($airlineServices[$airline][$userAirport] as $service) {
                            $data[] = [
                                'user_id'       => $user->id,
                                'airline_id'    => $airline,
                                'service_id'    => $service,
                            ];
                        }
                    }
                }
            }

            if (count($data) >= 5000){
                StaffService::insert($data);
                $data = [];
            }
        }

        return 1;
    }

    /**
     * Roster Setup
     */
    public function setup(){

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
