<?php

namespace App\Http\Controllers;

use App\Classes\FlightStaff\StaffFilter;
use App\Classes\FlightStaff\StaffFilterWatch;
use App\Classes\Simple\ExecutionTime;
use App\Classes\Staff\Report\OverlapHoursCalculation;
use App\Classes\Staff\Report\StaffHours;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\Department;
use App\Models\Flight;
use App\Models\FlightNumber;
use App\Models\FlightStaff;
use App\Models\License;
use App\Models\Location;
use App\Models\Notification;
use App\Models\Service;
use App\Models\StaffAirline;
use App\Models\StaffLicense;
use App\Models\StaffStation;
use App\Models\User;
use App\Models\UserHistory;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class StaffReportController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        ini_set('max_execution_time', 600);
        ini_set('memory_limit', '1024M');
//        return phpinfo();
//        ini_set("max_execution_time", 0);

        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $selectedAirportIds = $request->get("airport") ? $request->get("airport") : array_keys($handlingAirports);
        $selectedAirlineIds = $request->get("airline") ? $request->get("airline") : array_keys($handlingAirlines);

        // AIRLINE Mode
        $selectedDepartment = $request->has("department") ? $request->get("department") : null;

        $period = getPeriod($request);

        $monthlyReport = $staffByDepartment = $staffByAirports = $staffHours = $airlineHours = $flightNumberHours = $flightHours = $dailyReport = $periodUnique = null;

        $staffHistory = $expiryByPeriods = $overlappingHours = null;
        $slaData = [];

        $selectedServices = $this->getSelectedServices($request->get("service_id"));

        debug("Airlines: ". implode(",", $selectedAirlineIds));
        debug($request->all());

        if ($request->has("tab")) {

            switch($request->get("tab")){
                case "expiry":
                    if (airlineModule()){
                        $staffByDepartment = $this->getExpiryArrayByDepartment($selectedDepartment);
                    }
                    else {
                        $expiryByPeriods = $this->getExpiryLicenses($selectedAirportIds);
                    }
//                    return 1;

                    break;

                case "expiry_summary":
                    if (airlineModule()){
                        $staffData = $this->getExpiryArrayByDepartment($selectedDepartment);
                    }
                    else {
                        $staffData = $this->getExpiryArrayByAirport($selectedAirportIds);
                    }
                    break;

                default:
                case "hours":
                    $periodSelected = getSelectedFormPeriod($request->get("dateSearch"), $request->get("dateFrom"), $request->get("dateTo"), $request->get("month"), $request->get("year"));

                    //place this before any script you want to calculate time
                    $executionTime = new ExecutionTime("getAll");
                    $staffFlights = FlightStaff::getAll($period, null, $selectedAirportIds, $selectedAirlineIds, $request->get("flightNumber"), $request->get("report_type"), $handlingAirports);
                    $executionTime->finish();

                    $executionTime->init("getHours");
                    list($staffHours, $airlineHours, $flightNumberHours, $flightHours, $dailyReport, $periodUnique) = FlightStaff::getHours($staffFlights, $request->get("period"), $request->get('dateSearch'));
                    $executionTime->finish();

                    if ($request->get('dateSearch') == PERIOD_MONTH_YEAR && $request->get("period") == MONTHLY) {
                        $monthlyReport = true;
                    }

                    $executionTime->init("getUserHistory");
                    $staffHistory = UserHistory::getUserHistory($periodSelected[0], $periodSelected[1], true, true, $request->get("report_type"), $handlingAirports, $selectedAirportIds, [], $selectedAirlineIds);
                    $executionTime->finish();

                    $executionTime->init("OverlapHoursCalculation");
                    $overlappingHours = new OverlapHoursCalculation($staffHours, $staffHistory, $periodSelected[0], $periodSelected[1]);
//                    $overlappingHours->addNonRosteredUsers(User::getUsersByLocation($selectedAirportIds, false, false, $overlappingHours->getReportUserIDs()));

                    $executionTime->finish();
//                    return 1;

                    //$selectedAirlineIds = Airline::getSelectedAirlineIds($request);
                    $executionTime->init("handlingFlightsRange");
                    $flights = Flight::handlingFlightsRange($periodSelected[0] . " 00:00:00", $periodSelected[1] . " 23:59:59",
                        $selectedAirlineIds, $selectedAirportIds, $request->get("flightNumber"), [], false, false, false,
                        [], false);
                    $executionTime->finish();
                    $processedFlightIDs = $flights->pluck("id")->all();

                    // When Staff has been assigned to another airport flights
                    $executionTime->init("getAirportStaffFlights");
                    $locationFlights = Flight::getAirportStaffFlights($periodSelected[0] . " 00:00:00", $periodSelected[1] . " 23:59:59",
                        $processedFlightIDs, $selectedAirportIds, null, $selectedAirlineIds);
                    $executionTime->finish();

                    if (count($locationFlights)) {
                        foreach ($locationFlights as $each) {
                            $flights->push($each);
                        }
                    }

                    $slaData = [];

                    if ($request->get("export_ba_report")) {
                        try {
                            $slaData = $this->getExportTableData($flights, $selectedAirlineIds, $selectedAirportIds, $dailyReport, $selectedServices);
                            debug($slaData);
                        } catch (\Exception $e) {
                            debug($e);
                        }
                    }

                break;
            }
        }

        $this->viewData = [
            'expiryTypes'               => [
                1           => "View",
                2           => "Export",
            ],

            'reportTypes'               => [
                EXCLUDING_OCC           => "Excluding OCC",
                EXCLUDING_OCC_ALL_STATIONS => "Excluding OCC (all stations)",
                COMBINED_REPORT         => "Combined",
                COMBINED_ALL_STATIONS   => "Combined (all stations)",
                OCC_REPORT              => "OCC Report",
                OCC_REPORT_ALL_STATIONS => "OCC Report (all stations)",
            ],

            'reports'       => [
                1   => "Export & BA Reports",
                2   => "Other Reports",
            ],

            'monthlyReport'             => $monthlyReport,
            'period'                    => $request->get("period"),
            'airports'                  => $handlingAirports,
            'airlines'                  => $handlingAirlines,
            'selectedAirports'          => $selectedAirportIds,
            'selectedAirlines'          => $selectedAirlineIds,

            "flightNumbers"         => FlightNumber::getArrayFlightNumbersWithSector(false, false, false, null, true),

            'staffData'             => isset($staffData) ? $staffData : null,
            'dateToday'             => date('Y-m-d'),
            'periods'               => getPeriods(),
            'monthNames'            => getMonthsArray(),
            'years'                 => getYearsArray(),
            'periodUnique'          => $periodUnique,

            // HOURS REPORT
            'dailyReport'           => $dailyReport,

            // By Staff
            "overlappingHours"      => $overlappingHours,
            // Monthly Version
            'staffHours'            => $staffHours,


            // Office Duties
            "staffHistory"          => $staffHistory,

            // By Airline
            'airlineHours'          => $airlineHours,

            // By Flight
            'flightNumberHours'     => $flightNumberHours,

            // By Flight Date
            'flightHours'           => $flightHours,

            'expiryByPeriods'       => $expiryByPeriods,
            'expiryPeriods'         => Notification::getPeriods(TITLE),
            'licenses'              => License::get(),
            'isAdm'                 => isAdminOrSuperAdmin(),
            'isSuperAdmin'          => isSuperAdmin(),
            'departments'           => ["" => "Select"] + Department::whereNull("deleted_at")
                                                                        ->pluck("name", "id")
                                                                        ->toArray(),
            "data"                  => $slaData,

            "services"              => Service::getServicesListByID(),
            "selectedServices"          => $selectedServices,
            "selectedServicesByName"    => Service::getServicesListByID($selectedServices),
        ];

//        return view("staff-report/layouts/index-export-tab", $this->viewData);
        return view("staff-report/index", $this->viewData);
    }

    function getSelectedServices($data){
        if (!$data || !count($data)){
            return []; //Service::/*whereIn("abbr", ["CKIN", "GATE" ,"LOFO"])->*/orderBy("position")->pluck("id")->all();
        }

        return Service::whereIn("id", $data)->orderBy("position")->pluck("id")->all();
    }

    function getExportTableData($flights, $airlines, $airports, &$dailyReport, $selectedServices)
    {
        $data = $slaReport = $servicesWithData = [];

        $maxServices = 1;

        $airports = is_array($airports) ? $airports : [$airports];

        $handlingStations = Airport::getHandlingStationsIdAndObject();

        debug("Airlines");
        debug($airlines);
        foreach ($flights as $flight) {

            $staffFilter = new StaffFilterWatch( null, $handlingStations, true, true);

            $depInitDate = getFlightDepartureInitialDate($flight);
            $depInitialType = getFlightDepartureInitialTimeType($flight);

            $arrInitDate = getFlightArrivalInitialDate($flight);
            $arrInitialType = getFlightArrivalInitialTimeType($flight);

            $depInitialSpan = departureArrivalTypeSpan($depInitialType, null);
            $arrInitialSpan = departureArrivalTypeSpan($arrInitialType, null);

            $flightNumber = $flight->flightNumber;
            $airline = $flightNumber ? $flightNumber->airline : null;
            $route = $flightNumber ? getSector($flightNumber) : null;

//            $serviceData = \App\Models\Flight::getFlightsStaffServiceData($flight, $airport, true);
//            $staffFilter = new StaffFilterWatch($airport, $flights, true, true);
//            $serviceData = $staffFilter->getFlightServiceData($flight);
            $serviceData = $staffFilter->getFlightServiceData($flight);
            $serviceType = $staffFilter->getRosteredStaffService($flight);

            $fn = ($flightNumber ? getAirlineCode($airline) . "-" . $flightNumber->flight_number : "-");
            $arr = getFlightArrivalInitialDatePTA($flight);
            $dep = getFlightDepartureInitialDatePTD($flight);

            list($stype, $ap) = FlightStaff::getFlightServiceType($flight, null, $handlingStations);

            if (!in_array($ap->id, $airports)
                || (count($airlines) && !in_array($flightNumber->airline_id, $airlines))){
//                debug($fn." / ".$ap->iata. "(Skipped)");
                continue;
            }
//            debug( $fn." / ".$ap->iata);
//            debug($serviceData);

            if ($ap){
                $ap = $ap->iata;
            }
//            $ap = $serviceType && $serviceType == ARRIVAL_SERVICE ? getFlightArrivalAirport($flight, false, true) : getFlightDepartureAirport($flight, false, true);

//            debug($ap);
            if (!isset($data[$ap])){
                $data[$ap] = [];
            }

            $data[$ap][$flight->id] = [
                "fn"            => $fn,
                "std"           => baseDateFormat($dep, true),
                "sta"           => baseDateFormat($arr, true),
                "route"         => $route,
                "type"          => null,
                "date"          => null,
                "max_req"       => 1,

                "stype"         => $stype,
                "services"      => [],
            ];

            if ($serviceType == ARRIVAL_SERVICE) {
                $data[$ap][$flight->id]["type"] = $arrInitialSpan;
                $data[$ap][$flight->id]["date"] = $arrInitDate ? baseDateFormat($arrInitDate, true) : "";
            }
            else {
                $data[$ap][$flight->id]["type"] = $depInitialSpan;
                $data[$ap][$flight->id]["date"] = $depInitDate ? baseDateFormat($depInitDate, true) : "";
            }

            $counter = 0;

//            debug("FINAL: {$serviceType} - ". getFlightNumberFull($flight->flightNumber));
            foreach ($serviceData["services"] as $j => $airlineService) {

                if ($airlineService->service_timings == 1) {
                    if ($airlineService->service->{$serviceType} != 1) {
                        continue;
                    }

                    $obj = $airlineService->service;
                }
                else {
                    if ($airlineService->{$serviceType} != 1) {
                        continue;
                    }

                    $obj = $airlineService;
                }

                $plannedReport = $plannedRelease = $duration = null;

                if ($counter == 0){
//                    debug("FINAL: {$serviceType} - ". getFlightNumberFull($flight->flightNumber));
                }

                switch ($serviceType){
                    case ARRIVAL_SERVICE:
                        $req = "arr_staff_req";
                        $min = "arr_staff_min";
                        $arr = getFlightArrivalInitialDatePTA($flight);
                        $plannedReport = date("Y-m-d H:i:s", strtotime($arr) - (60 * $obj->arr_report_time));
                        $plannedRelease = date("Y-m-d H:i:s", strtotime($arr) + (60 * $obj->arr_release_time));
                        $duration = date("H:i", strtotime($plannedRelease) - strtotime($plannedReport));
                        break;

                    case DEPARTURE_SERVICE:
                        $req = "dep_staff_req";
                        $min = "dep_staff_min";
                        $dep = getFlightDepartureInitialDatePTD($flight);
                        $plannedReport = date("Y-m-d H:i", strtotime($dep) - (60 * $obj->dep_report_time));
                        $plannedRelease = date("Y-m-d H:i", strtotime($dep) - (60 * $obj->dep_release_time));
                        $duration = date("H:i", strtotime($plannedRelease) - strtotime($plannedReport));
                        break;

                    case TURNAROUND_SERVICE:
                        $req = "turn_staff_req";
                        $min = "turn_staff_min";
                        $arr = getFlightArrivalInitialDatePTA(getParentFlight($flight));
                        $dep = getFlightDepartureInitialDatePTD($flight);

                        $plannedReport = date("Y-m-d H:i", strtotime($arr) - (60 * $obj->turn_report_time));
                        $plannedRelease = date("Y-m-d H:i", strtotime($dep) - (60 * $obj->turn_release_time));
                        $duration = date("H:i", strtotime($plannedRelease) - strtotime($plannedReport));

                        break;
                }

                if (!$plannedReport || !$plannedRelease){
                    continue;
                }

                $service = $obj->service ? $obj->service : $obj;
                $sla = $service->abbr;

                if ($selectedServices && count($selectedServices) && !in_array($service->id, $selectedServices)){
                    continue;
                }

                $data[$ap][$flight->id]["services"][$sla] = [
                    "req"       => $obj->{$req},
                    "start"     => baseDateFormat($plannedReport, true),
                    "end"       => baseDateFormat($plannedRelease, true),
                    "staff"     => [],
                ];

                if ($obj->{$req} > $data[$ap][$flight->id]["max_req"]) {
                    $data[$ap][$flight->id]["max_req"] = $obj->{$req};
                }

                $counter++;

                if ($counter > $maxServices) {
                    $maxServices = $counter;
                }

                if (!in_array($sla, $servicesWithData)){
                    $servicesWithData[] = $sla;
                }
            }
        }


        if ($dailyReport && isset($dailyReport["data"])) {
            foreach ($dailyReport["data"] as $flightId => $each) {

                $flight = $each->flight;
                $arr = getFlightArrivalInitialDatePTA($flight);
                $dep = getFlightDepartureInitialDatePTD($flight);


                list($stype, $ap) = FlightStaff::getFlightServiceType($flight, null, $handlingStations);
                if ($ap){
                    $ap = $ap->iata;
                }
//                debug($flight);
//                $ap = $stype && $stype == ARRIVAL_SERVICE ? getFlightArrivalAirport($flight, false, true) : getFlightDepartureAirport($flight, false, true);

//                debug($ap);
                if (!isset($data[$ap])){
                    $data[$ap] = [];
                }

                if (!isset($data[$ap][$flightId])){
                    $flightNumber = $flight->flightNumber;
                    $airline = $flightNumber ? $flightNumber->airline : null;
                    $route = $flightNumber ? getSector($flightNumber) : null;
                    $fn = ($flightNumber ? getAirlineCode($airline) . "-" . $flightNumber->flight_number : "-");

                    $data[$ap][$flightId] = [
                        "fn"            => $fn,
                        "std"           => baseDateFormat($dep, true),
                        "sta"           => baseDateFormat($arr, true),

                        "route"         => $route,
                        "type"          => null,
                        "date"          => null,
                        "max_req"       => 1,

                        "stype"         => $stype,
                        "services"      => [],
                    ];
                }

//                debug($data[$ap][$flightId]);

                /** @var StaffHours $staffHours */
                foreach ($each->staffList as $j => $staffHours) {
                    $user = $staffHours->user;
                    $service = $staffHours->service;

                    switch ($staffHours->serviceType){
                        case ARRIVAL_SERVICE:
                            $req = "arr_staff_req";
                            break;

                        case DEPARTURE_SERVICE:
                            $req = "dep_staff_req";
                            break;

                        case TURNAROUND_SERVICE:
                            $req = "turn_staff_req";
                            break;
                    }

                    if ($selectedServices && count($selectedServices) && !in_array($service->id, $selectedServices)){

                        // Unset data
                        unset($dailyReport["data"][$flightId]->staffList[$j]);
                        continue;
                    }

                    if (!isset($data[$ap][$flightId]["services"][$service->abbr])) {
                        $data[$ap][$flightId]["services"][$service->abbr] = [
                            "req"           => $service->{$req} ? $service->{$req} : "",
                            "start"         => baseDateFormat($staffHours->pReportTime, true),
                            "end"           => baseDateFormat($staffHours->pReleaseTime, true),
                            "staff"         => [],
                            "serviceType"   => $staffHours->serviceType,
                        ];
                    }

                    $item = [
                         "user"     => \App\Models\User::getStation($user) . "-" . $user->first_name . " " . $user->last_name,
                         "start"    => baseDateFormat($staffHours->reportTime ? $staffHours->reportTime : $staffHours->pReportTime, true),
                         "end"      => baseDateFormat($staffHours->releaseTime ? $staffHours->releaseTime : $staffHours->pReleaseTime, true),
                    ];

                    $data[$ap][$flightId]["services"][$service->abbr]["staff"][] = $item;

                    $counter = count($data[$ap][$flightId]["services"]);

                    if ($counter > $maxServices) {
                        $maxServices = $counter;
                    }

                    $currentSlaStaffCount = count($data[$ap][$flightId]["services"][$service->abbr]["staff"]);
                    if ($currentSlaStaffCount > $data[$ap][$flightId]["max_req"]){
                        $data[$ap][$flightId]["max_req"] = $currentSlaStaffCount;
                    }

                    if (!in_array($service->abbr, $servicesWithData)){
                        $servicesWithData[] = $service->abbr;
                    }
                }

//                $data[$ap][$flight->id]["max_req"] = $maxServices;
            }
        }

        foreach ($data as $ap => $fltData) {
            foreach ($fltData as $flightID => $each) {
                foreach ($each["services"] as $sla => $staffData){

                    /// SET
                    $currentSlaStaffCount = count($staffData["staff"]);

                    if ($currentSlaStaffCount > $each["max_req"]){
                        debug("Before: ".$data[$ap][$flightID]["max_req"]);
                        $data[$ap][$flightID]["max_req"] = $currentSlaStaffCount;
                        debug($data[$ap][$flightID]["max_req"]);
                    }
                    // END

                    if (!isset($slaReport[$sla])){
                        $slaReport[$sla] = [
                            "counter"       => 0,

                            "full"          => 0,
                            "short"         => 0,
                            "empty"         => 0,
                            "assigned"      => 0,
                            "unassigned"    => 0,
                        ];
                    }

                    $slaReport[$sla]["counter"]++;

                    if (!$staffData["staff"] || !count($staffData["staff"])){
                        $slaReport[$sla]["empty"]++;
                        $slaReport[$sla]["unassigned"] += isset($staffData["req"]) && $staffData["req"] ? $staffData["req"] : 1;
                    }
                    else {
                        $slaReport[$sla]["assigned"] += count($staffData["staff"]);

                        if (count($staffData["staff"]) >= $staffData["req"]){
                            $slaReport[$sla]["full"]++;
                        }
                        else {
                            $slaReport[$sla]["short"]++;
                        }
                    }
                }
            }
        }

        return [
            "cols"          => $maxServices,
            "list"          => $data,
            "sla"           => $slaReport,
            "slaWithData"   => $servicesWithData,
        ];
    }

    function getExpiryLicenses($selectedAirports){
        $expiryByPeriods = [];

        $periods = Notification::getPeriods(DATE);

        $locations = Location::whereIn("airport_id", is_array($selectedAirports) ? $selectedAirports : [$selectedAirports])
            ->pluck("id")
            ->all();

        $userIDs = User::whereNull("deleted_at")
            ->where(function($sql){
                $sql->whereNull("users.resigned_date")
                    ->orWhere("users.resigned_date", EMPTY_DATE)
                    ->orWhere("users.resigned_date", ">", date("Y-m-d"));
            })
            ->whereIn("location_id", $locations)
            ->whereNull("vs")
            ->pluck("id")
            ->all();

        $prevPeriod = null;
        foreach ($periods as $i => $period) {
            if (!$i || !$period){
                continue;
            }

            $staffLicenses = StaffLicense::with([
                "user",
                "user.reportsTo",
                "user.location",
                "user.location.airport",
                "license"
            ])
                ->whereIn("user_id", $userIDs)
                ->whereNotNull("expiry_date");

            // daily_reminder
            if ($i == 1){
                $staffLicenses->where("expiry_date", "<=", $period);
            }
            else {
                $staffLicenses->where("expiry_date", "<=", $period)
                              ->where("expiry_date", ">", $prevPeriod);
            }

            $staffLicenses = $staffLicenses->orderBy("expiry_date")
                                            ->get();

            $expiryByPeriods[$i] = $staffLicenses;

            $prevPeriod = $period;
        }

        return $expiryByPeriods;
    }

    public function getExpiryArrayByAirport($selectedAirports = null){
        $staffByAirports = [];
        $licenseIds = [];
        $userIds = [];

        $locations = Location::select();

        if ($selectedAirports && ((is_array($selectedAirports) && count($selectedAirports)) || (!is_array($selectedAirports)))){
            $locations->whereIn("airport_id", is_array($selectedAirports) ? $selectedAirports : [$selectedAirports]);
        }

        $locations = $locations->pluck("id")
                                ->all();

        $staffLicenses = StaffLicense::with(["user", "user.location", "user.location.airport"])
                                        ->join("users", "users.id", "=", "staff__licenses.user_id");

        if ($locations && count($locations)){
            $staffLicenses->whereIn("users.location_id", $locations);
        }

        $staffLicenses = $staffLicenses->where(function($sql){
                                            $sql->whereNull("users.resigned_date")
                                                ->orWhere("users.resigned_date", EMPTY_DATE)
                                                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
                                        })
                                        ->whereNull('users.deleted_at')
                                        ->whereNull("users.vs")
                                        ->orderBy("user_id")
                                        ->orderBy("license_id")
                                        ->get(["staff__licenses.*"]);


        foreach ($staffLicenses as $each) {
            if (isUserResignationStarted($each->user) || $each->user->deleted_at){
                continue;
            }

            if ($each->user && $each->user->location && $each->user->location->airport) {
                $ap = $each['user']->location->airport_id; //->iata;
            }
            else {
                $ap = "N/A";
            }

            if (!in_array($each->license_id, $licenseIds)){
                $licenseIds[] = $each->license_id;
            }
            if (!in_array($each->user_id, $userIds)){
                $userIds[] = $each->user_id;
            }

            if (!isset($staffByAirports[$ap])){
                $staffByAirports[$ap] = [];
            }
            if (!isset($staffByAirports[$ap][$each->user_id])){
                $staffByAirports[$ap][$each->user_id] = [
                    'user'      => $each->user
                ];
            }
            if (!isset($staffByAirports[$ap][$each->user_id][$each->license_id])){
                $staffByAirports[$ap][$each->user_id][$each->license_id] = [
                    $each->issue_date,
                    $each->expiry_date
                ]
                ;
            }
        }

        $remainingUsers = User::with(["location", "location.airport"])
            ->where(function($sql){
                $sql->whereNull("users.resigned_date")
                    ->orWhere("users.resigned_date", EMPTY_DATE)
                    ->orWhere("users.resigned_date", ">", date("Y-m-d"));
            })
            ->whereNull('users.deleted_at')
            ->whereNull("vs")
            ->whereIn("location_id", $locations)
            ->whereNotIn("id", $userIds)
            ->get();

        foreach ($remainingUsers as $user) {
            if ($user && $user->location && $user->location->airport) {
                $ap = $user->location->airport_id; //->iata;
            }
            else {
                $ap = "N/A";
            }

            if (!isset($staffByAirports[$ap])){
                $staffByAirports[$ap] = [];
            }

            $staffByAirports[$ap][$user->id] = [
                'user'      => $user
            ];
        }

        if (isset($staffByAirports["N/A"])){
            $airports[] = "N/A";
        }

        return $staffByAirports;
    }

    public function getExpiryArrayByDepartment($selectedDepartment){
        $staffByDepartment = [];
        $licenseIds = [];
        $userIds = [];


        $staffLicenses = StaffLicense::with(["user", "user.location", "user.location.airport"])
            ->join("users", "users.id", "=", "staff__licenses.user_id")
            ->join("users__departments", "users__departments.user_id", "=", "users.id");


        if ($selectedDepartment){
            $staffLicenses->whereIn("users__departments.department_id", is_array($selectedDepartment) ? $selectedDepartment : [$selectedDepartment]);
        }

        $staffLicenses = $staffLicenses->where(function($sql){
                                            $sql->whereNull("users.resigned_date")
                                                ->orWhere("users.resigned_date", EMPTY_DATE)
                                                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
                                        })
                                        ->whereNull('users.deleted_at')
                                        ->orderBy("user_id")
                                        ->get(["staff__licenses.*"]);


        foreach ($staffLicenses as $each) {

            if (!in_array($each->license_id, $licenseIds)){
                $licenseIds[] = $each->license_id;
            }
            if (!in_array($each->user_id, $userIds)){
                $userIds[] = $each->user_id;
            }

            if (!isset($staffByDepartment[$each->user_id])){
                $staffByDepartment[$each->user_id] = [
                    'user'      => $each->user
                ];
            }
            if (!isset($staffByDepartment[$each->user_id][$each->license_id])){
                $staffByDepartment[$each->user_id][$each->license_id] = $each->expiry_date;
            }
        }

        return $staffByDepartment;
    }


}
