<?php

namespace App\Http\Controllers;

use App\Classes\Staff\Roster\Staff\Staff;
use App\Models\License;
use App\Models\StaffLicense;
use App\Models\User;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

use Illuminate\Support\Facades\Validator;

class StaffLicenseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * @param User $user
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function create(User $user)
    {
        $remainingLicenses = [];

        if ($user){

            $type = getUserPositionType($user);

            // Find All Licenses
            $userLicenses = StaffLicense::where("user_id", $user->id)
                                        ->get();

            $userLicensesIds = $userLicenses->keyBy("license_id")->all();
            $userLicensesIds = array_keys($userLicensesIds);

            $remainingLicenses = License::select(["name", "id"]);

            if ($userLicensesIds){
                $remainingLicenses = $remainingLicenses->whereNotIn("id", $userLicensesIds);
            }

            if ($type){
                switch($type){
                    case FCM_CPT_TYPE_ID:
                    case FCM_FA_TYPE_ID:
                        $remainingLicenses->where("type", FCM_LICENSE);
                        break;

                    case CCM_PSR_TYPE_ID:
                    case CCM_CC_TYPE_ID:
                        $remainingLicenses->where("type", CCM_LICENSE);
                        break;
                }
            }
//            else {
//                $remainingLicenses->whereIn("type", [STAFF_AIRPORT_LICENSE, STAFF_AIRLINE_LICENSE]);
//            }


            $remainingLicenses = $remainingLicenses->pluck("name", "id")
                                                   ->all();


        }

        $this->viewData = [
            'user'          => $user,
            'licenses'      => $remainingLicenses,
        ];

        return view("staff-license/create", $this->viewData);
    }

    /**
     * @param Request $request
     * @param User $user
     * @return \Illuminate\Http\RedirectResponse
     */
    public function updateStore(Request $request, User $user)
    {
        debug($request->all());

        $licenseId = $request->get("license");
        $issue_date = $request->get("issue_date");
        $expiry_date = $request->get("expiry_date");

        $staffLicense = StaffLicense::where("user_id", $user->id)
                                    ->where("license_id", $licenseId)
                                    ->first();

        $authUser = Auth::user();
        if ($staffLicense) {
            $staffLicense->updated_by = $authUser->id;
        }
        else {
            $staffLicense = new StaffLicense();
            $staffLicense->user_id = $user->id;
            $staffLicense->license_id = $licenseId;
            $staffLicense->created_by = $authUser->id;
        }

        $staffLicense->issue_date = $issue_date;
        $staffLicense->expiry_date = $expiry_date;
        $staffLicense->save();

        return redirect()->to( route("homepage")."#"."staff/{$user->id}/edit?s=".rand(100, 999)."&tab=licenses");
    }

    /**
     * @var StaffLicense $staff_license
     * @return \Illuminate\Http\RedirectResponse
     */
    public function delete($staff_license)
    {
        if ($staff_license){
            // Audit Deleted
            auditDeleted($staff_license);
//            $staff_license->delete();
        }

        return redirect()->to( route("homepage")."#"."staff/{$staff_license->user_id}/edit?s=".rand(100, 999)."&tab=licenses");
    }

    public function deleteFile(Request $request, StaffLicense $staffLicense){
        $filename = $staffLicense->attachment_file;

        $storageUrl = storage_path("app/public/staff/license/{$staffLicense->user_id}/$filename");

        if (File::exists($storageUrl)){
            File::delete($storageUrl);
        }

        $staffLicense->attachment_file = null;
        $staffLicense->save();

        flash()->success("Certificate Successfully Deleted");

        return redirect()->to( route("homepage")."#"."staff/{$staffLicense->user_id}/edit?s=".rand(100, 999)."&tab=licenses");
    }

    /**
     * @param Request $request
     * @param StaffLicense $staffLicense
     * @return $this|\Illuminate\Http\RedirectResponse
     */
    public function store(Request $request, $staffLicense){

        // Redirect If Not Found
//        if (!Auth::user() || Auth::user() == '' || !userAnyAdmin()) {
//            return redirect()->to('error/page-not-found');
//        }

        $redirectUrl = route("homepage")."#"."staff/{$staffLicense->user_id}/edit?s=".rand(100, 999)."&tab=licenses";

        $mimeType = $request->file('file')->getClientMimeType();
        $file =  ['file' => $request->file('file')];
        $rulesArray = ["application/pdf", "pdf", "image/jpeg", "image/jpg", "image/png", "image/gif",
            "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            "application/vnd.openxmlformats-officedocument.spreadsheetml.template",
            "application/vnd.ms-excel.sheet.macroEnabled.12",
            "application/vnd.ms-excel.template.macroEnabled.12",
            "application/vnd.ms-excel.addin.macroEnabled.12",
            "application/vnd.ms-excel.sheet.binary.macroEnabled.12"];

        if (!in_array($mimeType, $rulesArray)){ // if ($mimeType !== 'application/pdf') {
            return redirect()->to($redirectUrl)
                ->withInput()
                ->withErrors(["'Current File's extension is {$mimeType}. \nFile has to be in PDF format"]);
        }
        else {
            $fileName = $staffLicense->license_id . '.' . $file['file']->getClientOriginalExtension();
            $storagePath = storage_path("app/public/staff/license/{$staffLicense->user_id}/");

            // Picture Save
            $file['file']->move($storagePath, $fileName);

            // Save in DB
            $staffLicense->attachment_file = $fileName;
            $staffLicense->save();

            return redirect()->to($redirectUrl)
                ->withInput()
                ->with("message", "Certificate Successfully Uploaded");
        }
    }

    /**
     * @param Request $request
     * @param $staffLicense
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\Response|\Illuminate\View\View|\Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function show(Request $request, $staffLicense)
    {
        $filename = $staffLicense->attachment_file;
        $url = storage_path("app/public/staff/license/{$staffLicense->user_id}/$filename");

        if ($filename && File::exists($url)) {
            $mimeType = getMimeType($filename);
            $licenseExists = true;
            $fileContents = File::get($url);
            debug(request()->all());
            if (\request("view")){
                return response()->make($fileContents, 200,array('Content-Type' => $mimeType));
            }
            elseif (\request("download")){
                return response()->download($url, $filename, array('Content-Type' => $mimeType));
            }
        }

        return view('staff-license.upload', [
            'staffLicense'      => $staffLicense,
            'user'              => $staffLicense->user,
            'license'           => $staffLicense->license,
            'licenseUrl'        => $url,
            'licenseExists'     => isset($licenseExists) ? $licenseExists : false
        ]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
