<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class SetupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view("setup/index", $this->viewData);
    }

    public function createAdmin()
    {
        return view("setup/create-admin", $this->viewData);
    }

    public function storeAdmin(Request $request)
    {
        if ($request->get('Next')){
            return redirect()->to('setup/create-airline-info');
        }
    }

    public function createAirlineInfo()
    {
        return view("setup/create-airline-info", $this->viewData);
    }

    public function storeAirlineInfo(Request $request)
    {
        if ($request->get('Next')){
            return redirect()->to('setup/create-aircraft-types');
        }
        else if ($request->get('Back')){
            return redirect()->to('setup/create-admin');
        }
    }

    public function createAircraftTypes()
    {
        return view("setup/create-aircraft-types", $this->viewData);
    }

    public function storeAircraftTypes(Request $request)
    {
        if ($request->get('Next')){
            return redirect()->to('setup/create-aircraft');
        }
        else if ($request->get('Back')){
            return redirect()->to('setup/create-airline-info');
        }
    }

    public function createAircraft()
    {
        return view("setup/create-aircraft", $this->viewData);
    }

    public function storeAircraft(Request $request)
    {
        if ($request->get('Next')){
            return redirect()->to('setup/create-flight-crew');
        }
        else if ($request->get('Back')){
            return redirect()->to('setup/create-aircraft-types');
        }
    }


    public function createFlightCrew()
    {
        return view("setup/create-flight-crew", $this->viewData);
    }

    public function storeFlightCrew(Request $request)
    {
        if ($request->get('Next')){
            return redirect()->to('setup/create-cabin-crew');
        }
        else if ($request->get('Back')){
            return redirect()->to('setup/create-aircraft');
        }
    }

    public function createCabinCrew()
    {
        return view("setup/create-cabin-crew", $this->viewData);
    }

    public function storeCabinCrew(Request $request)
    {
        if ($request->get('Next')){
            return redirect()->to('setup/create-cabin-crew');
        }
        else if ($request->get('Back')){
            return redirect()->to('setup/create-flight-crew');
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
