<?php

namespace App\Http\Controllers;

use App\Models\AirlineService;
use App\Models\FlightComFlightStaff;
use App\Models\FlightStaff;
use App\Models\Service;
use App\Models\AirlineLicense;
use App\Models\StaffService;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;


class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->viewData = [
            'services'      => Service::get(),
        ];

        return view("service.index", $this->viewData);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view("service.create", $this->viewData);
    }

    /**
     * Store a newly created resource in storage.
     * @return \Illuminate\Http\Response
     */
    public function store()
    {
        $service = new Service();
        $service->name = \request("name");
        $service->abbr = \request("abbr");
        $this->updateFields($service, true);
        //

        flash()->success("New service successfully created");

        return redirect()->to("airline");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     * @var Service $service
     * @return \Illuminate\Http\Response
     */
    public function edit($service)
    {
        $this->viewData = [
            "service"       => $service,
        ];

        return view("service.edit", $this->viewData);
    }

    /**
     * Update the specified resource in storage.
     * @var Service $service
     * @return \Illuminate\Http\Response
     */
    public function update($service)
    {
        if (!$service){
            return redirect()->back();
        }

        $service->name = \request("name");
        $service->abbr = \request("abbr");
        // Update Record
        $this->updateFields($service, true);
        //

        flash()->success("Service successfully updated.");

        return redirect()->to("airline");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($service)
    {
        if ($service){
            $aLicenses = AirlineLicense::where("service_id", $service->id)
                                        ->get();
            // Audit Deleted
            auditDeleted($aLicenses);

            $airlineServices = AirlineService::where("service_id", $service->id)
                                            ->get();
            // Audit Deleted
            auditDeleted($airlineServices);

            $staffServices = StaffService::where("service_id", $service->id)
                                        ->get();
            // Audit Deleted
            auditDeleted($staffServices);

            $fComFlightStaff = FlightComFlightStaff::where("service_id", $service->id)
                                            ->get();
            // Audit Deleted
            auditDeleted($fComFlightStaff);

            FlightStaff::where("service_id", $service->id)
                                ->update([
                                    "service_id" => null,
                                    "reason"     => "{$service->id} - {$service->abbr} removed",
                                    "deleted_at" => date("Y-m-d H:i:s"),
                                    "updated_by" => Auth::user()->id
                                ]);

            // Audit Deleted
            auditDeleted($service);
//            $service->delete();
        }

        return redirect()->to("airline");
    }

    public function updateFields(&$service, $skipPosition = false){

        $service->include_all_stations = \request("include_all_stations") ? true : null;

        // Departure Services
        $service->departure_service = \request("departure_service") ? true : null;
        $service->dep_staff_req = \request("dep_staff_req");
        $service->dep_staff_min = \request("dep_staff_min");

        $service->effective_from = \request("effective_to") ? \request("effective_from") : null;
        $service->effective_to = \request("effective_from") ? \request("effective_to") : null;

        $depReportTime = \request("dep_report_time");
        if (\request("dep_report_time_type") == "1"){
            $service->dep_report_time = $depReportTime ? (-1) * $depReportTime : null;
        }
        else {
            $service->dep_report_time = $depReportTime;
        }

        $depReleaseTime = \request("dep_release_time");
        if (\request("dep_release_time_type") == "1"){
            $service->dep_release_time = $depReleaseTime ? (-1) * $depReleaseTime : null;
        }
        else {
            $service->dep_release_time = $depReleaseTime;
        }

        // Arrival Services
        $service->arrival_service = \request("arrival_service") ? true : null;
        $service->arr_staff_req = \request("arr_staff_req");
        $service->arr_staff_min = \request("arr_staff_min");

        $arrReportTime = \request("arr_report_time");
        if (\request("arr_report_time_type") == "1"){
            $service->arr_report_time = $arrReportTime ? (-1) * $arrReportTime : null;
        }
        else {
            $service->arr_report_time = $arrReportTime;
        }

        $arrReleaseTime = \request("arr_release_time");
        if (\request("arr_release_time_type") == "1"){
            $service->arr_release_time = $arrReleaseTime ? (-1) * $arrReleaseTime : null;
        }
        else {
            $service->arr_release_time = $arrReleaseTime;
        }


        // Turnaround Services
        $service->turnaround_service = \request("turnaround_service") ? true : null;
        $service->turn_staff_req = \request("turn_staff_req");
        $service->turn_staff_min = \request("turn_staff_min");

        $turnArrReportTime = \request("turn_report_time");
        if (\request("turn_report_time_type") == "1"){
            $service->turn_report_time = $turnArrReportTime ? (-1) * $turnArrReportTime : null;
        }
        else {
            $service->turn_report_time = $turnArrReportTime;
        }

        $turnDepReleaseTime = \request("turn_release_time");
        if (\request("turn_release_time_type") == "1"){
            $service->turn_release_time = $turnDepReleaseTime ? (-1) * $turnDepReleaseTime : null;
        }
        else {
            $service->turn_release_time = $turnDepReleaseTime;
        }

        if (!$skipPosition){
            $service->position = $this->getLastServicePosition();
        }

        $service->save();

    }

    function getLastServicePosition(){
        $pos = Service::orderBy("position", "DESC")->first("position");
        return $pos ? $pos + 1 : 0;
    }
}
