<?php

namespace App\Http\Controllers;

use App\Models\Organization;
use App\Models\PassengerFlight;
use App\Models\RevenueTarget;
use App\Models\SalesCall;
use App\Repositories\Interfaces\IDepartmentRepository;
use App\Repositories\Interfaces\IOrganizationDetailsRepository;
use App\Repositories\Interfaces\IOrganizationLevelDetailsRepository;
use App\Repositories\Interfaces\IOrganizationLevelRepository;
use App\Repositories\Interfaces\IOrganizationRepository;
use App\Repositories\Interfaces\IPositionRepository;
use App\Repositories\Interfaces\ITableRepository;
use App\Repositories\Interfaces\IUserDepartmentRepository;
use App\Repositories\Interfaces\IUserRepository;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


class SalesOrganisationController extends Controller
{
    public function __construct(IOrganizationRepository $organization,
                                IOrganizationDetailsRepository $organizationDetails,
                                IOrganizationLevelRepository $organizationLevel,
                                IOrganizationLevelDetailsRepository $organizationLevelDetails,
                                IUserRepository $user,
                                ITableRepository $table,
                                IPositionRepository $position,
                                IDepartmentRepository $department,
                                IUserDepartmentRepository $userDepartment)
    {
        $this->organization = $organization;
        $this->organizationDetails = $organizationDetails;
        $this->organizationLevel = $organizationLevel;
        $this->organizationLevelDetails = $organizationLevelDetails;
        $this->user = $user;
        $this->table = $table;
        $this->position = $position;
        $this->department = $department;
        $this->userDepartment = $userDepartment;
    }


    public function profile($id)
    {
        $organization = $revenue = $performance = $salesCalls = [];

        if ($id) {
            $organization = $this->organization->find($id);

            // Get All User Organization Info For Index Page
            $this->getUserOrganizationInfo($organization);

            $organization->target = [
                'yearly'            => RevenueTarget::where("organization_id", $id)
                                                    ->where("type_id", 1)
                                                    ->where(DB::raw("YEAR(period_to)"), date("Y"))
                                                    ->first(),

                'quarterly'         => RevenueTarget::where("organization_id", $id)
                                                    ->where("type_id", 2)
                                                    ->where('period_from', "<=", date("Y-m-d"))
                                                    ->where('period_to',   ">", date("Y-m-d"))
                                                    ->first(),

                'monthly'           => RevenueTarget::where("organization_id", $id)
                                                    ->where("type_id", 3)
                                                    ->where('period_from', "<=", date("Y-m-d"))
                                                    ->where('period_to',   ">", date("Y-m-d"))
                                                    ->first(),
            ];

            debug($organization->target);
            if (isset($organization->target['yearly']) && isset($organization['tableIds'])){
                $result = PassengerFlight::searchPassengerFlights($organization['tableIds'] + [
                    'sales_from' => $organization->target['yearly']->period_from,
                    'sales_to' => $organization->target['yearly']->period_from,
                ], FALSE, TRUE);
            }
            /*
            $result = PassengerFlight::searchPassengerFlights([
                'sales_from' => $organization->target['yearly']-> period_from,
                'sales_to' => $organization->target['yearly']->period_from,
            ], FALSE, TRUE);
            */

            $level = $organization->organizationLevel['level'];

            $revenue = [
                'yearly'        => $level ? 250000 / $level : 250000, //isset($result[3]) ? $result[3]   : null,
                'quarterly'     => $level ? 40000 / $level : 40000,
                'monthly'       => $level ? 5000 / $level : 5000
            ];

            if ($organization->target['yearly']) {
                $performance['yearly'] = [
                    'from'          => $organization->target['yearly']->period_from,
                    'to'            => $organization->target['yearly']->period_to,
                    'target'        => $organization->target['yearly']->target,
                    'revenue'       => $revenue['yearly'],
                    'accomplished'  => round($revenue['yearly'] / $organization->target['yearly']->target, 2) * 100,
                    'status'        => $this->TargetAccomplishmentStatus($organization->target['yearly']->target, $revenue['yearly'], $organization->target['yearly']->period_from, $organization->target['yearly']->period_to),
                ];
            }
            if ($organization->target['quarterly']) {
                $performance['quarterly'] = [
                    'from'              => $organization->target['quarterly']-> period_from,
                    'to'                => $organization->target['quarterly']-> period_to,
                    'target'            => $organization->target['quarterly']->target,
                    'revenue'           => $revenue['quarterly'],
                    'accomplished'      => round($revenue['quarterly'] / $organization->target['quarterly']->target, 2) * 100,
                    'status'            => $this->TargetAccomplishmentStatus($organization->target['quarterly']->target, $revenue['quarterly'], $organization->target['quarterly']->period_from, $organization->target['quarterly']->period_to),
                ];
            }
            if ($organization->target['monthly']) {
                $performance['monthly'] = [
                    'from'              => $organization->target['monthly']-> period_from,
                    'to'                => $organization->target['monthly']-> period_to,
                    'target'            => $organization->target['monthly']->target,
                    'revenue'           => $revenue['monthly'],
                    'accomplished'      => round($revenue['monthly'] / $organization->target['monthly']->target, 2) * 100,
                    'status'            => $this->TargetAccomplishmentStatus($organization->target['monthly']->target, $revenue['monthly'], $organization->target['monthly']->period_from, $organization->target['monthly']->period_to),
                ];
            }

            debug($organization);

            $reps = $this->organization->getAllDirectReportees($id, false, ['user', 'position']);

            $arr = [];

            array_walk_recursive($reps, function(&$each) use (&$arr){
                if ($each){

                    $each->target = RevenueTarget::where("organization_id", $each->id)
                                            ->where(DB::raw("YEAR(period_from)"), date("Y"))
                                            ->where("type_id", 1)
                                            ->orderBy("period_from", "DESC")
                                            ->first();

                    $each->reportees = $this->organization->getAllDirectReportees($each->id, false, ['user', 'position']);

                    $arr[] = $each;
                }
            });

            $organization->reportees = $arr;

            if (Auth::user()->id == $organization->user_id){
                $salesCalls = SalesCall::prepareSalesCallsForCalendar($organization);
            }
        }

        $this->viewData = [
            'salesCalls'                    => $salesCalls,
            'performance'                   => $performance,
            'organization'                  => $organization,
        ];

        debug($organization);

        return view("sales-organisation/profile", $this->viewData);
    }


    public function TargetAccomplishmentStatus($target, $revenue, $from, $to){

        $today = date("Y-m-d");
        $days = (strtotime($to) - strtotime($from)) / (60 * 60 * 24);
        $passed = (strtotime($today) - strtotime($from)) / (60 * 60 * 24);

        $averageDailyTarget = round($target / $days, 2);
        $averageDailyRevenue = round($revenue / $passed, 2);

        debug("TARGET: ".$target. "/ DAYS: ".$days." / PASSED: ".$passed." / Average Target: ".$averageDailyTarget. " / Average Revenue: ". $averageDailyRevenue);

        if ($averageDailyRevenue >= $averageDailyTarget * 1.5){
            $class = "bg-color-blue";// "target-over-110";
        }
        elseif ($averageDailyRevenue >= $averageDailyTarget * 1.1){
            $class = "bg-color-green";// "target-over-110";
        }
        else if ($averageDailyRevenue >= $averageDailyTarget){
            $class = "bg-color-greenLight"; // "target-over-100";
        }
        else if ($averageDailyRevenue >= $averageDailyTarget * 0.9){
            $class = "bg-color-orange"; //"target-over-90";
        }
        else {
            $class = "bg-color-red"; //"target-lower-90";
        }

        return $class;
    }


    public function ajaxAddSalesCall(){

        debug(request()->all());

        $user_id = Auth::user()->id;

        $organization = Organization::where('user_id', $user_id)->first();
        if (!$organization){
            return response()->json([
                'success'       => false,
                'message'       => "Your profile is not in the sales organisation list. Please take appropriate actions."
            ]);
        }

        // Create Sales Call
        SalesCall::createSalesCallFromInput($organization);

        return response()->json([
            'success'       => true,
            'message'       => "Sales Call successfully added",
        ]);
    }




    public function getUserOrganizationInfo(&$organization){
        $details = $organization->details;
        $organization->first_name = $organization->user ? $organization->user->first_name : "";
        $organization->last_name = $organization->user ? $organization->user->last_name : "";
        $organization->thumb = $organization->user ? $organization->user->thumb : "";
        $organization->level = $organization->organizationLevel ? $organization->organizationLevel->level : 'Not Assigned';
        $organization->position = $organization->position ? $organization->position->name : '';
        $organization->report_to = $organization->reportToUser ? $organization->reportToUser->first_name." ".$organization->reportToUser->last_name : '';

        if ($organization->reportToUser){
            $reportToOrganization = Organization::where('user_id', $organization->reportToUser->id)->first();
            $organization->report_to_id = $reportToOrganization ? $reportToOrganization->id : null;
        }

        $tableInfo = [];
        foreach ($details as $detail) {
            // Get Value Out Of TableId
            $tableName = $this->table->getAttributeById($detail->table_id, 'name');
            $valueName = $this->getValueFromTableId($detail->table_id, $detail->table_value_id);
            $tableInfo[$tableName][] = $valueName;
        }
        $organization->tableInfo = $tableInfo;

        $tableInfo = [];
        foreach ($details as $detail) {
            // Get Value Out Of TableId
            $tableName = $this->table->getAttributeById($detail->table_id, 'name');
            $tableInfo[$tableName."_id"][] = $detail->table_value_id;
        }
        $organization->tableIds = $tableInfo;

    }

    public function getValueFromTableId($tableId, $tableValueId){
        $name = $this->table->getAttributeById($tableId, 'name');
        $valueObject = DB::table($name)->find($tableValueId);
        $value = null;
        if ($valueObject) {
            switch ($name) {
                case 'sales__channel':
                    $value = $valueObject->channel;
                    break;
                case 'divisions':
                    $value = $valueObject->division;
                    break;
                case 'regions':
                    $value = $valueObject->region;
                    break;
                case 'countries':
                    $value = $valueObject->country;
                    break;
                case 'cities':
                    $value = $valueObject->city;
                    break;
                case 'agency':
                    $value = $valueObject->agency;
                    break;
                case 'passengers':
                    $value = $valueObject->first_name . " " . $valueObject->last_name;
                    break;
            }
        }
        return $value;
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
