<?php

namespace App\Http\Controllers;

use App\Classes\ULD\StockControl;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\Container;
use App\Models\ContainerType;
use App\Models\Flight;
use App\Models\FlightContainerInfo;
use App\Models\FlightNumber;
use App\Models\SCM;
use App\Models\SCMDetail;
use App\Models\StaffAirline;
use App\Models\StaffStation;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;


class SCMController extends Controller
{
    const MAX_EXECUTION_TIME = 60;

    public function index(Request $request)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '128M');

        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $SCMs = [];
        if ($request->all()){

            $selectedAirports = $request->has("airport") ? $request->get("airport") : array_keys($handlingAirports);
            $selectedAirlines = $request->has("airline") ? $request->get("airline") : array_keys($handlingAirlines);

            $SCMs = SCM::searchByDateAirlineAirport(getFormPeriod(), $selectedAirlines, $selectedAirports);
        }

        $this->viewData = [
            "airlines"          => $handlingAirlines,
            "airports"          => $handlingAirports,
            'handlingStations'  => Airport::getHandlingStationsIdAndObject(),

            "SCMs"              => $SCMs,
            'periods'           => getPeriodsArray([6]),
            'monthNames'        => getMonthsArray(),
            'years'             => getYearsArray(),
        ];


        return view("scm-report.index", $this->viewData);
    }


    public function create(Request $request)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '128M');

        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $selectedAirline = $request->get("airline");
        $selectedAirport =  $request->get("airport");
        $datetime = $request->get("datetime");

        $stockControl = new StockControl($selectedAirline, $selectedAirport, $datetime);
        $stockControl->process();


        $this->viewData = [
            "stockULDs"         => isset($stockControl) ? $stockControl->stockULDs : [],
            "airlines"          => $handlingAirlines,
            "airports"          => $handlingAirports,
            'handlingStations'  => Airport::getHandlingStationsIdAndObject(),

            "uldTypes"         => ContainerType::pluck("name", "id")->all() + ["0" => "Other"],
            "owner"            => $selectedAirline ? Airline::find($selectedAirline) : null,
            "airport"          => $selectedAirport,
            "airline"          => $selectedAirline,
            "datetime"         => $datetime,
        ];


        return view("scm-report.create", $this->viewData);
    }


    public function store(Request $request)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '128M');

        $airlineID = $request->get("airline");
        $airportID = $request->get("airport");
        $datetime = $request->get("datetime");

        $stocks = $request->get("st");
        $ULDs = $request->get("uld");

        if (!$stocks && (count($ULDs) == 1 && !$ULDs[0])){
            return redirect()->to("scm-report/create?s=".rand(100, 999)."&airline={$airlineID}&airport={$airportID}");
        }

        $scm = new SCM();
        $scm->airline_id = $airlineID;
        $scm->airport_id = $airportID;
        $scm->scm_datetime = $datetime;
        $scm->created_by = Auth::user()->id;
        $scm->save();

        if ($stocks && is_array($stocks) && count($stocks)) {
            foreach ($stocks as $each) {

                $content = explode("_", $each);
                $containerID = $content[0];
                $infoID = $content[1];

                $scmDetails = new SCMDetail();
                $scmDetails->scm_id = $scm->id;
                $scmDetails->container_id = $containerID;
                if ($infoID) {
                    $scmDetails->info_id = $infoID;
                }
                $scmDetails->save();

            }
        }

        $type = $request->get("type");
        $oType = $request->get("oType");
        $owner = $request->get("owner");

        $airlines = Airline::whereNotNull("iata")
                            ->where("iata", "!=", "")
                            ->pluck("id", "iata")
                            ->all();

        foreach ($ULDs as $i => $num) {

            if (!$num || !$type[$i] && !$oType[$i]){
                continue;
            }

            $currentTypeID = $type[$i];

            if (!$currentTypeID && $oType[$i]){
                $searchType = ContainerType::where("name", strtoupper($oType[$i]))
                                ->first();

                if (!$searchType){
                    $searchType = new ContainerType();
                    $searchType->name = strtoupper($oType[$i]);
                    $searchType->save();
                }

                $currentTypeID = $searchType->id;
            }

            $selectedOwner = null;
            if (array_key_exists(strtoupper($owner[$i]), $airlines)){
                $selectedOwner = $airlines[$owner[$i]];
            }

            // Search Container
            $searchContainer = Container::where("num", $num)
                                        ->where("container_type_id", $currentTypeID);

            if ($selectedOwner){
                $searchContainer->where("airline_id", $selectedOwner);
            }

            $searchContainer = $searchContainer->first();

            // Insert if not found
            if (!$searchContainer){
                $searchContainer = new Container();
                $searchContainer->container_type_id = $currentTypeID;
                $searchContainer->airline_id = $selectedOwner;
                $searchContainer->owner = $owner[$i];
                $searchContainer->num = $num;
                $searchContainer->save();
            }

            $scmDetails = new SCMDetail();
            $scmDetails->scm_id = $scm->id;
            $scmDetails->container_id = $searchContainer->id;
            $scmDetails->save();
        }

        $date = date("Y-m-d", strtotime($datetime));

        return redirect()->to("scm-report?airline={$airlineID}&airport={$airportID}&dateSearch=fromTo&dateFrom={$date}&dateTo={$date}");
    }

    public function delete($scm)
    {
        $scm->deleted_at = date("Y-m-d H:i:s");
        $scm->save();

        return redirect()->to("scm-report?airline={$scm->airline_id}");

    }

    public function restore($scm)
    {
        $scm->deleted_at = null;
        $scm->save();

        return redirect()->to("scm-report?airline={$scm->airline_id}");

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }




    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
