<?php

namespace App\Http\Controllers;

use App\Models\FlightNumber;
use App\Models\FlightSector;
use App\Models\PassengerFlight;
use App\Models\ReportType;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;


class RevenueByFlightController extends Controller
{

    public function index()
    {
        $data = $this->GetFormData();

        return view('revenue-by-flight.index', $data);
    }

    function GetFormData() {

        return [
            "flightNumbers"     => FlightNumber::getArrayFlightNumbersWithSector(false, false, false, false, false),
            'sectors'           => FlightSector::listSectors(),

            "records_per_page" => [
                '50'    => '50',
                '250'   => '250',
                '500'   => '500',
                '1000'  => '1000'
            ],

            "report_types"    => ReportType::pluck('type', 'id')->all(),
        ];

    }

    public function search(){
        // Get All Inputs
        $inputs = request()->all();

        debug($inputs);

        // For Pagination Do Not Update Info Alert Box (Total Result)
        $cacheQuery = isset($inputs['cacheQuery']) ? TRUE : FALSE;

        $inputs["report_type"] = 9;

//        $inputs["status_not_in"] = ["R"];

        // Search Passenger Flights And Total
        list($tableData, $pagination, $totalMode, $total) = PassengerFlight::searchPassengerFlights($inputs, $cacheQuery, TRUE, TRUE);

        // If Report Type is Set -> Show Results View, else Regular
        $view = $totalMode ? 'revenue-by-flight/layouts/index-result-totals' : 'revenue-by-flight/layouts/index-result';

        $strInputs = "?";

        foreach ($inputs as $param => $val ) {
            if ($param != "_token"){
                if (is_array($val)){
                    foreach ($val as $item) {
                        $strInputs .= $param."[]=".$item."&";
                    }
                }
                else {
                    $strInputs .= $param."=".$val."&";
                }
            }
        }

        $this->viewData = [
            'strInputs'         => $strInputs,
            // Query Totals Cache
            'cacheQuery'        => $cacheQuery,
            // Passenger Flights
            'tableData'         => $tableData,
            // Total Mode
            'totalMode'         => $totalMode,
            // Total
            'total'             => $total,
            // Pagination (Enable)
            'pagination'        => $pagination,
            // Records Per Page
            'recordsPerPage'    => isset($inputs['recordsPerPage']) ? $inputs['recordsPerPage'] : 1000,
            // Current Page
            'page'              => isset($inputs['page']) ? $inputs['page'] : 1,
            // Report Type
            'report_type'       => isset($inputs['report_type']) ? ReportType::find($inputs['report_type']) : null,
            // Unique Period
            'unique_periods'    => isset($unique_periods) ? $unique_periods : null,
            // Unique POS
            'unique_pos'        => isset($unique_pos) ? $unique_pos : null,
        ];

        foreach ($this->GetFormData() as $index => $data ) {
            $this->viewData[$index] = $data;
        }

        return view($view, $this->viewData);
    }

    function CalculateIndicators(&$data){

        foreach ($data as $date => $each) {
            if (!($each['flight'] && $each['flight']->flightNumber && $each['flight']->flightNumber->distance)) {
                continue;
            }

            if (!($each['flight']->aircraft && ($each['flight']->aircraft->config_c + $each['flight']->aircraft->config_y) > 0)) {
                continue;
            }

            $distance = $each['flight']->flightNumber->distance;
            $capacity = $each['flight']->aircraft->config_c + $each['flight']->aircraft->config_y;


            $yield = $each['revenue'] && $each['revenue']->pax != 0 > 0 ? round($each['revenue']->revenue / $each['revenue']->pax) : 0;
            $ask = round($distance * $capacity);
            $rask = $each['revenue'] && $ask != 0 ? round($each['revenue']->revenue / $ask, 2) : 0;
            $rpk = $each['revenue'] ? round($each['revenue']->pax * $distance) : 0;
            $loadFactor = $ask != 0 ? 100 * round($rpk / $ask, 2) : 0;
            $yieldKm = $each['revenue'] && $rpk != 0 ? 100 * round($each['revenue']->revenue / $rpk, 2) : 0;

            $data[$date]['indicators'] = [
                'capacity'		=> $capacity,
                'pax'			=> $each['revenue']  ? $each['revenue']->pax      : 0,
                'revenue'		=> $each['revenue']  ? $each['revenue']->revenue  : 0,
                'yield'			=> $yield,
                'ask'			=> $ask,
                'rask'			=> $rask,
                'rpk'			=> $rpk,
                'loadFactor'	=> $loadFactor,
                'yieldKm'		=> $yieldKm,
            ];
        }
    }



}
