<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 28.08.14

 */

use App\Forms\PositionForm;
use App\Models\SubDepartment;
use Illuminate\Http\Request;

use App\Models\Department;
use App\Models\Position;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;

class PositionController extends Controller
{
    /**
     * Index action
     * @return \Illuminate\View\View
     */
    public function getIndex()
    {
        $data = $positions = [];
        if (\request("department_id"))
        {
            $department = Department::findOrFail(\request("department_id"));
            $positions  = Position::where("department_id", $department->id)
                ->orderBy("head_of_department", "DESC")
                ->orderBy("subdepartment_id")
                ->get();
            $data       = [
                "department" => $department
            ];
        }
        elseif (\request("subdepartment_id"))
        {
            $subDepartment = SubDepartment::findOrFail(\request("subdepartment_id"));
            $positions     = Position::where("subdepartment_id", $subDepartment->id)
                ->orderBy("head_of_department", "DESC")
                ->orderBy("subdepartment_id")
                ->get();
            $data          = [
                "subDepartment" => $subDepartment
            ];
        }

        $data["positions"] = $positions;
        return view("position/index", $data);
    }

    /**
     * Add position action
     * @return $this|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function create()
    {
        $data = [];
        if (\request("department_id"))
        {
            $department         = Department::findOrFail(\request("department_id"));
            $data["department"] = $department;
        }
        else if (\request("subdepartment_id"))
        {
            $subDepartment         = SubDepartment::findOrFail(\request("subdepartment_id"));
            $data["subDepartment"] = $subDepartment;
        }

        return view("position/create", $data);
    }


    public function store(Request $request){

        $form = new PositionForm();
        $link = null;

        if (\request("department_id"))
        {
            $department         = Department::findOrFail(\request("department_id"));
            $data["department"] = $department;
        }
        else if (\request("subdepartment_id"))
        {
            $subDepartment         = SubDepartment::findOrFail(\request("subdepartment_id"));
            $data["subDepartment"] = $subDepartment;
        }

        if ($form->isValidAddEdit())
        {
            $position        = new Position;
            $position->name = \request("name");
            $position->type = \request("type");
            $position->head_of_department = \request("head_of_department");
            $position->show_leave_requests = \request("show_leave_requests");
            if (isset($department))
            {
                $link                    = "department_id=" . $department->id;
                $position->department_id = $department->id;
            }
            elseif (isset($subDepartment))
            {
                $link                       = "subdepartment_id=" . $subDepartment->id;
                $position->department_id    = $subDepartment->department_id;
                $position->subdepartment_id = $subDepartment->id;
            }
            $position->save();

            return redirect()->to("position/index?" . $link)
                ->with("message", [
                    "text" => "New position \"$position->name\" was successfully saved",
                    "type" => MESSAGE_SUCCESS
                ]);
        }

        return redirect()->to(URL::full())
            ->withInput()
            ->withErrors($form->getErrors());
    }

    public function edit($position)
    {
        return view("position/edit", [
            "position" => $position
        ]);
    }

    public function update($position){
        $form = new PositionForm;
        if ($form->isValidAddEdit())
        {
            $position->name = \request("name");
            $position->type = \request("type");
            $position->show_leave_requests = \request("show_leave_requests");
            $position->head_of_department = \request("head_of_department");
            $position->save();
            $link = ($position->subdepartment_id) ? "subdepartment_id=$position->subdepartment_id" : $link = "department_id=$position->department_id";

            return redirect()->to("position/index?" . $link)
                ->with("message", [
                    "text" => "Position \"$position->name\" was successfully updated",
                    "type" => MESSAGE_SUCCESS
                ]);
        }

        return redirect()->to(URL::full())
            ->withInput()
            ->withErrors($form->getErrors());
    }

    /**
     * Delete position action
     * @return \Illuminate\Http\RedirectResponse
     */
    public function getDelete()
    {
        $position        = Position::findOrFail(\request("id"));
        $deletedPosition = clone $position;

        // Audit Deleted
        auditDeleted($position);
//        $position->delete();

        return redirect()->to("position/index?" .
            (($deletedPosition->subdepartment_id) ? "subdepartment_id=$position->subdepartment_id" : "department_id=$position->department_id"))
            ->with("message", [
                "text" => "Position \"$deletedPosition->name\" was successfully deleted",
                "type" => MESSAGE_SUCCESS
            ]);
    }

    /**
     * AJAX query to load list of positions
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAjaxPositions()
    {
        if (\request("department_id"))
        {
            $subDepartmentId = \request("sub_department_id");

            if ($subDepartmentId){
                $positions = Position::select([
                    "id",
                    "name"
                ])
                    ->where("subdepartment_id", $subDepartmentId)
                    ->orderBy("name")
                    ->get(["name", "id"]);
            }
            else{
                $positions = Position::where("department_id", \request("department_id"))
                    ->whereNull('subdepartment_id')
                    ->orderBy("name")
                    ->get(["name", "id"]);
            }

            if (count($positions))
            {
                return response()->json([
                    "positions" => $positions,
                    "success"   => TRUE
                ]);
            }

            return response()->json([
                "success"   => false,
                "message"   => "Found 0 positions!"
            ]);
        }
    }

    /**
     * AJAX query to load list of positions
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAjaxPositionUsers()
    {
        $departmentIDs = \request("department_id");
        $locationIDs = \request("location_id");
        $subDepartmentID = \request("subdepartment_id");
        $positionIDs = \request("position_id");

        $users = findUsersByDepartmentPositionLocation($locationIDs, $departmentIDs, $positionIDs, null, true);

        return response()->json([
            "users"     => $users,
            "success"   => TRUE
        ]);
    }
}
