<?php

namespace App\Http\Controllers;

use App\Classes\Simple\ExecutionTime;
use App\Classes\Staff\Report\OverlapHoursCalculation;
use App\Models\Department;
use App\Models\FlightNumber;
use App\Models\FlightStaff;
use App\Models\License;
use App\Models\Notification;
use App\Models\Service;
use App\Models\User;
use App\Models\UserHistory;
use Illuminate\Http\Request;

class PayrollHoursController extends Controller
{
    public function index(Request $request){

        ini_set('max_execution_time', 600);
        ini_set('memory_limit', '1024M');
//        return phpinfo();
//        ini_set("max_execution_time", 0);

        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $selectedAirportIds = $request->get("airport") ? $request->get("airport") : array_keys($handlingAirports);
        $selectedAirlineIds = $request->get("airline") ? $request->get("airline") : array_keys($handlingAirlines);

        $overlappingHours = $monthlyReport = $periodUnique = $selectedServices =null;

        if (\request()->has("dateSearch")) {
            $period = getPeriod($request);

            $selectedServices = $this->getSelectedServices($request->get("service_id"));

            $periodSelected = getSelectedFormPeriod($request->get("dateSearch"), $request->get("dateFrom"), $request->get("dateTo"), $request->get("month"), $request->get("year"));

            //place this before any script you want to calculate time
            $staffFlights = FlightStaff::getAll($period, null, $selectedAirportIds, $selectedAirlineIds, $request->get("flightNumber"),
                $request->get("report_type"), $handlingAirports, $request->get("service_id"));
            list($staffHours, $airlineHours, $flightNumberHours, $flightHours, $dailyReport, $periodUnique)
                = FlightStaff::getHours($staffFlights, $request->get("period"), $request->get('dateSearch'));

            if ($request->get('dateSearch') == PERIOD_MONTH_YEAR && $request->get("period") == MONTHLY) {
                $monthlyReport = true;
            }

            debug($request->all());

//            $staffHistory = [];
//            if (!$request->get("service_id")){
            // If All Airlines
//            $apAll = $selectedAirlineIds == array_keys($handlingAirlines);
                $staffHistory = UserHistory::getUserHistory($periodSelected[0], $periodSelected[1], true, true,
                    $request->get("report_type"), $handlingAirports, $selectedAirportIds, []);
//                    $apAll ? null : $selectedAirlineIds);
//            }

            $overlappingHours = new OverlapHoursCalculation($staffHours, $staffHistory, $periodSelected[0], $periodSelected[1], true);

//            if ($apAll){
                $overlappingHours->addNonRosteredUsers(User::getUsersByLocation($selectedAirportIds, false, false, $overlappingHours->getReportUserIDs()));
                $overlappingHours->sortByUserLastName();
//            }
        }

        $this->viewData = [

            'monthlyReport'         => $monthlyReport,
            'period'                => $request->get("period"),
            'airports'              => $handlingAirports,
            'airlines'              => $handlingAirlines,
            'selectedAirports'      => $selectedAirportIds,
            'selectedAirlines'      => $selectedAirlineIds,

//            "flightNumbers"         => FlightNumber::getArrayFlightNumbersWithSector(false, false, false, null, true),

            'dateToday'             => date('Y-m-d'),
            'periods'               => getPeriods(),
            'monthNames'            => getMonthsArray(),
            'years'                 => getYearsArray(),
            'periodUnique'          => $periodUnique,


            // By Staff
            "overlappingHours"      => $overlappingHours,

            'isAdm'                 => isAdminOrSuperAdmin(),
            'isSuperAdmin'          => isSuperAdmin(),
            "services"              => Service::getServicesListByID(),
            "selectedServices"          => $selectedServices,
            "selectedServicesByName"    => Service::getServicesListByID($selectedServices),
        ];


        return view("payroll-hours/index", $this->viewData);
    }

    function getSelectedServices($data){
        if (!$data || !count($data)){
            return []; //Service::/*whereIn("abbr", ["CKIN", "GATE" ,"LOFO"])->*/orderBy("position")->pluck("id")->all();
        }

        return Service::whereIn("id", $data)->orderBy("position")->pluck("id")->all();
    }
}
