<?php namespace App\Http\Controllers;

use App\Classes\MatchFlights\FlightPosition;
use App\Commands\BindFlights;
use App\Models\Airport;
use App\Models\FlightCom;
use App\Models\FlightSector;
use App\Models\FlightStaff;

use function foo\func;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use App\Models\Flight;
use App\Models\FlightNumber;


class OperationReportsController extends Controller
{
    protected $ptsProperties = [
        "jetway_steps",
        "jetway_on",
        "first_pax_off",
        "last_pax_off",
        "cleaners_onboard",
        "fuelling_started",
        "pre_boarding_started",
        "cleaners_off",
        "pilot_headset",
        "board_pax",
        "all_pax_onboard",
        "gatebags_collected",
        "loadsheet_onboard",
        "all_doors_closed",
        "tug_connected",
        "jetway_off",
        "pushback",
        "final_walk_around",
        "back_steps_used",
        "cabin_bags_checkin",
        "cabin_bags_gate",
        "mhb_ahl",
        "mhb_ohd",
        "mhb_dpr",

        'ckin_open',
        'ckin_close',
        'all_doors_panels_closed',

    ];

    public function flightList(Request $request){
        ini_set("max_execution_time", 300);
        ini_set('memory_limit', '512M');

        // Get Flights With Flight Crew
        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $date = $request->get("date") ? $request->get("date") : date("Y-m-d");

        $selectedAirportIds = $request->get("airport") ? $request->get("airport") : array_keys($handlingAirports);
        $selectedAirlineIds = $request->get("airline") ? $request->get("airline") : array_keys($handlingAirlines);

//        $flights  = $this->getFlights($selectedAirlines, $selectedAirports, $date);


//        $startDate = date("Y-m-d H:i:s", strtotime("-9 hours", strtotime($date." 00:00:00")));
        $startDate   = $date." 00:00:00";
        $endDate   = $date." 23:59:59";

        $flights =  Flight::handlingFlightsRange($startDate, $endDate, $selectedAirlineIds, $selectedAirportIds);

        $ssrList = [];
        // Data Array
//      list($flights, $ssrList) = $this->getMatchedFlights($flights, $date);
        $flights = $this->setParentFlightsAndSSR($flights, $ssrList);

        $this->viewData = [
            'date'              => $date,
            "airlines"          => $handlingAirlines,
            "airports"          => $handlingAirports,

            "flights"           => $flights,
        ];

        return view('operation-reports.flight-list', $this->viewData);
    }

    public function monthlyStatistics(Request $request){

        ini_set("max_execution_time", 300);
        ini_set('memory_limit', '512M');

        // Get Flights With Flight Crew
        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $dateFrom = $request->get("dateFrom") ? $request->get("dateFrom") : date("Y-m-d", strtotime("yesterday"));
        $dateTo = $request->get("dateTo") ? $request->get("dateTo") : date("Y-m-d", strtotime("yesterday"));

        $selectedAirportIds = $request->get("airport") ? $request->get("airport") : array_keys($handlingAirports);
        $selectedAirlineIds = $request->get("airline") ? $request->get("airline") : array_keys($handlingAirlines);

//        $flights  = $this->getFlights($selectedAirlines, $selectedAirports, $date);

//        $startDate = date("Y-m-d H:i:s", strtotime("-9 hours", strtotime($dateFrom." 00:00:00")));
        $startDate   = $dateFrom." 00:00:00";
        $endDate   = $dateTo." 23:59:59";

        $flights =  Flight::handlingFlightsRange($startDate, $endDate, $selectedAirlineIds, $selectedAirportIds, null, [],
            false, false, false, ["flightChild"]);

        // Data Array
//        list($flights, $ssrList) = $this->getMatchedFlights($flights, $dateFrom, $request->get("ssr"));
        $ssrList = [];
        $flights = $this->setParentFlightsAndSSR($flights, $ssrList);

        $this->viewData = [
            'dateFrom'          => $dateFrom,
            'dateTo'            => $dateTo,
            "airlines"          => $handlingAirlines,
            "airports"          => $handlingAirports,

            "flights"           => $flights,
            "ssrList"           => $ssrList,
        ];

        return view('operation-reports.monthly-statistics', $this->viewData);
    }

    public function ptsReport(Request $request){

        ini_set("max_execution_time", 120);
        ini_set('memory_limit', '128M');

        // Get Flights With Flight Crew
        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $dateFrom = $request->get("dateFrom") ? $request->get("dateFrom") : date("Y-m-d", strtotime("yesterday"));
        $dateTo = $request->get("dateTo") ? $request->get("dateTo") : date("Y-m-d", strtotime("yesterday"));

        $selectedAirportIds = $request->get("airport") ? $request->get("airport") : array_keys($handlingAirports);
        $selectedAirlineIds = $request->get("airline") ? $request->get("airline") : array_keys($handlingAirlines);

//        $flights  = $this->getFlights($selectedAirlines, $selectedAirports, $date);

        $startDate = date("Y-m-d H:i:s", strtotime("-9 hours", strtotime($dateFrom." 00:00:00")));
        $endDate   = $dateTo." 23:59:59";

//        $flights =  $this->ptsFlights($startDate, $endDate, $selectedAirlineIds, $selectedAirportIds);

//        $flights =  Flight::handlingFlightsRange($startDate, $endDate, $selectedAirlineIds, $selectedAirportIds);
//        list($linkedFlights, $ssrList) = $this->getMatchedFlights($flights, $dateFrom, $request->get("ssr"));

        $ptsFlights  = $this::FlightsRangeConditional($selectedAirportIds, $selectedAirlineIds,  $request->get("type"));

        /*
           foreach ($flights->lines as $k => $line) {
               $items = $line->getFlights();

               if (count($items) == 2){
                   $flight = $items[1];
               }
               elseif (count($items) == 1){
                   $flight = $items[0];
               }
           }
        */

        foreach ($ptsFlights as $ptsFlight) {
            debug($ptsFlight);
        }

        $this->viewData = [
            "flights"           => $ptsFlights,

            'dateYesterday'     => date('Y-m-d',strtotime(" - 1 days")),
            'dateFrom'          => $dateFrom,
            'dateTo'            => $dateTo,

            "airlines"          => $handlingAirlines,
            "airports"          => $handlingAirports,

            "flightNumbers"     => FlightNumber::getArrayFlightNumbersWithSector(false, false, false, null, true),
            'sectors'           => FlightSector::listSectors(),
            'sectorsByAirlines' => FlightSector::getSectorsByAirlines(),

            'periods'           => getPeriodsArray([6]),
            'monthNames'        => getMonthsArray(),
            'years'             => getYearsArray(),
        ];


        return view('operation-reports.pts-report', $this->viewData);
    }

    public function finance(Request $request){

        ini_set("max_execution_time", 300);
        ini_set('memory_limit', '1024M');

        // Get Flights With Flight Crew
        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $dateFrom = $request->get("dateFrom") ? $request->get("dateFrom") : date("Y-m-d", strtotime("yesterday"));
        $dateTo = $request->get("dateTo") ? $request->get("dateTo") : date("Y-m-d", strtotime("yesterday"));

        $selectedAirportIds = $request->get("airport") ? $request->get("airport") : array_keys($handlingAirports);
        $selectedAirlineIds = $request->get("airline") ? $request->get("airline") : array_keys($handlingAirlines);

//        $flights  = $this->getFlights($selectedAirlines, $selectedAirports, $date);

//        $startDate = date("Y-m-d H:i:s", strtotime("-9 hours", strtotime($dateFrom." 00:00:00")));
//        $endDate   = $dateTo." 23:59:59";

        $flights = $result = null;
        $ssrList = [];
        if ($request->has("form")) {
            $dateSearch = getFormPeriod();

            $flights = Flight::FlightsRangeConditional($selectedAirportIds, $selectedAirlineIds, ALL, null,true, $dateSearch);


            $this->setFlightStaffCounterBySLA($flights);

            setFlightsStationSectorInfo($flights);
            debug(count($flights));

            // Data Array
            $flights = $this->setParentFlightsAndSSR($flights, $ssrList, ["UMNR", "MAAS", "VIP"]);
//            list($flights, $ssrList) = $this->getMatchedFlights($flights, $dateSearch["from"], true, ["UMNR", "MAAS", "VIP"]);


        }

        $currentMonth = $request->get("month") ? $request->get("month") : date('m');
        $this->viewData = [
            "sprAdm"            => isSuperAdmin(),
            'dateFrom'          => $dateFrom,
            'dateTo'            => $dateTo,

            "airlines"          => $handlingAirlines,
            "airports"          => $handlingAirports,

            "flights"           => $flights,
            "ssrList"           => $ssrList,

            'dateYesterday'     => date('Y-m-d',strtotime(" - 1 days")),
            'currentMonth'      => $currentMonth,
            'biMonths'           => [
                null => "Monthly",
                1 => "Bi-Monthly 1-15",
                2 => "Bi-Monthly 16-31",
            ],
            'monthNames'        => getMonthsArray(),
            'years'             => getYearsArray(),
        ];

        return view('operation-reports.finance', $this->viewData);
    }

    function setParentFlightsAndSSR($flights, &$ssrList, $filterSSRs = []){
        $handlingStations = Airport::getHandlingStationsIdAndObject();

        $result = [];
        $parentIDs = [];
        $processedIDs = [];
        foreach ($flights as $i => &$each) {

            if ($each->id == 16198){ // 16203){
                debug($each->parent_id);
            }

            $each->type = getFlightsDepArrType($each, $handlingStations);
            /// Process DEP Flights ONLY
            if ($each->type == DEPARTURE) {
                $each->dep_datetime = getFlightDepartureInitialDate($each);
                $each->dep_date = date("Y-m-d", strtotime($each->dep_datetime));

                $each->arr_datetime = getFlightArrivalInitialDate($each);
                $each->arr_date = date("Y-m-d", strtotime($each->arr_datetime));

                $this->setFlightSSR($each, $ssrList, $filterSSRs);

                $flt = [
                    $each
                ];

                // Processed
                $processedIDs[] = $each->id;

                if ($each->parent_id && !in_array($each->parent_id, $processedIDs)){
                    $parent = $flights->where("id", $each->parent_id)->first();
                    if (!$parent){
                        $parentIDs[] = $each->parent_id;
//                        $parent = Flight::getFlight($each->parent_id, true);
                    }

                    if ($parent){
                        $this->setFlightSSR($parent, $ssrList, $filterSSRs);
                        $flt[] = $parent;

                        // Processed
                        $processedIDs[] = $parent->id;
                    }

                    if ($each->parent_id == 16202){
                        debug($each->id."-". $each->parent_id);
                    }

                    $result[$each->parent_id] = $flt;
                }
                else {
                    $result[] = $flt;
                }
            }

        }

        debug($result);

        // Set parents flights that aren't in $flights' array
        if (count($parentIDs)){
            $parents = Flight::getFlightsDetailed($parentIDs);
            foreach ($parents as $parent){
                if (isset($result[$parent->id])){
                    $this->setFlightSSR($parent, $ssrList, $filterSSRs);
                    $result[$parent->id][] = $parent;
                }
            }
        }

        $unprocessedFlts = $flights->whereNotIn("id", $processedIDs);
        debug("UNPROCESSED FLTS: ");
        debug($unprocessedFlts);
        foreach ($unprocessedFlts as $each){
            $each->type = getFlightsDepArrType($each, $handlingStations);
            $each->dep_datetime = getFlightDepartureInitialDate($each);
            $each->dep_date = date("Y-m-d", strtotime($each->dep_datetime));

            $each->arr_datetime = getFlightArrivalInitialDate($each);
            $each->arr_date = date("Y-m-d", strtotime($each->arr_datetime));

            $this->setFlightSSR($each, $ssrList, $filterSSRs);

            $result[] = [
                $each
            ];
        }

        return $result;
    }

    function setFlightSSR(&$flight, &$ssrList, $filterSSRs = null){

        if ($flight->ssr->count()) {
            $itemSSR = [];
            foreach ($flight->ssr as $flightSSR) {
                if ($filterSSRs && !in_array($flightSSR->ssr, $filterSSRs)){
                    continue;
                }


                $total = $flightSSR->pax_total ? $flightSSR->pax_total : $flightSSR->pax_c + $flightSSR->pax_y;
                if ($total) {
                    debug($total);
                    debug($flightSSR->ssr);
                    $itemSSR[$flightSSR->ssr] = $total;

                    if (!in_array($flightSSR->ssr, $ssrList)) {
                        $ssrList[] = $flightSSR->ssr;
                    }
                }
            }
            $flight->ssr_ready = $itemSSR;
        }
    }

    function FlightsRangeConditional($selectedAirports = null, $selectedAirlines = null, $type = ALL, $includeCancelled = false){

        $flightSearchOption = \request()->get('flightSearch');
        switch ($flightSearchOption) {
            case 'flightNumber':
                $flightSearch = ['flightNumberIds' => \request()->get('flightNumber')];
                break;
            case 'sector':
                $flightSearch = ['sectorId' => \request()->get('sector')];
                break;
            default:
                $flightSearch = null;
                break;
        }

        $dateSearch = getFormPeriod();

        // Get All Flights (filter: Date, Flight Number)
        return $this::getFlightsByDateFlightNumber($dateSearch, $flightSearch, null,
            ($selectedAirports ? $selectedAirports : \request()->get("airport")),
            ($selectedAirlines ? $selectedAirlines : \request()->get("airline")), $type, $includeCancelled);
    }

    function getFlightsByDateFlightNumber($dateSearch, $flightSearch = null, $period = null, $airport = null, $airline = null,
                                          $type = DEPARTURE, $includeCancelled = false){

        $select = "DATE(std)";

        $flightNumberSelect = "flight_number";

        $relationships = [
            'aircraft',
            'aircraft.type',
            'aircraftType',
            'station',
            'departureAirport',
            'arrivalAirport',
            'flightNumber',
            'delays',
            'delays.delay',
            'delays.delay.airline',
            'flightNumber.airline',
            'flightNumber.departureAirport',
            'flightNumber.arrivalAirport',
            'flightParent'
        ];

        $flights = Flight::with($relationships)
            ->join('flights__numbers', 'flights.flight_number_id', '=', 'flights__numbers.id')
            ->join("flights__com_flights_pts", "flights__com_flights_pts.flight_id", "=", "flights.id");

        if ($airline){
            $airline = is_array($airline) ? $airline : [$airline];
            $flights->whereIn("flights__numbers.airline_id", $airline);
        }

        if (isset($dateSearch['month'], $dateSearch['year'])) {
            $month = is_array($dateSearch['month']) ? $dateSearch['month'] : [ $dateSearch ['month'] ];
            $year = is_array($dateSearch['year']) ? $dateSearch['year'] : [ $dateSearch ['year'] ];

            $flights->where(function($query) use ($month, $year) {

                $query->where(function ($sql) use ($month, $year) {
                    $sql->whereIn(DB::raw("MONTH(std)"), $month)
                        ->whereIn(DB::raw("YEAR(std)"), $year);
                })
                    ->orWhere(function ($sql) use ($month, $year) {
                        $sql->whereIn(DB::raw("MONTH(ptd)"), $month)
                            ->whereIn(DB::raw("YEAR(ptd)"), $year);
                    })
                    ->orWhere(function ($sql) use ($month, $year) {
                        $sql->whereIn(DB::raw("MONTH(etd)"), $month)
                            ->whereIn(DB::raw("YEAR(etd)"), $year);
                    })
                    ->orWhere(function ($sql) use ($month, $year) {
                        $sql->whereIn(DB::raw("MONTH(atd)"), $month)
                            ->whereIn(DB::raw("YEAR(atd)"), $year);
                    })
                ;
            });

        }
        elseif (isset($dateSearch['from'], $dateSearch['to'])) {
            $flights->whereBetween("departure_date",
                [
                    date("Y-m-d", strtotime($dateSearch['from'])),
                    date("Y-m-d", strtotime($dateSearch['to']))
                ]);
//            $flights->where(function($sql) use ($dateSearch){
//                $sql->whereBetween  ("std", [ $dateSearch['from']." 00:00:00", $dateSearch['to']." 23:59:59"])
//                    ->orWhereBetween("ptd", [ $dateSearch['from']." 00:00:00", $dateSearch['to']." 23:59:59"])
//                    ->orWhereBetween("etd", [ $dateSearch['from']." 00:00:00", $dateSearch['to']." 23:59:59"])
//                    ->orWhereBetween("atd", [ $dateSearch['from']." 00:00:00", $dateSearch['to']." 23:59:59"]);
//            });
        }

        if (isset($flightSearch['flightNumberIds'])){
            $flightNumbersId = is_array($flightSearch['flightNumberIds']) ? $flightSearch['flightNumberIds'] : [ $flightSearch['flightNumberIds'] ];
            $flights->whereIn('flights__numbers.id', $flightNumbersId);
        }

        if (isset($flightSearch['sectorIds'])){
            $sectorIds = is_array($flightSearch['sectorIds']) ? $flightSearch['sectorIds'] : [ $flightSearch['sectorIds'] ];
            $flights->whereIn('flights__numbers.flight_sector_id', $sectorIds);
        }

        if($airport){
            $airport = is_array($airport) ? $airport : [ $airport ];
            switch($type){
                case ALL:
                    $flights->where(function($sql) use ($airport){
                        $sql->whereIn('flights.departure_airport_id', $airport)
                            ->orWhereIn('flights.arrival_airport_id', $airport)
                            ->orWhereIn('flights__numbers.departure_airport_id', $airport)
                            ->orWhereIn('flights__numbers.arrival_airport_id', $airport);

                    });
                    break;

                case ARRIVAL:
                    $flights->where(function($sql) use ($airport){
                        $sql->whereIn('flights.arrival_airport_id', $airport)
                            ->orWhereIn('flights__numbers.arrival_airport_id', $airport);

                    });
                    break;

                case DEPARTURE:
                default:
                    $flights->where(function($sql) use ($airport){
                        $sql->whereIn('flights.departure_airport_id', $airport)
                            ->orWhereIn('flights__numbers.departure_airport_id', $airport);
                    });
                    break;
            }
        }

        // If Period IS Selected Group By Period
        if (isset($period) && $period != ''){
            $select = groupSelectionNonComparison($period);
            $flights->groupBy('date');
        }

        $flights->whereNull("flights.deleted_at");

        if (!$includeCancelled){
            $flights->whereNull("flights.cancelled_at");
        }

        $flights->orderBy("std")
            ->orderBy("ptd")
            ->orderBy("etd")
            ->orderBy("atd");

        return $flights->get([
                "flights.*",
                $flightNumberSelect,
                DB::raw($select . " AS date"),
            ] + $this->ptsProperties)
            ->keyBy("id");
    }

    function ptsFlights($startDate, $endDate, $airlines = null, $airports = null, $flightNumbers = null){

        $relations = [
            "station",
            "divertedAirport",
            "departureAirport",
            "arrivalAirport",
            "aircraft",
            "aircraft.type",
            "aircraftType",
            "flightNumber",
            "flightNumber.airline",
            "flightNumber.departureAirport",
            "flightNumber.arrivalAirport",
            "delays",
            "delays.delay",
        ];

        $flights = Flight::with($relations)
            ->join("flights__numbers", "flights__numbers.id", "=", "flights.flight_number_id")
            ->join("flights__com_flights_pts", "flights__com_flights_pts.flight_id", "=", "flights.id");

        if ($airlines){
            $flights->join("airlines", "flights__numbers.airline_id", "=", "airlines.id");
        }

        $flights->whereNull("flights.deleted_at");
        $flights->whereNull("flights.cancelled_at");

        if ($startDate) {
            $flights->where(function ($sql) use ($startDate, $endDate) {
                $sql->whereBetween("std", [$startDate, $endDate])
                    ->orWhereBetween("ptd", [$startDate, $endDate])
                    ->orWhereBetween("etd", [$startDate, $endDate])
                    ->orWhereBetween("atd", [$startDate, $endDate]);
            });

        }
        else {
            $flights->where(function ($sql) use ($endDate) {
                $sql->where("std", "<=", $endDate)
                    ->orWhere("ptd", "<=", $endDate)
                    ->orWhere("etd", "<=", $endDate)
                    ->orWhere("atd", "<=", $endDate);
            });
        }

        if ($airports){
            $airports = is_array($airports) ? $airports : [$airports];

            if (count($airports)) {
                if (isset($options['only_departure_airports'])) {
                    $flights->where(function($sql) use ($airports){
                        $sql->whereIn("flights__numbers.departure_airport_id", $airports)
                            ->orWhereIn("flights.departure_airport_id", $airports);
                    });
                } else {
                    $flights->where(function ($sql) use ($airports) {
                        $sql->whereIn("flights__numbers.departure_airport_id", $airports)
                            ->orWhereIn("flights__numbers.arrival_airport_id", $airports)
                            ->orWhereIn("flights.departure_airport_id", $airports)
                            ->orWhereIn("flights.arrival_airport_id", $airports);
                    });
                }
            }
        }

        if ($airlines){
            if (is_array($airlines)){
                $flights->whereIn("flights__numbers.airline_id", $airlines);
            }
            else {
                $flights->where("flights__numbers.airline_id", $airlines);
            }
        }

        if ($flightNumbers && count($flightNumbers)) {
            if (is_array($flightNumbers)){
                $flights->whereIn("flights.flight_number_id", $flightNumbers);
            }
            else {
                $flights->where("flights.flight_number_id", $flightNumbers);
            }
        }

        if ($airlines){
            $flights->orderBy("airlines.airline");
        }



        return $flights->orderBy("std")
            ->orderBy("atd")
            ->orderBy("parent_id")
            ->orderBy("flights__com_flights_pts.id")
            ->get([
                "flights.*",
                "flights__com_flights_pts.*",
            ]);
    }

    function getMatchedFlights($flights, $date = null, $includeSSR = null, $filterSSRs = null){
        $flightPosition = new FlightPosition($flights);
//        $flightPosition = new \App\Classes\BindFlights\FlightPosition($flights);
        $flightPosition->strict = true;
        $flightPosition->date = $date;
//        $flightPosition->limitFlightsPerLine = 2;
        $flightPosition->run();

        $ssrList = [];
        if ($includeSSR) {
            foreach ($flightPosition->lines as $k => $line) {

                foreach ($line->getFlights() as &$flightItem) {
                    if ($flightItem->ssr->count()) {
                        $itemSSR = [];
                        foreach ($flightItem->ssr as $flightSSR) {
                            if ($filterSSRs && !in_array($flightSSR->ssr, $filterSSRs)){
                                continue;
                            }

                            $total = $flightSSR->pax_total ? $flightSSR->pax_total : $flightSSR->pax_c + $flightSSR->pax_y;
                            if ($total) {
                                $itemSSR[$flightSSR->ssr] = $total;

                                if (!in_array($flightSSR->ssr, $ssrList)) {
                                    $ssrList[] = $flightSSR->ssr;
                                }
                            }
                        }

                        $flightItem->ssr_ready = $itemSSR;
                    }
                }
            }
        }

        return [$flightPosition, $ssrList];
    }

    function setFlightStaffCounterBySLA(&$flights){
        $flightIDs = $flights->pluck("id")->all();

        $fStaff = FlightStaff::join("services", "services.id", "=", "flights__staff.service_id")
            ->whereIn("flight_id", $flightIDs)
            ->whereNull("deleted_at")
            ->where(function ($sql){
                $sql->whereNotNull("report_time")
                    ->orWhereNotNull("release_time");
            })
            ->orderBy("flight_id")
            ->orderBy("services.position")
            ->get([
                "flights__staff.flight_id",
                "flights__staff.service_id",
                "flights__staff.report_time",
                "flights__staff.release_time",
                "services.abbr",
            ]);

        if ($fStaff->count() == 0){
            return;
        }

        $services = [];
        foreach ($fStaff as $item) {
            $sla = $item->abbr;
            if (contains($sla, "-T")){
                continue;
            }

            if (!isset($services[$item->flight_id])){
                $services[$item->flight_id] = [];
            }

            if (!isset($services[$item->flight_id][$sla])){
                $services[$item->flight_id][$sla] = 0;
            }

            $services[$item->flight_id][$sla]++;
        }

        foreach ($flights as &$flight){
            if (!isset($services[$flight->id])){
                continue;
            }

            $flight->sla = $this->convertArrayToString($services[$flight->id]);
//            debug($flight->sla);
        }
//        debug($services);
    }

    function convertArrayToString($array) {
        $result = "";
        foreach ($array as $key => $value) {
            $result .= $key . " - " . $value . ", ";
        }
        $result = rtrim($result, ", ");
        return $result;
    }
}
