<?php

namespace App\Http\Controllers;

use App\Models\EmailNotification;
use App\Models\Notification;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class NotificationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $this->viewData = [
            "periods"           => Notification::getPeriods(),
            "types"             => Notification::getTypes(),
            "notifications"     => Notification::with(["updatedBy", "createdBy"])
                                                        ->whereNull("deleted_at")
                                                        ->get(),
        ];


        return view("notification/index", $this->viewData);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->viewData = [
            "periods"           => Notification::getPeriods(),
            "types"             => Notification::getTypes(),
        ];

        return view("notification/create", $this->viewData);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $search = Notification::where("period", $request->get("period"))
                                ->where("type", $request->get("type"))
                                ->where("emails", $request->get("emails"))
                                ->whereNull("deleted_at")
                                ->first();

        if ($search){
            return redirect()->back()->withInput($request->all());
        }

        $notification = new Notification();
        $notification->name = $request->get("name");
        $notification->type = $request->get("type");
        $notification->emails = $request->get("emails");
        $notification->period = $request->get("period");

        $notification->daily_reminder = $request->has("daily_reminder") ? 1 : null;
        $notification->notes = $request->get("notes") ? $request->get("notes") : null;
        $notification->disabled = $request->has("disabled") ? 1 : null;
        $notification->updated_by = Auth::user()->id;
        $notification->created_by = Auth::user()->id;
        $notification->save();

        return redirect()->to("notification");
    }



    /**
     * @param $notification
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit($notification)
    {
        $this->viewData = [
            "notification"    => $notification,

            "periods"           => Notification::getPeriods(),
            "types"             => Notification::getTypes(),
        ];

        return view("notification/edit", $this->viewData);
    }

    /**
     * @param Request $request
     * @param $notification
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, $notification)
    {
        $notification->name = $request->get("name");
        $notification->type = $request->get("type");
        $notification->emails = $request->get("emails");
        $notification->period = $request->get("period");

        $notification->daily_reminder = $request->has("daily_reminder") ? 1 : null;
        $notification->notes = $request->get("notes") ? $request->get("notes") : null;
        $notification->disabled = $request->has("disabled") ? 1 : null;
        $notification->updated_by = Auth::user()->id;
        $notification->save();

        return redirect()->to("notification");
    }

    public function delete($notification)
    {
        $notification->deleted_at = date("Y-m-d H:i:s");
        $notification->updated_by = Auth::user()->id;
        $notification->save();

        return redirect()->to("notification");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
