<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: intranet.dev
 */

use App\Models\Module;
use App\Models\ModulePermission;
use App\Models\UserModule;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;

use App\Models\Department;

use Illuminate\Support\Facades\Session;

class ModuleController extends Controller
{
    protected $data = [];

    /**
     * Index action
     * @return \Illuminate\View\View
     */
    public function index()
    {
        if (!checkAuthorization(ROLE_SUPER_ADMIN))
            return redirect()->to('error/page-not-found');

        $modules = Module::with(["department", 'permission'])
            ->orderBy("category")
            ->orderBy("name")
            ->get();

        if (!$modules->count())
        {
            Session::set("message", [
                "text"  => "Not found any module, you can create module using Add button below",
                "title" => "Information!",
                "type"  => MESSAGE_INFO
            ]);
        }

        return view("module/index", [
            "modules" => $modules
        ]);
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function create()
    {
        $this->viewData = [
            "categories"        => ["" => "Select Category"] + Module::getCategories(),
            "subcategories"     => ["" => "Select Subcategory"] + Module::getSubcategories(),
            "departments"       => [ "0"  => "Home", ""   => "Admin"] + Department::where("is_menu", TRUE)->pluck("name", "id")->all(),
        ];

        return view("module/create", $this->viewData);
    }

    /**
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(){

        $name = \request("name") ? ucwords(trim(\request("name"))) : null;
        $category = \request("new_category") ? ucwords(trim(\request("new_category"))) : (\request("category") ? ucwords(trim(\request("category"))) : null);
        $subcategory = \request("new_subcategory") ? ucwords(trim(\request("new_subcategory"))) : (\request("subcategory") ? ucwords(trim(\request("subcategory"))) : null);

        $findModule = Module::where("name", $name)
                                ->where('category', $category)
                                ->first();

        if ($findModule){
            return redirect()->back();
        }

        $module                = new Module;
        $module->name          = $name;
        $module->lang          = createLangString(\request("name"));

        $module->subname       = \request("subname") ? ucwords(trim(\request("subname"))) : null;
        $module->subname_lang  = createLangString(\request("subname"));

        $module->category      = $category;
        $module->category_lang = createLangString($category);
        $module->subcategory      = $subcategory;
        $module->subcategory_lang = createLangString($subcategory);

        $module->link          = \request("link");

        $module->icon          = \request("icon");
        $module->open_module    = \request("open_module");
        $module->hidden_module = \request("hidden_module");
        $module->open_new_tab  = \request("open_new_tab");
        $module->quick_links   = \request("quick_links");

        $module->department_id = \request("department_id") ? \request("department_id") :  null;
        $module->created_at    = date("Y-m-d H:i:s");
        $module->created_by    = $this->authObject->user()->id;
        $module->save();

        $module->permission()->create([
            "name"      => VIEW_PERMISSION
        ]);

        return redirect()->to("module")
            ->with("message", [
                "text"  => "Module was successfully created",
                "title" => "Success!",
                "type"  => MESSAGE_SUCCESS
            ]);
    }

    /**
     * @param $module
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit($module)
    {
        $this->viewData = [
            "categories"        => ["" => "Select Category"] + Module::getCategories(),
            "subcategories"     => ["" => "Select Subcategory"] + Module::getSubcategories(),
            "departments"       => [ "0"  => "Home", "-1" => "Admin" ] + Department::where("is_menu", TRUE)->pluck("name", "id")->all(),
            "selectedModule"    => $module,
        ];

        return view("module/edit", $this->viewData);
    }

    /**
     * @param $module
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update($module){

        $name = \request("name") ? ucwords(trim(\request("name"))) : null;
        $category = \request("new_category") ? ucwords(trim(\request("new_category"))) : (\request("category") ? ucwords(trim(\request("category"))) : null);
        $subcategory = \request("new_subcategory") ? ucwords(trim(\request("new_subcategory"))) : (\request("subcategory") ? ucwords(trim(\request("subcategory"))) : null);

        $findModule = Module::where("id", "!=", $module->id)
                            ->where("name", $name)
                            ->where('category', $category)
                            ->first();

        if ($findModule){
            return redirect()->back();
        }

        $module->name          = $name;
        $module->lang          = createLangString(\request("name"));
        $module->subname       = \request("subname") ? ucwords(trim(\request("subname"))) : null;
        $module->subname_lang  = createLangString(\request("subname"));

        $module->category      = $category;
        $module->category_lang = createLangString($category);
        $module->subcategory      = $subcategory;
        $module->subcategory_lang = createLangString($subcategory);

        $module->link          = \request("link");

        $module->icon          = \request("icon");
        $module->open_module    = \request("open_module");
        $module->hidden_module = \request("hidden_module");
        $module->open_new_tab  = \request("open_new_tab");
        $module->quick_links   = \request("quick_links");

        $module->department_id = \request("department_id")  && \request("department_id") > 0 ? \request("department_id") :  null;
        $module->updated_by    = Auth::user()->id;
        $module->save();

        if (!$module->permission()->count()){
            $module->permission()->create([
                "name"      => VIEW_PERMISSION
            ]);
        }

        return redirect()->to("module")
            ->with("message", [
                "text"  => "Module was successfully updated",
                "title" => "Success!",
                "type"  => MESSAGE_SUCCESS
            ]);
    }

    /**
     * @param $module
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function delete($module)
    {
        if ($module) {
            // User
            $uModule = UserModule::where('module_id', $module->id)->get();

            // Audit Deleted
            auditDeleted($uModule);

            // Permissions
            $mPermission = ModulePermission::where('module_id', $module->id)->delete();

            // Audit Deleted
            auditDeleted($mPermission);

            // Itself
            $module->delete();
        }

        flash()->success('Module Was Successfully Deleted');

        return redirect("module");
    }

    /**
     * Map action controller
     * @return \Illuminate\View\View
     */
    public function map()
    {
        $modules = Module::with("Department")
            ->get();
        return view("module/map", [
            "modules"     => $modules,
            "departments" => [
                    "0"  => "Home",
                    "-1" => "Admin"
                ] + Department::where("is_menu", TRUE)
                    ->pluck("name", "id")->all()
        ]);
    }


    public function users(){
        $data = [];

        return view('module.users', $data);
    }


    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function ajaxSavePermission(){
        $moduleId = \request("moduleId");
        $permissionId = \request("permissionId");
        $permissionName = \request("permissionName");
        $defaultAll = (int)\request("defaultAll");
        $defaultDept = (int)\request("defaultDept");
        $defaultNone = (int)\request("defaultNone");
        $success = false;
        $messageType = 'Danger';

        if ($permissionId == 'new') {
            $permission = new ModulePermission();
            $permission->module_id = $moduleId;
        }
        else {
            $permission = ModulePermission::find($permissionId);
        }

        if ($permission && $permissionName && strlen($permissionName) > 0) {
            if ($defaultAll) {
                // Give This Permission To EveryOne By Default
                $permission->default_all = 1;
                $permission->default_department = 0;
            } elseif ($defaultDept) {
                // Give This Permission To Everyone Within Permission's Department By Default
                $permission->default_all = 0;
                $permission->default_department = 1;
            } elseif ($defaultNone) {
                // No Default Permission Is Set
                $permission->default_all = 0;
                $permission->default_department = 0;
            }

            $permission->name = $permissionName;
            $permission->updated_by = Auth::user()->id;
            $permission->save();
            $success = true;
            $message = 'Successfully Changed.';
            $messageType = 'Success';
        }
        else{
            $message = 'Permission Not Found. Please Check Again';
        }

        return response()->json([
            'messageType'   => $messageType,
            'success'       => $success,
            'message'       => $message
        ]);
    }


    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function ajaxDeletePermission(){
        $permissionId = \request("permissionId");
        $success = false;
        $messageType = 'Danger';

        if ($permissionId == 'new') {
        }
        else {
            $permission = ModulePermission::find($permissionId);
            if ($permission) {
//              Delete Permissions From Users
//                  UserModule::where('module_permission_id', $permissionId)->delete();

                // Soft Delete
                $permission->deleted_at = date('Y-m-d H:i:s');
                $permission->save();

                $success = true;
                $message = 'Successfully Deleted.';
                $messageType = 'Success';
            }
            else{
                $message = 'Permission Not Found. Please Check Again';
            }

        }
        return response()->json([
            'messageType'   => $messageType,
            'success'       => $success,
            'message'       => $message
        ]);
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function ajaxRestorePermission(){
        $permissionId = \request("permissionId");
        $success = false;
        $messageType = 'Danger';

        $permission = ModulePermission::find($permissionId);
        if ($permission) {

            // Soft Delete
            $permission->deleted_at = null;
            $permission->save();

            $success = true;
            $message = 'Successfully Deleted.';
            $messageType = 'Success';
        }
        else{
            $message = 'Permission Not Found. Please Check Again';
        }

        return response()->json([
            'messageType'   => $messageType,
            'success'       => $success,
            'message'       => $message
        ]);
    }


    /**
     * AJAX remove module from department and attach to HOME menu item
     * @return \Illuminate\Http\JsonResponse
     */
    public function ajaxUpdateModuleDepartment()
    {
        if ($this->isPostRequest() && \request()->ajax())
        {
            $moduleId     = \request("module_id");
            $departmentId = \request("department_id");
            $module       = Module::find($moduleId);
            if ($module)
            {
                $module->department_id = $departmentId;
                $module->save();
                return response()->json(array(
                    "success" => 1,
                    "text"    => "Module was successfully removed from this department"
                ));
            }
            else
            {
                return response()->json(array(
                    "error" => 1,
                    "text"  => "Not found module by given ID"
                ));
            }
        }
        App::abort(404);
    }

}
