<?php namespace App\Http\Controllers;

use App\Http\Requests;

use App\Repositories\ApplicationStatusRepository;
use App\Repositories\Interfaces\IAirlineRepository;
use App\Repositories\Interfaces\IAirportRepository;
use App\Repositories\Interfaces\IApplicationStatusRepository;
use App\Repositories\Interfaces\IBaggageBrandRepository;
use App\Repositories\Interfaces\IBaggageColorRepository;
use App\Repositories\Interfaces\IBaggageTypeRepository;
use App\Repositories\Interfaces\ICountryRepository;
use App\Repositories\Interfaces\IMhbBaggageDetailRepository;
use App\Repositories\Interfaces\IMhbBaggageRepository;
use App\Repositories\Interfaces\IMHBRepository;
use App\Repositories\Interfaces\IMhbTypeRepository;
use Illuminate\Support\Facades\Auth;

use Maatwebsite\Excel\Facades\Excel;

class MhbController extends Controller {

	protected $fileReferenceLength = 6;

    protected $mhbRepository;
    protected $mhbBaggageRepository;
    protected $mhbBaggageDetailRepository;
    protected $mhbTypeRepository;
    protected $airportRepository;
    protected $airlineRepository;
    protected $baggageBrandRepository;
    protected $baggageTypeRepository;
    protected $baggageColorRepository;

    public function __construct(IMHBRepository $mhbRepository, IMhbBaggageRepository $mhbBaggageRepository,
                                IMhbBaggageDetailRepository $mhbBaggageDetailRepository, IMhbTypeRepository $mhbTypeRepository,
                                IAirportRepository $airportRepository, IAirlineRepository $airlineRepository,
                                IBaggageTypeRepository $baggageTypeRepository, IBaggageColorRepository $baggageColorRepository,
                                IBaggageBrandRepository $baggageBrandRepository)
    {
        $this->mhbRepository = $mhbRepository;
        $this->mhbBaggageRepository = $mhbBaggageRepository;
        $this->mhbBaggageDetailRepository = $mhbBaggageDetailRepository;
        $this->airportRepository = $airportRepository;
        $this->airlineRepository = $airlineRepository;
        $this->baggageTypeRepository = $baggageTypeRepository;
        $this->baggageColorRepository = $baggageColorRepository;
        $this->baggageBrandRepository = $baggageBrandRepository;
        $this->mhbTypeRepository = $mhbTypeRepository;

        // call parent constructor
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
	public function index()
	{
        $this->viewData = [
            'mhb'                   => $this->mhbRepository->get(['type', 'airport']),
            'mhb_baggage'           => $this->mhbBaggageRepository->get(['carrier', 'brandName', 'type', 'color', 'details']),
        ];

        return view("mhb/index", $this->viewData);
    }


    public function export($mhb){

        $this->viewData = [
            'mhb'           => $mhb,
            'signature'     => \request("signature")
        ];

        if (\request("export") && \request("export")){

            switch(\request("export")) {
                case XLS:
                    Excel::create('MHB Report', function ($excel) {

                        $excel->sheet('New sheet', function ($sheet) {

                            $sheet->loadView('mhb/export-pdf', $this->viewData);
                        });
                    })->download();
                    break;

                case PDF:
                    Excel::create('MHB Report', function ($excel) {

                        $excel->sheet('New sheet', function ($sheet) {

                            $sheet->loadView('mhb/export-pdf', $this->viewData);
                        });
                    })->download("pdf");
                    break;
            }
        }

        return view('mhb/export-pdf', $this->viewData);
    }


	public function create(ICountryRepository $countryRepository)
	{

		$lastMhb = $this->mhbRepository->first([],[ ['file_reference', ORDER_DESC ]]);
		$fileReference = $lastMhb ? $lastMhb->file_reference : null;

		$this->viewData = [
			'file_reference'  	=> $this->makeFileReferenceNo($fileReference),
			'airlines'  		=> $this->airlineRepository->listModelVariable([ ['iata', 'airline'], 'id', '-']),
			'baggage_types'  	=> $this->baggageTypeRepository->listModelVariable([ 'code', 'id']),
			'baggage_colors'  	=> $this->baggageColorRepository->listModelVariable(['code', 'id']),
			'mhb_types'			=> $this->mhbTypeRepository->listModelVariable(['type', 'id'], true),
			'airports'			=> ["" => "Select"] + $this->airportRepository->findAndListModelVariable(['mhb' => true], [['iata', 'name'], 'id', ', ']),
			'all_airports'		=> $this->airportRepository->findAndListModelVariable(['iata' => [WHERE_NOT_NULL]],[['iata', 'name'], 'id', ', ']),
			'countries'			=> $countryRepository->listModelVariable(['country', 'id'], true)
		];

		return view("mhb/create", $this->viewData);
	}


	public function makeFileReferenceNo($lastFileReference = null){
		if (!$lastFileReference)
		{
			$length = 1;
			$int = 1;
		}
		else {
			$int = (int)$lastFileReference + 1;
			$length = strlen($int);
		}

		$newReferenceNo = "";
		for ($i = 0; $i < $this->fileReferenceLength - $length; $i++){
			$newReferenceNo .= "0";
		}

		$newReferenceNo .= "{$int}";

		return $newReferenceNo;
	}

    /**
     * @param IApplicationStatusRepository $applicationStatusRepository
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
	public function store(IApplicationStatusRepository $applicationStatusRepository)
	{
        // Create MHB Record
        $mhb = $this->createMhbRecord($applicationStatusRepository);

		// Create Each Baggage Details
		$this->createMhbBaggageAndDetails($mhb);

		flash()->success("Application Successfully Submitted.");
		return redirect("/mhb");
	}

    /**
     * @param $applicationStatusRepository
     * @return mixed
     */
    public function createMhbRecord($applicationStatusRepository){
        $mhb = $this->mhbRepository->createByAttributes([
            'file_reference'		=> \request("file_ref"),
        ]);

        if (\request("type_id")) {
            $mhb->type_id = \request("type_id") ? \request("type_id") : null;
        }

        $status = $applicationStatusRepository->findByAttributes(['status' => APPLICATION_STATUS_OPEN]);

        // Make Status To OPEN
        $mhb->status_id = $status ? $status->id : null;

        $mhb->airport_id = \request("apt_id");
        $mhb->carrier = \request("current_carrier");
        $mhb->last_name = \request("lname");
        $mhb->initials = \request("init");
        $mhb->title = \request("title");
        $mhb->ticket_number = \request("tkt_no");
        $mhb->passport_number = \request("passp_no");
        $mhb->received_baggage_weight = \request("recv_wt");
        $mhb->checked_baggage_weight = \request("chkd_wt");
        $mhb->forwarding_instructions = \request("forw_instr");
        $mhb->permanent_address = \request("perm_addr");
        $mhb->permanent_phone = \request("perm_phone");
        $mhb->temporary_address = \request("temp_addr");
        $mhb->temporary_phone = \request("temp_phone");

        $mhb->local_forwarding_instructions = \request("local_forw_instr");
        $mhb->local_delivery_instructions = \request("deliv_instr");
        $mhb->lock_code = \request("lock_code");
        $mhb->keys_attached = \request("keys_attached");
        if (\request("lang") && \request("lang") == 1) {
            $mhb->language = "English";
        }
        else {
            if (\request("lang_other")) {
                $mhb->language = \request("lang_other");
            }
        }

        $mhb->loss_reason = \request("rsn_loss");
        $mhb->report_date = \request("report_date");
        $mhb->agent_signed = \request("agent_signed");
        $mhb->passenger_signed = \request("psng_signed");

        $mhb->save();

        return $mhb;
    }

    /**
     * Create Mhb Details From Submitted Form
     * @param $mhb
     */
    public function createMhbBaggageAndDetails($mhb){
        $carriers = \request("carrier");
        // Used For Converting String With ID
        $airports = $this->airportRepository->findAndListModelVariable(['iata' => [WHERE_NOT_NULL]], ['id', 'iata']);
        $airlines = $this->airlineRepository->findAndListModelVariable(['iata' => [WHERE_NOT_NULL]], ['id', 'iata']);
        $baggageBrands = $this->baggageBrandRepository->listModelVariable([ 'id', 'name']);

        debug(request()->all());

        foreach ($carriers as $i => $each) {
            if ($each){
                $mhbBaggage = $this->mhbBaggageRepository->createByAttributes([
                    'mhb_id'		=> $mhb->id,
                ]);
                $j = $i + 1;

                $mhbBaggage->carrier_id = isset($airlines[$each]) ? $airlines[$each] : null;
                $mhbBaggage->baggage_tag_no = \request("bag_tag")[$i];
                $mhbBaggage->brand_name_id = \request("brand")[$i] ? (isset($baggageBrands[\request("brand")[$i]]) ? $baggageBrands[\request("brand")[$i]] : null) : null;
                $mhbBaggage->baggage_type_id = \request("bag_type")[$i] ? \request("bag_type")[$i] : null;
                $mhbBaggage->baggage_color_id = \request("bag_clr")[$i] ? \request("bag_clr")[$i] : null;
                $mhbBaggage->contents = \request("contents")[$i];
                $mhbBaggage->whs = \request("bag{$j}_whs") ? true : null;


                // Damage Info (if applicable)
                $showBag = false;
                $side1 = \request("bag{$j}_side1");
                $side2 = \request("bag{$j}_side2");
                $end1 = \request("bag{$j}_end1");
                $end2 = \request("bag{$j}_end2");
                $top = \request("bag{$j}_top");
                $bottom = \request("bag{$j}_bottom");

                $mhbBaggage->damage_description = \request("bag{$j}_dmg_desc");
                $mhbBaggage->damage_type = \request("bag{$j}_dmg_type");
                // Add These Details
                if (isset($side1) && is_array($side1) && count($side1)) {
                    $showBag = true;
                    $mhbBaggage->side1 = implode(';', $side1);
                }
                if (isset($side2) && is_array($side2) && count($side2)) {
                    $showBag = true;
                    $mhbBaggage->side2 = implode(';', $side2);
                }
                if (isset($end1) && is_array($end1) && count($end1)) {
                    $showBag = true;
                    $mhbBaggage->end1 = implode(';', $end1);
                }
                if (isset($end2) && is_array($end2) && count($end2)) {
                    $showBag = true;
                    $mhbBaggage->end2 = implode(';', $end2);
                }
                if (isset($top) && is_array($top) && count($top)) {
                    $showBag = true;
                    $mhbBaggage->top = implode(';', $top);
                }
                if (isset($bottom) && is_array($bottom) && count($bottom)) {
                    $showBag = true;
                    $mhbBaggage->bottom = implode(';', $bottom);
                }

                if ($showBag){
                    $mhbBaggage->show_bag = true;
                }

                $mhbBaggage->save();

                debug(\request("dep_apt{$j}"));
                $flightsNumber = count(\request("dep_apt{$j}"));
                for ($n = 0; $n < $flightsNumber; $n++) {
                    debug("HERE");
                    $this->mhbBaggageDetailRepository->createByAttributes([
                        'mhb_baggage_id'		=> $mhbBaggage->id,
                        'departure_airport_id'  => \request("dep_apt{$j}")[$n] ? (isset($airports[\request("dep_apt{$j}")[$n]]) ? $airports[\request("dep_apt{$j}")[$n]] : null) : null,
                        'arrival_airport_id'    => \request("arr_apt{$j}")[$n] ? (isset($airports[\request("arr_apt{$j}")[$n]]) ? $airports[\request("arr_apt{$j}")[$n]] : null) : null,
                        'flight_number'         => \request("flt_no{$j}")[$n],
                        'date_time'             => \request("date{$j}")[$n],
                        'sta'                   => \request("sta{$j}")[$n],
                        'ata'                   => \request("ata{$j}")[$n]
                    ]);

                }

            }
        }
    }


    /**
     * @param $mhb
     * @param ApplicationStatusRepository $applicationStatusRepository
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function delete($mhb, ApplicationStatusRepository $applicationStatusRepository){
        $status = $applicationStatusRepository->findByAttributes(['status' => APPLICATION_STATUS_CANCELLED]);
        // Update Status TO Cancelled
        $mhb->status_id = $status ? $status->id : null;

        $mhb->deleted_at = date('Y-m-d H:i:s');
        $mhb->updated_by = Auth::user()->id;
        $mhb->save();

        flash()->success("Application Cancelled.");
        return redirect("/mhb");
    }

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

    /**
     * @param $mhb
     * @param ApplicationStatusRepository $applicationStatusRepository
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
	public function update($mhb, ApplicationStatusRepository $applicationStatusRepository)
	{
        $status = $applicationStatusRepository->findByAttributes(['status' => APPLICATION_STATUS_CLOSED]);
        // Update Status TO Cancelled
        $mhb->status_id = $status ? $status->id : null;
        $mhb->updated_by = Auth::user()->id;
        $mhb->save();

        flash()->success("Application Status Successfully Changed.");
        return redirect("/mhb");
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

	public function updateAirports(IAirportRepository $airportRepository){
		//$str = file_get_contents('C:\Users\dimmer\Downloads\Airports-master\Airports-master\left_airports.json');
		$json = json_decode($str, true);

		foreach ($json as $i => $each) {
			unset($airport);

			$attr = [
				'iata' => $each['iata'],
				'icao' => $each['icao'],
				'name' => $each['name'],
				'elevation' => $each['elevation'],
				'latitude' => $each['lat'],
				'longitude' => $each['lon'],
				'timezone' => $each['tz']
			];
			if ($each['country']){
				$country = $this->country->findByAttributes(['abbr' => $each['country']]);
				if ($country){
					$attr['country_id'] = $country->id;
				}
			}

			if ($each['city']){
				$city = $this->city->firstOrCreate(['city' => $each['city']]);
				if (!$city->country_id && isset($country)){
					$city->country_id = $country->id;
					$city->save();
				}
				$attr['city_id'] = $city->id;
			}

			if ($each['iata'] || $each['icao']) {
				if ($each['iata']) {
					$airport = $airportRepository->findByAttributes(['iata' => $each['iata']]);
				}

				if ($each['icao'] && (!isset($airport) || !$airport)){
					$airport = $airportRepository->firstOrCreate(['icao' => $each['icao']]);
				}
				$airportRepository->updateById($airport->id, $attr);
			}
			else {
				$airport = $airportRepository->createByAttributes($attr);
			}
		}
	}
}
