<?php namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Repositories\Interfaces\IChatStatusRepository;
use App\Repositories\Interfaces\IUserChatRepository;
use App\Repositories\Interfaces\IUserRepository;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Response;

class MessengerController extends Controller
{
    public function loadUsers(Guard $auth, IUserRepository $user)
    {
        // Load Only (STATUS) IF SET (ex. ONLY Online, Offline, All)
        $status = \request("status");

        $conditions = [
            'vs'                    => [WHERE_NULL],
            'users.id'              => ['<>', $auth->user()->id],
            'chat__status.status'   => [WHERE_RAW, "(`s_chat__status`.`status` is null OR `s_chat__status`.`status` not in ('Offline' , 'Invisible'))"],
        ];

        switch($status){
            case STATUS_OFFLINE:
                $conditions['logged'] = false;
                break;
            case STATUS_ALL:
                break;
            // BY Default -> Show Only Logged Users
            default:
            case STATUS_ONLINE:
                $conditions['logged'] = true;
                break;

        }

        $onlineUsers = $user->findAllByAttributes(
            $conditions, ['chatStatus'], [DB::raw('SUM(IF(s_users__chat.read = 0, 1, 0)) AS counter'), 'first_name', 'last_name', 'thumb', 'chat_status_id', 'logged', 'users.id AS id', 'structure__departments.name AS department'],
                [
                    ['users__departments', 'users__departments.user_id', '=', 'users.id'],
                    ['structure__departments', 'structure__departments.id', '=', 'users__departments.department_id'],
                    ['chat__status', 'chat__status.id', '=', 'users.chat_status_id', 'left'],
                    ['users__chat', 'users__chat.from_user_id', '=', 'users.id', 'left']
                ],
                ['department', ['logged', 'DESC'], 'first_name', 'last_name'],[], ['users.id']
            );

        $usersByDepartment = [];

        foreach ($onlineUsers as $each) {
            if ($each->vs){
                continue;
            }

            if (!isset($usersByDepartment[$each->department]))
                $usersByDepartment[$each->department] = [];

            $usersByDepartment[$each->department][] =
                [
                    'id'        => $each->id,
                    'full_name' => $each->first_name." ".$each->last_name,
                    'logged'    => $each->logged,
                    'thumb'     => $each->thumb,
                    'counter'   => $each->counter,
                    'status'    => $each->chatStatus ? $each->chatStatus->status : ($each->logged ? STATUS_ONLINE : STATUS_OFFLINE)
                ];
        }

        return Response::json(['usersByDepartment' => $usersByDepartment]);
    }

    public function changeStatus(Guard $auth, IUserRepository $user, IChatStatusRepository $chatStatus)
    {
        $status = \request("status");

        $userId = $auth->user()->id;

        $findUsers = $user->find($userId);

        if ($findUsers){
            $findStatus = $chatStatus->findByAttributes(['status' => $status]);
            if ($findStatus){
                $findUsers->chat_status_id = $findStatus->id;
                $findUsers->save();
            }
        }

        return Response::json(['success' => true]);
    }

    public function searchAndLoadUsers(Guard $auth, IUserRepository $user)
    {
        $search = \request("search") == '0' || ! \request("search") ? false : \request("search");

        $onlineUsers = $user->findAllByAttributes(
            [
                'raw' => [WHERE_RAW, "(first_name LIKE '$search%' OR last_name LIKE '$search')"],
                'vs'    => [WHERE_NULL],
                'users.id' => ['<>', $auth->user()->id]],
            [], ['first_name', 'last_name', 'users.id AS id', 'logged', 'chat_status_id', 'structure__departments.name AS department'],
            [
                ['users__departments', 'users__departments.user_id', '=', 'users.id'],
                ['structure__departments', 'structure__departments.id', '=', 'users__departments.department_id']
            ],
            ['department', ['logged', 'DESC'], 'first_name', 'last_name']
        );


        $usersByDepartment = [];

        foreach ($onlineUsers as $each) {
            if (!isset($usersByDepartment[$each->department]))
                $usersByDepartment[$each->department] = [];

            $usersByDepartment[$each->department][] =
                [
                    'id'        => $each->id,
                    'full_name' => $each->first_name." ".$each->last_name,
                    'logged'    => $each->logged,
                    'status'    => $each->chatStatus ? $each->chatStatus->status : ($each->logged ? STATUS_ONLINE : STATUS_OFFLINE)
                ];
        }

        debug($usersByDepartment);
        return Response::json(['usersByDepartment' => $usersByDepartment]);
    }


    public function loadMessages(Guard $auth, IUserChatRepository $userChat, IUserRepository $user){
        $authUserId = $auth->user()->id;
        $userId = \request("userId");

        $messages = $userChat->findAllByAttributes([
            'from_user_id'  => [WHERE_IN, [$authUserId, $userId]],
            'to_user_id'    => [WHERE_IN, [$authUserId, $userId]]
            ],['fromUser', 'toUser'],[],[], [ ['sent', 'DESC'] ], 5);

        // Reverse Order, Put Early Sent First (ASC order)
        $messages = $messages->sortBy('sent');

        // Mark Messages As Read
        $this->markMessagesAsRead($messages);

        $this->viewData = [
            'authUser'          => $user->find($authUserId),
            'toUser'            => $user->find($userId),
            'messages'          => $messages
        ];

        return view('messenger/layouts/active-message-list', $this->viewData);
    }

    public function markMessagesAsRead(&$messages){
        if ($messages && is_object($messages) && count($messages)){
            foreach ($messages as &$each) {
                $each->read = 1;
                $each->save();
            }

        }
    }

    public function loadPreviousMessages(Guard $auth, IUserChatRepository $userChat, IUserRepository $user){
        $authUserId = $auth->user()->id;
        $userId = \request("userId");
        $lastMessageDate = \request("lastMessageDate");
        $lastMessageId = \request("lastMessageId");

        $messages = $userChat->findAllByAttributes([
            'from_user_id'      => [WHERE_IN, [$authUserId, $userId]],
            'to_user_id'        => [WHERE_IN, [$authUserId, $userId]],
            'sent'              => [ "<" , $lastMessageDate],
            'users__chat.id'    => [ "<>" , $lastMessageId],
            ],['fromUser', 'toUser'],[],[], [ ['sent', 'DESC'] ], 3);

        // Reverse Order, Put Early Sent First (ASC order)
        $messages = $messages->sortBy('sent');

        $filtered = $messages->filter(function ($item) use ($authUserId){
            return $item->from_user_id <> $authUserId;
        });

        // Mark Messages As Read
        $this->markMessagesAsRead($filtered, ['from_user_id', '<>', $authUserId]);

        $this->viewData = [
            'authUser'          => $user->find($authUserId),
            'toUser'            => $user->find($userId),
            'messages'          => $messages
        ];

        return view('messenger/layouts/active-message-list', $this->viewData);

    }

    public function loadNewMessages(Guard $auth, IUserChatRepository $userChat, IUserRepository $user){
        $authUserId = $auth->user()->id;
        $userId = \request("userId");

        // IF User is OFFLINE or Status is set TO -> OFFLINE
        $userCheck = $user->find($userId);
        if ($userCheck){
            $userActiveStatus = $userCheck->chatStatus ? $userCheck->chatStatus->status : STATUS_ONLINE;
            if (!$userCheck->logged || $userActiveStatus == STATUS_OFFLINE){
                return response()->json(['userActiveStatus' => STATUS_OFFLINE]);
            }
        }

        $firstMessageDate = \request("firstMessageDate");
        $firstMessageId = \request("firstMessageId");

        $messages = $userChat->findAllByAttributes([
            'from_user_id' => [WHERE_IN, [$authUserId, $userId]],
            'to_user_id' => [WHERE_IN, [$authUserId, $userId]],
            'sent' => [">", [$firstMessageDate]],
            'users__chat.id' => ["<>", [$firstMessageId]],
        ], ['fromUser', 'toUser'], [], [], ['sent']);


        if ($messages->count() == 0){
            return response()->json([
                'increaseRefreshTime'     => true
            ]);
        }


        // Reverse Order, Put Early Sent First (ASC order)
        $messages = $messages->sortBy('sent');

        $filtered = $messages->filter(function ($item) use ($authUserId){
            return $item->from_user_id <> $authUserId;
        });

        // Mark Messages As Read
        $this->markMessagesAsRead($filtered, ['from_user_id', '<>', $authUserId]);

        $this->viewData = [
            'authUser'          => $user->find($authUserId),
            'toUser'            => $user->find($userId),
            'userActiveStatus'  => isset($userActiveStatus) ? $userActiveStatus : STATUS_ONLINE,
            'messages'          => $messages
        ];

        return view('messenger/layouts/active-message-list', $this->viewData);

    }

    public function loadPassiveNewMessages(Guard $auth, IUserChatRepository $userChat, IUserRepository $user){
        $authUserId = $auth->user()->id;
//        $lastUpdateDate =  !\request("lastUpdateDate") || \request("lastUpdateDate") == 'false' ? date('Y-m-d H:i:s') : \request("lastUpdateDate");

        $messages = $userChat->findAllByAttributes([
            'to_user_id'        => $authUserId,
//            'sent'              => [ ">" ,  [$lastUpdateDate]],
            'read'              => 0,
        ],[],['from_user_id', DB::raw('COUNT(*) AS counter')],[], ['sent'], [], 'from_user_id');

        return response()->json([
            'messages'          => $messages->toArray(),
            'lastUpdateDate'    => date('Y-m-d H:i:s')
        ]);

    }



    public function sendMessage(Guard $auth, IUserChatRepository $userChat, IUserRepository $user){
        $authUserId = $auth->user()->id;
        $userId = \request("userId");
        $message = \request("message");
        $key = \request("key");

        $userChat->createByAttributes([
            'from_user_id'  => $authUserId,
            'to_user_id'    => $userId,
            'message'       => $message,
            'key'           => $key,
            'sent'          => date('Y-m-d H:i:s')
        ]);

        return response()->json([
            'success'       => true
        ]);

    }


    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return Response
     */
    public function edit($id)
    {
        //
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return Response
     */
    public function destroy($id)
    {
        //
    }

}
