<?php namespace App\Http\Controllers;

use App\Forms\Airport\AirportUpdateForm;
use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Models\AirportLicense;
use App\Models\Location;
use App\Models\StaffStation;
use App\Repositories\Interfaces\IAirportRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


class LocationController extends Controller {

	public function delete($location)
	{
		$page = \request("page");
        $location->delete();

		flash()->success("Changes Successfully Saved");
		return redirect()->to("airport?page={$page}");
	}


	public function add()
	{
		return view("location/add", $this->viewData);
	}

	/**
	 * @param Request $request
	 * @return \Illuminate\Http\RedirectResponse
	 */
	public function save(Request $request)
	{
		$iata = $request->get("iata");
		$icao = $request->get("icao");

		if ($iata){
            $airport = Airport::where("iata", $iata)
                ->first();
        }
		elseif ($icao){
            $airport = Airport::where("icao", $icao)
                ->first();
        }
		else {
            flash()->error("Please fill one of the fields!");
            return redirect()->back();
        }

		if (!$airport){
            flash()->error("Airport with given IATA/ICAO code not found!");
            return redirect()->back();
		}

		$location = Location::where("airport_id", $airport->id)
                            ->first();

		if ($location){
            flash()->error("Location already exists!");
            return redirect()->back();
        }

        $location = new Location();
		$location->airport_id = $airport->id;
		$location->city_id = $airport->city_id;
		$location->created_by = Auth::user()->id;
        $location->save();

        StaffStation::createCurrentStaffStation($airport);

        return redirect()->to("airport");
	}


}
