<?php

namespace App\Http\Controllers;

use App\Models\License;
use App\Models\Service;
use App\Models\AirlineLicense;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;


class LicenseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $licenses = License::with([
            "airlineLicense",
            "airlineLicense.service",
        ])->get();

        /*
        $services = Service::with([
            "airlineLicense",
            "airlineLicense.license",
        ])->get();
        */

        $this->viewData = [
            "licenses"          => $licenses,
            "airlineModule"     => airlineModule(),
//            "services"  => $services,
            "types"     => getLicenseTypes(false),
        ];

        return view("license.index", $this->viewData);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $services = Service::select([
            DB::raw("CONCAT(abbr, ' (', name, ')') AS full_name"),
            "id"
        ])->pluck("full_name", "id");


        $this->viewData = [
            "services"  => $services,
            "types"     => getLicenseTypes(),

        ];

        return view("license.create", $this->viewData);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($this->checkIfLicenseExists($request->get("name"), $request->get("type"), $request->get("abbr"))){
            return redirect()->back()->withInput([
                "name"  => $request->get("name"),
                "abbr"  => $request->get("abbr"),
                "type"  => $request->get("type"),
            ]);
        }

        $license = new License;
        $license->name = $request->get("name");
        $license->abbr = $request->get("abbr");
        $license->type = $request->get("type");
        $license->save();

        if ($request->get("current_airline_id")){
            return redirect()->to("airline/{$request->get('current_airline_id')}?current_tab=licenses");
        }

        return redirect()->to("license");
    }

    public function checkIfLicenseExists($name, $type, $abbr = null, $excludeId = null){

        if ($abbr){
            $license = License::where(function($sql) use ($name, $abbr){
                $sql->where("name", $name)
                    ->where("abbr", $abbr);
            });
        }
        else{
            $license = License::where("name", $name);
        }

        $license->where("type", $type);

        if ($excludeId){
            $license->where("id", "<>", $excludeId);
        }

        $license = $license->get();

        return ($license->count() > 0);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($license)
    {
        $this->viewData = [
            "license"   => $license,
            "types"     => getLicenseTypes(),

        ];

        return view("license.edit", $this->viewData);
    }

    /**
     * @param Request $request
     * @param $license
     * @return $this|\Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, $license)
    {
        if ($this->checkIfLicenseExists($request->get("name"), $request->get("type"), $request->get("abbr"), $license->id)){
            return redirect()->back()->withInput([
                "name"  => $request->get("name"),
                "abbr"  => $request->get("abbr"),
            ]);
        }

        $license->name = $request->get("name");
        $license->abbr = $request->get("abbr");
        $license->type = $request->get("type");
        $license->save();

        if ($request->get("current_airline_id")){
            return redirect()->to("airline/{$request->get('current_airline_id')}?current_tab=licenses");
        }

        return redirect()->to("license");
    }

    public function delete(Request $request, $license)
    {
        if ($license){
            $aLicenses = AirlineLicense::where("license_id", $license->id)
                                        ->get();
            // Audit Deleted
            auditDeleted($aLicenses);

            // Audit Deleted
            auditDeleted($license);
//            $license->delete();
        }

        if ($request->get("current_airline_id")){
            return redirect()->to("airline/{$request->get('current_airline_id')}?current_tab=licenses");
        }

        return redirect()->to("license");
    }

    public function destroy(Request $request, $license)
    {
        if ($license){
            $aLicenses = AirlineLicense::where("license_id", $license->id)
                                       ->get();
            // Audit Deleted
            auditDeleted($aLicenses);

            // Audit Deleted
            auditDeleted($license);
//            $license->delete();
        }

        if ($request->get("current_airline_id")){
            return redirect()->to("airline/{$request->get('current_airline_id')}?current_tab=licenses");
        }

        return redirect()->to("license");
    }
}
