<?php

namespace App\Http\Controllers;

use App\Models\AirlineLibrary;
use App\Models\Library;
use App\Models\LibrarySign;
use App\Models\LibraryView;
use Illuminate\Http\Request;

class LibraryViewsController extends Controller
{
    public function show($library){

        if (!checkIfModulePermissionIsEnabled(\LIBRARY, "read_and_sign")){
            return redirect()->to('error/page-not-found');
        }

        $this->prepareViewData($library);

        return view("library-view/show", $this->viewData);
    }

    public function showAirline($airline_library){

        if (!checkIfModulePermissionIsEnabled(AIRLINE_LIBRARY, "read_and_sign")){
            return redirect()->to('error/page-not-found');
        }

        $this->prepareViewData($airline_library, AIRLINE_LIBRARY);

        return view("library-view/show", $this->viewData);
    }

    function prepareViewData($library, $type = \LIBRARY){
        $column = $type == AIRLINE_LIBRARY ? "airline_library_id" : "library_id";

        $views = LibraryView::with([
            "user",
            "user.location",
            "user.location.airport",
            "librarySign",
            "librarySign.user",
            "librarySign.locations",
            "librarySign.locations.location",
            "librarySign.locations.location.airport",
            "librarySign.departments",
            "librarySign.positions",
            "librarySign.users",
        ])  ->where("{$column}", $library->id)
            ->whereNotIn("user_id", [42,44])
            ->orderBy("library_sign_id")
            ->get();

        $librarySigns = LibrarySign::with([
            "user",
            "locations",
            "locations.location",
            "locations.location.airport",
            "departments",
            "positions",
            "users",
        ])->where("{$column}", $library->id)
            ->get();

        $this->viewData = [
            "library"       => $library,
            "type"          => $type,
            "libraryViews"  => $views,
            "librarySigns"  => $librarySigns,
        ];
    }

    public function save($id){
        $view = LibraryView::find($id);

        $view->signed_at = date("Y-m-d H:i:s");
        $view->save();

        return redirect()->back();
    }
}
