<?php namespace App\Http\Controllers;

use App\Http\Requests;
use App\Repositories\Interfaces\IIndicatorCategoryRepository;
use App\Repositories\Interfaces\IIndicatorRepository;
use App\Repositories\Interfaces\IUserIndicatorDetailRepository;
use App\Repositories\Interfaces\IUserIndicatorRepository;
use App\Repositories\Interfaces\IWBIncomeLevelRepository;
use App\Repositories\Interfaces\IWBRegionRepository;


class IndicatorController extends Controller {

	/**
	 * Display a listing of the resource.
	 *
	 * @return Response
	 */
	public function index()
	{
		//
	}

    public function deleteUserIndicator($id, IUserIndicatorRepository $userIndicator,
                                            IUserIndicatorDetailRepository $userIndicatorDetail)
    {
        $userInd = $userIndicator->find($id);

        if ($userInd){
            $userIndicatorDetail->deleteByAttributes([
                'user_indicator_id'  => $id
            ]);
            $userIndicator->deleteObject($userInd);
        }

        return response()->json([
            'success'   => true
        ]);
    }

    public function updateUserIndicator($id,
                                        IIndicatorRepository $indicator,
                                        IIndicatorCategoryRepository $indicatorCategory,
                                        IUserIndicatorRepository $userIndicator,
                                        IUserIndicatorDetailRepository $userIndicatorDetail,
                                        IWBIncomeLevelRepository $incomeLevel,
                                        IWBRegionRepository $region){

            $currentUrl = \request("currentUrl");
            $incomeLevels = \request("incomeLevels");
            $regions = \request("regions");
            $countries = \request("countries");
            $categoryId = \request("category") ? \request("category") : null;
            $indicatorId = \request("indicator_id");
            $periodFrom = \request("periodFrom") ? \request("periodFrom") : null;
            $periodTo = \request("periodTo") ? \request("periodTo") : null;

            debug(request()->all());
            $findIndicator = $userIndicator->find($id);
            if ($findIndicator) {
                $userIndicator->update($findIndicator,
                    [
                        'indicator_id'              => $indicatorId,
                        'indicator_category_id'     => $categoryId,
                        'period_from'               => $periodFrom,
                        'period_to'                 => $periodTo
                    ]);
                // Delete Previous
                $userIndicatorDetail->deleteByAttributes(['user_indicator_id' => $id]);

                $data['indicator_id'] = $indicator->find($indicatorId)->indicator_name;
                $data['category'] = $categoryId ? $indicatorCategory->find($categoryId)->category : '';
                $data['periodFrom'] = $periodFrom;
                $data['periodTo'] = $periodTo;

                // Generate Url
                $data['url'] = $currentUrl."?user_indicator_id={$id}".
                    "&indicator_id={$indicatorId}";
                if ($categoryId) {
                    $data['url'] .= "&category={$categoryId}";
                }
                if ($periodFrom) {
                    $data['url'] .= "&periodFrom={$periodFrom}";
                }
                if ($periodTo) {
                    $data['url'] .= "&periodTo={$periodTo}";
                }

                if ($incomeLevels) {
                    foreach ($incomeLevels as $each) {
                        $itemLevel = $incomeLevel->findByAttributes(['code' => $each]);
                        if ($itemLevel) {
                            $userIndicatorDetail->createByAttributes([
                                'user_indicator_id' => $id,
                                'wb_income_level_id' => $itemLevel->id
                            ]);
                            $data['incomeLevels'][] = $itemLevel->name;
                            $data['url'] .= "&incomeLevels[]={$itemLevel->id}";

                        }
                    }
                } elseif ($regions) {
                    foreach ($regions as $each) {
                        $itemRegion = $region->findByAttributes(['code' => $each]);
                        if ($itemRegion) {
                            $userIndicatorDetail->createByAttributes([
                                'user_indicator_id' => $id,
                                'wb_region_id' => $itemRegion->id
                            ]);
                            $data['regions'][] = $itemRegion->name;
                            $data['url'] .= "&regions[]={$itemRegion->id}";
                        }
                    }
                }
                foreach ($countries as $each) {
                    $itemCountry = $this->country->find($each);
                    if ($itemCountry) {
                        $userIndicatorDetail->createByAttributes([
                            'user_indicator_id'  => $id,
                            'country_id'         => $itemCountry->id
                        ]);
                        $data['countries'][] = $itemCountry->country;
                        $data['url'] .= "&countries[]={$each}";
                    }
                }

            }

            return view('template/widget-list-item', ['data' => $data, 'class' => 'bg-orange']);
    }

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		//
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

}
