<?php namespace App\Http\Controllers;

use App\Classes\Support\PaginationFactory;
use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Models\IataTerms;
use App\Repositories\IataTermsRepository;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;


class IataController extends Controller {


    public function terms(IataTermsRepository $iataTerms){

        $perPage = 30;

        $term = \request("iata_term");

        $search_source = \request("search_source") ? \request("search_source") : 'term';

        $currentPage = \request("page") ? \request("page") : 1;

        $terms = $iataTerms->findAllByAttributes([$search_source => ['LIKE', "$term%"]]);

        // $items, $total, $perPage, $currentPage = null, array $options = []

        $termsPerPage = paginate($terms, $currentPage, $perPage);


        $this->viewData = [
            'total'         => $terms,
            'terms'         => $termsPerPage['pageData'],
            'pagination'    => $termsPerPage['pagination'],
            'perPage'       => $perPage,
            'currentPage'   => $currentPage,
            'totalPage'     => ceil(count($terms) / $perPage)
        ];

        return view('iata/terms', $this->viewData);
    }

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		//
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

}
