<?php namespace App\Http\Controllers;
use App\Models\Airport;
use App\Models\StaffStation;
use App\Models\User;
use App\Models\UserLeaveStatus;
use App\Repositories\Interfaces\IUserEntitlementRepository;
use Illuminate\Http\Request;


/**
 * Created by PhpStorm.


 * Project: aviation.dev
 */

class HrmController extends Controller
{
    public function index(){

        $handlingAirports = [ALL => ALL] + StaffStation::currentStaffStationsList(IATA, null, true);

        if (!count($handlingAirports)){
            $handlingAirports = Airport::listHandlingStations();
        }

        $staffList = $this->staffByAirports(User::getUsersByStation(array_keys($handlingAirports), true), $handlingAirports);

        $currentYear = (int)date('Y');

        $this->viewData = [
            'staffList'     => $staffList,
            'airports'      => $handlingAirports,
            "types"         => [
                "Calendar"  => "Calendar",
                "Working"   => "Working"
            ],

            'last3years'    => [$currentYear, ++$currentYear]
        ];

        return view('hrm.index', $this->viewData);
    }

    public function requests(Request $request){
        ini_set("max_execution_time", 300);
        ini_set('memory_limit', '1024M');

        // LM
        $employeesStatus = [];

        $dateFrom = $request->get("dateFrom") ? $request->get("dateFrom") :date("Y-01-01");
        $dateTo = $request->get("dateTo") ? $request->get("dateTo") : date("Y-m-d");
        $user = auth()->user();

        if (isCeo() || isSprAdm()) {

            $ceoUser = isCeo() ? $user : getCeoUser();

            if ($ceoUser){
                // Leaves And Others
                $employeesStatus = UserLeaveStatus::with("leaveRequest")
                    ->join("users__leave_requests", "users__leave_requests.id", "=", "users__leave_status.request_id")
                    ->where('report_to_user_id', $ceoUser->id)
                    ->where(function ($sql) use ($dateFrom, $dateTo){
                        $sql->whereBetween("date_from", [$dateFrom, $dateTo." 23:59:59"])
                            ->orWhereBetween("date_to", [$dateFrom, $dateTo." 23:59:59"])
                            ->orWhereBetween("users__leave_requests.created_at", [$dateFrom, $dateTo." 23:59:59"])
                            ->orWhereBetween("users__leave_requests.updated_at", [$dateFrom, $dateTo." 23:59:59"]);
                    })
                    ->orderBy("users__leave_status.updated_at", "DESC")
                    ->get([
                        "users__leave_status.*"
                    ]);

                $data = UserLeaveStatus::with("leaveRequest")
                    ->join("users__leave_requests", "users__leave_requests.id", "=", "users__leave_status.request_id")
                    ->where("report_to_user_id", "!=", $ceoUser->id)
                    ->where(function ($sql) use ($dateFrom, $dateTo){
                        $sql->whereBetween("date_from", [$dateFrom, $dateTo." 23:59:59"])
                            ->orWhereBetween("date_to", [$dateFrom, $dateTo." 23:59:59"])
                            ->orWhereBetween("users__leave_requests.created_at", [$dateFrom, $dateTo." 23:59:59"])
                            ->orWhereBetween("users__leave_requests.updated_at", [$dateFrom, $dateTo." 23:59:59"]);
                    })
                    ->orderBy("users__leave_status.updated_at", "DESC")
                    ->get([
                        "users__leave_status.*"
                    ]);

                $requests = $employeesStatus->pluck("request_id")->all();


                foreach ($data as $item) {
                    if (!in_array($item->request_id, $requests)) {
                        if (in_array($item->leaveRequest->status_id, [1, 2])) {
                            $employeesStatus[] = $item;
                            $requests[] = $item->request_id;
                        }
                    }
                }
            }
        }

        $currentMonth = $request->get("month") ? $request->get("month") : date('m');

        $this->viewData = [
            'employeesStatus' => $employeesStatus,
            'dateFrom'          => $dateFrom,
            'dateTo'            => $dateTo,
            'currentMonth'      => $currentMonth,
            'monthNames'        => getMonthsArray(),
            'years'             => getYearsArray(),
        ];

        return view('hrm.requests', $this->viewData);
    }

    public function staffByAirports($staffList, &$airports){
        $staffByAirports = [
            "ALL" => []
        ];

        foreach ($staffList as $each) {

            if ($each->location && $each->location->airport) {
                $ap = $each->location->airport->iata;
            }
            else {
                $ap = "N/A";
                if ($each->user_role_id == ROLE_SUPER_ADMIN){
                    continue;
                }
            }

            if (!isset($staffByAirports[$ap])){
                $staffByAirports[$ap] = [];
            }

            $each->ap = $ap;

            $staffByAirports[$ap][] = $each;

            // All
            $staffByAirports[ALL][] = $each;
        }

        if (isset($staffByAirports["N/A"]) && !in_array("N/A", $airports)){
            $airports[] = "N/A";
        }

        return $staffByAirports;
    }

    public function edit($user, IUserEntitlementRepository $entitlementRepository){

        $currentYear = (int)date('Y');
        $last3years = [$currentYear, ++$currentYear, ++$currentYear];

        $entitlements = $entitlementRepository->findAllByAttributes([
            'year'      => [WHERE_IN, $last3years],
            'user_id'   => $user->id
        ]);


        $this->viewData = [
            'user'              => $user,
            'types'             => ['Calendar' => "Calendar", 'Working' => "Working"],
            'last3years'        => $last3years,
            'entitlements'      => $entitlements->keyBy('year')
        ];

        return view('hrm.edit', $this->viewData);
    }

    public function update($user, IUserEntitlementRepository $userEntitlementRepository){
        debug(\request()->all());

        $entitlement = $user->entitlements;

        foreach (\request()->get('year') as $i => $year) {
            $search = $entitlement->where('year', intval($year));

            if (count($search)) {
                $search = $search->first();
            }
            else {
                $search = $userEntitlementRepository->createByAttributes([
                    'user_id'   => $user->id,
                    'year'      => $year
                ]);
            }

            if (\request()->get('type')[$i]) {
                $search->type = \request()->get('type')[$i];
            }
            $search->entitlement = \request()->get('entitlement')[$i];
//            $search->pending = \request()->get('pending')[$i];
            $search->used = \request()->get('used')[$i];
            $search->save();
        }

        flash()->success('Successfully Saved');

        return redirect()->to("hrm");//to('/user/'.$user->id);
    }
}
