<?php

namespace App\Http\Controllers;

use App\Repositories\Interfaces\IHomeChartRepository;
use Illuminate\Http\Request;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\Chart;
use App\Models\ChartType;
use App\Models\Flight;
use App\Models\FlightDelay;
use App\Models\HomeChart;
use App\Models\ReportPeriod;
use App\Models\StaffAirline;
use App\Models\StaffStation;
use Illuminate\Contracts\Auth\Guard;
use App\Models\User;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Session;

class HomeController extends Controller
{
    const MAX_EXECUTION_TIME = 100;

    public function __construct()
    {
        $this->middleware('auth');
//        $this->homeChart = $homeChart;
    }

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index()
    {
        //return redirect()->to(route("homepage")."#".route("smart/dashboard"));

        return view("smart/index");
    }

    public function dashboard()
    {
        $birthdays = User::getUserBirthDays(date('Y-m-d'), 3);

        $chartJs = $charts = [];
        $chartArray = [];
        $maxRevenue = 0;

        $dateFrom = \request("dateFrom");
        $dateTo = \request("dateTo");

        // Get Charts By Columns
        for ($i = 1; $i <= 3; $i++) {

            $chartByColumn = $this->homeChart->findAllByAttributes(['column_id' => $i]);

//            $charts[$i] = [];

            foreach ($chartByColumn as $j => $each) {

                $chart = Chart::find($each->chart_id);

                $from = ($dateFrom ? $dateFrom : $each->date_from);
                $to = ($dateTo ? $dateTo : $each->date_to);

                // Remove
                if (!in_array($chart->constant,[CHART_REVENUE_BY_COUNTRY, CHART_SEAT_FACTORS, CHART_PUNCTUALITY])){
                    continue;
                }

                if (getMyDepartmentId(Auth::user()) != 7 && !in_array($chart->constant, [CHART_SEAT_FACTORS, CHART_PUNCTUALITY, CHART_FLIGHT_COUNTER])){
                    continue;
                }

                $chartType = ChartType::find($each->chart_type_id);
                $data = Chart::getChartJSByName($chart->constant, $each->report_period_id, $from, $to, $each->type);

                $name = $title = ucwords($chart->chart);

                if (isset($each->report_period_id)) {
                    $report = ReportPeriod::find($each->report_period_id);
                    $title .= ' /' . $report->period . '/';
                }

                elseif (isset($from) || isset($to)) {
                    $title .= ' /';
                    if (isset($from) && isset($to)){
                        $title .= baseDateFormat($from)." - ".baseDateFormat($to);
                    }
                    else {
                        if (isset($from))
                            $title .= baseDateFormat($from);
                        if (isset($from))
                            $title .= baseDateFormat($to);
                    }
                    $title .= '/';
                }

                $chartData = [
                    'skip'          => $chart->constant == CHART_REVENUE_BY_COUNTRY ? 1 : 0,
                    'data'          => $data,
                    'keys'          => array_keys($data),
                    'details'       => $each,
                    'chart_type'    => $chartType->constant,
                    'div_id'        => $chart->constant . '_' . $i . '_' . $j,
                    'title'         => $title,
                    'name'          => $name
                ];

                if ($chart->constant == CHART_REVENUE_BY_COUNTRY){
                    $countryChart = $chartData;
                }
                else if ($chart->constant == CHART_SEAT_FACTORS){
                    $seatFactorsChart = $chartData;
                }
                else if ($chart->constant == CHART_PUNCTUALITY){
                    $punctualityChart = $chartData;
                }
                else {
                    $charts[] = $chartData;
//                    $charts[$i][$j] = $chartData;
                }

                if ($chart->constant == CHART_REVENUE_BY_COUNTRY) {
                    foreach ($data as $item) {
                        if ($item['abbr']) {
                            $maxRevenue = $item['revenue'] > $maxRevenue ? $item['revenue'] : $maxRevenue;
                            $chartArray[$item['abbr']] = $item['revenue'] ? $item['revenue'] : 0;
                        }
                    }
                }

            }
        }

        $seatFactorsDaily = Chart::getChartJSByName(CHART_SEAT_FACTORS_DAILY, 5, "2016-03-01", "2016-03-31");

        $this->viewData = [
            'seatFactorsDaily'      => $seatFactorsDaily,
            'seatFactorsChart'      => isset($seatFactorsChart) ? $seatFactorsChart : null,
            'punctualityChart'      => isset($punctualityChart) ? $punctualityChart : null,
            'chartArray'            => $chartArray,
            'maxRevenue'            => $maxRevenue,
            'chartJs'               => $chartJs,
            'chart'                 => Chart::pluck('id', 'constant')->all(),
            'birthdays'             => $birthdays,
            'charts'                => $charts,
            'countryChart'          => isset($countryChart) ? $countryChart : [],
        ];

        return view("home/dashboard", $this->viewData);
    }

    public function airlineDashboard()
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '512M');

        $dateFrom = \request("dateFrom")  ? \request("dateFrom") : date("Y-m-d", strtotime("- 1 days")) ;
        $dateTo =   \request("dateTo")    ? \request("dateTo")   : date("Y-m-d", strtotime("- 1 days")) ;

        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $selectedAirports = \request("airport") ? \request("airport") : array_keys($handlingAirports);
        $selectedAirlines = \request("airline") ? \request("airline") : array_keys($handlingAirlines);

        // Get Punctuality Ready Array
        list($foundAirports, $airportsByCategory, $airportGraph, $flightsByCategory, $flightsByDelayCode, $categories, $airlinesByCategory, $flights)
            = ReportController::punctualityArray($dateFrom, $dateTo, false, $selectedAirports, $selectedAirlines, ALL);

        list($paxByAirports, $paxByAirportsMorris, $paxByFN, $paxBySector, $paxBySectorMorris, $paxBySectorSFMorris, $sectorLabels)
            = Airport::getPaxNoByStation($dateFrom, $dateTo, $selectedAirports,true);

        $airlinesObj = Airline::where("handling_airline", true)
            ->get();

        $this->viewData = [
            'selectedAirports'      => $selectedAirports,
            'selectedAirlines'      => $selectedAirlines,

            'airlineModule'              => airlineModule(),

            'dateFrom'              => $dateFrom,
            'dateTo'                => $dateTo,
            'airports'              => $handlingAirports,
            'airlines'              => $handlingAirlines,
            'categories'            => isset($categories) ? $categories : [],

            'foundAirports'         => isset($foundAirports) ? $foundAirports : [],
            'airportsByCategory'    => isset($airportsByCategory) ? $airportsByCategory : [],

            'totalFlights'          => count($flights),
            'airlinesObj'           => $airlinesObj,
            'airlinesByCategory'    => isset($airlinesByCategory) ? $airlinesByCategory : [],

            'flightsByCategory'     => isset($flightsByCategory) ? $flightsByCategory : [],
            'flightsByDelayCode'    => isset($flightsByDelayCode) ? $flightsByDelayCode : [],
            'flightsByDelayCodeChart' => isset($flightsByDelayCode) ? FlightDelay::getFlightsByDelayChart($flightsByDelayCode) : [],

            'paxByAirports'         => isset($paxByAirports) ? $paxByAirports : null,
            'paxByAirportsMorris'   => isset($paxByAirportsMorris) ? $paxByAirportsMorris : null,

            'paxByFN'               => isset($paxByFN) ? $paxByFN : null,
            'paxBySector'           => isset($paxBySector) ? $paxBySector : null,
            'paxBySectorMorris'     => isset($paxBySectorMorris) ? $paxBySectorMorris : null,
            'paxBySectorSFMorris'   => isset($paxBySectorSFMorris) ? $paxBySectorSFMorris : null,

            'sectorLabels'          => isset($sectorLabels) ? $sectorLabels : null,
        ];



        return view("home/a-dashboard", $this->viewData);
    }

    public function handlingDashboard()
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '512M');

        $dateFrom = \request("dateFrom")  ? \request("dateFrom") : date("Y-m-d", strtotime("- 1 days")) ;
        $dateTo =   \request("dateTo")    ? \request("dateTo")   : date("Y-m-d", strtotime("- 1 days")) ;

        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $selectedAirports = \request("airport") ? \request("airport") : array_keys($handlingAirports);
        $selectedAirlines = \request("airline") ? \request("airline") : array_keys($handlingAirlines);


        // Get Punctuality Ready Array
        list($foundAirports, $airportsByCategory, $airportGraph, $flightsByCategory, $flightsByDelayCode, $categories, $airlinesByCategory, $flights)
            = ReportController::punctualityArray($dateFrom, $dateTo, false, $selectedAirports, $selectedAirlines);

        list($paxByAirports, $paxByAirportsMorris, $paxByAirlines, $paxByAirlinesMorris)
            = Airport::getPaxNoByStationAndAirline($dateFrom, $dateTo, $selectedAirports, $selectedAirlines, true);

//        debug($paxByAirports);
//        debug($paxByAirlines);
//        debug($paxByAirportsMorris);
//        debug($paxByAirlinesMorris);

        $airlinesObj = Airline::where("handling_airline", true)
                                ->get();

        $this->viewData = [
            'selectedAirports'      => $selectedAirports,
            'selectedAirlines'      => $selectedAirlines,

            'dateFrom'              => $dateFrom,
            'dateTo'                => $dateTo,
            'airports'              => $handlingAirports,
            'airlines'              => $handlingAirlines,
            'categories'            => isset($categories) ? $categories : [],

            'foundAirports'         => isset($foundAirports) ? $foundAirports : [],
            'airportsByCategory'    => isset($airportsByCategory) ? $airportsByCategory : [],

            'totalFlights'          => count($flights),
            'airlinesObj'           => $airlinesObj,
            'airlinesByCategory'    => isset($airlinesByCategory) ? $airlinesByCategory : [],

            'flightsByCategory'     => isset($flightsByCategory) ? $flightsByCategory : [],
            'flightsByDelayCode'    => isset($flightsByDelayCode) ? $flightsByDelayCode : [],
            'flightsByDelayCodeChart' => isset($flightsByDelayCode) ? FlightDelay::getFlightsByDelayChart($flightsByDelayCode) : [],

            'paxByAirports'         => isset($paxByAirports) ? $paxByAirports : null,
            'paxByAirportsMorris'   => isset($paxByAirportsMorris) ? $paxByAirportsMorris : null,
            'paxByAirlines'         => isset($paxByAirlines) ? $paxByAirlines : null,
            'paxByAirlinesMorris'   => isset($paxByAirlinesMorris) ? $paxByAirlinesMorris : null,
        ];



        return view("home/h-dashboard", $this->viewData);
    }

    public function config(){
        $column[1] = $this->homeChart->findAllByAttributes(['column_id' => 1]);
        $column[2] = $this->homeChart->findAllByAttributes(['column_id' => 2]);
        $column[3] = $this->homeChart->findAllByAttributes(['column_id' => 3]);
        $this->viewData = [
            'column_charts'     => $column,
            'charts'            => Chart::lists('chart', 'id')->all(),
            'chart_types'       => ChartType::lists('chart_type', 'id')->all(),
            'types'             => ["" => "Select"] + ['flown' => 'Flown',  'sold' => 'Sold'],
            'periods'           => ["" => "Select"] + ReportPeriod::lists('period', 'id')->all()
        ];
        return view('home/config', $this->viewData);
    }

    public function store(){
        $inputs = request()->all();

        // Remove Unnecessary field
        removeUnnecessaryField($inputs, ['_token', 'insert', 'order']);

        // Remove Blank Values From Input
        replaceBlankAttributes($inputs);

        $this->homeChart->createByAttributes($inputs);

        flash()->success('Successfully Done');

        return redirect()->back();
    }

    public function update(HomeChart $homeChart){
        $inputs = request()->all();

        // Remove Unnecessary field
        removeUnnecessaryField($inputs, ['_token', 'edit', 'order']);

        // Remove Blank Values From Input
        replaceBlankAttributes($inputs);

        // Update
        $this->homeChart->update($homeChart, $inputs);

        flash()->success('Successfully Done');

        return redirect()->back();
    }

    public function delete(HomeChart $homeChart){

        $homeChart->delete();
        flash()->success('Successfully Done');

        return redirect()->back();
    }
}
