<?php

namespace App\Http\Controllers;

use App\Models\Airport;
use App\Models\Holiday;
use App\Models\HolidayAirport;
use App\Models\Location;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HolidayController extends Controller
{
    public function index(){

        $holidays = Holiday::with(["holidayAirports", "holidayAirports.airport"])->orderBy("fixed_date")->get();

        $byYears = [];

        foreach ($holidays as $holiday) {
            $year = date("Y", strtotime($holiday->fixed_date));
            if (!isset($byYears[$year])){
                $byYears[$year] = [];
            }

            $byYears[$year][] = $holiday;
        }

        $this->viewData = [
            "holidays"      => $holidays,
            "byYears"       => $byYears,
        ];

        return view("holiday.index", $this->viewData);
    }


    public function create(){

        $this->viewData = [
            "stations"      => Airport::listHandlingStations("iata", "id"),

        ];

        return view("holiday.create", $this->viewData);

    }

    public function copyForNextYear(){
        $year = intval(\request("year"));
        $nextYear = $year + 1;

        $holidays = Holiday::whereRaw("YEAR(fixed_date) = {$year}")
                    ->get();

        foreach ($holidays as $each){
            $hDate = date("{$nextYear}-m-d", strtotime($each->fixed_date));
            $holiday = Holiday::firstOrCreate([
                "name"          => $each->name,
                "fixed_date"    => $hDate
            ]);

            $holiday->abbr = $each->abbr;
            $holiday->notes = $each->notes;

            if ($each->all_stations){
                $holiday->all_stations = true;

                auditDeleted($holiday->holidayAirports());
            }
            else {
                $holiday->all_stations = null;

                $holidayAirportIDs = [];
                foreach ($each->holidayAirports as $item){
                    $record = HolidayAirport::firstOrCreate([
                        "holiday_id"    => $holiday->id,
                        "airport_id"    => $item->airport_id,
                        'date'          => $hDate
                    ]);

                    $holidayAirportIDs[] = $record->id;
                }

                auditDeleted($holiday->holidayAirports()->whereNotIn("id", $holidayAirportIDs)->get());
            }

            $holiday->save();
        }

        flash("Successfully created!");

        return redirect()->to("holiday");
    }

    public function store(){
//        if ($this->checkIfExist(\request("name"))){
//            flash()->error("Holiday with selected name already exists. Please double check and try again.");
//            return redirect()->back();
//        }

        debug(\request()->all());

        $airportIDs = \request("airport_id");
        
        $holiday = Holiday::create(\request()->except(["airport_id"]));

        $hStations = Airport::listHandlingStations("iata", "id");
        
        if (count($airportIDs) == count($hStations)){
            $holiday->all_stations = true;
        }
        else {
            foreach ($airportIDs as $airportID) {
                $record = HolidayAirport::firstOrCreate([
                    "holiday_id"    => $holiday->id,
                    "airport_id"    => $airportID,
                    'date'          => \request("fixed_date")
                ]);

                $record->created_by = Auth::user()->id;
                $record->save();
            }
        }

        $holiday->created_by = Auth::user()->id;
        $holiday->save();
        
        flash("Successfully created!");
        
        return redirect()->to("holiday");
        
    }

    public function edit($holiday){

        $this->viewData = [
            "holiday"       => $holiday,
            "stations"      => Airport::listHandlingStations("iata", "id"),

        ];

        return view("holiday.edit", $this->viewData);
    }

    public function update($holiday){
//        if ($this->checkIfExist(\request("name"), $holiday->id)){
//            flash()->error("Holiday with selected name already exists. Please double check and try again.");
//            return redirect()->back();
//        }

        $airportIDs = \request("airport_id");

        $hStations = Airport::listHandlingStations("iata", "id");

        $holiday->update(\request()->except(["airport_id"]));

        if (count($airportIDs) == count($hStations)){
            $holiday->all_stations = true;

            auditDeleted($holiday->holidayAirports());
        }
        else {
            $holiday->all_stations = null;
            $holidayAirportIDs = [];

            foreach ($airportIDs as $airportID) {
                $record = HolidayAirport::firstOrCreate([
                    "holiday_id"    => $holiday->id,
                    "airport_id"    => $airportID,
                    'date'          => \request("fixed_date")
                ]);

                $holidayAirportIDs[] = $record->id;

                if (!$record->created_by){
                    $record->updated_by = Auth::user()->id;
                    $record->save();
                }
            }

            auditDeleted($holiday->holidayAirports()->whereNotIn("id", $holidayAirportIDs)->get());
        }

        $holiday->updated_by = Auth::user()->id;
        $holiday->save();

        flash("Successfully updated!");

        return redirect()->to("holiday");

    }

    public function delete($holiday){
        auditDeleted($holiday->holidayAirports()->get());

        auditDeleted($holiday);

        return redirect()->to("holiday");
    }

    function checkIfExist($name, $excludeID = null){
        $search = Holiday::where("name", $name)
                        ->whereNull("deleted_at");

        if ($excludeID){
            $search->where("id", "!=", $excludeID);
        }

        return $search->first();

    }
}
