<?php

namespace App\Http\Controllers;

use App\Classes\Staff\Roster\Staff\Staff;
use App\Models\Aircraft;
use App\Models\AircraftType;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\Flight;
use App\Models\FlightNumber;
use App\Models\FlightSchedule;
use App\Models\FlightScheduleAirline;
use App\Models\FlightScheduleFlight;
use App\Models\StaffAirline;
use App\Models\StaffStation;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


class HandlingFlightScheduleController extends Controller
{
    const MAX_EXECUTION_TIME = 120;

    public function index(){

//        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
//        ini_set('memory_limit', '128M');

        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '512M');

        $today = date("Y-m-d");

        $lastMonth = date("Y-m-d", strtotime("- 1 month"));

        $inactiveSchedules = FlightSchedule::with([
//            "flights",
            "airlines",
            "airlines.airline",
        ])
            ->where("date_to", "<", $today)
            ->where("date_to", ">=", $lastMonth)
//            ->orWhereNotNull("deleted_at")
            ->get();

        $inactiveSchedulesIDs = $inactiveSchedules->pluck("id")->all();

        $schedules = FlightSchedule::with([
            "flights",
            "airlines",
            "airlines.airline",
        ])
            ->whereNotIn("id", $inactiveSchedulesIDs)
            ->where("date_to", ">=", $today)
            ->whereNull("deleted_at")
            ->get();

        $this->viewData = [
            'schedules'             => $schedules,
            'inactiveSchedules'     => $inactiveSchedules,
            'airlines'              => StaffAirline::currentStaffAirlinesList()
        ];

//        return StaffAirline::currentStaffAirlinesList();

        return view("handling-flight-schedule.index", $this->viewData);
    }

    public function airlines($flight_schedule){

        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $schedule = FlightSchedule::with(["flights", "airlines", "airlines.airline"])
            ->find($flight_schedule->id);

        $this->viewData = [
            'schedule'         => $schedule
        ];

        return view("handling-flight-schedule.airlines", $this->viewData);
    }

    public function flights($flight_schedule){

        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $flights = FlightScheduleFlight::with(['flightNumber'])
            ->where("flight_schedule_id", $flight_schedule->id)
            ->where("airline_id", \request("airline_id"))
            ->get();

        $airline = Airline::find(\request("airline_id"));

        $handlingStations = Airport::where("handling_airport", true)
            ->get();

        $groupedFlights = [
            "ACTIVE"        => [],
        ];

        $deletedScheduleFlights =[];

        foreach ($flights as $flight) {
            if ($flight->flightNumber && !$flight->deleted_at){
                foreach ($handlingStations as $station) {
                    if ($flight->flightNumber->departure_airport_id == $station->id ||
                        $flight->flightNumber->arrival_airport_id == $station->id){
                        if (!isset($groupedFlights[$station->iata])){
                            $groupedFlights[$station->iata] = [];
                        }
                        $groupedFlights[$station->iata][] = $flight;
                    }
                }
            }
            if ($flight->deleted_at){
                $deletedScheduleFlights[] = $flight;
            }
            else {
                $groupedFlights["ACTIVE"][] = $flight;
            }

        }

        $groupedFlights["DELETED"] = $deletedScheduleFlights;



        $this->viewData = [
            'aircraftTypes'     => ["" => "Select"] + AircraftType::byAirline($airline->id, true), //AircraftType::pluck("iata_name", "id")->all(),

            'aircraftList'      => ["" => "Select"] + Aircraft::getAircraftByAirline($airline->id, true), //Aircraft::whereNull("deleted_at")->pluck("name", "id")->all(),
            'flightNumbers'     => ["" => "Select"] + FlightNumber::getArrayFlightNumbersWithSector(false, false, false, $airline->id),
            'weekDays'          => weekDaysArray(),
            'schedule'          => $flight_schedule,
            'groupedFlights'    => $groupedFlights,
            'airline'           => $airline,
        ];

        return view("handling-flight-schedule.flights", $this->viewData);
    }


    public function manualCreate(){

        $handlingAirlines = $handlingAirports = [];

        if (ghaModule()) {
            $handlingAirlines = StaffAirline::currentStaffAirlinesList(NAME);
            $handlingAirports = StaffStation::currentStaffStationsList(IATA);
        }
        else {
            $handlingAirports = Airport::listOperatedStations();
        }

        $this->viewData = [
            'airlines'               => $handlingAirlines,
            'airports'               => $handlingAirports,
        ];

        return view("handling-flight-schedule.create", $this->viewData);
    }

    public function store(Request $request){

        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $flightSchedule = new FlightSchedule();
        $flightSchedule->name = $request->get("name");
        $flightSchedule->created_by = Auth::user()->id;
        $flightSchedule->date_from = $request->get("date_from");
        $flightSchedule->date_to = $request->get("date_to");
        $flightSchedule->save();

        if ($airlineID = airlineID()){
            $airline = new FlightScheduleAirline();
            $airline->flight_schedule_id = $flightSchedule->id;
            $airline->airline_id = $airlineID;
            $airline->save();
        }
        else {
            if ($request->get("airline")) {
                foreach ($request->get("airline") as $each) {
                    $airline = new FlightScheduleAirline();
                    $airline->flight_schedule_id = $flightSchedule->id;
                    $airline->airline_id = $each;
                    $airline->save();
                }
            }
        }


        return redirect()->to("handling-flight-schedule-airlines/{$flightSchedule->id}");
    }

    public function destroy($flight_schedule)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        if (!$flight_schedule){
            return redirect()->to("handling-flight-schedule");

        }

        if (count($flight_schedule->flights)){
            foreach($flight_schedule->flights as $each){
                if (!$each->deleted_at){
                    return redirect()->to("handling-flight-schedule-airlines/{$flight_schedule->id}");
                }
            }
        }

        $flight_schedule->updated_by = Auth::user()->id;
        $flight_schedule->deleted_at = date("Y-m-d H:i:s");
        $flight_schedule->save();

        return redirect()->to("handling-flight-schedule");
    }

    public function delete($flight_schedule_flight){
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $scheduleId = \request("schedule_id");
        $airlineId = \request("airline_id");

        if ($flight_schedule_flight){
            $flight_schedule_flight->updated_by = Auth::user()->id;
            $flight_schedule_flight->deleted_at = date("Y-m-d H:i:s");
            $flight_schedule_flight->save();
        }

        if ($flight_schedule_flight){
            // Remove Other Flights
            Flight::where("flight_schedule_flight_id", $flight_schedule_flight->id)
                ->where("std", ">=", date("Y-m-d", strtotime("+ 1 day")). " 00:00:00")
                ->whereNull("deleted_at")
                ->update([
                    'deleted_at'    =>  date("Y-m-d H:i:s"),
                    'updated_by'    =>  Auth::user()->id
                ]);
        }

        return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
                        ->with("message", "Success!<br/>Schedule Successfully Deleted!");
    }

    public function restore($flight_schedule_flight){
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $scheduleId = \request("schedule_id");
        $airlineId = \request("airline_id");

        if ($flight_schedule_flight){
            $flight_schedule_flight->updated_by = Auth::user()->id;
            $flight_schedule_flight->deleted_at = null;
            $flight_schedule_flight->save();

            // Create or Update Current Flights
            $result = [];
            FlightSchedule::createScheduledFlights($flight_schedule_flight, $result);
        }

        return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
            ->with("message", "Success!<br/>Schedule Successfully Restored!");
    }

    public function deleteSelected(){
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $scheduleId = \request("schedule_id");
        $airlineId = \request("airline_id");
        $flightScheduleIds = \request("flight_schedule_ids");

        if ($flightScheduleIds){
            $flightScheduleIds = explode(",", $flightScheduleIds);
            if (count($flightScheduleIds)){
                foreach ($flightScheduleIds as $id) {
                    $flightScheduleFlight = FlightScheduleFlight::find($id);
                    if ($flightScheduleFlight){
                        $flightScheduleFlight->updated_by = Auth::user()->id;
                        $flightScheduleFlight->deleted_at = date("Y-m-d H:i:s");
                        $flightScheduleFlight->save();
                    }

                    if ($id){
                        // Remove Other Flights
                        Flight::where("flight_schedule_flight_id", $id)
                            ->where("std", ">=", date("Y-m-d", strtotime("+ 1 day")). " 00:00:00")
                            ->whereNull("deleted_at")
                            ->update([
                                'deleted_at'    =>  date("Y-m-d H:i:s"),
                                'updated_by'    =>  Auth::user()->id
                            ]);
                    }
                }
            }
        }

        return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
                         ->with("message", "Success!<br/>Selected Schedules Successfully Deleted!");

    }

    public function restoreSelected(){
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $scheduleId = \request("schedule_id");
        $airlineId = \request("airline_id");
        $flightScheduleIds = \request("flight_schedule_ids");

        if ($flightScheduleIds){

            $flightScheduleIds = explode(",", $flightScheduleIds);

            if (count($flightScheduleIds)){

                $result = [];
                foreach ($flightScheduleIds as $id) {

                    $flightScheduleFlight = FlightScheduleFlight::find($id);

                    if ($flightScheduleFlight){
                        $flightScheduleFlight->updated_by = Auth::user()->id;
                        $flightScheduleFlight->deleted_at = null;
                        $flightScheduleFlight->save();

                        // Create or Update Current Flights
                        FlightSchedule::createScheduledFlights($flightScheduleFlight, $result);
                    }
                }
            }
        }

        return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
            ->with("message", "Success!<br/>Selected Schedules Successfully Restored!");
    }


    public function create(){
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $scheduleId = \request("schedule_id");
        $airlineId = \request("airline_id");
        $flightNumber = \request("flight_number");
        $newFlightNumber = \request("flt_no");
        $effDate = \request("eff_date");
        $disDate = \request("dis_date");
        $days = \request("days");
        $depTime = \request("dep_time");
        $arrTime = \request("arr_time");
        $aircraftType = \request("aircraft_type");
        $aircraft = \request("aircraft");

        if (!$flightNumber){

            debug(request()->all());
            if ($newFlightNumber) {
                if (\request("departure_airport") && \request("arrival_airport")) {
                    $flightNumber = FlightNumber::createManualFlightNumber();
                    $flightNumber = $flightNumber ? $flightNumber->id : null;
                }
                else {
                    return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
                        ->with("message", "Error!\n Flight Number/Departure Airport/Arrival Airport Are Required Fields!\nPlease Fill Them Out.");
                }
            }
            else {
                return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
                    ->with("message", "Error!\nFlight Number Can Not Be Blank!");
            }
        }

        if (!$days){
            return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
                ->with("message", "Error!\nFrequency Can Not Be Blank!");
        }

        $flightScheduleFlight = new FlightScheduleFlight();
        $flightScheduleFlight->flight_schedule_id   = $scheduleId;
        $flightScheduleFlight->airline_id           = $airlineId;
        $flightScheduleFlight->flight_number_id     = $flightNumber;
        $flightScheduleFlight->effective_date       = $effDate;
        $flightScheduleFlight->discontinue_date     = $disDate;
        $flightScheduleFlight->days                 = implode("", $days);
        $flightScheduleFlight->departure_time       = $depTime;
        $flightScheduleFlight->arrival_time         = $arrTime;
        $flightScheduleFlight->aircraft_type_id     = $aircraftType;
        $flightScheduleFlight->aircraft_id          = $aircraft;
        $flightScheduleFlight->created_by           = Auth::user()->id;
        $flightScheduleFlight->created_at           = date("Y-m-d H:i:s");
        $flightScheduleFlight->save();

        // Create or Update Current Flights
        $result = [];
        FlightSchedule::createScheduledFlights($flightScheduleFlight, $result);

        return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
                        ->with("message", "Success!\nNew Schedule Successfully Created!");
    }

    public function editFlights(){

        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $id = \request("id");
        $scheduleId = \request("schedule_id");
        $airlineId = \request("airline_id");
        $effDate = \request("eff_date");
        $disDate = \request("dis_date");
        $days = \request("days");
        $depTime = \request("dep_time");
        $arrTime = \request("arr_time");
        $aircraftType = \request("aircraft_type");
        $aircraft = \request("aircraft");

        if (!$days){
            return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
                             ->with("message", "Error!\nFrequency Can Not Be Blank!");
        }

        // Save Changes
        $flightScheduleFlight = FlightScheduleFlight::find($id);
        $flightScheduleFlight->effective_date = $effDate;
        $flightScheduleFlight->discontinue_date = $disDate;
        $flightScheduleFlight->days = implode("", $days);
        $flightScheduleFlight->departure_time = $depTime;
        $flightScheduleFlight->arrival_time = $arrTime;
        $flightScheduleFlight->aircraft_type_id = $aircraftType;
        $flightScheduleFlight->aircraft_id = $aircraft;
        $flightScheduleFlight->updated_by = Auth::user()->id;;
        $flightScheduleFlight->save();

        // Create or Update Current Flights
        $result = [];

        $processedFlightIds = FlightSchedule::createScheduledFlights($flightScheduleFlight, $result);

        // Remove Other Flights
        // Only future flights, historic flights ( <= TODAY) won't be altered
        Flight::where("flight_schedule_flight_id", $id)
                ->where("std", ">=", date("Y-m-d", strtotime("+ 1 day")). " 00:00:00")
                ->whereNull("deleted_at")
                ->whereNotIn("id", $processedFlightIds)
                ->update([
                    'deleted_at'    =>  date("Y-m-d H:i:s"),
                    'updated_by'    =>  Auth::user()->id
                ]);

        return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
                        ->with("message", "Success!\nSchedule Successfully Updated!");
    }

    public function deleteFlights(){

        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $id = \request("id");
        $scheduleId = \request("schedule_id");
        $airlineId = \request("airline_id");
        $dateFrom = \request("eff_date");
        $dateTo = \request("dis_date");
        $days = \request("days");

        if (!$days){
            return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
                ->with("message", "Error!\nFrequency Can Not Be Blank!");
        }

        Flight::where("flight_schedule_flight_id", $id)
                ->where("std", ">=", date("Y-m-d", strtotime("+ 1 day")). " 00:00:00")
                ->where(DB::raw("DATE(std)"), ">=", $dateFrom)
                ->where(DB::raw("DATE(std)"), "<=", $dateTo)
                ->whereIn(DB::raw("WEEKDAY(std) + 1"), $days)
                ->whereNull("deleted_at")
                ->update([
                    'deleted_at'    =>  date("Y-m-d H:i:s"),
                    'updated_by'    =>  Auth::user()->id
                ]);


        return redirect()->to("handling-flight-schedule-flights/{$scheduleId}?airline_id={$airlineId}")
                            ->with("message", "Success!\nFlights Successfully Deleted!");
    }

}
