<?php namespace App\Http\Controllers;
/**
 * Created by PhpStorm.

 */
use App\Models\Airline;
use App\Models\Airport;
use App\Models\FlightSector;
use App\Models\StaffAirline;
use App\Models\StaffStation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use App\Models\Flight;
use App\Models\FlightNumber;
use App\Models\ForwardBooking;

class ForwardBookingController extends Controller{

    const MAX_EXECUTION_TIME = 120;

    public function index(){


        $from = \request("dateFrom") ? \request("dateFrom") : date('Y-m-d');
        $to =   \request("dateTo")   ? \request("dateTo")   : date('Y-m-d', strtotime("+ 1 months", strtotime($from)));

        $groupFlights = Flight::FlightsGroupedByFlightNumber($from." 00:00:00", $to. " 23:59:59");

        debug($from);
        debug($to);

        $this->viewData = [
            'flightNumbers' => array_keys($groupFlights),
            'groupedFlights' => $groupFlights
        ];

        return view('forwardbooking.index', $this->viewData);
    }

    public function report(){
        $flightNumbers = \request("flight_numbers") ? \request("flight_numbers") : [];
        $sectors = [];
        if (count($flightNumbers)) {
            foreach ($flightNumbers as $i => $sector){
                if (!$sector || $sector == '') {
                    unset($flightNumbers[$i]);
                }
                else{
                    $sectors[] = $sector;
                    $sectors[] = $sector + 1;
                }
            }
        }

        $from = \request("from") ? \request("from") : date('Y-m-d');
        $to =   \request("to")   ? \request("to")   : date('Y-m-d');

        // Get All Flights In Range
        $flights = Flight::flightsRange($from.' 00:00:00', $to.' 23:59:59', ['flightNumber', 'Aircraft', 'flightChild'], TRUE, 'std', $flightNumbers);

        // Calculate SF
        Flight::getFlightsSeatFactors($flights);

        // Group And Calculate Capacity, Pax of Flights By Date(STD)
        $result = Flight::groupAndCalculateCapacityPaxOfFlightsByDate($flights);

        $groupedFlights = $result && isset($result[0]) ? $result[0] : [];

        // Calculate SF
        Flight::calculateSeatFactors($groupedFlights);


        //$pax_by_std = Flight::Pax_Bound_Std($from, $to, $sectors);
        $this->viewData = [
            'groupedFlights'        => $groupedFlights ? $groupedFlights : [],
            'flight_numbers_list'   => ['' => 'All'] + FlightNumber::getArrayFlightNumbersWithSector(['Scheduled'], false, 'outbound'),
            'flightNumbers'         => $flightNumbers,
            'sectors'               => $sectors,
            'from'                  => $from,
            'to'                    => $to,
        ];

        return view('forwardbooking.report', $this->viewData);
    }

    public function handlingReport(Request $request){

        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $selectedAirports = \request("airport") ? \request("airport") : array_keys($handlingAirports);
        $selectedAirlines = \request("airline") ? \request("airline") : array_keys($handlingAirlines);

        $flights =  Flight::FlightsRangeConditional($selectedAirports, $selectedAirlines, $request->get("type") ? $request->get("type") : ALL);

        $handlingStations = Airport::getHandlingStationsIdAndObject();
        // Calculate SF
        Flight::getHandlingFlightsSeatFactors($flights, $handlingStations);

        // Group And Calculate Capacity, Pax of Flights By Date(STD)
        $result = Flight::handlingGroupAndCalculateCapacityPaxOfFlightsByDate($flights, $handlingStations);
        $groupedFlights = $result && isset($result[0]) ? $result[0] : [];
        $totals         = $result && isset($result[1]) ? $result[1] : [];

        // Calculate SF
        Flight::calculateSeatFactors($groupedFlights, $totals);

        //$pax_by_std = Flight::Pax_Bound_Std($from, $to, $sectors);
        $data = [
            'dateYesterday'         => date('Y-m-d',strtotime(" - 1 days")),
            'periods'               => getPeriodsArray(),
            'monthNames'            => getMonthsArray(),
            'years'                 => getYearsArray(),

            'groupedFlights'        => $groupedFlights,
            'totals'                => $totals,

            "airlines"              => $handlingAirlines,
            "airports"              => $handlingAirports,

            "flightNumbers"         => FlightNumber::getArrayFlightNumbersWithSector(false, false, false, null, true),
            'sectors'               => FlightSector::listSectors(),
            'sectorsByAirlines'     => FlightSector::getSectorsByAirlines(),
        ];

        return view('forwardbooking/handling/report',$data);
    }

    public function handlingReportDaily(Request $request){

        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $handlingStations = Airport::getHandlingStations();

        $selectedAirports = \request("airport") ? \request("airport") : $handlingStations;

        $flightNumbers = \request("flightNumber") ? \request("flightNumber") : \request("sector");

        $date = $request->get('date') ? $request->get('date') : null;

        $from = $date ? $date : ($request->get('from') ? $request->get('from') :  date('Y-m-d', strtotime("-1 day")));
        $to =   $date ? $date : ($request->get('to')   ? $request->get('to')   :  date('Y-m-d', strtotime("-1 day")));

        $flights =  Flight::handlingFlightsRange($from.' 00:00:00', $to.' 23:59:59', \request("airline"), $selectedAirports, $flightNumbers,
            [
                'off_order_by_airline_id' => TRUE
            ]
        );

        $handlingStations = Airport::getHandlingStationsIdAndObject();
        // Get Flight Seat Factors
        $total = Flight::getHandlingFlightsSeatFactors($flights, $handlingStations, TRUE);

        $data = [
            'flights'               => $flights,
            'total'                 => $total,

            "handlingStations"      => $handlingStations,

            "airlines"              => Airline::listHandlingAirlines(),
            "airports"              => Airport::listHandlingAirports(),

            "flightNumbers"         => FlightNumber::getArrayFlightNumbersWithSector(false, false, false, null, true),
            'sectors'               => FlightSector::listSectors(),
            'sectorsByAirlines'     => FlightSector::getSectorsByAirlines(),

            'from'                  => $from,
            'to'                    => $to,
        ];

        return view('forwardbooking/handling/reportdaily',$data);
    }

    public function reportDaily(){
        $date = \request("date") ? \request("date") : date('Y-m-d');

        // Get All Flights
        $flights = Flight::flightsRange($date." 00:00", $date." 23:59", ['flightNumber','Aircraft', 'flightChild'], TRUE, 'std');

        // Get Flight Seat Factors
        Flight::getFlightsSeatFactors($flights);

        debug($flights[0]);

        $data = [
            'flights'    => $flights,
            'flight_numbers_list'   => ['' => 'All'] + FlightNumber::getArrayFlightNumbersWithSector(['Scheduled'], false, 'outbound'),
            'flightNumbers' => [],
            'date'       => $date
        ];

        return view('forwardbooking.reportdaily',$data);
    }

    public function reportByFlight(){
        $flt_ids = \request("flt_ids") ? \request("flt_ids") : [];
        $date = \request("date") ? \request("date") : date('Y-m-d');

        $flight_numbers_get = \request("flight_number") ? \request("flight_number") : [];
        $from = \request("from") ? \request("from") : date('Y-m-d');
        $to = \request("to") ? \request("to") : date('Y-m-d', strtotime('+ 1 months'));

        $flt_no = [];
        $route = [];

        if (count($flight_numbers_get)){
            $date_previous = date('Y-m-d', strtotime("$date - 1 days"));
            foreach ($flight_numbers_get as $flight_number){
                // Find Parent Flight
                $flight_parent = Flight::join('flights__numbers', 'flights.flight_number_id','=','flights__numbers.id')
                    ->where('flight_number_id',$flight_number);

                if (in_array($flight_number, ['201', '202']))
                    $flight_parent->whereRaw("DATE(std)  = '$date'");
                else
                    $flight_parent->whereRaw("DATE(std) IN ('$date', '$date_previous')");

                $flight_parent = $flight_parent->orderBy('std', 'DESC')
                    ->first(['flights.id']);

                if ($flight_parent) {
                    // Find Binded (Child) Flight
                    $flt_ids[] = $flight_parent->id;
                    $flight_child = Flight::where('parent_id',$flight_parent->id)->first();

                    if ($flight_child)
                        $flt_ids[] = $flight_child->id;

                    debug($flight_parent);
                    debug($flight_child);
                }
                break;
            }
        }

        if (count($flt_ids)) {
            foreach ($flt_ids as $id) {
                $flight_no = Flight::with('flightNumber')->find($id);
                $flt_no[$flight_no['flightNumber']['bound']] = $flight_no['flightNumber']['flight_number'];

                $forward = ForwardBooking::with(['aircraft', 'flightNumber', 'flight'])
                    ->where('flight_id', $id)
                    ->orderBy('updated_date', 'DESC')
                    ->get();

                if ($forward) {
                    foreach ($forward as $each) {
                        if (!isset($route[$each->updated_date])) {
                            $route[$each->updated_date] = [];
                        }

                        if (!isset($route[$each->updated_date][$each->flight_id])) {
                            $route[$each->updated_date][$each->flight_id] = $each;
                        }
                    }
                }
            }

            krsort($route);
        }


        $data = [
            'from'       => $from,
            'to'         => $to,
            'flight_numbers_list'   => ['' => 'All'] + FlightNumber::getArrayFlightNumbersWithSector(['Scheduled'], false, 'outbound'),
            'flightNumbers' => [],
            'route'      => isset($route) ? $route : [],
            'flight_numbers' => $flt_no,
            'date'      =>  $date
        ];

        return view('forwardbooking.reportbyflight',$data);
    }

    public function ajaxsavedailybooking(){
        $input_array = \request("input_data");
        $updated_date = \request("date");

        $keys_excluded = ['capacity_c', 'capacity_y', 'remark', 'closed_sales', 'cancel_flight'];

        foreach($input_array as $i=>$each){
            if ($each['cancel_flight'] == "")
                $input_array[$i]['cancel_flight'] = null;
            if ($each['closed_sales'] == "")
                $input_array[$i]['closed_sales'] = null;

            $check = ForwardBooking::where('updated_date',$each['updated_date'])->where('flight_id',$each['flight_id'])->first(['id']);

            if ($check) {
                foreach ($input_array[$i] as $key => $value) {
                    if (in_array($key, $keys_excluded)){
                        continue;
                    }
                    else
                        $check->$key = $value;
                }
            }
            else {
                $check = new ForwardBooking;
                foreach ($input_array[$i] as $key => $value) {
                    if (in_array($key, $keys_excluded)){
                        continue;
                    }
                    else
                        $check->$key = $value;
                }
                $check->created_by = Auth::user()->id;
            }
            $check->updated_by = Auth::user()->id;

            $check->save();

            debug($check);
            $flight = Flight::find($each['flight_id']);
            if (is_null($flight->closed_sales)){
                if (!is_null($input_array[$i]['closed_sales']))
                    $flight->closed_sales = $input_array[$i]['closed_sales'];
            }
            else{ // Flight->closed_sales NOT NULL
                if (is_null($input_array[$i]['closed_sales']))
                    $flight->closed_sales = $input_array[$i]['closed_sales'];
            }
            $flight->remark = $each['remark'];
            $flight->capacity_c = $each['capacity_c'];
            $flight->capacity_y = $each['capacity_y'];
            $flight->pax_c_booked = $each['pax_c_booked'];
            $flight->pax_y_booked = $each['pax_y_booked'];
            $flight->save();
        }

        return response()->json([
            "message" => "",
            "success" => TRUE,
        ]);
    }
}
