<?php

namespace App\Http\Controllers;

use App\Exports\FHRExport;
use App\Models\Flight;
use App\Models\FlightCom;
use App\Models\FlightComCheckin;
use App\Models\FlightPTS;
use App\Models\FlightStaff;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use Maatwebsite\Excel\Facades\Excel;

class FlightViewController extends Controller
{
    const MAX_EXECUTION_TIME = 240;

    public function index(Request $request, $type = null)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $flights = [];
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $selectedAirportIds = $request->get("airport") ? $request->get("airport") : array_keys($handlingAirports);
        $selectedAirlineIds = $request->get("airline") ? $request->get("airline") : array_keys($handlingAirlines);

        if ($request->get("from")) {

            $from = $request->get("from") . " 00:00:00";
            $to = $request->get("to") . " 23:59:59";

            $queryFlights = Flight::with([
                "user",
                getFlightMessageRelation($to),
                "aircraft",
                "departureAirport",
                "arrivalAirport",
                "flightNumber",
                "flightNumber.departureAirport",
                "flightNumber.arrivalAirport",
                "flightNumber.airline",
                "flightNumber.flightType"
            ])
                ->select([
                    "flights.*",
                    DB::raw('(select id from s_flights__staff where flight_id = s_flights.id and deleted_at is null limit 1) as staff_exists')
                ]);

//            $queryFlights->leftJoin('flights__staff as p', function ($q) {
//                $q->on('flights__staff.flight_id', '=',
//                        DB::raw('(select min(flight_id) from s_flights__staff where flight_id = p.flight_id)'))
//                    ->whereNull('flights__staff.deleted_at');
//            });
//            $queryFlights->leftJoin("flights__staff", "flights__staff.flight_id", "=", "flights.id")
//                ->whereNull("flights__staff.deleted_at");

            if ($request->get("airport") || $request->get("airline")) {
                $queryFlights->join("flights__numbers", "flights__numbers.id", "=", "flights.flight_number_id");

                if ($request->get("airport") && count($request->get("airport"))) {

                    // if (isset($options['only_departure_airports'])) {
                    /*
                    $queryFlights->where(function ($sql) use ($selectedAirportIds) {
                        $sql->whereIn("flights__numbers.departure_airport_id", $selectedAirportIds)
                            ->orWhereIn("flights.departure_airport_id", $selectedAirportIds);
                    });
                    }
                    else {
                    */
                    $queryFlights->where(function ($sql) use ($selectedAirportIds) {
                        $sql->whereIn("flights__numbers.departure_airport_id", $selectedAirportIds)
                            ->orWhereIn("flights__numbers.arrival_airport_id", $selectedAirportIds)
                            ->orWhereIn("flights.departure_airport_id", $selectedAirportIds)
                            ->orWhereIn("flights.arrival_airport_id", $selectedAirportIds);
                    });
                    //}
                }

                if ($request->get("airline") && count($request->get("airline"))) {
                    $queryFlights->whereIn("flights__numbers.airline_id", $selectedAirlineIds);
                }
            }

            $queryFlights->where(function ($query) use ($from, $to) {
                $query->where(function ($sql) use ($from, $to){
                    $fromDate = date("Y-m-d", strtotime($from));
                    $toDate = date("Y-m-d", strtotime($to));

                    $sql->whereBetween("departure_date", [$fromDate, $toDate])
                        ->orWhereBetween("arrival_date", [$fromDate, $toDate]);
                })
                    ->orWhere(function ($sql) use ($from, $to){
                        $sql->whereBetween("std", [$from, $to])
                            ->orWhereBetween("ptd", [$from, $to])
                            ->orWhereBetween("etd", [$from, $to])
                            ->orWhereBetween("atd", [$from, $to]);
                    });
            });

            $queryFlights->orderBy("std")
                ->orderBy("ptd")
                ->orderBy("etd")
                ->orderBy("atd")
                ->orderBy("departure_date");

            $type = ALL;
            switch ($type) {
                case ALL:
                    $sql = clone($queryFlights);
                    $flights[ALL] = $sql->whereNull("flights.cancelled_at")
                        ->whereNull("flights.deleted_at")
                        ->get();
//                    break;

                case CANCELLED:
                    $sql = clone($queryFlights);
                    $flights[CANCELLED] = $sql->whereNotNull("flights.cancelled_at")->get();
                /*->where(function ($query) use ($from, $to) {
                $query->whereNotNull("cancelled_at")
                    ->whereBetween("cancelled_at", [$from, $to]);
            })*/
//                        ->get(["flights.*"]);
//                    break;

                case REMOVED:
                    $sql = clone($queryFlights);
                    $flights[REMOVED] = $sql->whereNotNull("flights.deleted_at")->get();
                /*->where(function ($query) use ($from, $to) {
                $query->whereNotNull("deleted_at")
                    ->whereBetween("deleted_at", [$from, $to]);
            })*/
//                        ->get(["flights.*"]);
//                    break;

                case AUTO_CREATED:
                    $sql = clone($queryFlights);
                    $flights[AUTO_CREATED] = $sql->whereNotNull("created_by_email")->get();
                /*->where(function ($query) use ($from, $to) {
                $query->whereNotNull("created_by_email")
                    ->whereBetween("created_at", [$from, $to]);
            })*/
//                        ->get(["flights.*"]);
//                    break;

                case MANUALLY_CREATED:
                    $sql = clone($queryFlights);
                    $flights[MANUALLY_CREATED] = $sql->whereNull("flight_schedule_id")
                        ->whereNull("created_by_email")
                        ->get();
                    /*->where(function ($query) use ($from, $to) {
                    $query->whereNull("flight_schedule_id")
                        ->whereNull("created_by_email")
                        ->whereBetween("created_at", [$from, $to]);
                })
                    */
//                        ->get(["flights.*"]);
                    break;
            }

            debug($flights["ALL"]->toArray());

            /*
            $queryFlights = $queryFlights->orWhere(function($sql) use ($from, $to) {
                                            $sql->whereBetween("std", [$from, $to])
                                                ->orWhereBetween("ptd", [$from, $to])
                                                ->orWhereBetween("etd", [$from, $to])
                                                ->orWhereBetween("atd", [$from, $to]);
                                        })
            */
        }

        $this->viewData = [
            "airlines"          => $handlingAirlines,
            "airports"          => $handlingAirports,

            'tab'               => $request->get("tab"),
            'selectedType'      => isset($type) ? $type : null,
            'flights'           => $flights,
            'sprAdm'            => Auth::user()->user_role_id == 4,
            'adm'               => in_array(Auth::user()->user_role_id, [ROLE_DEPARTMENT_ADMIN, ROLE_ADMIN, ROLE_SUPER_ADMIN]),
        ];

        return view("flight-view/index", $this->viewData);
    }

    public function fhrExcel($flight){

        $flightCom = FlightCom::where("flight_id", $flight->id)->first();

        $pts = FlightPTS::where("flight_id", $flight->id)->first();

        $flight->delaysString = getFlightDelaysArrayString($flight);

        list($fn1, $fn2, $fn3) = getFlightNumber3Types($flight);

        $flight->staffList = Flight::getFlightStaff($flight);

        $this->viewData = [
            'fn1'           => $fn1,
            'fn2'           => $fn2,
            'fn3'           => $fn3,
            "flight"        => $flight,
            "flightCom"     => $flightCom,
            "pts"           => $pts,
        ];

        $name = "FHR_".$fn3."_".strtoupper(date("dM", strtotime(getFlightDepartureInitialDate($flight)))).".xlsx";

        return Excel::download(new FHRExport($this->viewData), $name);

//        Excel::create('fhr', function($excel) {
//            $excel->sheet('FHR', function($sheet) {
//                $sheet->loadView("flight/reports/ba-fhr-table", $this->viewData);
//            });
//        })->export('xls');
    }

    public function fhr($flight){

        $flightCom = FlightCom::where("flight_id", $flight->id)->first();

        $pts = FlightPTS::where("flight_id", $flight->id)->first();

        $flight->delaysString = getFlightDelaysArrayString($flight);

        list($fn1, $fn2, $fn3) = getFlightNumber3Types($flight);

        $flight->staffList = Flight::getFlightStaff($flight);

        $this->viewData = [
            'fn1'           => $fn1,
            'fn2'           => $fn2,
            'fn3'           => $fn3,
            "flight"        => $flight,
            "flightCom"     => $flightCom,
            "pts"           => $pts,
        ];

        return view("flight/reports/ba-fhr", $this->viewData);
    }

    public function cancelSelected(Request $request){
        $flightIDs = \request("flight_ids");

        if ($flightIDs){
            $flightIDs = explode(",", $flightIDs);
            if (count($flightIDs)){
                foreach ($flightIDs as $id) {
                    $flight = Flight::find($id);
                    if ($flight && !$flight->cancelled_at){
                        $flight->updated_by = Auth::user()->id;
                        $flight->cancelled_at = date("Y-m-d H:i:s");
                        $flight->deleted_at = null;
                        $flight->save();
                    }
                }
            }
        }

        $url = "flight-view?from=".$request->get("date_from")."&to=".$request->get("date_to");
        if ($request->get("airline")){
            foreach ($request->get("airline") as $item) {
                $url .= "&airline[]={$item}";
            }
        }

        if ($request->get("airport")){
            foreach ($request->get("airport") as $item) {
                $url .= "&airport[]={$item}";
            }
        }

        flash()->success("Success!\nSelected Flights Successfully Deleted!");

        return redirect()->to($url);
    }

    public function deleteSelected(Request $request){
        $flightIDs = \request("flight_ids");

        if ($flightIDs){
            $flightIDs = explode(",", $flightIDs);
            if (count($flightIDs)){
                foreach ($flightIDs as $id) {
                    $flight = Flight::find($id);
                    if ($flight && !$flight->deleted_at){
                        $flight->updated_by = Auth::user()->id;
                        $flight->deleted_at = date("Y-m-d H:i:s");
                        $flight->cancelled_at = null;
                        $flight->save();
                    }
                }
            }
        }

        $url = "flight-view?from=".$request->get("date_from")."&to=".$request->get("date_to");
        if ($request->get("airline")){
            foreach ($request->get("airline") as $item) {
                $url .= "&airline[]={$item}";
            }
        }

        if ($request->get("airport")){
            foreach ($request->get("airport") as $item) {
                $url .= "&airport[]={$item}";
            }
        }

        flash()->success("Success!\nSelected Flights Successfully Deleted!");

        return redirect()->to($url);
    }

    public function restoreSelected(Request $request){
        $flightIDs = \request("flight_ids");

        if ($flightIDs){

            $flightIDs = explode(",", $flightIDs);

            if (count($flightIDs)){
                foreach ($flightIDs as $id) {

                    $flight = Flight::find($id);

                    if ($flight){
                        $flight->updated_by = Auth::user()->id;
                        $flight->deleted_at = null;
                        $flight->cancelled_at = null;
                        $flight->save();
                    }
                }
            }
        }

        $url = "flight-view?from=".$request->get("date_from")."&to=".$request->get("date_to")."&tab=".REMOVED;
        if ($request->get("airline")){
            foreach ($request->get("airline") as $item) {
                $url .= "&airline[]={$item}";
            }
        }

        if ($request->get("airport")){
            foreach ($request->get("airport") as $item) {
                $url .= "&airport[]={$item}";
            }
        }

        flash()->success("Success!\nSelected Flights Successfully Restored!");
        return redirect()->to($url);
    }

    public function ajaxBindFlight($flight){
        $bindArrFlightID = \request("arr_flight_id");

        if (!\request()->ajax()){
            return response()->json([
                "success"   => false,
                "message"   => "Request error"
            ]);
        }

        if ( !$flight || !$bindArrFlightID){
            return response()->json([
                "success"   => false,
                "message"   => "Flight not found"
            ]);
        }


        $flight->parent_id = $bindArrFlightID;
        $flight->updated_by = Auth::id();
        $flight->save();

        // Unset others
        Flight::where("id", "!=", $flight->id)
            ->where("parent_id", $bindArrFlightID)
            ->update([
                "parent_id" => null
            ]);


        return response()->json([
            "success"   => true,
            "message"   => "Flight successfully binded"
        ]);
    }

}
