<?php

namespace App\Http\Controllers;

use App\Models\Flight;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class FlightStaffController extends Controller
{
    public function index(Request $request){

        $from = ($request->get("from") ? $request->get("from") : date("Y-m-d")). " 00:00:00";
        $to = ($request->get("to") ? $request->get("to") : date("Y-m-d")). " 23:59:59";

        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $selectedAirportIds = $request->get("airport") ? $request->get("airport") : array_keys($handlingAirports);
        $selectedAirlineIds = $request->get("airline") ? $request->get("airline") : array_keys($handlingAirlines);

        debug($selectedAirportIds);

        $queryFlights = Flight::with([
            "user",
            "message",
            "aircraft",
            "departureAirport",
            "arrivalAirport",
            "flightNumber",
            "flightNumber.departureAirport",
            "flightNumber.arrivalAirport",
            "flightNumber.airline"
        ]);

        $queryFlights->join("flights__numbers", "flights__numbers.id", "=", "flights.flight_number_id");

        if (count($selectedAirportIds)) {

            // if (isset($options['only_departure_airports'])) {
            /*
            $queryFlights->where(function ($sql) use ($selectedAirportIds) {
                $sql->whereIn("flights__numbers.departure_airport_id", $selectedAirportIds)
                    ->orWhereIn("flights.departure_airport_id", $selectedAirportIds);
            });
            }
            else {
            */
            $queryFlights->where(function ($sql) use ($selectedAirportIds) {
                $sql->whereIn("flights__numbers.departure_airport_id", $selectedAirportIds)
                    ->orWhereIn("flights__numbers.arrival_airport_id", $selectedAirportIds)
                    ->orWhereIn("flights.departure_airport_id", $selectedAirportIds)
                    ->orWhereIn("flights.arrival_airport_id", $selectedAirportIds);
            });
            //}
        }

        if (count($selectedAirlineIds)) {
            $queryFlights->whereIn("flights__numbers.airline_id", $selectedAirlineIds);
        }

        $queryFlights = $queryFlights->where(function($sql) use ($from, $to) {
                        $sql->whereBetween("std", [$from, $to])
                            ->orWhereBetween("ptd", [$from, $to])
                            ->orWhereBetween("etd", [$from, $to])
                            ->orWhereBetween("atd", [$from, $to]);
                        })
                            ->whereNull("flights.deleted_at")
                            ->whereNull("flights.cancelled_at")
                            ->orderBy("std")
                            ->orderBy("ptd")
                            ->orderBy("etd")
                            ->orderBy("atd")
                            ->get([
                                "flights.*"
                            ]);


        $this->viewData = [
            "airlines"          => $handlingAirlines,
            "airports"          => $handlingAirports,

            'selectedType'      => isset($type) ? $type : null,
            'flights'           => $queryFlights,
            'sprAdm'            => Auth::user()->user_role_id == 4,
        ];

        return view("flight-staff.index", $this->viewData);
    }

    public function create(Request $request, $flight){


        $this->viewData = [
            "flight"        => $flight
        ];

        return view("flight-staff.create", $this->viewData);
    }

    public function store(Request $request, $flight){

    }
}
