<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: intranet.dev
 */

use app\Classes\ProjectConstant;
use App\Models\FlightSchedule;
use App\Models\Aircraft;
use App\Models\FlightNumber;
use App\Models\FlightScheduleFlight;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use App\Forms\FlightScheduleForm;
use DateTime;
use App\Models\Flight;
use Illuminate\Support\Facades\Session;

class FlightScheduleController extends Controller
{

    /**
     * Get index action
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $data = [
            "template_id"   => NULL,
            "templates"     => ["" => "Select Template"] + FlightSchedule::pluck("name", "id")->all(),
            "aircraft"      => ["" => "Select Aircraft"] + Aircraft::whereNull("deleted_at")->pluck("name", "id")->all(),

            "flightNumbers" => ["" => "Select Flight Number"] +
                FlightNumber::selectRaw("CONCAT(flight_number, ' ', departure_airport, ' - ', arrival_airport) AS name, id")
                    ->whereNull("deleted_at")
                    ->orderBy('flight_number')
                    ->pluck("name", "id")
                    ->all()
        ];
        if (\request("source"))
        {
            $flights = [];
            $form    = new FlightScheduleForm();
            if ($form->isValidForm())
            {

            }
            $source = \request("source");
            if ($source == "fleetwatch")
            {
                $loadDate = \request("load_date");
                $dates    = [];
                if ($loadDate == "from_to")
                {
                    $dates = [
                        "from" => \request("from"),
                        "to"   => \request("to")
                    ];
                }
                else if ($loadDate == "week")
                {
                    $dates = $this->getStartAndEndDate(\request("week"), \request("year"));
                }

                $flights = Flight::flightsRange($dates["from"], $dates["to"]);
                $flights = $this->parseFlightsForView($flights);
                $data['from'] = $dates['from'];
                $data['to'] = $dates['to'];
            }
            else if ($source == "template")
            {
                $template = FlightSchedule::find(\request("template_id"));
                if (!$template)
                {
                    Session::flash("message", [
                        "text" => "Template Was Not Found",
                        "type" => MESSAGE_DANGER
                    ]);
                }
                $data['from'] = $template->date_from;
                $data['to'] = $template->date_to;

                $templateData = FlightScheduleFlight::with([
                    "Aircraft",
                    "FlightNumber"
                ])
                    ->where("flight_schedule_id", "=", \request("template_id"))
                    ->get();

                if (!count($templateData))
                {
                    Session::flash("message", [
                        "text" => "Template data is empty",
                        "type" => MESSAGE_DANGER
                    ]);
                }
                else
                {
                    $data["template_id"] = \request("template_id");
                    $flights             = $this->parseTemplateDataForView($templateData);
                }
            }
            $data["flights"] = $flights;

        }
        return view("flight-schedule/index-new", $data);
    }


    /**
     * POST save template data to DB
     * @return \Illuminate\Http\RedirectResponse
     */
    public function saveAsTemplate()
    {
        $templateData = json_decode(\request("template_data"));
        $templateName = \request("template_name");

        FlightSchedule::saveTemplate($templateName, $templateData, \request("from"), \request("to"));

        return redirect()->to("flight-schedule/index")
            ->with("message", [
                "text" => "Template was successfully saved",
                "type" => MESSAGE_SUCCESS
            ]);
    }

    /**
     * POST AJAX request update current template
     * @return \Illuminate\Http\JsonResponse
     * @throws Exception
     */
    public function ajaxUpdateTemplate()
    {
        $templateData = json_decode(\request("template_data"));
        $templateId   = \request("template_id");
        $template     = FlightSchedule::find($templateId);
        $insertData   = [];
        if (is_array($templateData) && is_object($template))
        {
            // remove old rows
            FlightScheduleFlight::where("flight_schedule_id", $template->id)
                ->delete();

            $parents = [];
            $children = [];
            foreach ($templateData as $flight)
            {
                if (!$flight->parent_id)
                {
                    $parents[] = $flight;
                }
            }
            foreach ($templateData as $flight)
            {
                if ($flight->parent_id > 0)
                {
                    $children[] = $flight;
                }
            }
            //_debug($parents);
            //_debug($children);exit;

            foreach ($parents as $parent)
            {
                $flightScheduleFlight                     = new FlightScheduleFlight();
                $flightScheduleFlight->flight_schedule_id = $template->id;
                $flightScheduleFlight->aircraft_id        = $parent->aircraft_id;
                $flightScheduleFlight->flight_number_id   = $parent->flight_number_id;
                $flightScheduleFlight->std_weekday        = $parent->std_weekday;
                $flightScheduleFlight->std_time           = $parent->std_time;
                $flightScheduleFlight->sta_weekday        = $parent->sta_weekday;
                $flightScheduleFlight->sta_time           = $parent->sta_time;
                $flightScheduleFlight->frequency          = (isset($parent->frequency)) ? $parent->frequency : FREQ_WEEKLY;
                $flightScheduleFlight->starting_week      = (isset($parent->starting_week)) ? $parent->starting_week : STARTING_WEEK_FIRST;
                $flightScheduleFlight->parent_id          = 0;
                $flightScheduleFlight->save();

                foreach ($children as $key => $child)
                {
                    if ($child->parent_id == $parent->unique_id)
                    {
                        $childScheduleFlight                     = new FlightScheduleFlight();
                        $childScheduleFlight->flight_schedule_id = $template->id;
                        $childScheduleFlight->aircraft_id        = $parent->aircraft_id;
                        $childScheduleFlight->flight_number_id   = $child->flight_number_id;
                        $childScheduleFlight->std_weekday        = $child->std_weekday;
                        $childScheduleFlight->std_time           = $child->std_time;
                        $childScheduleFlight->sta_weekday        = $child->sta_weekday;
                        $childScheduleFlight->sta_time           = $child->sta_time;
                        $childScheduleFlight->frequency          = (isset($child->frequency)) ? $child->frequency : FREQ_WEEKLY;
                        $childScheduleFlight->starting_week      = (isset($child->starting_week)) ? $child->starting_week : STARTING_WEEK_FIRST;
                        $childScheduleFlight->parent_id          = $flightScheduleFlight->id;
                        $childScheduleFlight->save();
                        unset($children[$key]);
                    }
                }
            }
            if (is_array($children) && count($children))
            {
                foreach ($children as $key => $child)
                {
                    $childScheduleFlight                     = new FlightScheduleFlight();
                    $childScheduleFlight->flight_schedule_id = $template->id;
                    $childScheduleFlight->aircraft_id        = $child->aircraft_id;
                    $childScheduleFlight->flight_number_id   = $child->flight_number_id;
                    $childScheduleFlight->std_weekday        = $child->std_weekday;
                    $childScheduleFlight->std_time           = $child->std_time;
                    $childScheduleFlight->sta_weekday        = $child->sta_weekday;
                    $childScheduleFlight->sta_time           = $child->sta_time;
                    $childScheduleFlight->frequency          = (isset($child->frequency)) ? $child->frequency : FREQ_WEEKLY;
                    $childScheduleFlight->starting_week      = (isset($child->starting_week)) ? $child->starting_week : STARTING_WEEK_FIRST;
                    $childScheduleFlight->parent_id          = 0;
                    $childScheduleFlight->save();
                }
            }
            return response()->json([
                "message" => "Template was successfully updated",
                "success" => 1
            ]);
        }
        return response()->json([
            "message" => "Not found POST data, please specify correct data",
            "error"   => 1
        ]);
    }

    /**
     * AJAX delete template
     * @return \Illuminate\Http\JsonResponse
     * @throws Exception
     */
    public function ajaxDeleteTemplate()
    {
        $templateId = \request("template_id");
        $template   = FlightSchedule::find($templateId);
        if (is_object($template))
        {
            // remove template rows
            FlightScheduleFlight::where("flight_schedule_id", $template->id)
                                ->delete();

            // remove template
            $fSchedule = FlightSchedule::where("id", "=", $templateId)
                                        ->get();
            // Audit Deleted
            auditDeleted($fSchedule);


            return response()->json([
                "message" => "Template was successfully deleted",
                "success" => 1
            ]);
        }
        return response()->json([
            "message" => "Not found template ID, please specify correct data",
            "error"   => 1
        ]);
    }

    /**
     * POST request upload template to fleet watch
     * @return \Illuminate\Http\RedirectResponse
     */
    public function uploadToFleetwatch()
    {
        $templateData      = json_decode(\request("fleetwatch_data"));
        $period            = $this->getUploadPeriodDates();
        $flightsInsertData = [];

        if (is_array($templateData))
        {
            debug($period);
            $dateTimeNow = date("Y-m-d H:i:s");
            $from = strtotime($period["from"]);
            $to   = strtotime($period["to"]);
            $week = 0;
            $flightIds = [];

            for ($i = $from; $i < $to; $i = strtotime("+7 days", $i))
            {
                $week++;
                foreach ($templateData as $flight)
                {
                    if (!FlightSchedule::checkWeekNumber($flight->frequency, $flight->starting_week, $week))
                    {
                        continue;
                    }

                    $stdWeekDay = date('N', strtotime($flight->std_time));

                    $staWeekDay = date('N', strtotime($flight->sta_time));

                    $std       = date("Y-m-d", strtotime("+" . ($stdWeekDay - 1) . " days", $i));

                    // Continue In Case It Starts From Sunday
                    if (strtotime($std) < $from){
                        continue;
                    }

                    if ($staWeekDay < $stdWeekDay){
                        $sta   = date("Y-m-d", strtotime("+" . ($staWeekDay - 1 + 7) . " days", $i));
                    }
                    else
                        $sta   = date("Y-m-d", strtotime("+" . ($staWeekDay - 1) . " days", $i));


                    // Search Flight
                    $searchFlight = Flight::where('flight_number_id', $flight->flight_number_id)
                                            ->where(DB::raw('DATE(std)'), $std)
                                            ->get();

                    // If FLight Exists Update Record
                    if (count($searchFlight) == 1){
                        $searchFlight[0]->aircraft_id = $flight->aircraft_id;
                        $searchFlight[0]->std = $std . " " . date('H:i:s', strtotime($flight->std_time));
                        $searchFlight[0]->departure_date = $std;

                        $searchFlight[0]->sta = $sta . " " . date('H:i:s', strtotime($flight->sta_time));
                        $searchFlight[0]->arrival_date = $sta;

                        $searchFlight[0]->updated_by = Auth::user()->id;
                        $searchFlight[0]->updated_at = $dateTimeNow;
                        $searchFlight[0]->cancelled_at = null;
                        $searchFlight[0]->save();
                        $flightIds[] = $searchFlight[0]->id;
                        continue;
                    }

                    // Else Soft Delete All Flights If More Than 1 Found
                    if (count($searchFlight)) {
                        foreach ($searchFlight as $flt) {
                            $flt->updated_by    = Auth::user()->id;
                            $flt->cancelled_at  = $dateTimeNow;
                            $flt->save();
                        }
                    }

                    // Add New Flight
                    $newFlight = new Flight;
                    $newFlight->aircraft_id      = $flight->aircraft_id;
                    $newFlight->flight_number_id = $flight->flight_number_id;

                    $newFlight->std              = $std . " " . date('H:i:s', strtotime($flight->std_time));
                    $newFlight->departure_date   = $std;

                    $newFlight->sta              = $sta . " " . date('H:i:s', strtotime($flight->sta_time));
                    $newFlight->arrival_date     = $sta;

                    $newFlight->created_by       = Auth::user()->id;
                    $newFlight->created_at       = $dateTimeNow;
                    $newFlight->save();

                    $flightIds[] = $newFlight->id;

                    /*$flightsInsertData[] = [
                       "aircraft_id"      => $flight->aircraft_id,
                       "flight_number_id" => $flight->flight_number_id,
                       "std"              => $std . " " . date('H:i:s', strtotime($flight->std_time)),
                       "sta"              => $sta . " " . date('H:i:s',  strtotime($flight->sta_time)),
                       "created_by"       => Auth::user()->id,
                       "created_at"       => $dateTimeNow
                   ];*/
                }
            }

            if (count($flightIds))
            {

                Flight::whereBetween(DB::raw('std'), [$period["from"], $period["to"]])
                        ->whereNotIn('id', $flightIds)
                        ->update(['deleted_at' => $dateTimeNow,
                                  'updated_by' => Auth::user()->id]);

                return redirect()->to("flight-schedule/index")
                    ->with("message", [
                        "text" => "Template was successfully uploaded to fleetwatch",
                        "type" => MESSAGE_SUCCESS
                    ]);
            }
        }
        return redirect()->to("flight-schedule/index")
            ->with("message", [
                "text" => "Not found template data to upload to fleetwatch, please check timeline",
                "type" => MESSAGE_DANGER
            ]);
    }

    /**
     * Parse flights from database for view
     * @param $flights
     * @return array
     */
    private function parseFlightsForView($flights)
    {
        $json = [];
        foreach ($flights as $flightItem)
        {
            $flightNumber  = $flightItem->flightNumber;
            $aircraftItem  = $flightItem->aircraft;
            $departureDate = new DateTime($flightItem->std);
            $arrivalDate   = new DateTime($flightItem->sta);
            $dayDepartureOriginal = date('d', $departureDate->getTimestamp());
            $dayArrivalOriginal = date('d', $arrivalDate->getTimestamp());

            $dayDeparture       = new DateTime($flightItem->std);
            $dayArrival         = new DateTime($flightItem->sta);
            $currentDayNumber   = date("N");
            $departureDayNumber = date("N", $departureDate->getTimestamp());
            $arrivalDayNumber   = date("N", $arrivalDate->getTimestamp());
            $diffDeparture      = abs($currentDayNumber - $departureDayNumber);
            $diffArrival        = abs($currentDayNumber - $arrivalDayNumber);

            if ($currentDayNumber > $departureDayNumber)
            {
                $dayDeparture->modify("-$diffDeparture days");
            }
            else if ($currentDayNumber < $departureDayNumber)
            {
                $dayDeparture->modify("+$diffDeparture days");
            }

            if ($currentDayNumber > $arrivalDayNumber)
            {
                $dayArrival->modify("-$diffArrival days");
            }
            else if ($currentDayNumber < $arrivalDayNumber)
            {
                $dayArrival->modify("+$diffArrival days");
            }
            $monthArrival   = $departureDate->format("n") - 1;
            $monthDeparture = $arrivalDate->format("n") - 1;
            $json[]         = [
                "unique_id"        => $flightItem->id,
                "parent_id"        => $flightItem->parent_id,
                "start_date"       => [
                    $dayDeparture->format("Y"),             // Year
                    $monthDeparture,                        // Month
                    $dayDepartureOriginal, //$dayDeparture->format("j"),
                    $departureDate->format("G"),            // Hour
                    (int)$departureDate->format("i"),       // Minute
                    (int)$departureDate->format("s")        // Seconds
                ],
                "end_date"         => [
                    $dayArrival->format("Y"),
                    $monthArrival,
                    $dayArrivalOriginal, //$dayArrival->format("j"),
                    $arrivalDate->format("G"),
                    (int)$arrivalDate->format("i"),
                    (int)$arrivalDate->format("s")
                ],
                "content"          => "<div id='flight-" . $flightItem->id .
                    "'  class='row fw-flight-item'><span class='col-xs-0 col-sm-4'>" .
                    $flightNumber->departure_airport . "</span><span class='col-xs-0 col-sm-4'>".ProjectConstant::getConstants(IATA_CODE)." " .
                    $flightNumber->flight_number . "</span><span class='col-xs-0 col-sm-4'>" .
                    $flightNumber->arrival_airport . "</span></div>",
                "group"            => $aircraftItem->name,
                "className"        => "available",
                "aircraft_id"      => $aircraftItem->id,
                "std_weekday"      => $departureDayNumber,
                "std_time"         => $departureDate->format("Y-m-d H:i:s"),
                "sta_weekday"      => $arrivalDayNumber,
                "sta_time"         => $arrivalDate->format("Y-m-d H:i:s"),
                "flight_number_id" => $flightNumber->id,
                "frequency"        => FREQ_WEEKLY,
                "starting_week"    => STARTING_WEEK_FIRST
            ];
        }
        return $json;
    }

    /**
     * Parse template data for view
     * @return array
     */
    private function parseTemplateDataForView($templateData)
    {
        $json = [];
        $now  = new DateTime();
        if (count($templateData))
        {
            foreach ($templateData as $flight)
            {
                $departureDate = new DateTime($flight->std_time);
                $arrivalDate   = new DateTime($flight->sta_time);
                $flightNumber  = $flight->flightNumber;
                $aircraftItem  = $flight->aircraft;

                $duration = $arrivalDate->diff($departureDate);
                $durationMinutes = $duration->h * 60 + $duration->i;

                if ($durationMinutes < 90){
                    $content = "<div id='flight-" . $flight->id . "' class='row fw-flight-item'>".
                        "<div class='col-sm-12 flightStandard'>".
                        "<span class='flight_number_box_small'>" . $flightNumber->flight_number ."</span>".
                        "</div>".
                        "</div>";
                }
                else{

                    if (in_array($flightNumber->flightType->type,[ TAJIKAIR, OTHERAIRLINES ])){
                        $fNo = $flightNumber->flight_number;
                    }
                    else {
                        $fNo = ProjectConstant::getConstants(IATA_CODE)." ".$flightNumber->flight_number;
                    }

                    $content = "<div id='flight-" . $flight->id . "' class='row fw-flight-item'>".
                        "<div class='col-sm-12 flightStandard'>".
                        "<span class='flight_number_box_left'>". $flightNumber->departure_airport ."</span>".
                        "<span class='flight_number_box_center'>".$fNo."</span>".
                        "<span class='flight_number_box_right'>". $flightNumber->arrival_airport ."</span>".
                        "</div>".
                        "</div>";
                }

                $json[]        = [
                    "unique_id"        => $flight->id,
                    "start_date"       => [
                        $departureDate->format("Y"),
                        $departureDate->format("n") - 1,
                        $departureDate->format('d'),  //$this->getDayByWeekNumber($flight->std_weekday),
                        (int)$departureDate->format("H"),
                        (int)$departureDate->format("i"),
                        (int)$departureDate->format("s")
                    ],
                    "end_date"         => [
                        $arrivalDate->format("Y"),
                        $arrivalDate->format("n") - 1,
                        $arrivalDate->format('d'),  //$this->getDayByWeekNumber($flight->sta_weekday),
                        (int)$arrivalDate->format("H"),
                        (int)$arrivalDate->format("i"),
                        (int)$arrivalDate->format("s")
                    ],
                    "content"          => $content,
                    "group"            => $aircraftItem->name,
                    "className"        => "available",
                    "aircraft_id"      => $aircraftItem->id,
                    "std_weekday"      => $flight->std_weekday,
                    "std_time"         => $flight->std_time,
                    "sta_weekday"      => $flight->sta_weekday,
                    "sta_time"         => $flight->sta_time,
                    "flight_number_id" => $flightNumber->id,
                    "frequency"        => $flight->frequency,
                    "starting_week"    => $flight->starting_week,
                    "parent_id"        => $flight->parent_id
                ];
            }
        }
        return $json;
    }

    /**
     * Get upload period dates
     * @return array
     */
    private function getUploadPeriodDates()
    {
        $from       = $to = NULL;
        $uploadType = \request("upload_data");
        if ($uploadType == "week")
        {
            $week_from  = \request("upload_week_from");
            $year_from  = \request("upload_year_from");
            $week = $this->getStartAndEndDate($week_from, $year_from);
            if (is_array($week)){
                $from = $week["from"];
            }

            $week_to  = \request("upload_week_to");
            $year_to  = \request("upload_year_to");
            $week = $this->getStartAndEndDate($week_to, $year_to);
            if (is_array($week)){
                $to = $week["to"];
            }
        }
        else if ($uploadType == "from_to")
        {
            $from = \request("upload_from");
            $to   = \request("upload_to");
        }
        return [
            "from" => $from,
            "to"   => $to
        ];
    }

    /**
     * Get day current date by week number
     * @param $weekday
     * @return bool|string
     */
    private function getDayByWeekNumber($weekday)
    {
        $last_sunday = strtotime("last Sunday");
        return date("j", strtotime("+" . $weekday . " day", $last_sunday));
    }


    /**
     * Get start and end of week
     * @param int $week
     * @param int $year
     * @return mixed
     */
    /*private function getStartAndEndDate($week, $year)
    {
        $dto         = new DateTime();
        $ret["from"] = $dto->setISODate($year, $week)
            ->format("Y-m-d");
        $ret["to"]   = $dto->modify("+7 days")
            ->format("Y-m-d");
        return $ret;
    }*/

    function getStartAndEndDate($week, $year)
    {
        $time = strtotime("1 January $year", time());
        $day = date('w', $time);
        $time += (( 7 * ($week - 1)) + 1 - $day)*24*3600;
        $return["from"] = date('Y-m-d', $time);
        $time += 7 * 24 * 3600;
        $return["to"] = date('Y-m-d', $time);
        return $return;
    }

}
