<?php

namespace App\Http\Controllers;

use App\Repositories\Interfaces\IAirportRepository;
use App\Repositories\Interfaces\IFlightRouteRepository;
use App\Repositories\Interfaces\IFlightTypeRepository;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;


class FlightRouteController extends Controller
{
    /**
     * @param IFlightRouteRepository $modelRepository
     * @return \Illuminate\View\View
     */
    public function index(IFlightRouteRepository $modelRepository)
    {
        $modelVariable			= $modelRepository->findAllByAttributes(['deleted_at' => [WHERE_NULL]]);
        $modelVariableRemoved	= $modelRepository->findAllByAttributes(['deleted_at' => [WHERE_NOT_NULL]]);
        // Pagination (Used For Pagination Links Only)

        $perPage = \request("perPage") ? \request("perPage") : 1000;

        $this->viewData = [
            'perPage'		            => $perPage,
            'currentPage'	            => \request("page") ? \request("page") : 1,
            'airport'		            => \request("airport"),
            'modelVariable'		        => paginate($modelVariable, (\request("page") ? \request("page") : 1), $perPage),
            'modelVariableRemoved'		=> paginate($modelVariableRemoved, (\request("page") ? \request("page") : 1), $perPage),
        ];

        return view('flight-route/index', $this->viewData);
    }

    /**
     * @param IAirportRepository $airportRepository
     * @param IFlightTypeRepository $flightTypeRepository
     * @return \Illuminate\View\View
     */
    public function create(IAirportRepository $airportRepository, IFlightTypeRepository $flightTypeRepository)
    {
        $this->viewData = [
            'currentPage'			=> \request("page"),
            'airports'				=> ['' => "Select"] + $airportRepository->findAndListModelVariable(['operated' => true, 'iata' => [WHERE_NOT_NULL]], [['iata', 'name'], 'id', '-']),
            'flightTypes'			=> ['' => "Select"] + FlightType::pluck("type", "id")->all(),
        ];

        return view('flight-route/create', $this->viewData);

    }

    /**
     * @param IFlightRouteRepository $modelRepository
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(IFlightRouteRepository $modelRepository)
    {
        $flight_route = $modelRepository->findByAttributes([
            'from_airport_id'   =>  \request("from_airport"),
            'to_airport_id'     =>  \request("to_airport")
        ]);

        if ($flight_route){
            $message = "Selected Route Already Exists. Details Updated.";
        }
        else {
            $flight_route = $modelRepository->createByAttributes([
                'from_airport_id'   =>  \request("from_airport"),
                'to_airport_id'     =>  \request("to_airport")
            ]);

            $message = "New Route Successfully Created.";
        }

        $flight_route->flight_type_id = \request("flight_type");
        $flight_route->duration = \request("duration");
        $flight_route->distance = \request("distance");
        $flight_route->save();

        flash()->success($message);
        return redirect()
            ->to("flight-route");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * @param $flight_route
     * @param IAirportRepository $airportRepository
     * @param IFlightTypeRepository $flightTypeRepository
     * @return \Illuminate\View\View
     */
    public function edit($flight_route, IAirportRepository $airportRepository, IFlightTypeRepository $flightTypeRepository)
    {

        $this->viewData = [
            'modelVariable'			=> $flight_route,
            'currentPage'			=> \request("page"),
            'airports'				=> ['' => "Select"] + $airportRepository->findAndListModelVariable(['operated' => true, 'iata' => [WHERE_NOT_NULL]], [['iata', 'name'], 'id', '-']),
            'flightTypes'			=> ['' => "Select"] + FlightType::pluck("type", "id")->all(),
        ];

        return view('flight-route/edit', $this->viewData);
    }

    /**
     * @param $flight_route
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update($flight_route)
    {
        $page = \request("page");
        $flight_route->flight_type_id = \request("flight_type");
        $flight_route->from_airport_id = \request("from_airport");
        $flight_route->to_airport_id = \request("to_airport");
        $flight_route->duration = \request("duration");
        $flight_route->distance = \request("distance");
        $flight_route->save();

        flash()->success("Changes Successfully Saved");
        return redirect()
            ->to("flight-route?page={$page}");

    }

    /**
     * @param $flight_route
     * @return int
     */
    public function destroy($flight_route)
    {
        $flight_route->deleted_at = date("Y-m-d H:i:s");
        $flight_route->save();

        flash()->success("Record Successfully Deleted");
        return redirect()
            ->to("flight-route");
    }

    public function restore($flight_route){
        $flight_route->deleted_at = null;
        $flight_route->save();

        flash()->success("Record Successfully Restored");
        return redirect()
            ->to("flight-route");
    }
}
