<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
use App\Models\Aircraft;
use App\Models\Flight;
use App\Models\FlightNumber;
use App\Models\FlightType;
use Illuminate\Support\Facades\DB;


class FlightQueryController extends Controller
{
    private $data = array();

    const PER_PAGE_RESULT = 50;

    public function anyIndex()
    {
        $this->data = [
            "aircraft"          => ["" => "Select"] + Aircraft::whereNull("deleted_at")
                                                                ->pluck("name", "id")
                                                                ->all(),

            "flightNumbers"     => FlightNumber::whereNull("deleted_at")
                                                ->pluck("flight_number", "id")
                                                ->all(),
            "departureAirports" => ["" => "Select"] + FlightNumber::whereNull("deleted_at")
                                                ->distinct()
                                                ->pluck("departure_airport", "departure_airport")->all(),
            "arrivalAirports"   => ["" => "Select"] + FlightNumber::whereNull("deleted_at")
                                                ->distinct()
                                                ->pluck("arrival_airport", "arrival_airport")->all(),
            'flightTypes'       => ['' => 'Select'] + FlightType::pluck('type', 'id')->all()
        ];

        if (is_array($_GET) && count($_GET))
        {
            $flights = Flight::with(['delays'])
                ->select([
                    "flights.id",
                    "flights.std",
                    "flights.etd",
                    "flights.atd",
                    "flights.sta",
                    "flights.eta",
                    "flights.ata",
                    "flights.pax_a_booked",
                    "flights.pax_c_booked",
                    "flights.pax_w_booked",
                    "flights.pax_y_booked",
                    "flights.pax_inf_booked",
                    "flights.pax_a_actual",
                    "flights.pax_c_actual",
                    "flights.pax_w_actual",
                    "flights.pax_y_actual",
                    "flights.pax_inf_actual",
//                    "flights.flights_delay_id",
                    "flights.in_tanks",
                    "flights.uplifted",
                    "flights.utilised",
                    "flights__numbers.departure_airport",
                    "flights__numbers.arrival_airport",
                    "flights__numbers.flight_number",
                    "flights__numbers.id AS flight_number_id",
                    "aircraft.name AS aircraft_name"
                ])
                ->join("flights__numbers", "flights.flight_number_id", "=", "flights__numbers.id")
                ->join("flights__types", "flights__types.id", "=", "flights__numbers.flight_type_id")
                ->join("aircraft", "flights.aircraft_id", "=", "aircraft.id");

            if (\request("aircraft") && \request("aircraft"))
            {
                $flights->where("flights.aircraft_id", "=", \request("aircraft"));
            }
            if (\request("delay") && \request("delay"))
            {
//                $flights->whereNotNull("delay_id");
            }
            if (\request("flight_type") && strlen(\request("flight_type")))
            {
                $flights->where("flights__numbers.flight_type_id", "=", \request("flight_type"));
            }
            if (\request("flight_condition") && \request("flight_condition"))
            {
                switch (\request("flight_condition"))
                {
                    case "is_flight_number":
                        if (\request("n") && is_array(\request("n")))
                        {
                            $flights->whereIn("flights__numbers.id", \request("n"));
                        }
                        break;
                    case "is_airport":
                        if (\request("departure_airport") && \request("departure_airport"))
                        {
                            $flights->where("flights__numbers.departure_airport", "=", \request("departure_airport"));
                        }
                        if (\request("arrival_airport") && \request("arrival_airport"))
                        {
                            $flights->where("flights__numbers.arrival_airport", "=", \request("arrival_airport"));
                        }
                        break;
                    default:
                        break;
                }
            }

            if (\request("period") && \request("period"))
            {
                switch (\request("period"))
                {
                    case "departure_date":
                        if (\request("from") && \request("from"))
                        {
                            $flights->where("flights.std", ">=", \request("from"));
                        }
                        if (\request("to") && \request("to"))
                        {
                            $flights->where("flights.std", "<=", \request("to"));
                        }
                        break;
                    case "arrival_date":
                        if (\request("from") && \request("from"))
                        {
                            $flights->where("flights.atd", ">=", \request("from"));
                        }
                        if (\request("to") && \request("to"))
                        {
                            $flights->where("flights.atd", "<=", \request("to"));
                        }
                        break;
                    case "period":
                        if (\request("period_field") && \request("period_field"))
                        {
                            switch (\request("period_field"))
                            {
                                case "current_month":
                                    $flights->whereRaw("MONTH(s_flights.std) = " . date('m') .
                                        " AND YEAR(s_flights.std) = " . date('Y'));
                                    break;
                                case "last_28_days":
                                    $flights->whereRaw("s_flights.std >= ( CURDATE() - INTERVAL 28 DAY )");
                                    break;
                                case "last_90_days":
                                    $flights->whereRaw("s_flights.std >= ( CURDATE() - INTERVAL 90 DAY )");
                                    break;
                                case "last_year":
                                    $flights->whereRaw("s_flights.std >= DATE_SUB(NOW(),INTERVAL 1 YEAR)");
                                    break;
                                default:
                                    $flights->whereRaw("DATE(s_flights.std) = CURDATE()");
                                    break;
                            }
                        }
                        break;
                    default:
                        break;
                }
            }

            $recordsPerPage = 50;
            $flights               = $flights->orderBy('std')->get();//->paginate($recordsPerPage);
            $this->data['flights'] = $flights;
            $this->data['recordsPerPage'] = $recordsPerPage;
        }

        return view("flightquery/index", $this->data);
    }

}
