<?php namespace App\Http\Controllers;

use App\Classes\Messages\Message;
use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Models\Aircraft;
use App\Models\Chart;
use App\Models\Flight;
use App\Models\FlightContainer;
use App\Models\FlightContainerInfo;
use App\Models\FlightOrderStatus;
use App\Models\PassengerFlight;
use App\Models\PassengerFlightAct;
use App\Repositories\Interfaces\ICountryRepository;
use App\Repositories\Interfaces\IFlightRepository;
use App\Repositories\Interfaces\IPassengerFlightRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class FlightInfoController extends Controller {

    /**
     * @param $id
     * @param IPassengerFlightRepository $passengerFlightRepository
     * @param IFlightRepository $flightRepository
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
	public function index($id, IPassengerFlightRepository $passengerFlightRepository, IFlightRepository $flightRepository)
	{
        $passengerFlights = $passengerFlightRepository->findAllByAttributes([
            'flight_order_status_id' => [WHERE_NOT_IN, FlightOrderStatus::getExcludedFlightStatusesIds()],
            'fare_basis'             => ['NOT LIKE', '%IN%'],
            'flight_id'              => $id
        ],  [
            'passenger',
            'flightRbd',
            'flightCabin',
            'passengerOrder',
            'passengerFrequentFlyer',
            'fareCurrency',
            'flightFareBasis',
        ],
            ['*'],
            ['flights__fare_basis', 'flights__fare_basis.id', '=', 'passengers__flights.flight_fare_basis_id'] ,
            [['fare', 'DESC']]);


        $flight = $flightRepository->findByAttributes(['id' => $id], [
            'aircraft',
            'aircraft.type',
            'aircraftType',
        ]);

        $data = [];

        self::getFlightCapacity($data, $flight);

        // Get Passengers Revenue Data For Charts
        $passengers = $this->getPassengerRevenueChartData($passengerFlights, $id, $passengers, $data);

        $aircraft = $flight->aircraft ? $flight->aircraft : $flight->aircraftType;

        // Group By Cabin
//        $data['revenue']['table_chart_rbd'] = $this->groupByCabinFromRbd($data['revenue']['table_chart_rbd']);

        $this->viewData = [
            'picture'           => asset("/assets/img/profile_picture.png"),
            'passengers'        => $passengers,
            'aircraft'          => json_encode($aircraft),
            'data'              => $data,
            'moduleName'        => isset($data['flight']) ? $data['flight']->flightNumber->flight_number_iata."/".$data['flight']->flightNumber->flight_sector."/".baseDateFormatYear($data['flight']->std) : ""
        ];

        return view('flight-info/index', $this->viewData);
	}

    public function handlingIndex($id)
    {
        $passengerFlights = PassengerFlight::getFlightsPassengers($id);

        $passengerFlightsAct = PassengerFlightAct::getFlightsActPassengers($id);

        $flight = Flight::getFlight($id);

//        $this->fillAC();

        $data = [];

        self::getFlightCapacity($data, $flight);

        $aircraft = Aircraft::getFlightAircraftSeatConfig($flight);

        // Get Passengers Revenue Data For Charts
        $passengers = $this->getPassengerRevenueChartData($passengerFlightsAct, $passengerFlights, $data, $id, TRUE);

        // Group By Cabin
//        $data['revenue']['table_chart_rbd'] = $this->groupByCabinFromRbd($data['revenue']['table_chart_rbd']);

        $flightContainerInfo = FlightContainerInfo::with(["cpmMessage"])
                                                    ->whereNull("manual")
                                                    ->where("flight_id", $flight->id)
                                                    ->first();

        $flightContainers = $compartments = $messages = [];

        if ($flightContainerInfo) {

            list ($flightContainers, $compartments, $totalWeight, $totalWidth) = FlightContainer::getAircraftCompartments($flightContainerInfo);

            $messages[CPM] = Flight::parseMessages($flightContainerInfo->cpmMessage, CPM);
        }
        else {

            list ($compartments, $totalWeight, $totalWidth) = FlightContainer::getFlightCompartments($flight, false);

            $messages[CPM] = Flight::parseMessages($flight->cpm->sortByDesc("id")->first(), CPM);
        }

        $messages[LDM] = Flight::parseMessages($flight->ldmMessage->sortByDesc("id")->first(), LDM);

        $messages[UCM] = Flight::parseMessages($flight->ucm->sortByDesc("id")->first(), UCM);



        $this->viewData = [
            'aircraft'              => $aircraft,
            'picture'               => asset("/assets/img/profile_picture.png"),
            'passengers'            => $passengers,
            'passengerFlights'      => $passengerFlights,
            'passengerFlightsAct'   => $passengerFlightsAct,
            'type'                  => count($passengerFlightsAct) ? PRL : PNL,
            'chartPassengers'       => count($passengerFlightsAct) ? $passengers[PRL] : $passengers[PNL],
            'data'                  => $data,
            'totalWeight'           => $totalWeight,
            'totalWidth'            => $totalWidth,
            'flight'                => $flight,
            'flightContainers'      => $flightContainers,
            'flightContainerInfo'   => $flightContainerInfo,
            'compartments'          => $compartments,
            'messages'              => $messages,
            'ghaModule'             => ghaModule(),
        ];

        debug($this->viewData["aircraft"]);
        debug($this->viewData["chartPassengers"]);

        return view('flight-info/h-index', $this->viewData);
    }

    public function fillAC(){
        /*
         * rowStart    : 2,
         * rowEnd      : 4,
         * columns     : [ 'F', 'E', 'D', '_' ,  'C', 'B', 'A'],
         * extraSpace  : [10, 11],
         * emptyRows   : [13, 14, 15]
         * emptySeats  : ['11D', '11E', '11F']
         */

        // a    - First class
        // b    - Business class
        // e    - Economy class
        $cDetails = [
            "rowStart"    => 1,
            "rowEnd"     => 3,
            "columns"     => ['J', 'H', '_', 'F', 'D', '_', 'B', 'A'],

            // Extra space after rows
//            "extraSpace"  => [11, 12],
        ];

        $yDetails = [
            "rowStart"    => 11,
            "rowEnd"      => 40,
            "columns"     => ['I', 'H', 'G', '_', 'F', 'E', 'D', '_', 'C', 'B', 'A'],

            "emptyRows"   => [13, 29],
            "emptySeats"  => [ '11D', '11E', '11F', '39C', '39G', '40A', '40B', '40C', '40G', '40H', '40I'],

            // Extra space after rows
            "extraSpace"  => [11, 12],
        ];

        $aircraft = Aircraft::find(568);
        $aircraft->config_c_details = serialize($cDetails);
        $aircraft->config_y_details = serialize($yDetails);
        $aircraft->save();

        $yDetails = [
            "rowStart"    => 1,
            "rowEnd"      => 29,
            "columns"     => ['F', 'E', 'D', '_', 'C', 'B', 'A'],

            // Extra space after rows
            "extraSpace"  => [11, 12],
        ];

        $aircraft = Aircraft::find(11);
        $aircraft->config_y_details = serialize($yDetails);
        $aircraft->save();
    }


    public static function getPassengerRevenueChartData($passengerFlightsAct, $passengerFlights, &$data, $flightId, $handling = false){

        $data['cabin']['booked'] = [ 'Economy' => 0, 'Business'  => 0 ];
        $data['revenue']= [ 'Economy' => 0, 'Business'  => 0 ];
        $data['seat_factors'] = [
            'Economy'    => null,
            'Business'   => null,
            'Total'      => null,
        ];
        $data['pax'] = [
            ['Economy',  0],
            ['Business', 0],
        ];

        $passFlightData = [
            PRL     => $passengerFlightsAct,
            PNL     => $passengerFlights,
        ];

        $prl = count($passengerFlightsAct);

        $passengers = [
            PRL     => [],
            PNL     => [],
        ];

        foreach ($passFlightData as $type => $passFlightEach) {

            if ($passFlightEach && count($passFlightEach)) {

                foreach ($passFlightEach as $each) {
                    $passenger = $each->passenger;


                    $cabin = $each->flightCabin ? $each->flightCabin->cabin : 'Economy';
                    $passengerOrder = $each->passengerOrder;
                    $ticketNumber = $passengerOrder ? $passengerOrder->ticket_number : "";

                    $item = [];

                    $item['passenger_id']= $passenger->id;

                    $item['seat_number']= $each->seat_number ? $each->seat_number : "";

                    if ($handling){
                        $item['last_name']  = ucwords(strtolower($passenger->last_name));
                        $item['first_name'] = $passenger->first_name ? ucwords(strtolower($passenger->first_name)) : "";
//                        $item['gender']     = getGenderAbbr($passenger->gender);
                        $item['TKT_NO']     = $ticketNumber . ($each->coupon ? " | CPN-".$each->coupon : "");



                        /*
                        $FqTv = "";
                        if ($each->passengerFrequentFlyer){
                            $FqTv = $each->passengerFrequentFlyer->airline ? $each->passengerFrequentFlyer->airline->iata."-" : "";
                            $FqTv .= $each->passengerFrequentFlyer->ff_no;
                        }
                        $item['FQTV']= $FqTv;
                        $XBag = "";
                        if ($each->xbag_info) {
                            $info = unserialize($each->xbag_info);
                            $XBag .= $each->xbag_qty ? ($each->xbag_qty . " BAGS ") : "";
                            $XBag .= $info[0] . " ";
                            if ($each->xbag_wt) {
                                $XBag .= $each->xbag_wt . "KG" . " ";
                            }
                            if ($info && count($info) > 1) {
                                $XBag .= $info[1];
                            }
                        }

                        $item['XBAG'] = $XBag;
                        */


                        $passenger = $each->passenger;

                        $fqtv = "";
                        if ($each->passengerFrequentFlyer) {
                            $fqtv = $each->passengerFrequentFlyer->airline ? $each->passengerFrequentFlyer->airline->iata . "-" : "";
                            $fqtv .= $each->passengerFrequentFlyer->ff_no;
                        }

                        $inbound = "";
                        if ($each->inbound) {
                            $string = unserialize($each->inbound);
                            if ($string && count($string)) {
                                $inbound = $string["airline"] . $string["flight_number"] . " ";

                                $inbound .= isset($string["rbd"]) && $string["rbd"] ? $string["rbd"] . " " : '';
                                $inbound .= isset($string["arrival_date"]) && $string["arrival_date"] ? newDateFormat($string["arrival_date"]) . " " : '';
                                $inbound .= isset($string["origin"]) && $string['origin'] ? $string["origin"] . " " : '';

                                $inbound .= isset($string["arrival_time"]) && $string['arrival_time'] ? "ARR " . $string["arrival_time"] : '';
                                // $inbound .= isset($string["arrival_airline"]) && $string['arrival_airline']  ? "/".$string["arrival_airline"]          : '';
                            }
                        }

                        $outbound = '';
                        if ($each->outbound){
                            $string = unserialize($each->outbound);
                            if ($string && count($string)) {
                                $outbound = $string["airline"].$string["flight_number"]." ";

                                $outbound .= isset($string["rbd"]) && $string["rbd"]                        ? $string["rbd"] . " "              : '';
                                $outbound .= isset($string["departure_date"]) && $string["departure_date"]  ? newDateFormat($string["departure_date"]) . " " : '';
                                $outbound .= isset($string["destination"]) && $string['destination']        ? $string["destination"]. " "          : '';

                                $outbound .= isset($string["departure_time"]) && $string['departure_time']        ? "DEP ".$string["departure_time"]          : '';
                                // $outbound .= isset($string["departure_airline"]) && $string['departure_airline']  ? "/".$string["departure_airline"]          : '';
                            }
                        }

                        $codeShareStr = "";
                        if ($each->codeshare_flight){
                            $codeShare = unserialize($each->codeshare_flight);

                            $codeShareStr = isset($codeShare['airline'])        ? $codeShare['airline']         : "";
                            $codeShareStr .= isset($codeShare['flight_number']) ? $codeShare['flight_number']   : "";
//                            $codeShareStr .= isset($codeShare['rbd'])           ? $codeShare['rbd']             : "";
                        }

                        $fareString = "";
                        if ($type == PRL){

                            $passengerFlight = $passengerFlights->where("passenger_id", $each->passenger_id)->first();

                            if ($passengerFlight){

                                if (!$codeShareStr && $passengerFlight->codeshare_flight){
                                    $codeShare = unserialize($passengerFlight->codeshare_flight);

                                    $codeShareStr = isset($codeShare['airline'])        ? $codeShare['airline']         : "";
                                    $codeShareStr .= isset($codeShare['flight_number']) ? $codeShare['flight_number']   : "";
//                                    $codeShareStr .= isset($codeShare['rbd'])           ? $codeShare['rbd']             : "";
                                }

                                if (!$fqtv && $passengerFlight->passengerFrequentFlyer) {
                                    $fqtv = $passengerFlight->passengerFrequentFlyer->airline ? $passengerFlight->passengerFrequentFlyer->airline->iata . "-" : "";
                                    $fqtv .= $passengerFlight->passengerFrequentFlyer->ff_no;
                                }

                                if(!$inbound && $passengerFlight->inbound) {
                                    $string = unserialize($passengerFlight->inbound);
                                    if ($string && count($string)) {
                                        $inbound = $string["airline"] . $string["flight_number"] . " ";

                                        $inbound .= isset($string["rbd"]) && $string["rbd"] ? $string["rbd"] . " " : '';
                                        $inbound .= isset($string["arrival_date"]) && $string["arrival_date"] ? newDateFormat($string["arrival_date"]) . " " : '';
                                        $inbound .= isset($string["origin"]) && $string['origin'] ? $string["origin"] . " " : '';

                                        $inbound .= isset($string["arrival_time"]) && $string['arrival_time'] ? "ARR " . $string["arrival_time"] : '';
                                        // $inbound .= isset($string["arrival_airline"]) && $string['arrival_airline']  ? "/".$string["arrival_airline"]          : '';
                                    }
                                }

                                if (!$outbound && $passengerFlight->outbound){
                                    $string = unserialize($each->outbound);
                                    if ($string && count($string)) {
                                        $outbound = $string["airline"].$string["flight_number"]." ";

                                        $outbound .= isset($string["rbd"]) && $string["rbd"]                        ? $string["rbd"] . " "              : '';
                                        $outbound .= isset($string["departure_date"]) && $string["departure_date"]  ? newDateFormat($string["departure_date"]) . " " : '';
                                        $outbound .= isset($string["destination"]) && $string['destination']        ? $string["destination"]. " "          : '';

                                        $outbound .= isset($string["departure_time"]) && $string['departure_time']        ? "DEP ".$string["departure_time"]          : '';
                                        // $outbound .= isset($string["departure_airline"]) && $string['departure_airline']  ? "/".$string["departure_airline"]          : '';
                                    }
                                }

                                $fareCurrency   = $passengerFlight->fareCurrency;
                                $fareBasis      = $passengerFlight->flightFareBasis;
                                $fareRbd        = $passengerFlight->flightRbd;
                                $fare           = $passengerFlight->fare ? round($passengerFlight->fare) : "";

                                // Brought from AIRLINE MODULE
                                $fareString     =  ($fareCurrency ? " {$fareCurrency->code}" : "").$fare
                                                  .($fareBasis ? " | {$fareBasis->fare_basis}" : '')
                                                  .($fareRbd ? " | {$fareRbd->rbd}" : '');
                            }

                        }

                        $item['fare'] = $fareString;

                        // Basic Info
                        $item['GRP']    = $each->group_tcp ? $each->group_tcp : "";
                        $item['PNR']    = $passengerOrder ? $passengerOrder->pnr : "";
                        $item['BAG']    = ($each->baggage_pcs     ? trim($each->baggage_pcs) : '').
                            ($each->baggage_weight  ? "/".trim($each->baggage_weight) : '');

                        $item['TAG_NO'] = $each->tag_number ? $each->tag_number : "";
                        // End

                        $item['FQTV'] = $fqtv;
                        $item['inbound'] = $inbound;
                        $item['outbound'] = $outbound;
                        $item['codeshare'] = $codeShareStr;

                        $ssr = "";
                        if ($each->ssr){
                            foreach (explode(";", $each->ssr) as $s) {
                                $ssr .= $s.", ";
                            }
                            $ssr = rtrim($ssr, ", ");
                        }
                        $item['SSR'] = $ssr;
                        $item['SSR_INFO']  = $each->ssr_info ? $each->ssr_info : "";

                        $source = $each->from_prl ? PRL.", " : "";
                        $source .= $each->from_ptm ? PTM.", " : "";
                        $source .= $each->from_tpm ? TPM.", " : "";
                        $source .= $each->from_psm ? PSM.", " : "";
                        $source = rtrim($source, ", ");

                        $item['source'] = $source;


                    }
                    else {
                        $item['name']       = ucwords(strtolower($passenger->first_name . " " . $passenger->last_name));
                        $item['ticket_no']  = $ticketNumber;
//                        $item['fare']       = $fareCurrency ?$fare. " " . $fareCurrency->code : $fare;
//                        $item['fare_basis'] = $fareBasis ? $fareBasis->fare_basis : '';
//                        $item['rbd']        = $fareRbd ? $fareRbd->rbd : '';
                        $item['baggage']    = $each->baggage_pcs ? $each->baggage_pcs . '/'. $each->baggage_weight : '';
                        $item['t__n']       = $each->tag_number;
                    }

                    if (env("AIRLINE") == "Emirates"){
                        $item['profile-picture'] = $passenger->thumb ? asset("/assets-emirates/img/passengers/" . $passenger->thumb) : asset("/assets/img/profile_picture.png");
                    }
                    else {
                        $item['profile-picture'] = $passenger->picture ? asset("/assets/img/passengers/" . $passenger->picture) : asset("/assets/img/profile_picture.png");
                    }

                    $passengers[$type][] = $item;

                    if (($prl && $type == PRL) || (!$prl && $type == PNL)){
                        $data['cabin']['booked'][$cabin]++;
                    }
                }

                if (($prl && $type == PRL) || (!$prl && $type == PNL)) {
                    $data['cabin']['booked']['Total'] = $data['cabin']['booked']['Economy'] + $data['cabin']['booked']['Business'];

                    $data['pax'] = [
                        ['Economy',  $data['cabin']['booked']['Economy']],
                        ['Business', $data['cabin']['booked']['Business']],
                    ];

                    if (isset($data['cabin']['config'])) {
                        $data['seat_factors'] = [
                            'Economy'   => $data['cabin']['config']['Economy']  ? 100 * round($data['cabin']['booked']['Economy']   / $data['cabin']['config']['Economy'], 2)   : null,
                            'Business'  => $data['cabin']['config']['Business'] ? 100 * round($data['cabin']['booked']['Business']  / $data['cabin']['config']['Business'], 2)  : null,
                            'Total'     => $data['cabin']['config']['Total']    ? 100 * round($data['cabin']['booked']['Total']     / $data['cabin']['config']['Total'], 2)     : null,
                        ];
                    }
                }
            }
        }

        $data['revenue'] = [
//            'total'             => Chart::getC3Charts(CHART_REVENUE, ['flight_id' => [ $flightId ]]),
//            'salesChannels'     => Chart::getC3Charts(CHART_REVENUE_SALES_CHANNELS, ['flight_id' => [ $flightId ]]),
//            'country'           => Chart::getC3Charts(CHART_REVENUE_BY_COUNTRY, ['flight_id' => [ $flightId ]]),
//            'agency'            => Chart::getC3Charts(CHART_REVENUE_BY_AGENCY, ['flight_id' => [ $flightId ]]),
//            'rbd'               => Chart::getC3Charts(CHART_REVENUE_BY_RBD, ['flight_id' => [ $flightId ]]),
//            'table_chart_rbd'   => PassengerFlight::getRevenue(['flight_id' => [ $flightId ]], ['field' => 'rbd']),
//            'salesDate'         => Chart::getChartJS(CHART_REVENUE_BY_SALES_DATE, ['flight_id' => [ $flightId ]]),
        ];

        return $passengers;
    }

    /**
     * Group Given Rbd Array By Cabin
     * @param $arrayRbd
     * @return array
     */
    protected function groupByCabinFromRbd($arrayRbd){
        $newArray = [];
        if ($arrayRbd && count($arrayRbd)){
            foreach ($arrayRbd as $each) {
                if (in_array($each->grouped_field, $this->businessCabinRbd)){
                    $newArray['business'][] = $each;
                }
                else {
                    $newArray['economy'][] = $each;
                }
            }
        }
        return $newArray;
    }


    /**
     * Get Flight Capacity
     * @param $data
     * @param $flight
     */
    public static function getFlightCapacity(&$data, $flight){
        $aircraft = $flight ? $flight->aircraft : null;
        $data['flight'] = $flight;
        $data['aircraft']  = $aircraft ? $aircraft : null;
        if ($flight) {
            $aircraftType = null;
            if ($flight->aircraft && $flight->aircraft->type){
                $aircraftType = $flight->aircraft->type;
            }
            elseif ($flight->aircraftType){
                $aircraftType = $flight->aircraftType;
            }

            $data['aircraftType']  = $aircraftType;

            $capacityA = $capacityC = $capacityW = $capacityY = null;

            if ($flight->capacity_a || $flight->capacity_c || $flight->capacity_w || $flight->capacity_y){
                $capacityA = $flight->capacity_a;
                $capacityC = $flight->capacity_c;
                $capacityW = $flight->capacity_w;
                $capacityY = $flight->capacity_y;
            }
            else if ($aircraft && ($aircraft->config_A || $aircraft->config_c || $aircraft->config_w || $aircraft->config_y)){
                $capacityA = $aircraft->config_a;
                $capacityC = $aircraft->config_c;
                $capacityW = $aircraft->config_w;
                $capacityY = $aircraft->config_y;
            }
            else if ($aircraftType && ($aircraftType->config_a || $aircraftType->config_c || $aircraftType->config_w || $aircraftType->config_y)){
                $capacityA = $aircraftType->config_a;
                $capacityC = $aircraftType->config_c;
                $capacityW = $aircraftType->config_w;
                $capacityY = $aircraftType->config_y;
            }

            $data['cabin']['config'] = [
                'First'  => $capacityA,
                'Business'  => $capacityC,
                'EconomyPremium'   => $capacityW,
                'Economy'   => $capacityY,
                'Total'     => ($capacityA ? intval($capacityA) : 0) + ($capacityC ? intval($capacityC) : 0)
                            + ($capacityW ? intval($capacityW) : 0) + ($capacityY ? intval($capacityY) : 0)
            ];

            $fltNo =  $flight->flightNumber && $flight->flightNumber->airline ? ($flight->flightNumber->airline->iata ? $flight->flightNumber->airline->iata : $flight->flightNumber->airline->icao ): "";
            $fltNo .= $flight->flightNumber ? $flight->flightNumber->flight_number." (" : "";

            $fltNo .= $flight->flightNumber && $flight->flightNumber->departureAirport ? $flight->flightNumber->departureAirport->iata : "";
            $fltNo .= "-";
            $fltNo .= $flight->flightNumber && $flight->flightNumber->arrivalAirport ? $flight->flightNumber->arrivalAirport->iata.")" : "";

            $data['flight_number'] = $fltNo;
        }
    }

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		//
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

}
