<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 19.08.14

 */

use app\Classes\ProjectConstant;
use App\Models\User;
use App\Repositories\Interfaces\IAirportRepository;
use App\Repositories\Interfaces\IParameterRepository;
use App\Repositories\Interfaces\ISupCrewRepository;

use App\Models\Maintenance;
use App\Models\Flight;
use App\Models\City;
use App\Models\Aircraft;
use App\Models\FlightNumber;
use App\Models\Delay;
use App\Models\Airport;
use App\Models\FlightType;
use DateTime;

class FleetWatchController extends Controller
{

    private $data = [];

    /**
     * @param ISupCrewRepository $supCrew
     * @param IAirportRepository $airport
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(ISupCrewRepository $supCrew, IAirportRepository $airport)
    {
        $date = time();
        if (\request("start_time") && \request("end_time") && \request("start_time") && \request("end_time"))
        {
            $startDate = date("Y-m-d", strtotime("-1 days", strtotime(\request("start_time"))));
            $endDate   = date("Y-m-d", strtotime("+1 days", strtotime(\request("end_time"))));
        }
        elseif (\request("go_to_date"))
        {
            $date = strtotime(\request("go_to_date"));
            $startDate = date("Y-m-d", strtotime("-1 days", $date));
            $endDate   = date("Y-m-d", strtotime("+1 days", $date));

            // Load Flights
            $flights = Flight::flightsRange($startDate, $endDate, [
                                                                    "flightNumber",
                                                                    "aircraft",
                                                                    "aircraftType",
                                                                    "delays",
                                                                    "delays.delay",
                                                                    "flightNumber.departureAirport",
                                                                    "flightNumber.arrivalAirport",
                                                                    "flightNumber.flightType",
                                                                   ], FALSE, FALSE, FALSE, TRUE);

            // Load Maintenance
            $aircraftMaintenance = Maintenance::maintenanceRange($startDate, $endDate);

            // Get JSON Ready
            return response()->json([
                "start_visible_period"  => date("Y-m-d 00:00:00", $date),
                "end_visible_period"    => date("Y-m-d 23:59:59", $date),
                "jsonData"              => self::getJsonDataForFleetWatchTimeline($flights, $aircraftMaintenance),
                "flights"               => $flights,
                "success"               => TRUE
            ]);
        }
        else {
            $startDate = date("Y-m-d", strtotime("-1 days", $date));
            $endDate   = date("Y-m-d", strtotime("+1 days", $date));
        }

        // Load Flights
        $flights = Flight::flightsRange($startDate, $endDate, [
                                                                "flightNumber",
                                                                "aircraft",
                                                                "aircraftType",
                                                                "delays",
                                                                "delays.delay",
                                                                "flightNumber.departureAirport",
                                                                "flightNumber.arrivalAirport",
                                                                "flightNumber.flightType",
                                                            ], FALSE, FALSE, FALSE, TRUE);

        // Load Maintenance
        $aircraftMaintenance = Maintenance::maintenanceRange($startDate, $endDate);

        // Get JSON Ready
        $json = self::getJsonDataForFleetWatchTimeline($flights, $aircraftMaintenance);

        $this->data = [
            "json"                => json_encode($json),
            "supCrew"             => $supCrew->listModelVariable(['type', 'id'], true),
            "aircraftMaintenance" => Maintenance::maintenanceRange($startDate, $endDate),
            "flights"             => Flight::flightsRange($startDate, $endDate),
            "flightTypes"         => ["" => "Select"] + FlightType::pluck('type', 'id')->all(),
            "airports"            => $airport->findAndListModelVariable(['iata' => [WHERE_NOT_NULL], 'country_id' => [WHERE_IN, [1062,1063, 1425, 1082,1037,1084,1040,1007,1006,1003,1077]]],[['iata', 'name'], 'id', '-'], true),
            "diversionAirports"   => $airport->findAndListModelVariable(['iata' => [WHERE_NOT_NULL], 'diversion_airport' => true], [['iata', 'name'], 'id', '-'], true),
            "aircraft"            => ["" => "Select Aircraft"] + Aircraft::pluck("name", "id")->all(),
            "flightsSelectBox"    => ["" => "Select Flight"] + FlightNumber::getArrayFlightNumbersWithSector(),
            "delays"              => ["" => "Select"] + Delay::pluck("code", "id")->all(),
            "captains"            => ["" => "Select Captain"] + User::getFlightCrew(FCM_CP_CREW),
            "firstOfficers"       => ["" => "Select First Officer"] +User::getFlightCrew(FCM_FO_CREW),
            "cabinCrew"           => ["" => "Select Flight Attendant"] + User::getFlightCrew(CCM_CREW),
            "reasons"             => ['' => "Select", 'head_order' => 'Head Order', 'roster_not_received' => 'Roster Not Received', 'sick' => 'Sick', 'no_show' => 'No Show']
        ];

       return view("fleetwatch/index-new", $this->data);
    }

    /**
     * @param null $from
     * @param null $to
     * @return \Illuminate\Http\JsonResponse
     */
    public static function ajaxGetRange($from = null, $to = null)
    {
        $startDate = ($from && $to) ? date("Y-m-d", strtotime("-1 days", strtotime($from))) : date("Y-m-d", strtotime("-1 days", strtotime(\request("start_date"))));
        $endDate = ($from && $to) ? date("Y-m-d", strtotime("+1 days", strtotime($to))) : date("Y-m-d", strtotime("+1 days", strtotime(\request("end_date"))));

      // Load Flights
//        $flights = Flight::flightsRange($startDate, $endDate);
        $flights = Flight::flightsRange($startDate, $endDate, [], FALSE, FALSE, FALSE, TRUE);

        // Load Maintenance
        $aircraftMaintenance = Maintenance::maintenanceRange($startDate, $endDate);

        // Fleetwatch Ready Json
        $jsonData = self::getJsonDataForFleetWatchTimeline($flights, $aircraftMaintenance);

        return response()->json([
            "jsonData"            => $jsonData,
            "aircraftMaintenance" => $aircraftMaintenance,
            "flights"             => $flights,
            "success"             => TRUE
        ]);
    }


    public function ajaxGetCrewInfo(){
        $userId = \request("id");
        $crewType = \request("crew_type");
        $date = date("Y-m-d");

        debug(request()->all());

        if ($userId && $crewType){

            $user = User::getCrew($crewType, false, $userId);

            if ($user){
                $periodPlanned = "planned";
                // Counter Types for Info Page
                $counterTypes = ['yearToDate', 'last365days', 'last28days', 'last7days', 'planned'];

                // Get Crew Hours & DHC - Standby Counters
                $crewHours = CrewController::getCrewHoursFlightHistoryDHCStandby($user, $date, $counterTypes, 'yearToDate', 'yearToDate', $userId);

                // Get Planned Counter Type
                $periodPlanned = getCrewHoursCounterTypesArray($date, $periodPlanned);

                // Get Planned Period From And To
                $periodPlanned = getFromToOutOfCounterTypeArray($periodPlanned);

                // Get Crew Planned Roster Details
                $userFlightsPlanned = Flight::getUserRoster($userId, $periodPlanned);

                $flightsTable = $this->getFlightsTable($userFlightsPlanned);

                return response()->json([
                    "success"       => true,
                    "user"          => $user,
                    "hours"         => $crewHours[$userId],
                    "flights"       => $userFlightsPlanned,
                    "flightsTable"  => $flightsTable,
                ]);
            }

        }

        return response()->json([
            "success"       => false,
            "message"       => "User Not Found!"
        ]);
    }


    public static function getFlightsTable($flights){
        $html = "";
        if (count($flights) == 0){
            return $html;
        }

        foreach ($flights as $i => $flight){
            if ($flight->is_standby){
                $class = '<span class="label label-danger">Standby</span>';
            }
            else if ($flight->is_dhc){
                $class = '<span class="label label-success">DHC</span>';
            }
            else {
                $class = "Position ".($flight->position_order + 1);
            }

            $html .= '<tr>'.
                '<td>' .  ++$i.'</td>' .
                '<td>' .  $class . '</td>' .
                '<td nowrap><a href="'. url("/flight/details?id={$flight->id}") .'">' .  ProjectConstant::getConstants(IATA_CODE).'-'.$flight->flight_number .'</a></td>' .
                '<td nowrap>'. $flight->departure_airport . "-" . $flight->arrival_airport .'</td>';

                if ($flight->atd && $flight->atd != EMPTY_DATETIME && $flight->ata && $flight->ata != EMPTY_DATETIME){
                    $html .= '<td>' . '<span class="label label-primary small-info"> ATD</span>'. dmy_format($flight->atd, 'time') .'</td>' .
                             '<td>' . '<span class="label label-danger small-info"> ATA</span>'. dmy_format($flight->ata, 'time') .'</td>';
                }
                else {
                    $html .= '<td>' . '<span class="label label-warning small-info"> STD</span>'. dmy_format($flight->std, 'time') .'</td>' .
                             '<td>' . '<span class="label label-warning small-info"> STA</span>'. dmy_format($flight->sta, 'time') .'</td>';
                }

            $html .= '</tr>';
        }

        return $html;
    }

    /**
     * @param $flights
     * @param $aircraftMaintenance
     * @return array
     * @throws \Exception
     */
    public static function getJsonDataForFleetWatchTimeline($flights, $aircraftMaintenance){
        $json = [];
        $processedFlights = [];

        $gha = ghaModule();
        foreach ($flights as $flightItem)
        {
            if (in_array($flightItem->id, $processedFlights)){
                continue;
            }

            $processedFlights[] = $flightItem->id;

            $flightNumber = $flightItem->flightNumber;
            $airlineID = $gha && $flightNumber->airline_id;

            $aircraftItem = $flightItem->aircraft;
            $aircraftType = $flightItem->aircraftType;
            $departureDate = new DateTime(getFlightDepartureDate($flightItem));
            $arrivalDate = new DateTime(getFlightArrivalDate($flightItem));
            $duration = $arrivalDate->diff($departureDate);
            $durationMinutes = $duration->h * 60 + $duration->i;

            $flt = [
                "start_date" => [
                    $departureDate->format("Y"),
                    (int)$departureDate->format("n") - 1,
                    $departureDate->format("j"),
                    $departureDate->format("G"),
                    (int)$departureDate->format("i"),
                    (int)$departureDate->format("s")
                ],
                "end_date" => [
                    $arrivalDate->format("Y"),
                    (int)$arrivalDate->format("n") - 1,
                    $arrivalDate->format("j"),
                    $arrivalDate->format("G"),
                    (int)$arrivalDate->format("i"),
                    (int)$arrivalDate->format("s")
                ],

                "group"     => $flightItem->deleted_at ? "Deleted" : ($flightItem->cancelled_at ? "Cancelled" : ($aircraftType ? $aircraftType->icao : "")),
//                "group"     => $flightItem->deleted_at ? "Deleted" : ($flightItem->cancelled_at ? "Cancelled" : ($aircraftItem ? $aircraftItem->name : "")),
                "className" => getFlightClassName($flightItem, $airlineID)
            ];

            $depAirport = $flightNumber->departureAirport;
            $arrAirport = $flightNumber->arrivalAirport;

            $departureAirport = $depAirport ? $depAirport->iata : "";
            $arrivalAirport = $arrAirport ? $arrAirport->iata : "";

            if ($flightItem->is_diversion){
                $departureAirport = $flightItem->departureAirport ? $flightItem->departureAirport->iata : "";
                $arrivalAirport = $flightItem->arrivalAirport ? $flightItem->arrivalAirport->iata : "";

                /*$flt['content'] = "<div id='flight-" . $flightItem->id . "' class='row fw-flight-item diversion'>".
                    "<div class='flight_number_diversion_box_left diversionBox'>".
                        "<span class='flight_number_diversion_box_left'>". $flightNumber->departure_airport ."</span>".
                        "<span class='flight_number_diversion_box_center'><i class=\"ionicons ion-plane icon-90\"></i></span>".
                        "<span class='flight_number_diversion_box_right'>". $divertedAirport ."</span>".
                    "</div>".
                    "<div class='flight_number_diversion_box_center flightStandard'>".
                        "<span class='text-center'>".CURRENT_IATA_CODE." ". $flightNumber->flight_number ."</span>".
                    "</div>".
                    "<div class='flight_number_diversion_box_right diversionBox'>".
                        "<span class='flight_number_diversion_box_left'>". $divertedAirport ."</span>".
                        "<span class='flight_number_diversion_box_center'><i class=\"ionicons ion-plane icon-90\"></i></span>".
                        "<span class='flight_number_diversion_box_right'>". $flightNumber->arrival_airport ."</span>".
                    "</div>".
                    "</div>";*/
            }

//            else {
                if ($durationMinutes < 90){
                    $flt['content'] = "<div id='flight-" . $flightItem->id . "' class='row fw-flight-item'>".
                        "<div class='col-sm-12 flightStandard'>".
                            "<span class='flight_number_box_small'>" . $flightNumber->flight_number ."</span>".
                        "</div>".
                        "</div>";
                }
                else{

                    if ($flightNumber->flightType && in_array($flightNumber->flightType->type,[ TAJIKAIR, OTHERAIRLINES ])){
                        $fNo = $flightNumber->flight_number;
                    }
                    else {
                        $fNo = ProjectConstant::getConstants(IATA_CODE)." ".$flightNumber->flight_number;
                    }

                    $flt['content'] = "<div id='flight-" . $flightItem->id . "' class='row fw-flight-item'>".
                        "<div class='col-sm-12 flightStandard'>".
                        "<span class='flight_number_box_left'>". $departureAirport ."</span>".
                        "<span class='flight_number_box_center'>".$fNo."</span>".
                        "<span class='flight_number_box_right'>". $arrivalAirport ."</span>".
                        "</div>".
                        "</div>";
                }
//            }

            $json[] = $flt;

        }

        foreach ($aircraftMaintenance as $itemMaintenance) {
            $aircraftItem = $itemMaintenance->aircraft()->first();
            $startDate = new DateTime($itemMaintenance->arrival_time);
            $endDate = new DateTime($itemMaintenance->departure_time);
            $json[] = [
                "start_date" => [
                    $startDate->format("Y"),
                    (int)$startDate->format("n") - 1,
                    $startDate->format("j"),
                    $startDate->format("G"),
                    (int)$startDate->format("i"),
                    (int)$startDate->format("s")
                ],
                "end_date" => [
                    $endDate->format("Y"),
                    (int)$endDate->format("n") - 1,
                    $endDate->format("j"),
                    $endDate->format("G"),
                    (int)$endDate->format("i"),
                    (int)$endDate->format("s")
                ],
                "content" => "<div id='maintenance-{$itemMaintenance->id}' class='fw-flight-item'>$itemMaintenance->note ($itemMaintenance->location_code)</div>",
                "group" => $aircraftItem->name,
                "className" => "maintenance"
            ];
        }

        return $json;
    }
}
