<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: aviation.dev
 */

use App\Models\Aircraft;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

use App\Models\AircraftPart;
use App\Models\AircraftCertificate;
use App\Models\AircraftCertificateHistory;
use App\Models\AircraftHistory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Validator;

class FleetManagementController extends Controller
{
    protected $aircraftParameters = [

        "max_take_off"  => "Max Take-Off",
        "max_ramp"      => "Max Ramp",
        "max_landing"   => "Max Landing",
        "max_zero_fuel" => "Max Zero Fuel",
        "max_payload"   => "Max Payload",

        "usable_fuel"   => "Usable Fuel",
        "total_fuel"    => "Total Fuel",

        "basic_weight" => "Basic Weight",
        "basic_index"  => "Basic Index",
        "mzfw"         => "MZFW",
        "mtow"         => "MTOW",
        "mldw"         => "MLDW"
    ];

    /**
     * Show list of available aircraft
     * @return \Illuminate\View\View
     */
    public function index()
    {
        // Redirect If Not Found
        if (!Auth::user() || Auth::user() == '' || !userAnyAdmin()) {
            return redirect()->to('error/page-not-found');
        }

        $this->viewData = [
            "aircraft"  => Aircraft::with("type")
                                    ->whereNull("deleted_at")
                                    ->get()
        ];

        return view("fleet-management/list", $this->viewData);
    }

    public function certificates(){

        // Redirect If Not Found
        $aircraftId = \request("aircraft_id");
        $certificateId = \request("certificate_id");
        $aircraft = Aircraft::find($aircraftId);
        $certificate = AircraftCertificate::find($certificateId);
        $filename = $certificateId.".pdf";

        $url = storage_path("app/public/aircraft/$aircraftId/certificates/$filename");
        //$url = route("homepage")."#". url('/')."/assets/img/SomonAir_logo.png";

        $pageUrl = URL::full();

        if ($this->isPostRequest()){
            if (\request("certificateDelete")){
                if (File::exists($url))
                    File::delete($url);

                return redirect()->to($pageUrl)
                    ->withInput()
                    ->with("message", "Certificate Successfully Deleted");
            }
            else {
                if (\request("certificateUpload")) {
                    $mimeType = \request()->file('certificateFile')->getClientMimeType();
                    $rules = ['file' => 'required|mimes:application/pdf'];
//                    , pdf, image/jpeg, image/jpg, image/png, image/gif'];
                    $file = ['file' => \request()->file('certificateFile')];
                    $validator = Validator::make($file, $rules);

                    if (!$validator){ //$mimeType !== 'application/pdf') {
                        return redirect()->to($pageUrl)
                            ->withInput()
                            ->withErrors(['File has to be in PDF format']);
//                            ->withErrors(['File has to be in *.pdf/jpg/jpeg/gif/png formats']);
                    }
                    else {
                        debug($file['file']->getRealPath());

                        $fileName = $certificateId . '.' . $file['file']->getClientOriginalExtension();
                        $storagePath = storage_path("app/public/aircraft/$aircraftId/certificates/");

                        // Picture Save
                        $file['file']->move($storagePath, $fileName);

                        return redirect()->to($pageUrl)
                            ->withInput()
                            ->with("message", "Certificate Successfully Uploaded");
                    }
                }
                else {
                    return redirect()->to($pageUrl)
                        ->withInput()
                        ->withErrors(['Error! Please Try Again.']);
                }
            }
        }


        if (File::exists($url)) {
            debug($url);
            $mimeType = getMimeType($filename);
            $certificateExists = true;
            $fileContents = File::get($url);
            if (\request("view"))
                return response()->make($fileContents, 200,array('Content-Type' => $mimeType));
            elseif (\request("download"))
                return response()->download($url, $filename, array('Content-Type' => $mimeType));
        }

        return view('fleet-management.certificates', [
            'aircraft'          => $aircraft,
            'certificate'       => $certificate,
            'certificateUrl'    => $url,
            'certificateExists' => isset($certificateExists) ? $certificateExists : false
        ]);

        /*$fileClientName = $certificate->certificate_name.'.pdf';
        if (File::exists($url))
            return Response::make(File::get($url),200, ["Content-Type" => "application/pdf"]);
        else
            return view('fleet-management.certificates', [
                'certificateUrl'   => $url
            ]);*/

    }

    /**
     * Get aircraft details page
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function details()
    {
        // Redirect If Not Found
        if (!Auth::user() || Auth::user() == '' || !userAnyAdmin()) {
            return redirect()->to('error/page-not-found');
        }

        $aircraftId = \request("id");
        $aircraft   = Aircraft::with("type")
                            ->find($aircraftId);

        if (!$aircraft)
        {
            return redirect()->to("fleet-management/index")
                ->with("message", [
                    "text" => "Not found aircraft by given ID",
                    "type" => MESSAGE_WARNING
                ]);
        }

        $aircraftCurrentParameters   = [];
        $aircraftCurrentCertificates = [];
        $aircraftParts               = AircraftPart::where("aircraft_id", "=", $aircraftId)
            ->get();
        $certificates                = AircraftCertificate::orderBy("order")
            ->get();
        $aircraftCertificates        = AircraftCertificateHistory::where("aircraft_id", "=", $aircraftId)
            ->get();
        $aircraftHistory             = AircraftHistory::where("aircraft_id", $aircraftId)
            ->get();

        if ($aircraftParts->count())
        {
            $aircraftPartsTmp = [];
            foreach ($aircraftParts as $aircraftPart)
            {
                $aircraftPartsTmp[$aircraftPart->part_type][] = $aircraftPart;
            }
            $aircraftParts = $aircraftPartsTmp;
        }

        foreach ($certificates as $certificate)
        {
            $aircraftCurrentCertificates[$certificate->id] = AircraftCertificateHistory::where("aircraft_id", $aircraftId)
                ->where("aircraft_certificate_id", $certificate->id)
                ->orderBy("created_at", "DESC")
                ->limit(1)
                ->first();
        }

        // Eloquent Builder instance
        $subQuery = AircraftHistory::select(['parameter', 'value'])
            ->where('aircraft_id', $aircraftId)
            ->orderBy('created_at', 'DESC');

        $aircraftCurrentParametersDB = DB::table( DB::raw("({$subQuery->toSql()}) as subQuery") )
                                    ->mergeBindings($subQuery->getQuery()) // Get Underlying Query Builder
                                    ->groupBy('parameter')
                                    ->get();

            debug($aircraftCurrentParametersDB);



        foreach ($this->aircraftParameters as $key => $param)
        {
            $query = AircraftHistory::select(['parameter', 'value'])
                    ->where('aircraft_id', $aircraftId)
                    ->where("parameter", $key)
                    ->orderBy('created_at', 'DESC')
                    ->first();


            $aircraftCurrentParameters[$key] = "";
            if ($query)
            {
                $aircraftCurrentParameters[$key] = $query->value;
            }
        }

        return view("fleet-management/details", [
            "aircraft"                    => $aircraft,
            "certificates"                => $certificates,
            "certificatesHistory"         => $aircraftCertificates,
            "aircraftHistory"             => $aircraftHistory,
            "aircraftCurrentCertificates" => $aircraftCurrentCertificates,
            "aircraftCurrentParameters"   => $aircraftCurrentParameters,
            "aircraftParameters"          => $this->aircraftParameters,
            "aircraftParts"               => $aircraftParts
        ]);
    }



    /**
     * AJAX request to save aircraft parameter
     * @return \Illuminate\Http\JsonResponse
     */
    public function ajaxParameter()
    {
        $aircraftId = (int)\request("aircraft_id");
        $parameter  = \request("parameter");
        $value      = \request("value");

        if ($aircraftId && $parameter)
        {
            $aircraftHistoryItem              = new AircraftHistory();
            $aircraftHistoryItem->parameter   = $parameter;
            $aircraftHistoryItem->value       = $value;
            $aircraftHistoryItem->created_by  = Auth::id();
            $aircraftHistoryItem->aircraft_id = $aircraftId;
            $aircraftHistoryItem->save();

            return response()->json([
                "message" => "Aircraft parameter was successfully saved",
                "success" => 1,
                "title"   => "Success!"
            ]);
        }
        return response()->json([
            "message" => "Please check your data",
            "error"   => 1,
            "title"   => "Validation Errors:"
        ]);
    }

    /**
     * Ajax save aircraft certificate
     * @return \Illuminate\Http\JsonResponse
     */
    public function ajaxSaveCertificate()
    {
        $aircraftId    = (int)\request("aircraft_id");
        $from          = \request("from");
        $to            = \request("to");
        $certificateId = (int)\request("certificate_id");
        if ($aircraftId && $certificateId && $from)
        {
            $aircraftCertificate                 = new AircraftCertificateHistory();
            $aircraftCertificate->aircraft_id    = $aircraftId;
            $aircraftCertificate->valid_from     = $from;
            $aircraftCertificate->valid_to       = $to ? $to : null;
            $aircraftCertificate->aircraft_certificate_id = $certificateId;
            $aircraftCertificate->created_by     = Auth::id();
            $aircraftCertificate->save();
            return response()->json([
                "success" => 1,
                "message" => "Certificate was successfully added",
                "title"   => "Success!"
            ]);
        }
        return response()->json([
            "message" => "Please check your data",
            "error"   => 1,
            "title"   => "Validation Errors:"
        ]);
    }

    /**
     * Get AJAX certificates for the aircraft
     * @return \Illuminate\Http\JsonResponse
     */
    public function ajaxCertificateHistory()
    {
        $aircraftId    = (int)\request("aircraft_id");
        $certificateId = (int)\request("certificate_id");
        if ($aircraftId && $certificateId)
        {
            $certificateHistory = AircraftCertificateHistory::join("aircraft__certificates", "aircraft__certificates.id",
                "=", "aircraft__certificates_history.aircraft_certificate_id")
                ->where("aircraft_id", "=", $aircraftId)
                ->where("aircraft_certificate_id", "=", $certificateId)
                ->orderBy("valid_to", "asc")
                ->get();

            return response()->json([
                "history" => $certificateHistory,
                "success" => 1,
                "message" => "History was successfully loaded",
                "title"   => "Success!"
            ]);
        }
        return response()->json([
            "error"   => 1,
            "message" => "Please check your data",
            "title"   => "Validation Errors:"
        ]);
    }


}
