<?php namespace App\Http\Controllers;
use App\Classes\Parsing\Helpers\ParseHelper;
use App\Classes\Parsing\ParseOperations;
use App\Classes\Parsing\ParsePSM;
use App\Classes\Parsing\UpdateMessageTypes;
use App\Classes\Sirena\XML\SirenaXML;
use App\Models\Aircraft;
use App\Models\AircraftType;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\Country;
use App\Models\CPMMessage;
use App\Models\CrewAircraftType;
use App\Models\CrewListMessage;
use App\Models\Department;
use App\Models\Flight;
use App\Models\FlightCom;
use App\Models\FlightCrew;
use App\Models\FlightMessage;
use App\Models\FlightMessage2018;
use App\Models\FlightNumber;
use App\Models\FlightRoute;
use App\Models\FlightSchedule;
use App\Models\FlightScheduleAirline;
use App\Models\FlightScheduleFlight;
use App\Models\FlightSector;
use App\Models\FlightStation;
use App\Models\FlightTracker;
use App\Models\ForwardBooking;
use App\Models\HBGMessage;
use App\Models\Language;
use App\Models\LDMmessage;
use App\Models\Location;
use App\Models\LPMMessage;
use App\Models\Message2018;
use App\Models\Module;
use App\Models\ModulePermission;
use App\Models\MVTMessage;
use App\Models\OtherMessage;
use App\Models\Passenger;
use App\Models\PassengerFlight;
use App\Models\PassengerFlightAct;
use App\Models\PassengerOrder;
use App\Models\PNLMessage;
use App\Models\Position;
use App\Models\PRLMessage;
use App\Models\PSMMessage;
use App\Models\PTMMessage;
use App\Models\ResultMessage;
use App\Models\SLSMessage;
use App\Models\StandbyCrew;
use App\Models\SubDepartment;
use App\Models\TPMMessage;
use App\Models\UCMMessage;
use App\Models\User;
use App\Models\UserDepartment;
use App\Models\UserLanguage;
use App\Models\UserModule;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;

use Intervention\Image\Image;
use PhpSpec\Exception\Exception;
use Symfony\Component\Routing\Loader\XmlFileLoader;

ini_set('max_execution_time', 100000);
ini_set('memory_limit', '8000M');

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 19.08.14

 *
**/
class FixController extends Controller
{
    public function ckinNum(){
        $flightComs = FlightCom::
            with("flight")
            ->whereNotNull("ckin_num")
            ->get();


        foreach ($flightComs as $each){
            $each->flight->ckin_num = $each->ckin_num;
            $each->flight->save();
        }

        return 1;
    }

    public function resizeLogos(){
        $airlines = Airline::whereNotNull("picture")->get();

        $path = "assets/img/airlines/";
        foreach ($airlines as &$airline) {

            if ($airline->picture && \Illuminate\Support\Facades\File::exists("{$path}/{$airline->picture}")) {

                $ext = strtolower(substr(strrchr($airline->picture, "."), 1));
//            $ext = $fileImage->getClientOriginalExtension();
                if (!$ext) {
                    $ext = "png";
                }

//                $fileImage = new \Illuminate\Support\Facades\File("{$path}/{$airline->picture}");
//              $fileImage = \Illuminate\Support\Facades\File::get("{$path}/{$airline->picture}");
//                $fileImage = getAirlineLogoWithSize($airline); // \Intervention\Image\Facades\Image::make("assets/img/airlines/{$airline->picture}");
                $fileImage = getFileObject("{$path}/{$airline->picture}");
                $airline->thumb = movePicture($fileImage, public_path($path), $airline->id . '_thumb.' . strtolower($ext), 256);
                $airline->save();
            }
        }
    }

    public function deleteMessages(Request $request){
        if (!Auth::user() || !in_array(Auth::user()->id, [44])) {
            return "Unauthorized";
        }

        $from = $request->get("from") ? $request->get("from") : "2018-01-01"; // "2018-02-20 00:00:00";
        $to   = $request->get("to")   ? $request->get("to")   : "2019-01-01"; //"2018-03-01 00:00:00";

        CPMMessage::whereBetween("created_at", [$from, $to])->delete();
        LDMmessage::whereBetween("created_at", [$from, $to])->delete();
        LPMMessage::whereBetween("created_at", [$from, $to])->delete();
        MVTMessage::whereBetween("created_at", [$from, $to])->delete();
        OtherMessage::whereBetween("created_at", [$from, $to])->delete();
        PNLMessage::whereBetween("created_at", [$from, $to])->delete();
        PRLMessage::whereBetween("created_at", [$from, $to])->delete();
        PSMMessage::whereBetween("created_at", [$from, $to])->delete();
        PTMMessage::whereBetween("created_at", [$from, $to])->delete();
        SLSMessage::whereBetween("created_at", [$from, $to])->delete();
        TPMMessage::whereBetween("created_at", [$from, $to])->delete();
        UCMMessage::whereBetween("created_at", [$from, $to])->delete();

        return "DONE";
    }

    public function updateTypes(){
        $update = new UpdateMessageTypes();
        $update->init();

        return "DONE";
    }

    public function backupMessages(Request $request){
        if (!Auth::user() || !in_array(Auth::user()->id, [44])) {
            return "Unauthorized";
        }

        $from = $request->get("from") ? $request->get("from") : "2018-01-01"; // "2018-02-20 00:00:00";
        $to   = $request->get("to")   ? $request->get("to")   : "2019-01-01"; //"2018-03-01 00:00:00";

       // MVT, CPM, CREW LIST, HBG, LDM, LPM, PSM, PTM, SLS, TPM, UCM
       // CPM LDM MVT OTH PNL PSM
       $messages = CPMMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(CPM))->toArray();
       $this->insert($messages);

       $messages = LDMmessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(LDM))->toArray();
       $this->insert($messages);

       $messages = LPMMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
            ->get($this->getFields(LPM))->toArray();
       $this->insert($messages);


       $messages1 = MVTMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(MVT))->toArray();
       $this->insert($messages1);

       $messages2 = OtherMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(OTHS))->toArray();
       $this->insert($messages2);

       $messages3 = PNLMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(PNL))->toArray();
       $this->insert($messages3);

       $messages4 = PRLMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(PRL))->toArray();
       $this->insert($messages4);

       $messages5 = PSMMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(PSM))->toArray();
       $this->insert($messages5);

       $messages6 = PTMMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(PTM))->toArray();
       $this->insert($messages6);

       $messages7 = SLSMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(SLS))->toArray();
       $this->insert($messages7);

       $messages8 = TPMMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(TPM))->toArray();
       $this->insert($messages8);

       $messages9 = UCMMessage::whereBetween("created_at", [$from, $to])->orderBy("created_at")
                           ->get($this->getFields(UCM))->toArray();
       $this->insert($messages9);

        Message2018::whereNull('message')->update(["message" => UCM]);

        return "DONE";
    }

    function insert($messages){
        $limit = 300;
        $length = count($messages);
        for($i = 0; $i < $length; $i += $limit){
            //$arr = $messages[$i] array_slice($messages, $i, $limit);
            $arr = [];
            for($j = $i; $j < $i + $limit; $j++ ){
                if ($j + 1 > $length){
                    break;
                }
                $arr[] = $messages[$j];
            }

            if (count($arr)){
                 Message2018::insert($arr);
            }
        }
    }

    public function backupMessages2(Request $request)
    {
        if (!Auth::user() || !in_array(Auth::user()->id, [44])) {
            return "Unauthorized";
        }

        $from = $request->get("from") ? $request->get("from") : "2019-01-01"; // "2018-02-20 00:00:00";
        $to   = $request->get("to")   ? $request->get("to")   : "2020-01-01"; //"2018-03-01 00:00:00";

        // MVT, CPM, CREW LIST, HBG, LDM, LPM, PSM, PTM, SLS, TPM, UCM
        $messages = FlightMessage::whereBetween("created_at", [$from, $to])
                            ->orderBy("created_at")
                            ->get([
                                "flight_id",
                                "message_type",
                                "message_id",
                                "received_datetime",
                                "created_at",
                                "updated_at",
                            ])
                            ->toArray();

        $limit = 300;
        $length = count($messages);
        for($i = 0; $i < $length; $i += $limit){
            //$arr = $messages[$i] array_slice($messages, $i, $limit);
            $arr = [];
            for($j = $i; $j < $i + $limit; $j++ ){
                if ($j + 1 > $length){
                    break;
                }
                $arr[] = $messages[$j];
            }

            if (count($arr)){
                FlightMessage2018::insert($arr);
                // Message2018::insert($arr);
            }
        }

        // Message2018::whereNull('message')->update(["message" => UCM]);

        return "DONE";
    }

    function getFields($type){
        $general = [
            "id AS actual_id",
//            "status",
//            "important",
//            "seen",
            "parsed",
            "email_id",
            "message_id",
            "udate",
            "flight_id",
            "flight_number_id",
            "received_datetime",
            "from_email",
            "to_email",
            "email_body",
            "email_title",
            "data",
            "log",
            "created_at",
//            "updated_at",
//            "created_by",
//            "updated_by",
//            "deleted_at",
        ];

        $fields = [];
        switch($type){
            case MVT:
                $fields = [
                    "type",
                    "skipped",
//                    "diversion",
                ];
                break;

            case PNL:
                $fields = [
                    "type",
                    "airline_id",
                    "part",
                    "pax_c",
                    "pax_y",
                    "pax_inf",
                ];
                break;

            case PRL:
                $fields = [
                    "part",
                    "airline_id",
                    "pax_c",
                    "pax_y",
                    "pax_inf",
                    "baggage_pcs",
                    "baggage_wt",
                ];
                break;

            case SLS:
            case HBG:
            case CREW_LIST:
                $fields = [
                    "airline_id",
                    "part",
                ];
                break;

            case OTHERS:
                $fields = [
                    "type",
                ];
                break;
        }

        if (count($fields)){
            return array_merge($general, $fields);
        }

        return $general;
    }

    protected function generateRandomPassword($length = 10){
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $randomString;
    }

    public function getAircraftType(){
//        $aircraftType = new AircraftType();
//        $aircraftType->iata_name = $acType;
//        $aircraftType->airline_id = $airline_id;


        return "inactive";

        $acTypes = AircraftType::whereNotNull("airline_id")
                                ->get();

        $typesArray = [];
        foreach ($acTypes as $each) {
            if (!isset($typesArray[$each->airline_id])){
                $typesArray[$each->airline_id] = [];
            }

            if (!array_key_exists($each->iata_name, $typesArray[$each->airline_id])){
                $typesArray[$each->airline_id][$each->iata_name] = $each->id;
            }
            else {
                debug("ac err / iata: ".$each->iata_name." / ". $each->airline_id);
            }
        }

        debug($typesArray);


        $flights = Flight::join("aircraft__types", "aircraft__types.id", "=", "flights.aircraft_type_id")
            ->join("flights__numbers", "flights__numbers.id", "=", "flights.flight_number_id")
            ->whereNotNull("flights.aircraft_type_id")
            ->where("flights.aircraft_type_id", "<=", 366)

//            ->whereNotNull("flights.deleted_at")
            ->whereNull("flights.deleted_at")

            ->get([
                "flights.id",
                "flights.aircraft_type_id",
                "flights__numbers.airline_id",
                "aircraft__types.iata_name",
                "aircraft__types.icao",
            ]);

        debug(count($flights));

        foreach ($flights as $i => &$each) {
            $airlineID = $each->airline_id;
            $iata = $each->iata_name;

            if (array_key_exists($airlineID, $typesArray) && array_key_exists($iata, $typesArray[$airlineID])){
                $each->aircraft_type_id = $typesArray[$airlineID][$iata];
                $each->save();
            }
            else {
                debug("err flt ID:". $each->id. " / airline_ID: " .$airlineID. " / iata: ".$iata);
            }
        }

        return 1;


        $flightsScheduleFlights = FlightScheduleFlight::join("aircraft__types", "aircraft__types.id", "=", "flights__schedule_flights.aircraft_type_id")
            ->whereNotNull("flights__schedule_flights.aircraft_type_id")
            ->where("flights__schedule_flights.aircraft_type_id", "<=", 366)

//            ->whereNotNull("flights__schedule_flights.deleted_at")
            ->whereNull("flights__schedule_flights.deleted_at")

            ->get([
                "flights__schedule_flights.id",
                "flights__schedule_flights.aircraft_type_id",
                "flights__schedule_flights.airline_id",
                "aircraft__types.iata_name",
                "aircraft__types.icao",
            ]);

        foreach ($flightsScheduleFlights as $i => &$each) {
            $airlineID = $each->airline_id;
            $iata = $each->iata_name;

            if (array_key_exists($airlineID, $typesArray) && array_key_exists($iata, $typesArray[$airlineID])){
//                debug("success! OBJ ID: {$each->id} / AIRLINE ID: ".$airlineID. " / prev: ". $each->aircraft_type_id. " /curr: ".$typesArray[$airlineID][$iata]);
                $each->aircraft_type_id = $typesArray[$airlineID][$iata];
                $each->save();
            }
            else {
                debug("error --- OBJ ID: ". $each->id. " / airline_ID: " .$airlineID. " / iata: ".$iata);
            }
        }

        /*
        $aircraft = Aircraft::with("type")
                    ->whereNotNull("airline_id")
                    ->whereNotNull("aircraft_type_id")
                    ->whereNull("deleted_at")
                    ->get();

        debug($aircraft);

        $match = [];
        foreach ($aircraft as &$each) {
            $type = $each->type;
            $airlineID = $each->airline_id;

            if (!$type){
                continue;
            }

            if (array_key_exists($airlineID, $match) && array_key_exists($type->id, $match[$airlineID])){
                $each->aircraft_type_id = $match[$airlineID][$type->id];
                $each->save();

                continue;
            }

            $obj = new AircraftType();
            $obj->airline_id = $airlineID;

            $obj->name = $type->name;
            $obj->iata_name = $type->iata_name;
            $obj->icao = $type->icao;
            $obj->wide_board = $type->wide_board;
            $obj->config_a = $type->config_a;
            $obj->config_c = $type->config_c;
            $obj->config_y = $type->config_y;
            $obj->config_a_details = $type->config_a_details;
            $obj->config_c_details = $type->config_c_details;
            $obj->config_y_details = $type->config_y_details;
            $obj->wake_category = $type->wake_category;
            $obj->save();

            // AC
            $each->aircraft_type_id = $obj->id;
            $each->save();

            // Match
            $match[$airlineID][$type->id] = $obj->id;
        }
        */


        return "DONE";
    }

    public function getSirena(){

        $sirena = new SirenaXML();
        $sirena->run();

        return 1;
    }

    public function getModulesCategoryLang(){
        $modules = Module::all();

        foreach ($modules as &$each) {
            $each->category_lang = createLangString($each->category);
            $each->save();
        }


        return "DONE";
    }

    public function getTimezone(){
        getLocalDateTime("2018-02-16 10:00:00", "Asia/Dushanbe");
        return 1;
    }

    public function deleteFlightSchedule(Request $request, $flight_schedule){
        if (!Auth::user() || !in_array(Auth::user()->id, [42,44])){
            return [
                "success"   => false,
                "message"   => "Error! Unauthorized access!",
            ];
        }

        if (!$flight_schedule){
            return [
                "success"   => false,
                "message"   => "Error! Selected schedule not found!",
            ];
        }

        $tomorrow = $request->get("date") ? $request->get("date") : date("Y-m-d", strtotime(" + 1 days"));

        if (strtotime($tomorrow) <= strtotime(date("Y-m-d"))){
            return [
                "success"   => false,
                "message"   => "Error! Historic flights can not be deleted!",
            ];
        }

        Flight::where("flight_schedule_id", $flight_schedule->id)
                ->where("std", ">=", $tomorrow)
                ->delete();

        FlightScheduleFlight::where("flight_schedule_id", $flight_schedule->id)
                ->delete();

        FlightScheduleAirline::where("flight_schedule_id", $flight_schedule->id)
                ->delete();

        FlightSchedule::where("id", $flight_schedule->id)
                ->delete();

        return [
            "success"   => true,
            "message"   => "Success! Schedule successfully deleted"
        ];
    }

    public function getRemoveFlightsWithOneStation(){
        if (!Auth::user() || Auth::user()->id != 44){
            return;
        }

        ini_set("max_execution_time", 600);
        ini_set('memory_limit', '1024M');

        $flightNumbersIDs = FlightNumber::where(function($sql){
                $sql->whereNull("departure_airport_id")
                    ->orWhereNull("arrival_airport_id");
            })
            ->whereNull("deleted_at")
            ->get(["id"])
            ->pluck("id")
            ->all();

        $period48 = date("Y-m-d H:i:s", strtotime("- 2 days"));
        $period3Days = date("Y-m-d", strtotime("- 3 days"));

//        $handlingAPs = Airport::listHandlingStations("id");

        $flights = Flight::
//                        join("flights__numbers", "flights__numbers.id", "=", "flights.flight_number_id")
//                        ->where(function($sql) use ($handlingAPs){
//                            $sql->whereIn("flights__numbers.departure_airport_id", $handlingAPs)
//                                ->orWhereIn("flights__numbers.arrival_airport_id", $handlingAPs);
//                        })
                        whereIn("flight_number_id", $flightNumbersIDs)
                        ->whereNull("flights.deleted_at")
                        ->whereNull("flights.cancelled_at")
                        ->where(function($sql) use ($period48){
                            $sql->where("std", "<", $period48)
                                ->orWhere("ptd", "<", $period48)
                                ->orWhere("atd", "<", $period48);
                        })
                        ->get([
                            "flights.id", "std", "sta",  "ptd", "pta", "flights.deleted_at", "flight_number_id"
                        ]);


        debug($flightNumbersIDs);
        debug($flights);

        $now = date("Y-m-d H:i:s");
        $excludeFNs = [];
        foreach ($flights as $flight) {
            $otherFlts = Flight::where("flight_number_id", $flight->flight_number_id)
                ->whereNull("deleted_at")
//                ->whereNull("cancelled_at")
                ->where("departure_date", ">=", $period3Days)
//                ->where(function($sql) use ($period48){
//                    $sql->where("std", ">", $period48)
//                        ->orWhere("ptd", ">", $period48)
//                        ->orWhere("atd", ">", $period48);
//                })
                ->first(["id"]);

            $flight->deleted_at = $now;
            $flight->save();

            if ($otherFlts){
                $excludeFNs[] = $flight->flight_number_id;
            }
        }

        debug($excludeFNs);
        $otherFNs = array_diff($flightNumbersIDs, $excludeFNs);
        debug("Other FNs:");
        debug($otherFNs);

        FlightNumber::whereIn("id", $otherFNs)
                    ->update([
                        "deleted_at" => $now
                    ]);

        return 1;
    }

    public function getFlightNumber(Request $request){

        if (!Auth::user() || Auth::user()->id != 44){
            return;
        }

        ini_set("max_execution_time", 600);
        ini_set('memory_limit', '1024M');

        $result = FlightNumber::select([
                                    "flight_number", "airline_id", "departure_airport_id", "arrival_airport_id"
                                ])
                                ->whereNull("deleted_at")
                                ->groupBy([
                                    "flight_number", "airline_id", "departure_airport_id", "arrival_airport_id"
                                ])
                                ->having(DB::raw("COUNT(*)"), ">", 1)
                                ->get();

        debug($result);
        debug($result[0]);
        foreach ($result as $i => $item) {
            removeFlightNumberDuplications($item->flight_number, $item->airline_id, $item->departure_airport_id, $item->arrival_airport_id);
            if ($i > 10){
                break;
            }
        }
        return 1;

        $fn = $request->get("fn");
        $airline = $request->get("airline");
        $depAp = $request->get("dep") ? $request->get("dep") : null;
        $arrAp = $request->get("arr") ? $request->get("arr") : null;

        if  (!($fn && $airline && $depAp && $arrAp)){
            return "Include all fields";
        }


        // Delete other FNs

        return "DONE";
    }


    public function getFlightSectors(){

        if (!Auth::user() || Auth::user()->id != 44){
            return;
        }

        $fltNumbers = FlightNumber::join('airports as depAirport', 'depAirport.id', '=', 'flights__numbers.departure_airport_id')
            ->join('airports as arrAirport', 'arrAirport.id', '=', 'flights__numbers.arrival_airport_id')
            ->whereNotNull("departure_airport_id")
            ->whereNotNull("arrival_airport_id")
            ->whereNull("flights__numbers.deleted_at")
            ->orderBy("depAirport.handling_airport", "DESC")
            ->orderBy("arrAirport.handling_airport", "DESC")
            ->orderBy("depAirport.operated", "DESC")
            ->orderBy("arrAirport.operated", "DESC")
            ->orderBy("depAirport.iata")
            ->orderBy("arrAirport.iata")
            ->get([
                "flights__numbers.*"
            ]);

        foreach ($fltNumbers as &$each) {
            $sector = FlightSector::where("from_airport_id", $each->departure_airport_id)
                ->where("to_airport_id", $each->arrival_airport_id)
                ->first();

            if (!$sector){
                $sector = new FlightSector();
                $sector->from_airport_id = $each->departure_airport_id;
                $sector->to_airport_id = $each->arrival_airport_id;
                $sector->save();
            }

            $each->flight_sector_id = $sector->id;
            $each->save();
        }

        return "DONE";
    }

    public function getFlightRoutes(){

        if (!Auth::user() || Auth::user()->id != 44){
            return;
        }

        $fltNumbers = FlightNumber::join('airports as depAirport', 'depAirport.id', '=', 'flights__numbers.departure_airport_id')
            ->join('airports as arrAirport', 'arrAirport.id', '=', 'flights__numbers.arrival_airport_id')
            ->whereNotNull("departure_airport_id")
            ->whereNotNull("arrival_airport_id")
            ->whereNull("flights__numbers.deleted_at")
            ->orderBy("depAirport.handling_airport", "DESC")
            ->orderBy("arrAirport.handling_airport", "DESC")
            ->orderBy("depAirport.operated", "DESC")
            ->orderBy("arrAirport.operated", "DESC")
            ->orderBy("depAirport.iata")
            ->orderBy("arrAirport.iata")
            ->get([
                "flights__numbers.*"
            ]);

        foreach ($fltNumbers as &$each) {
            $sector = FlightRoute::where(function($sql) use ($each){
                $sql->where("from_airport_id", $each->departure_airport_id)
                    ->where("to_airport_id", $each->arrival_airport_id);
            })
                ->orWhere(function($sql) use ($each){
                    $sql->where("from_airport_id", $each->arrival_airport_id)
                        ->where("to_airport_id", $each->departure_airport_id);
                })
                ->first();

            if (!$sector){
                $sector = new FlightRoute();
                $sector->from_airport_id = $each->departure_airport_id;
                $sector->to_airport_id = $each->arrival_airport_id;
                $sector->save();
            }

            $each->flight_route_id = $sector->id;
            $each->save();
        }

        return "DONE";
    }

    public function getAircraft(){
        if (!Auth::user() || Auth::user()->id != 44){
            return;
        }

         $results = Aircraft::whereIn('mvt_name', function ( $query ) {
             $query->select('mvt_name')
                    ->from('aircraft')
                    ->whereNull("deleted_at")
                    ->groupBy('mvt_name')
                    ->havingRaw('count(*) > 1');
         })
             ->whereNull("deleted_at")
             ->orderBy("id")
             ->get();

        foreach ($results as $i => $each) {
            $others = Aircraft::where("mvt_name", $each->mvt_name)
                                ->where("id", "!=", $each->id)
                                ->where("airline_id", $each->airline_id)
                                ->whereNull("deleted_at")
                                ->get();

            if ($others->count()) {
                debug($each->mvt_name);
//                debug($others);
//              break;
                $otherIDs = $others->pluck("id");
                // FLIGHTS
                $result["flt"] = Flight::whereIn("aircraft_id", $otherIDs)
                    ->update([
                        "aircraft_id" => $each->id
                    ]);

                // FLIGHTS SCHEDULE FLIGHTS
                $result["fsf"] = FlightScheduleFlight::whereIn("aircraft_id", $otherIDs)
                    ->update([
                        "aircraft_id" => $each->id
                    ]);
                debug($result);

                // FLIGHTS TRACKER
                $result["ft"] = FlightTracker::whereIn("aircraft_id", $otherIDs)
                    ->update([
                        "aircraft_id" => $each->id
                    ]);
                debug($result);


                // DELETE OTHERS LIST
                Aircraft::whereIn("id", $otherIDs)
                        ->update([
                            "deleted_at" => date("Y-m-d H:i:s")
                        ]);
            }
        }


        return 1;

    }

    public function getFlightScheduleTimes(){

        $flights = Flight::with(['flightScheduleFlight'])
            ->whereNotNull("flight_schedule_flight_id")
            ->whereNull("deleted_at")
            ->whereNull("cancelled_at")
            ->where("std", ">=", date("Y-m-d", strtotime("- 1 days"))." 00:00:00")
            ->orderBy("std")
            ->get();


        foreach($flights as $i => $each){
            $scheduleFlight = $each->flightScheduleFlight;

            if (!$scheduleFlight){
                continue;
            }

            $date = date("Y-m-d", strtotime($each->std));

            if ($scheduleFlight->departure_time){
                $flights[$i]->std = $date ." ". $scheduleFlight->departure_time;
                $flights[$i]->ptd = $date ." ". $scheduleFlight->departure_time;
                $flights[$i]->departure_date = $date;
            }

            if ($scheduleFlight->arrival_time){
                if (strtotime($scheduleFlight->departure_time) > strtotime($scheduleFlight->arrival_time)){
                    $date = date("Y-m-d", strtotime("+ 1 days", strtotime($each->std)));
                }
                $flights[$i]->sta = $date ." ". $scheduleFlight->arrival_time;
                $flights[$i]->pta = $date ." ". $scheduleFlight->arrival_time;
                $flights[$i]->arrival_date = $date;
            }

            $flights[$i]->save();
        }

        return 1;

    }


    public function getFlightDuplications(){

        $flights = Flight::whereNull("deleted_at")
                            ->whereNull("cancelled_at")
//                            ->whereIn("flight_number_id", [1150, 1151])
                            ->where(DB::raw("DATE(std)"), ">", date("Y-m-d"))
                            ->orderBy("std")
                            ->get();


        $processedFlights = [];
        $duplicatedFlights = [];
        foreach($flights as $i => $each){
            $date = date("Y-m-d", strtotime($each->std));

            if (!isset($processedFlights[$each->flight_number_id])){
                $processedFlights[$each->flight_number_id] = [];
            }

            if (!isset($processedFlights[$each->flight_number_id][$date])){
                $processedFlights[$each->flight_number_id][$date] = [];
            }
            else {
                $flights[$i]->deleted_at = date("Y-m-d H:i:s");
                $flights[$i]->save();

                $duplicatedFlights[] = $each;
            }
        }

        debug($duplicatedFlights);

        return 1;
    }

    public function getDates(){

        if (env("DB_DATABASE") != "aviation_intranet"){
            return "WRONG DB";
        }

        if (\request("key") != "aviation$12$34123key"){
            return "WRONG KEY";
        }

        // Flights
        $updateFl = true;
        if ($updateFl) {
            $variables = [
                PTD => "datetime", STD => "datetime", ETD => "datetime", ATD => "datetime", ABN => "datetime",
                PTA => "datetime", STA => "datetime", ETA => "datetime", TDN => "datetime", ATA => "datetime",
            ];

            $data = Flight::where("updated_at", "<", "2017-10-23 00:00:00")
                            ->orWhereNull("updated_at")
                            ->get();

            $this->updateDates($data, $variables);
        }

        // Flights Forward Booking
        $updateFlFrBk = true;
        if ($updateFlFrBk) {
            $variables = [
                "updated_date" => "date",
                STD => "datetime"
            ];

            $data = ForwardBooking::where("updated_at", "<", "2017-10-23 00:00:00")
                                    ->orWhereNull("updated_at")
                                    ->get();

            $this->updateDates($data, $variables);
        }

        // Flights Schedule
        $updateFlSc = true;
        if ($updateFlSc) {
            $variables = [
                "date_from" => "date",
                "date_to"   => "date"
            ];

            $data = FlightSchedule::where("updated_at", "<", "2017-10-23 00:00:00")
                                ->orWhereNull("updated_at")
                                ->get();

            $this->updateDates($data, $variables);
        }

        // Flights Schedule Flights
        $updateFlScFl = true;
        if ($updateFlScFl) {
            $variables = [
                "std_time" => "datetime",
                "sta_time" => "datetime"
            ];

            $data = FlightScheduleFlight::where("updated_at", "<", "2017-10-23 00:00:00")
                                    ->orWhereNull("updated_at")
                                    ->get();

            $this->updateDates($data, $variables);
        }

        // Flights MVT Messages
        $updateFlMVT = true;
        if ($updateFlMVT) {
            $variables = [
                "received_datetime" => "datetime",
            ];

            $data = MVTMessage::where("updated_at", "<", "2017-10-23 00:00:00")
                            ->orWhereNull("updated_at")
                            ->get();

            $this->updateDates($data, $variables);
        }

        // Passenger Flights

        // Passenger Orders

        return 1;
    }

    public function getPassFlightsDates(){
        if (env("DB_DATABASE") != "aviation_intranet"){
            return "WRONG DB";
        }

        if (\request("key") != "aviation$12$34123key"){
            return "WRONG KEY";
        }

        $updatePsFl = true;
        if ($updatePsFl) {
            $variables = [
                "departure"         => "datetime",
                "departure_date"    => "date",
            ];

            //for ($i = 0; $i < 30; $i++ ) {
                $data = PassengerFlight::where("updated_at", "<", "2017-10-23 00:00:00")
                    ->orWhereNull("updated_at")
                    ->limit(50000)
                    ->get([
                        "id",
                        "departure",
                        "departure_date",
                        "updated_at",
                    ]);

                $this->updateDates($data, $variables);
            //}
        }
    }

    public function getPassOrdersDates(){
        if (env("DB_DATABASE") != "aviation_intranet"){
            return "WRONG DB";
        }

        if (\request("key") != "aviation$12$34123key"){
            return "WRONG KEY";
        }

        $updatePsOr = true;
        if ($updatePsOr) {
            $variables = [
                "sales_date"    => "date"
            ];

            for ($i = 0; $i < 30; $i++ ) {
                $data = PassengerOrder::where("updated_at", "<", "2017-10-23 00:00:00")
                    ->orWhereNull("updated_at")
                    ->limit(50000)
                    ->get([
                        "id",
                        "sales_date",
                        "updated_at",
                    ]);

                $this->updateDates($data, $variables);
            }
        }
    }

    protected function updateDates(&$data, $variables){
         // Settings
        $updatedDate = date("Y-m-d H:i:s");

        $emptyValue = [
            "date"      => "0000-00-00",
            "datetime"  => "0000-00-00 00:00:00",
        ];

        $format = [
            "date"      => "Y-m-d",
            "datetime"  => "Y-m-d H:i:s",
        ];

        foreach ($data as &$each) {
            foreach ($variables as $property => $type) {

                if ($each->{$property} && $each->{$property} != $emptyValue[$type]) {
                    $each->{$property} = date($format[$type], strtotime(" + 356 days", strtotime($each->{$property})));
                    $each->updated_at = $updatedDate;
                    $each->save();
                }
            }
        }
    }



    public function getTempPass(){

        $proceed = \request("proceed");

        if (!$proceed){
            return "NOT ALLOWED";
        }

        $users = User::where("activated", false)
            ->get();

        foreach ($users as $i => &$each) {
            $generatePassword = $this->generateRandomPassword();
            $each->password = Hash::make($generatePassword);
            $each->tmp_password = $generatePassword;
            $each->save();
        }

        return "DONE";

    }

    public function psm(){
        ini_set("max_execution_time", 600);
        ini_set('memory_limit', '1024M');

        $list = PSMMessage::with("flight")
            ->whereNotNull("flight_id")
//            ->where(function($sql){
//                $sql->whereNull("parsed")->orWhere("parsed", false);
//            })
            ->where(DB::raw("received_datetime"), ">=", "2022-01-01")
            ->whereNull("status")
            ->orderBy("received_datetime")
            ->limit(5000)
            ->get();

        $parseOperations = new ParseOperations();
        $parsePSM = new ParsePSM($parseOperations);

        foreach ($list as $psm) {
            if ($psm->flight->cancelled_at || $psm->flight->deleted_at){
                continue;
            }

            $parsePSM->parse($psm->flight, $psm->email_body, null, true);
            $psm->status = "Re-parsed";
            $psm->save();
        }

        return 1;
    }

    public function getFlightMessages(){

        $proceed = \request("proceed");

        if (!$proceed){
            return "NOT ALLOWED";
        }

        if ($proceed == 1) {
            $messages = [
                CPM => CPMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), ">=", "2017-01-01")->get(),
                LDM => LDMmessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), ">=", "2017-01-01")->get(),
                LPM => LPMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), ">=", "2017-01-01")->get(),
                MVT => MVTMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), ">=", "2017-01-01")->get(),
                PNL => PNLMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), ">=", "2017-01-01")->get(),
                PSM => PSMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), ">=", "2017-01-01")->get(),
                PTM => PTMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), ">=", "2017-01-01")->get(),
                TPM => TPMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), ">=", "2017-01-01")->get(),
                UCM => UCMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), ">=", "2017-01-01")->get(),
                OTHS => OtherMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), ">=", "2017-01-01")->get(),
            ];
        }
        else {
            $messages = [
                CPM => CPMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), "<", "2017-01-01")->get(),
                LDM => LDMmessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), "<", "2017-01-01")->get(),
                LPM => LPMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), "<", "2017-01-01")->get(),
                MVT => MVTMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), "<", "2017-01-01")->get(),
                PNL => PNLMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), "<", "2017-01-01")->get(),
                PSM => PSMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), "<", "2017-01-01")->get(),
                PTM => PTMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), "<", "2017-01-01")->get(),
                TPM => TPMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), "<", "2017-01-01")->get(),
                UCM => UCMMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), "<", "2017-01-01")->get(),
                OTHS => OtherMessage::whereNotNull("flight_id")->where("parsed", true)->where(DB::raw("received_datetime"), "<", "2017-01-01")->get(),
            ];
        }

        foreach ($messages as $type => $message) {
            $data = [];
            foreach ($message as $each) {

                $record = [
                    'flight_id'         => $each->flight_id,
                    'message_type'      => $type,
                    'message_id'        => $each->id,
                    'received_datetime' => $each->received_datetime,
                    'created_at'        => $each->created_at,
                    'created_by'        => $each->created_by,
                ];

                if($type == OTHS && in_array($each->type, [LDS, LOADSHEET, LOADSHEET_FINAL])){
                    $record["message_type"] = LDS;
                }

                $data[] = $record;
            }

            FlightMessage::insert($data);
        }

        return 1;
    }

    public function getFlightStations(){
        $flightStations = FlightStation::orderBy("flight_id")->get();

        $data = [];
        foreach ($flightStations as $each) {
            if (!isset($data[$each->flight_id])){
                $data[$each->flight_id] = 0;
            }

            $data[$each->flight_id] += $each->eic;
        }

        foreach ($data as $id => $eic) {
            Flight::find($id)
                    ->update(['eic' => $eic]);
        }

        return "DONE";
    }

    /**
     * Add lang strings
     */
    public function getLang(){
        $data = Department::all();
        $this->generateLangString($data);

        $data = Module::all();
        $this->generateLangString($data);

        $data = SubDepartment::all();
        $this->generateLangString($data);

    }

    public function getSetUsersModules(){
        $proceed = \request("proceed");

        if (!$proceed){
            return "NOT ALLOWED";
        }

        $modulePermissions = ModulePermission::get();

        $users = User::where("activated", true)->get();

        $usersArray = [];

        foreach ($users as $user) {

            foreach ($modulePermissions as $permission) {

                if (in_array($permission->id, [10, 22]) && $user->user_role_id != 4){
                    continue;
                }

                $usersArray[] = [
                    "user_id"               => $user->id,
                    "module_id"             => $permission->module_id,
                    "module_permission_id"  => $permission->id,
                ];
            }
        }

        UserModule::insert($usersArray);

        return "DONE";
    }

    public function getFlightNumbers(){
        $flightNumbers = FlightNumber::where("flight_number", "LIKE", "0%")
            ->whereNull("deleted_at")
            ->get();

        debug($flightNumbers);
        foreach($flightNumbers as $i => $each){
            $flightNumbers[$i]->flight_number  = ltrim($each->flight_number, "0");
            $flightNumbers[$i]->save();
        }

        return "DONE"; // $flightNumbers->toArray();
    }

    public function getFlights(){
        $flights = Flight::whereNull("deleted_at")
                            ->whereNull("cancelled_at")
                            ->where(DB::raw("DATE(std)"), "<=", "2017-04-06")
                            ->where(DB::raw("DATE(std)"), ">", "2017-03-25")
                            ->orderBy("std")
                            ->orderBy("flight_number_id")
                            ->orderBy("edited_by_email", "DESC")
                            ->orderBy("flight_schedule_id")
                            ->get();

        $result = [];
        $deleteIds = [];
        $deleteInfo = [];
        foreach ($flights as $each) {
            $date = date("Y-m-d", strtotime($each->std));
            if (!isset($result[$date])){
                $result[$date] = [];
            }
            if (!isset($result[$date][$each->flight_number_id])){
                $result[$date][$each->flight_number_id] = $each;
            }
            else {
                $deleteIds[] = $each->id;
//                $deleteInfo[] = $each->flightNumber->airline->iata."-".$each->flightNumber->flight_number." | ".$each->std;
            }
        }

        Flight::whereIn("id", $deleteIds)
                ->update([
                    'deleted_at'    => date("Y-m-d H:i:s", strtotime("-1 day")),
                    'updated_by'    => 44
                ]);

        debug($deleteIds);

        return "DONE";

    }

    public function getFlightNumbersDups(){
        $fnByAirline = FlightNumber::groupBy("airline_id")
            ->whereNull("deleted_at")
            ->get(["airline_id"]);

        $flightNumbers = FlightNumber::orderBy("id")
            ->whereNull("deleted_at")
            ->get();

        foreach($fnByAirline as $item){
            $prFN = [];

            $flightNumbersByAirline = $flightNumbers->where("airline_id", $item->airline_id)->all();

            foreach($flightNumbersByAirline as $i => $each){
                if (!isset($prFN[$each->flight_number])){
                    $prFN[$each->flight_number] = [
                        "id"            => $each->id,
                        "dep_airport"   => $each->departure_airport_id,
                        "arr_airport"   => $each->arrival_airport_id,
                    ];
                }
                else {
                    if ($prFN[$each->flight_number]['dep_airport'] == $each->departure_airport_id &&
                        $prFN[$each->flight_number]['arr_airport'] == $each->arrival_airport_id){


                        Flight::where("flight_number_id", $each->id)->update([
                            'flight_number_id'  => $prFN[$each->flight_number]["id"]
                        ]);

                        FlightScheduleFlight::where("flight_number_id", $each->id)->update([
                            'flight_number_id'  => $prFN[$each->flight_number]["id"]
                        ]);

                        $flightNumbersByAirline[$i]->delete();

                        debug("DUP");
                    }
                }
            }
            debug($prFN);
        }

        return "DONE"; // $flightNumbers->toArray();
    }


    public function getAircraftTypes(){
        $flights = Flight::whereNotNull('aircraft_id')
                        ->whereNotNull("aircraft_type_id")
                        ->whereNull("cancelled_at")
                        ->whereNull("deleted_at")
                        ->whereBetween(DB::raw("DATE(std)"), ["2017-01-01", "2017-03-30"])
                        ->orderBy("std", "DESC")
                        ->groupBy("aircraft_id")
                        ->get(["aircraft_id", "aircraft_type_id"]);

        $aircraftList = [];
        foreach ($flights as $each) {
            $aircraftList[$each->aircraft_id] = $each->aircraft_type_id;
        }

        $aircraft = Aircraft::whereIn("id", array_keys($aircraftList))
//                            ->whereNull("aircraft_type_id")
                            ->get();


        foreach ($aircraft as $i => $each) {
            $aircraft[$i]->aircraft_type_id =  $aircraftList[$each->id];
            $aircraft[$i]->save();
        }

        debug($aircraft);

        return 1;
    }

    public function getMessages(){
        $processedIds = $processedMsgIds = [];
        for ($i = 0; $i <= 10; $i ++) {
            $from = intval($i * 50000);
            $to = intval(($i + 1) * 50000);

            $messages = OtherMessage::where("id", ">", $from)
                ->where("id", "<=", $to)
                ->whereNotNull("message_id")
                ->get([
                    "id",
                    "message_id",
                ]);

            foreach ($messages as $each) {
                if (!in_array($each->message_id, $processedMsgIds)) {
                    $processedIds[] = $each->id;
                    $processedMsgIds[] = $each->message_id;
                }
            }


        }

        OtherMessage::whereNotNull("message_id")
            ->whereNotIn("id", $processedIds)
            ->delete();

        $messages = OtherMessage::whereNull("message_id")
            ->get([
                "id",
                "udate",
                "from_email",
            ]);

        $processedIds = $processedUDateFromEmails = [];

        foreach($messages as $each){
            if (!array_key_exists($each->udate, $processedUDateFromEmails)) {
                $processedIds[] = $each->id;
                $processedUDateFromEmails[$each->udate] = $each->from_email;
            }
            else {
                if ($processedUDateFromEmails[$each->udate] != $each->from_email)
                {
                    $processedIds[] = $each->id;
                }
            }
        }

        OtherMessage::whereNull("message_id")
            ->whereNotIn("id", $processedIds)
            ->delete();

        debug($processedIds);
        debug($processedUDateFromEmails);

        return 1;
    }

    public function getNames(){
        if ((env("DB_DATABASE") == "aviation_emirates" || env("DB_DATABASE") == "aviation_bis") &&
            env("IATA_CODE") == "ZZ" &&
            env("AIRLINE") == "Emirates"){

            $users = User::whereNotIn('id', [42, 44])
                        ->get();

            /*foreach ($users as $i => $user) {
                $users[$i]->first_name = $this->swapNames($user->first_name);
                $users[$i]->last_name = $this->swapNames($user->last_name);
                $users[$i]->save();
            }*/

//            return 1;

            $queryLimit = 10000; //10000;
            $tableRows = Passenger::count();

            for ($i = 0; $i <= $tableRows; $i = $i + $queryLimit) {
                $skip = $i;
                $passengers = Passenger::skip($skip)->take($queryLimit)->get();

                foreach ($passengers as $j => $passenger) {
                    $passengers[$j]->first_name = $this->swapNames($passenger->first_name);
                    $passengers[$j]->last_name = $this->swapNames($passenger->last_name);
                    $passengers[$j]->save();
                }
            }

            return 2;
        }

        return "NOT DONE";
    }

    public static function swapNames($name){
        $name = str_replace("A", "E", $name);
        $name = str_replace("a", "e", $name);

        $name = str_replace("O", "A", $name);
        $name = str_replace("o", "a", $name);

        $name = str_replace("I", "Y", $name);
        $name = str_replace("i", "y", $name);

        $name = str_replace("T", "M", $name);
        $name = str_replace("t", "m", $name);

        $name = str_replace("N", "D", $name);
        $name = str_replace("n", "d", $name);

        $name = str_replace("S", "L", $name);
        $name = str_replace("s", "l", $name);

        $name = str_replace("V", "W", $name);
        $name = str_replace("v", "w", $name);

        $name = str_replace("B", "T", $name);
        $name = str_replace("b", "t", $name);

        $name = str_replace("K", "S", $name);
        $name = str_replace("k", "s", $name);

        return $name;
    }

    public static function generateLangString(&$data){
        foreach ($data as $i => $each ) {
            $data[$i]->lang = createLangString($each->name);
            $data[$i]->save();
        }
    }

    public static function getRemoveCrewDuplicates(){
        $from = \request("from_d");
        $to = \request("to_d");

        if (!$from || !$to){
            return "404";
        }

        // Remove Standby Duplicates
        $crew = FlightCrew::join("flights", "flights.id", "=", "flights__crew.flight_id")
            ->whereBetween(DB::raw("DATE(std)"), [$from, $to])
            ->whereNull("flights.cancelled_at")->whereNull("flights.deleted_at")
            ->orderBy('flight_id')
            ->orderBy('user_id')
            ->orderBy('is_standby')
            ->orderBy('is_dhc')
            ->orderBy('position_order')
            ->get(['flights__crew.*']);

        $crewFlight = $deletedIds = [];
        foreach ($crew as $i => $each) {
            if (!isset($crewFlight[$each->flight_id][$each->user_id])){
                $crewFlight[$each->flight_id][$each->user_id] = 1;
                continue;
            }
            $deletedIds[] = $each->id;
        }

        if (count($deletedIds)) {
            FlightCrew::whereIn('id', $deletedIds)->delete();
        }

        return "DONE";
    }

    public function getStandbyCrew(){
        $ids = DB::table("standby_crew")->where("city_id", 10012)->pluck("id");
        $lbd_ids = DB::table("standby_crew")->where("city_id", 10080)->pluck("id");


        StandbyCrew::whereIn("id", $ids)
                        ->update(["airport_id" => 1]);

        StandbyCrew::whereIn("id", $lbd_ids)
            ->update(["airport_id" => 14]);

        return 1;
    }

    public function getRegExp(){
        $pattern = '/(1|2);([INF]*\d{13});(\d{1});(\w*);(\w*);(\w*);(C|Y|);(M|F|"FI"|);(INF|);(\d{2}-\d{2}-\d{2});\w{1,3};[\w|\d]*(?:;((\w*)\/(\w{2})(?:,{1})?)*;(((PLD)-(\w*))|((\d{1,3})\/(\d{1,3}));(\d*(?:,{1})?)*)(;(\w*)?);(\w*)?)?/';
        $string = '1;4132401955844;1;ABDURAHMANOV;BOBOSODIK;8E;Y;;;03-03-06;TJK;1456;SZN6TB/1H,5NKZ06/SZ;1/20;000017491;;E2';
        preg_match($pattern, $string, $result);

        debug($result);
        return 1;
    }

    public function getCrewAircraftTypes(){
        $crewType = ['crew__cabin', 'crew__flight'];

        foreach ($crewType as $eachType) {
            debug(1);
            $acTypes = AircraftType::pluck('id', 'name')->all();
            debug($acTypes);
            $insert = [];

            $crew = DB::table($eachType)
                ->get([
                    'user_id',
                    'aircraft_types_temp'
                ]);

            foreach ($crew as $each) {
                if ($each->aircraft_types_temp){
                    $ac = unserialize($each->aircraft_types_temp);
                    if (count($ac)){
                        foreach ($ac as $type) {
                            if ($type && $type != ""){
                                $insert[] = [
                                    'user_id'           => $each->user_id,
                                    'aircraft_type_id'  => $acTypes[$type]
                                ];
                            }
                        }
                    }
                }
            }
            CrewAircraftType::insert($insert);
        }

        return 1;
    }


    public function getUsersPhoneNumbers(){
        $users = User::all();


        foreach ($users as $i => $each) {

            if (!$each->phone)
                continue;

            $phones = @unserialize($each->phone);
            if ($phones !== false) {
                $phonesCorrected = [];
                foreach ($phones as $phone) {
                    if ($phone){
                        $phonesCorrected[] = $phone;
                    }
                }
                $phonesCorrected = array_unique($phonesCorrected);

                $phonesCorrected = implode(", ", $phonesCorrected);

                $users[$i]->phone = $phonesCorrected;
                $users[$i]->save();
            } else {
                debug($each->id. "//NOT OK");
            }
        }

        return 1;
    }

    public function getUsersLanguages(){
        $users = DB::table("users2")->get();

        foreach ($users as $i => $each) {

            if (!$each->languages)
                continue;

            $languages = @unserialize($each->languages);
            if ($languages !== false) {
                $languagesCorrected = [];
                foreach ($languages as $language) {
                    if ($language){
                        $languagesCorrected[] = $language;
                    }
                }
                $languagesCorrected = array_unique($languagesCorrected);
                foreach ($languagesCorrected as $language) {

                    if (!$language)
                        continue;

                    if (contains($language, "-")){
                        $partedLangs = explode('-', $language);
                        foreach ($partedLangs as $lang) {
                            if (!$lang)
                                continue;

                            $findL = Language::where('language', $lang)->first();

                            if (!$findL){
                                $newL = new Language();
                                $newL->language = ucfirst($lang);
                                $newL->save();

                                $languageId = $newL->id;
                            }
                            else{
                                $languageId = $findL->id;
                            }

                            UserLanguage::create([
                                'user_id'        => $each->id,
                                'language_id'    => $languageId,
                            ]);
                        }

                    }
                    else {
                        $findL = Language::where('language', $language)->first();

                        if (!$findL) {
                            $newL = new Language();
                            $newL->language = ucfirst($language);
                            $newL->save();

                            $languageId = $newL->id;
                        } else {
                            $languageId = $findL->id;
                        }

                        UserLanguage::create([
                            'user_id' => $each->id,
                            'language_id' => $languageId,
                        ]);
                    }
                }

            } else {
                debug($each->id. "//NOT OK");
            }
        }

        return 1;
    }

    public function getUsersPassport(){
        $users = DB::table("users2")->get();

        foreach ($users as $i => $each) {
            if (!$each->passport)
                continue;

            $passport = @unserialize($each->passport);
            if ($passport !== false) {
                $user = User::find($each->id);
                if ($user) {
                    $user->passport_num = isset($passport["p_number"]) && $passport["p_number"] ? $passport["p_number"] : null;
                    $user->passport_doi = isset($passport["p_issued_date"]) && $passport["p_issued_date"] && $passport["p_issued_date"] != "0000-00-00" ? $passport["p_issued_date"] : null;
                    $user->passport_dex = isset($passport["p_exp_date"]) && $passport["p_exp_date"] && $passport["p_exp_date"] != "0000-00-00" ? $passport["p_exp_date"] : null;
                    $user->save();
                }
            } else {
                debug($each->id. "//NOT OK");
            }
        }

        return 1;
    }

    public function getMvtMessages(){
        $mvtMessages = MVTMessage::get();
        debug($mvtMessages);
        return "DONE";
    }

    public function getCitycode(){
        //$mycities= City::get();

        foreach($mycities as $city){

            $shortKey = DB::table('city_codes')->select('Code')->whereRaw("'$city->city%' LIKE City");

            if ($city->country_id != 0) {
                $shortKey->where('Country', $city->country->country);

            }
            $shortKey->first();

            if (!empty($shortKey) && $shortKey->count() > 0){
                $city->abbr = $shortKey->first()->Code;
                $city->save();
                //mydebug($shortKey);
                //exit;
            }
        }
        return "done";
    }


    public function getLanguages()
    {
        $employees = User::join('users__departments', 'users.id','=','users__departments.user_id')
            ->where('department_id', '!=', 14)
            ->get(['users.id as id', 'last_name', 'first_name', 'department_id']);


        if (count($employees)) {
            foreach ($employees as $employee) {
                $user = User::find($employee->id);
                debug($user);
                if ($user) {
                    if ($employee->department_id == 12) {
                        $languages = serialize(['English']);
                        $user->languages = $languages;
                        $user->save();
                    } else {
                        $languages = null;
                        $user->languages = $languages;
                        $user->save();
                    }
                }
            }
        }

        return "DONE";

    }

    public function getUserlanguages(){
        //$employees = DB::table('employees')->get();
        //$employees = DB::table('cabin_crew_language')->get();
        foreach($employees as $employee){
            $user = User::where('first_name', $employee->First_Name)
                        ->where("last_name", $employee->Last_Name)
                        ->first();
            if (count($user)){
                $languages = [];


                if ($employee->English) {
                    if ($employee->English == 'E' || $employee->English != 0)
                        $languages[] = 'English';
                }

                if ($employee->German){
                    if ($employee->German == 'G' || $employee->German == 1)
                        $languages[] = 'German';
                }

                if ($employee->Chinese) {
                    if ($employee->Chinese == 'C' || $employee->Chinese != 0)
                        $languages[] = 'Chinese';
                }
                debug($languages);

                if (count($languages)) {
                    $user->languages = serialize($languages);
                }
                else
                    $user->languages = '';

                if ($employee->Location && $employee->Location != "")
                    $user->location = $employee->Location;
                else
                    $user->location = '';

                    $phone = [];

                if ($employee->Office_Phone && $employee->Office_Phone != "")
                    $phone['office'] = $employee->Office_Phone;
                if ($employee->Home_Phone && $employee->Home_Phone != "")
                    $phone['home'] = $employee->Home_Phone;
                if ($employee->Mobile_1 && $employee->Mobile_1 != "")
                    $phone['mobile1'] = $employee->Mobile_1;
                if ($employee->Mobile_2 && $employee->Mobile_2 != "")
                    $phone['mobile2'] = $employee->Mobile_2;

                if (count($phone))
                    $user->phone = serialize($phone);
                else
                    $user->phone = '';


                if ($employee->Date_Joining != "0000-00-00" && !is_null($employee->Date_Joining))
                    $user->doj = $employee->Date_Joining;

                $passport = [];

                if ($employee->Passport_Num && $employee->Passport_Num != "")
                    $passport['p_number'] = $employee->Passport_Num;
                if ($employee->Passport_Issued != "0000-00-00" && !is_null($employee->Passport_Issued))
                    $passport['p_issued_date'] = $employee->Passport_Issued;
                if ($employee->Passport_Expiration != "0000-00-00" && !is_null($employee->Passport_Expiration))
                    $passport['p_exp_date'] = $employee->Passport_Expiration;

                if (count($passport))
                    $user->passport = serialize($passport);
                else
                    $user->passport = '';

                $user->birth_place = $employee->Birth_Place;
                $user->nationality = $employee->Nationality;

                $user->save();
            }
        }
        return "FINISHED";
    }

    public function getFlightsError(){
        $flights = Flight::get();
        $errorFlights = [];
        foreach ($flights as $flight) {
            if ($flight->atd && $flight->atd != EMPTY_DATETIME && $flight->ata && $flight->ata != EMPTY_DATETIME) {
                $total_hours = Calculate_Duration($flight->atd, $flight->ata, 'no_round');
                $departure_date = date('Y-m-d', strtotime($flight->atd));
            } else {
                $total_hours = Calculate_Duration($flight->std, $flight->sta, 'no_round');
                $departure_date = date('Y-m-d', strtotime($flight->std));
            }

            if ($total_hours < 0.4 || $total_hours > 10){
                $errorFlights[date('Y', strtotime($flight->std))][date('M', strtotime($flight->std))][] ="ATD: ".date('M d', strtotime($flight->atd))." | SZ ".$flight->flightNumber->flight_number." | Flight ID: ".$flight->id." | Hours: ".$total_hours;
            }
        }
        debug($errorFlights);
        return "DONE";

    }



    public function getUser(){

         // $employees = DB::table('employees')->get();
        //debug($employees);

        /*$employees = DB::table('employees')->whereNotNull('resigned_date')->get();
        debug($employees);
        foreach($employees as $employee){
            $user = User::where('email',$employee->Email)->first();
            if (!empty($user)){
                $user->resigned_date = $employee->resigned_date;
                $user->save();
            }
        }
        exit;*/

        foreach($employees as $employee){
           // $user = new User;
            $user = User::where('first_name', $employee->First_Name)
                ->where("last_name", $employee->Last_Name)
                ->first();

            if (!empty($user)) {
            /*$user->first_name = $employee->First_Name;
            $user->last_name = $employee->Last_Name;

            $generatePassword = $this->generateRandomPassword();
            $user->password = Hash::make($generatePassword);
            $user->tmp_password = $generatePassword;

            $user->email = $employee->Email;



            if ($employee->DOB != "0000-00-00" && !is_null($employee->DOB))
                $user->dob = $employee->DOB;

            if ($employee->Staff_Num != "" && $employee->Staff_Num != 0)
                $user->staff_number = $employee->Staff_Num;*/
                $languages = [];

                if ($employee->Tajik == 1)
                    $languages[] = 'Tajik';
                if ($employee->Russian == 1)
                    $languages[] = 'Russian';
                if ($employee->English == 1)
                    $languages[] = 'English';
                if ($employee->German == 1)
                    $languages[] = 'German';
                if ($employee->Chinese == 1)
                    $languages[] = 'Chinese';
                if (!empty($languages))
                    $user->languages = serialize($languages);

                if ($employee->Location != "")
                    $user->location = $employee->Location;

                $phone = [];
                if ($employee->Office_Phone != "")
                    $phone['office'] = $employee->Office_Phone;
                if ($employee->Home_Phone != "")
                    $phone['home'] = $employee->Home_Phone;
                if ($employee->Mobile_1 != "")
                    $phone['mobile1'] = $employee->Mobile_1;
                if ($employee->Mobile_2 != "")
                    $phone['mobile2'] = $employee->Mobile_2;

                if (!empty($phone))
                    $user->phone = serialize($phone);

                if ($employee->Date_Joining != "0000-00-00" && !is_null($employee->Date_Joining))
                    $user->doj = $employee->Date_Joining;

                $passport = [];

                if ($employee->Passport_Num != "")
                    $passport['p_number'] = $employee->Passport_Num;
                if ($employee->Passport_Issued != "0000-00-00" && !is_null($employee->Passport_Issued))
                    $passport['p_issued_date'] = $employee->Passport_Issued;
                if ($employee->Passport_Expiration != "0000-00-00" && !is_null($employee->Passport_Expiration))
                    $passport['p_exp_date'] = $employee->Passport_Expiration;

                if (!empty($passport))
                    $user->passport = serialize($passport);

                $user->birth_place = $employee->Birth_Place;
                $user->nationality = $employee->Nationality;

                /* if ($employee->Idcard_Num != "" && !is_null($employee->Idcard_Num))
                     $user->idcard_number =$employee->Idcard_Num;
                 if ($employee->Idcard_Valid != "0000-00-00" && !is_null($employee->Idcard_Valid))
                     $user->idcard_expiration =$employee->Idcard_Valid;
                 if ($employee->Picture != "" && !is_null($employee->Picture))
                     $user->picture =$employee->Picture;
                 if ($employee->Picture_2 != "" && !is_null($employee->Picture_2))
                     $user->thumb =$employee->Picture_2;*/

                $user->activated = 1;
                /*$user->role = 'user';*/
                $user->save();
            }
        }

/*        $languages = \request("language");
        if (is_array($languages))
        {
            $user->languages = serialize($languages);
        }*/

        /*$userSample =User::first();
        debug(unserialize($userSample->phone));

        debug($userSample);*/

        return "FIX";
    }

    public function getUserssubdepartment(){

        //$users = UserDepartment::whereIn('department_id', [8,16,20,19,17,18,15])->get();
        //$ceo_dep = Department::where('name', "CEO")->first();
        foreach($users as $user){
            $user_dep = Department::where('id',$user->department_id)->first();
            $sub_dep = SubDepartment::where('name',$user_dep->name)->first();
            $user->department_id = $ceo_dep->id;
            $user->subdepartment_id =$sub_dep->id;
            $user->save();
            //debug($sub_dep);
        }

        $users = Position::whereIn('department_id', [8,16,20,19,17,18,15])->get();
        foreach($users as $user){
            $user_dep = Department::where('id',$user->department_id)->first();
            $sub_dep = SubDepartment::where('name',$user_dep->name)->first();
            $user->department_id = $ceo_dep->id;
            $user->subdepartment_id =$sub_dep->id;
            $user->save();
            //debug($sub_dep);
        }
        return "Done";
    }

    public function getCrew(){

        //$cabin_crew = DB::table('cabin_crew_2')->get();
        foreach($cabin_crew as $each){
            $cc_id = User::where('first_name',$each->First_Name)->where('last_name',$each->Last_Name)->first();
            if (!empty($cc_id)){
                Db::table('users__departments')->insert(array(
                    'user_id' => $cc_id->id,
                    'department_id'=> 14,
                    'position_id'=>3
                ));
            }
        }

        exit;
        $employees = DB::table('cabin_crew_2')->get();
        //debug($employees);

        $userSample =CabinCrew::first();
        //debug($userSample);


        foreach($employees as $employee){
            $user = new CabinCrew;
            $find_cc = User::where('first_name', $employee->First_Name)->where('last_name', $employee->Last_Name)->first();

            $user->user_id = $find_cc->id;

            if (!is_null($employee->is_contract))
                $user->is_contractor = $employee->is_contract;

            if (!is_null($employee->is_purser))
                $user->is_purser = $employee->is_purser;

            if (!is_null($find_cc->location))
                $user->location = $find_cc->location;

            $aircrafts = array();

            if ($employee->B737_900 == 1)
                $aircrafts[] = 'B737-900';
            if ($employee->B737_800 == 1)
                $aircrafts[] = 'B737-800';
            if ($employee->B737_300 == 1)
                $aircrafts[] = 'B737-300';

            if (!empty($aircrafts))
                $user->aircraft_types = serialize($aircrafts);

            if ($employee->CMC != "0000-00-00" && !is_null($employee->CMC))
                $user->cmc_to = $employee->CMC;

            if ($employee->SEP != "0000-00-00" && !is_null($employee->SEP))
                $user->sep_to = $employee->SEP;

            if ($employee->CRM != "0000-00-00" && !is_null($employee->CRM))
                $user->crm_to = $employee->CRM;

            if ($employee->Security != "0000-00-00" && !is_null($employee->Security))
                $user->security_to = $employee->Security;

            if ($employee->Medical != "0000-00-00" && !is_null($employee->Medical))
                $user->medical_to = $employee->Medical;

            if ($employee->Flying_License_From != "0000-00-00" && !is_null($employee->Flying_License_From))
                $user->flying_license_from = $employee->Flying_License_From;

            if ($employee->Flying_License_To != "0000-00-00" && !is_null($employee->Flying_License_To))
                $user->flying_license_to = $employee->Flying_License_To;

            if ($employee->Line_Check != "0000-00-00" && !is_null($employee->Line_Check))
                $user->line_check_from = $employee->Line_Check;

            $user->save();
        }

        return "FIX";
    }



public function getCrewhistory(){

    //$employees = DB::table('captains_firstofficers2')->where('Condition_type','!=','')->whereNotNull('Condition_From')->whereNotNull('Condition_To')->get();
    //debug($employees);
    $not_found = [];
    foreach($employees as $employee){
        //$user = new CabinCrew;
        $find_cc = User::where('first_name', $employee->First_Name)->where('last_name', $employee->Last_Name)->first();
        if (count($find_cc)){
            $condition = Condition::where('name', $employee->Condition_Type)->first(['id']);
            if ($condition) {
                $user_history = new UserHistory;
                $user_history->user_id = $find_cc->id;
                $user_history->condition_id = $condition->id;
                $user_history->from = $employee->Condition_From;
                $user_history->to = $employee->Condition_To;
                $user_history->created_by = Auth::user()->id;
                $user_history->save();
            }
            else{
                $not_found[] = $employee->Condition_Type;
            }
        }
        else
            debug($employee);
    }

    return _debug($not_found);
}



    public function getUsersdepartment()
    {

       // $employees = DB::table('employees')->get();

        $all = array();
        foreach ($employees as $employee) {

            $department = Department::where('name', $employee->Department)->first();
            if (empty($department)){
                $department = new Department;
                $department->name = $employee->Department;
                $department->save();
            }

            $position = Position::where('title', $employee->Position)->first();
            if (empty($position)){
                $position = new Position;
                $position->title = $employee->Position;
                $position->department_id = $department->id;
                $position->save();
            }


            $user = User::where('first_name', $employee->First_Name)->where('last_name', $employee->Last_Name)->first();
            if ($employee->First_Name == 'Dilovar')
                $all[] = $user;

            if (!empty($user)) {
                Db::table('users__departments')->insert(array(
                    'user_id' => $user->id,
                    'department_id' => $department->id,
                    'position_id' => $position->id
                ));
            }
        }
        mydebug($all);
    }


    public function getFlightcrew(){
        $not_found = [];
        $captains = DB::table('crew__flight3')->get();
        foreach($captains as $captain){
            $captain_id = User::where('first_name',$captain->First_Name)->where('last_name',$captain->Last_Name)->first();
            if (count($captain_id)){
                if ($captain->Position == 'first_officer')
                    $position_id = 2;
                elseif($captain->Position == 'captain')
                    $position_id = 1;

                $check_exists = UserDepartment::where('user_id', $captain_id->id)->first();
                $not_found[] = $captain_id->id;
                if (empty($check_exists)) {
                    UserDepartment::insert(array(
                        'user_id' => $captain_id->id,
                        'department_id' => 12,
                        'position_id' => $position_id,
                    ));

                }
                else {
                    UserDepartment::where('user_id', $captain_id->id)->update(array(
                        'department_id' => 12,
                        'position_id' => $position_id,
                    ));
                }
            }
        }
        _debug($not_found);
        exit;

        //$employees =  DB::table('captains_firstofficers3')->get();
        foreach($employees as $employee){
            $find_cc = User::where('first_name', $employee->First_Name)->where('last_name', $employee->Last_Name)->first();
            if (count($find_cc))
                $user = CaptainFirstOfficer::where('user_id', $find_cc->id)->first();
            else {
                $not_found[] = $employee->Last_Name." ".$employee->First_Name;
                continue;
            }

            if (empty($user)) {
                $user = new CaptainFirstOfficer;
                $user->user_id = $find_cc->id;
            }

            if (!is_null($find_cc->location))
                $user->location = $find_cc->location;

            $aircrafts = [];

            if ($employee->B737_900 == 1)
                $aircrafts[] = 'B737-900';
            if ($employee->B737_800 == 1)
                $aircrafts[] = 'B737-800';
            if ($employee->B737_300 == 1)
                $aircrafts[] = 'B737-300';

            $user->aircraft_types = serialize($aircrafts);

            //$user->english_level = $employee->English_Level;

            if ($employee->Aruba_Validation_from != "0000-00-00" && !is_null($employee->Aruba_Validation_from))
                $user->aruba_validation_from = $employee->Aruba_Validation_from;
            else
                $user->aruba_validation_from = null;

            if ($employee->Aruba_Validation != "0000-00-00" && !is_null($employee->Aruba_Validation))
                $user->aruba_validation_to = $employee->Aruba_Validation;
            else
                $user->aruba_validation_to = null;

            if ($employee->CMC_from != "0000-00-00" && !is_null($employee->CMC_from))
                $user->cmc_from = $employee->CMC_from;
            else
                $user->cmc_from = null;

            if ($employee->CMC != "0000-00-00" && !is_null($employee->CMC))
                $user->cmc_to = $employee->CMC;
            else
                $user->cmc_to = null;

            if ($employee->SEP_12 != "0000-00-00" && !is_null($employee->SEP_12))
                $user->sep_12_expiration = $employee->SEP_12;
            else
                $user->sep_12_expiration = null;

            if ($employee->SEP_36 != "0000-00-00" && !is_null($employee->SEP_36))
                $user->sep_36_expiration = $employee->SEP_36;
            else
                $user->sep_36_expiration = null;

            if ($employee->CRM_from != "0000-00-00" && !is_null($employee->CRM_from))
                $user->crm_from = $employee->CRM_from;
            else
                $user->crm_from = null;

            if ($employee->CRM != "0000-00-00" && !is_null($employee->CRM))
                $user->crm_to = $employee->CRM;
            else
                $user->crm_to = null;

            if ($employee->Security != "0000-00-00" && !is_null($employee->Security))
                $user->security_expiration = $employee->Security;
            else
                $user->security_expiration = null;

            if ($employee->Medical_from != "0000-00-00" && !is_null($employee->Medical_from))
                $user->medical_from = $employee->Medical_from;
            else
                $user->medical_from = null;

            if ($employee->Medical != "0000-00-00" && !is_null($employee->Medical))
                $user->medical_to = $employee->Medical;
            else
                $user->medical_to = null;

            if ($employee->Flying_License_From != "0000-00-00" && !is_null($employee->Flying_License_From))
                $user->flying_license_from = $employee->Flying_License_From;
            else
                $user->flying_license_from = null;

            if ($employee->Flying_License_To != "0000-00-00" && !is_null($employee->Flying_License_To))
                $user->flying_license_to = $employee->Flying_License_To;
            else
                $user->flying_license_to = null;

            if ($employee->Line_Check_from != "0000-00-00" && !is_null($employee->Line_Check_from))
                $user->line_check_from = $employee->Line_Check_from;
            else
                $user->line_check_from = null;

            if ($employee->Line_Check != "0000-00-00" && !is_null($employee->Line_Check))
                $user->line_check_to = $employee->Line_Check;
            else
                $user->line_check_to = null;

            if ($employee->License_Attachment_from != "0000-00-00" && !is_null($employee->License_Attachment_from))
                $user->license_attachment_from = $employee->License_Attachment_from;
            else
                $user->license_attachment_from = null;

            if ($employee->License_Attachment != "0000-00-00" && !is_null($employee->License_Attachment))
                $user->license_attachment_to = $employee->License_Attachment;
            else
                $user->license_attachment_to = null;

            if ($employee->DGR_from != "0000-00-00" && !is_null($employee->DGR_from))
                $user->dgr_from = $employee->DGR_from;
            else
                $user->dgr_from = null;

            if ($employee->DGR != "0000-00-00" && !is_null($employee->DGR))
                $user->dgr_to = $employee->DGR;
            else
                $user->dgr_to = null;

            if ($employee->LPC_IR_from != "0000-00-00" && !is_null($employee->LPC_IR_from))
                $user->lpc_ir_from = $employee->LPC_IR_from;
            else
                $user->lpc_ir_from = null;

            if ($employee->LPC_IR != "0000-00-00" && !is_null($employee->LPC_IR))
                $user->lpc_ir_to = $employee->LPC_IR;
            else
                $user->lpc_ir_to = null;

            if ($employee->OPC_from != "0000-00-00" && !is_null($employee->OPC_from))
                $user->opc_from = $employee->OPC_from;
            else
                $user->opc_from = null;

            if ($employee->OPC != "0000-00-00" && !is_null($employee->OPC))
                $user->opc_to = $employee->OPC;
            else
                $user->opc_to = null;

            if ($employee->TRI_SFI_from != "0000-00-00" && !is_null($employee->TRI_SFI_from))
                $user->tri_sfi_from = $employee->TRI_SFI_from;
            else
                $user->tri_sfi_from = null;

            if ($employee->TRI_SFI != "0000-00-00" && !is_null($employee->TRI_SFI))
                $user->tri_sfi_to = $employee->TRI_SFI;
            else
                $user->tri_sfi_to = null;

            $user->save();

        }

        return _debug($not_found);
    }

    /*public function getCrewuserid(){
        $crew = CabinCrew::get();

            $not_found = [];
            $valid_ids = [];
        foreach ($crew as $employee) {
            $user = User::where('first_name', $employee->first_name)->where('last_name', $employee->last_name)->first();
            if (count($user)) {
                $employee->user_id = $user->id;
                $employee->save();
                debug($user);
            }
            else{
                debug($crew);
                $user = User::where('last_name', $employee->last_name)->get();
                if (count($user)== 1) {
                    $employee->user_id = $user->first()->id;
                    $employee->save();
                }
            }
        }
        return "finished";
    }*/


    public function getFlightcrewupdate(){
        //$updated_list = DB::table('captains_firstofficers2')->get();
        $not_found = [];
        $valid_ids = [];
        foreach($updated_list as  $updated_ccm) {
            $user = User::where('first_name', $updated_ccm->First_Name)->where('last_name', $updated_ccm->Last_Name)->first();
            if (empty($user)) {
                $not_found[] = $updated_ccm->First_Name . " " . $updated_ccm->Last_Name;
                continue;
            } else {
                $ccm = CaptainFirstOfficer::where('user_id', $user->id)->first(['id']);
                if (empty($ccm))
                    $ccm = new CaptainFirstOfficer;
            }

            /*if (empty($user)) {
                //$not_found[] = $updated_ccm->last_name.' '.$updated_ccm->first_name;
                $user = new User;
                $user->first_name = $updated_ccm->first_name;
                $user->last_name = $updated_ccm->last_name;
                $ccm = new CabinCrew;
            }*/
            //--------------USER INFO------------


            $user->location = $updated_ccm->Location != '' ? $updated_ccm->Location : null;

            $user->email = $updated_ccm->Email;

            $user->dob = $updated_ccm->DOB != '0000-00-00' ? $updated_ccm->DOB : null;

            $user->staff_number = $updated_ccm->Staff_Num != '' ? $updated_ccm->Staff_Num : null;

            $phones = [];
            if ($updated_ccm->Office_Phone != '')
                $phones['office'] = $updated_ccm->Office_Phone;
            if ($updated_ccm->Home_Phone != '')
                $phones['home'] = $updated_ccm->Home_Phone;
            if ($updated_ccm->Mobile_1 != '')
                $phones['mobile1'] = $updated_ccm->Mobile_1;
            if ($updated_ccm->Mobile_2 != '')
                $phones['mobile2'] = $updated_ccm->Mobile_2;

            $user->phone = serialize($phones);

            $passport = [];
            if ($updated_ccm->Passport_Num != '') {
                $passport['p_number'] = $updated_ccm->Passport_Num;
                $passport['p_issued_date'] = $updated_ccm->Passport_Issued;
                $passport['p_exp_date'] = $updated_ccm->Passport_Expiration;
                $passport['p_issued_place'] = '';
            }

            $user->passport = serialize($passport);

            $user->birth_place = $updated_ccm->Birth_Place != '' ? $updated_ccm->Birth_Place : null;

            $user->nationality = $updated_ccm->Nationality != '' ? $updated_ccm->Nationality : null;

            $user->idcard_number = $updated_ccm->Idcard_Num != '' ? $updated_ccm->Idcard_Num : null;

            if ($updated_ccm->Idcard_Valid != '0000-00-00')
                $user->idcard_expiration = $updated_ccm->Idcard_Valid;
            else
                $user->idcard_expiration = null;

            $user->save();

            $valid_ids[] = $user->id;
        }

        return _debug($not_found);

}

public function getCrewupdate(){
    $updated_list = DB::table('ccm_updated')->get();
    $not_found = [];
    $valid_ids = [];
    foreach($updated_list as  $updated_ccm) {
        $user = User::where('first_name', $updated_ccm->first_name)->where('last_name', $updated_ccm->last_name)->first();
        if (count($user))
            $valid_ids[] = $user->id;
        else
            debug($updated_ccm);
    }
        //$user = User::where('email', $updated_ccm->email)->first();

            /*if (empty($user)) {
                //$not_found[] = $updated_ccm->last_name.' '.$updated_ccm->first_name;
                $user = new User;
                $user->first_name = $updated_ccm->first_name;
                $user->last_name = $updated_ccm->last_name;
                $ccm = new CabinCrew;
            }
            else {
                $ccm = CabinCrew::where('user_id', $user->id)->first(['id']);
                if (empty($ccm))
                    $ccm = new CabinCrew;
            }
            //--------------USER INFO------------



            $user->location = $updated_ccm->location != '' ? $updated_ccm->location : null;

            $user->email = $updated_ccm->email;

            if ($updated_ccm->languages != ''){
                $languages = explode(';', $updated_ccm->languages);

                $user->languages = count($languages) ? serialize($languages) : null;
            }

            $user->dob = $updated_ccm->dob != '' ? $updated_ccm->dob : null;

            $user->staff_number = $updated_ccm->staff_number != '' ? $updated_ccm->staff_number : null;


            $phones = [];
            if ($updated_ccm->phone_mobile1 != '')
                $phones['mobile1'] = $updated_ccm->phone_mobile2;
            if ($updated_ccm->phone_mobile2 != '')
                $phones['mobile2'] = $updated_ccm->phone_mobile2;

            $user->phone = count($phones) ? serialize($phones) : null;

            $passport = [];
            if ($updated_ccm->passport_num != ''){
                $passport['p_number'] = $updated_ccm->passport_num;
                $passport['p_issued_date'] = $updated_ccm->passport_DOI;
                $passport['p_exp_date'] = $updated_ccm->passport_DEX;
                $passport['p_issued_place'] = $updated_ccm->passport_POI;
                $user->passport = serialize($passport);
            }
            else
                $user->passport = null;

            $user->birth_place = $updated_ccm->birth_place != '' ? $updated_ccm->birth_place : null;

            $user->nationality = $updated_ccm->nationality != '' ? $updated_ccm->nationality : null;

            $user->idcard_expiration = $updated_ccm->idcard_expiration != '' ? $updated_ccm->idcard_expiration : null;

            $user->save();

            $valid_ids[] = $user->id;
            //----------------------------------------
            if ($user->id == 0)
                debug($user);

            $ccm->user_id = $user->id;

            if ($updated_ccm->aircraft_types != ''){
                $ac = explode(';', $updated_ccm->aircraft_types);
                if (count($ac)){
                    $ccm->aircraft_types = serialize($ac);
                }
            }

        $ccm->location = $updated_ccm->location != '' ? $updated_ccm->location : null;


        if ($updated_ccm->is_purser == 1){
                $ccm->is_purser = 1;
            }
            else
                $ccm->is_purser = null;

            $ccm->is_contractor = null;


            if ($updated_ccm->CMC_from != "")
                $ccm->cmc_from = $updated_ccm->CMC_from;
            if ($updated_ccm->CMC_to != "")
                $ccm->cmc_to = $updated_ccm->CMC_to;

            if ($updated_ccm->sep_from != "")
                $ccm->sep_from = $updated_ccm->sep_from;
            if ($updated_ccm->sep_to != "")
                $ccm->sep_to = $updated_ccm->sep_to;

            if ($updated_ccm->CRM_from != "")
                $ccm->crm_from = $updated_ccm->CRM_from;
            if ($updated_ccm->CRM_to != "")
                $ccm->crm_to = $updated_ccm->CRM_to;

            if ($updated_ccm->License_validity != "")
                $ccm->license_validity = $updated_ccm->License_validity;

            if ($updated_ccm->Next_medical != "")
                $ccm->medical_next = $updated_ccm->Next_medical;

            if ($updated_ccm->dgr_from != "")
                $ccm->dgr_from = $updated_ccm->dgr_from;
            if ($updated_ccm->dgr_to != "")
                $ccm->dgr_to = $updated_ccm->dgr_to;

            if ($updated_ccm->security_from != "")
                $ccm->security_from = $updated_ccm->security_from;
            if ($updated_ccm->security_to != "")
                $ccm->security_to = $updated_ccm->security_to;

            if ($updated_ccm->practical_from != "")
                $ccm->practical_from = $updated_ccm->practical_from;
            if ($updated_ccm->practical_to != "")
                $ccm->practical_to = $updated_ccm->practical_to;

            if ($updated_ccm->line_check_from != "")
                $ccm->line_check_from = $updated_ccm->line_check_from;
            if ($updated_ccm->line_check_to != "")
                $ccm->line_check_to = $updated_ccm->line_check_to;

            $ccm->save();

    }*/

        // ------ Input Resigned Date if User Not in the list
        $cabincrew = CabinCrew::get();
        foreach($cabincrew as $each){
            $user = User::find($each->user_id);
            if ($user) {
                $users_dep = UserDepartment::where('user_id', $user->id)->get();
                if (count($users_dep)){
                    if (count($users_dep) > 1)
                        debug($user);
                }
                else{
                    $new = new UserDepartment;
                    $new->user_id = $user->id;
                    $new->department_id = 14;
                    $new->position_id = 3;
                    $new->save();
                }


                /*if (!in_array($each->user_id, $valid_ids)) {
                    $user->resigned_date = '2014-12-31';
                }
                else {
                    $user->resigned_date = null;
                }
                $user->save();*/
            }
            else
                debug($user);
        }
        //----------------------

        debug($valid_ids);
        //debug($not_found);
        return 'hello';
    }


    public function getOrderfare(){
        //$passengerOrders = PassengerOrder::select('id','fare')->get();
        foreach ($passengerOrders as $order) {
            $flightCount = PassengerFlight::where('passenger_order_id', $order->id)->get();

            if (!$flightCount->isEmpty()) {
                $fare = $order->fare / $flightCount->count();

                foreach ($flightCount as $each) {
                    $each->fare = $fare;
                    $each->save();
                }
                debug($order);
                debug($flightCount);
                exit;
            }

        }
        return view('report.index');
    }

    public function getFlightid()
    {
        $passengerFlights = PassengerFlight::whereRaw("flight_id is null AND DATE(departure) < '2013-10-21'")->get();
        foreach ($passengerFlights as $each) {
            $flightNumber_id = $each->flight_number_id;
            $std = date('Y-m-d', strtotime($each->departure));
            $dep_air = $each->flightNumber->departure_airport;
            $arr_air = $each->flightNumber->arrival_airport;
            $flight = Flight::whereRaw("departure_airport = '$dep_air' AND arrival_airport = '$arr_air' AND DATE(atd) = '$std'")
                ->join('flights__numbers', 'flights.flight_number_id', '=', 'flights__numbers.id')
                ->first();

            if (empty($flight)) {
                $get = FlightNumber::where('id', $flightNumber_id)
                    ->whereNull("deleted_at")
                    ->first();
                //if ($get->departure_airport != 'DYU' && $get->arrival_airport != 'DME') {
                    $tomorrow = date('Y-m-d', strtotime("$std + 1 days"));
                    $yesterday = date('Y-m-d', strtotime("$std - 1 days"));
                    $flight = Flight::whereRaw("departure_airport = '$dep_air' AND arrival_airport = '$arr_air' AND (DATE(atd) = '$yesterday' OR DATE(atd) = '$tomorrow')")
                        ->join('flights__numbers', 'flights.flight_number_id', '=', 'flights__numbers.id')
                        ->orderByRaw("DATE(atd) DESC")
                        ->first();
                    if (!empty($flight)){
                        $each->flight_id = $flight->id;
                        $each->flight_number_id = $flight->flight_number_id;
                        $each->save();
                    }
               // }
            }
            else{
                $each->flight_id = $flight->id;
                $each->flight_number_id = $flight->flight_number_id;
                $each->save();
            }
        }
        return "HELLO";
    }


    public function getOrderduplicates(){
        //select id,ticket_number from s_passengers_orders where ticket_number in (select ticket_number from s_passengers_orders group by ticket_number having count(id) > 1)

        $passOrders = PassengerOrder::select(['id', 'ticket_number'])
            ->whereRaw('ticket_number in (select ticket_number from s_passengers_orders group by ticket_number having count(id) > 1)')
            ->groupBy('ticket_number')
            ->get();

        //$passOrders = PassengerOrder::select(['id', 'ticket_number'])->groupBy('ticket_number')->get();

        /*foreach($passOrders as $order){
            $duplicateOrders = PassengerOrder::select('id')->where('ticket_number', $order->ticket_number)->where('id','!=', $order->id)->get();
            foreach($duplicateOrders as $dupOrder){
                $passFlights = PassengerFlight::select('id')->where('passenger_order_id', $dupOrder->id)->get();
                foreach ($passFlights as $each) {
                    $each->passenger_order_id = $order->id;
                    $each->save();
                }
                $dupOrder->deleted_at = date('Y-m-d H:i:s');
                $dupOrder->save();
            }
        }*/

        debug($passOrders->count());
        return "hello";
    }

    public function getTest(){

        $regExp = '/\b[0-9]+[a-zA-Z]+\b/m';
        $word = '104Y';
        //preg_match("/([0-9]+)|([a-zA-Z]+)/", $word, $match);
        $match = preg_split('/(?<=\d)(?=[a-zA-Z])/i', $word);
//        $match = preg_split('/\d(?=\w){0,}/i', $word);
        //preg_match_all($regExp, $word, $match);
        debug($match);
        return "DONE";
       /* $flight_int = (!empty($integer)) ? $integer[0][0] : null;

        debug($flight_int);exit;*/
        /*$test = DB::table('fleet_watch')->where('Flight_Num', 'SZ 260')->where('Departure_Date', '2014-07-28')->first();
        echo $time = $test->Atd;
        $time = "00:00:00";

        if (strtotime($time) == strtotime('00:00:00'))
            echo "hello";

        $str = 'ывпыва';*/

       /*if (mb_detect_encoding($str) == 'UTF-8')
           echo mb_convert_encoding($str, 'UTF-8','auto');*/

       /* $flight = Flight::with('FlightNumber')->whereRaw("flight_number_id = '1' AND DATE(std) = '2014-07-04'")->first();
        debug($flight);*/
    }



    /**
     * Crew Leaves & Training Log Export
     * @return string
     */
    public function getCrewHistoryLog(){
        $crew = DB::table('crew__flight_log')->get(['First_Name', 'Last_Name', 'Condition_Log']);
        $unique = [];

        foreach ($crew as $ccm) {
            //$user = User::where('first_name', $ccm->First_Name)->where('last_name', $ccm->Last_Name)->first();
            $user = $this->firstLastNameSeparator($ccm->Last_Name." ".$ccm->First_Name);
            if ($user != false) {
                $log = $ccm->Condition_Log;

                $cond = explode('/', $log);
                $unique_old = array_unique($cond);
                $unique_old = array_values($unique_old);
                $unique_old = array_filter($unique_old);
                $unique[$user] = [];
                $i = 0;
                foreach ($unique_old as $each) {
                    $split = explode("_", $each);
                    $condition_name = $split[0];
                    $from = $split[1];
                    $to = $split[2];

                    if (empty($each) || !$from || !$to || $from == '0000-00-00' || $to == '0000-00-00' || !dateValidation($from) || !dateValidation($to)){
                        continue;
                    }

                    $previous_from = end($unique[$user])['range']['from'];
                    $previous_to = end($unique[$user])['range']['to'];
                    $previous_condition = end($unique[$user])['condition'];

                    if ($from == $previous_from || $to == $previous_to) {
                        $i--;
                    }

                    if ($condition_name ==  $previous_condition) {
                        for ($n = -3; $n <= 3; $n++){
                            $j = $n > 0 ? "+ $n" : $n;
                            if ($n == 0) continue;

                            if (strtotime(" $j days", strtotime($previous_from)) == strtotime($from)){
                                $i--;
                                break;
                            }
                        }
                    }

                    $condition = Condition::where('name', $condition_name)->first(['id']);
                    if (!$condition) {
                        $condition = new Condition;
                        $condition->name = $condition_name;
                        $condition->save();
                    }

                    $unique[$user][$i++] = ['condition' => $condition->id, 'range' => ['from' => $from, 'to' => $to]];

                }
                // If Not Empty
                if (count($unique[$user])){
                    foreach ($unique[$user] as $history) {
                        $user_history = UserHistory::where('user_id', $user)
                            ->where('condition_id', $history['condition'])
                            ->where('from', $history['range']['from'])
                            ->where('to', $history['range']['to'])
                            ->first(['id']);

                        if (!$user_history) {
                            $user_history = new UserHistory;
                            $user_history->user_id = $user;
                            $user_history->condition_id = $history['condition'];
                            $user_history->from = $history['range']['from'];
                            $user_history->to = $history['range']['to'];
                            $user_history->save();
                        }
                    }
                }


            }
            else {
                debug($ccm);
            }

        }
        debug($unique);
        return "Finished";
    }


    public function DeleteCrewAndFlights($table){
        $dates = DB::table($table)->groupBy('Departure_Date')->orderBy('Departure_Date')->pluck('Departure_Date')->all();

        FlightCrew::join('flights', 'flights.id', '=', 'flights__crew.flight_id')
            ->whereIn(DB::raw("DATE(std)"), $dates)
            ->delete();

        /* Flight::whereIn(DB::raw('DATE(std)'), $dates)
                     ->delete();*/

        /*Maintenance::whereIn(DB::raw('DATE(arrival_time)'), $dates)
            ->delete();*/

    }

    public function DeleteNotFoundFlights($table, $flightIds){
        $dates = DB::table($table)->groupBy('Departure_Date')->orderBy('Departure_Date')->pluck('Departure_Date')->all();

       Flight::whereIn(DB::raw('DATE(std)'), $dates)
                     ->whereNotIn('id', $flightIds)
                     ->delete();

    }



    public function getFleetwatch(){

            $not_found_name =[];
            $notfound = [];
            $flightIds = [];

            //$table = 'march_2015';
            $this->DeleteCrewAndFlights($table);

            $fw_flights = DB::table($table)->get();

            foreach($fw_flights as $fw_flight){
                unset($std, $etd, $atd, $abn, $sta, $eta, $ata, $tdn, $departure_date, $arrival_date);

                $departure_date = $fw_flight->Departure_Date;
                $arrival_date = $fw_flight->Arrival_Date;
                $aircraft = $fw_flight->aircraft;
                $dep_airport = $fw_flight->Departure_Airport;
                $arr_airport = $fw_flight->Arrival_Airport;

                if (!is_null($fw_flight->Std))
                    $std = date('Y-m-d H:i:s', strtotime($departure_date." ".$fw_flight->Std));

                if (!is_null($fw_flight->Sta))
                    $sta = date('Y-m-d H:i:s', strtotime($arrival_date." ".$fw_flight->Sta));

                if (isset($fw_flight->Rmk) && $fw_flight->Rmk != ""){
                    $start = $std;
                    $end = $sta;
                    $find = Maintenance::where('aircraft_id', $aircraft)->where('arrival_time', $start)->where('location_code',$arr_airport)->first();
                    if (empty($find)){
                        $maintenance = new Maintenance;
                        $maintenance->aircraft_id = $aircraft;
                        $maintenance->note = $fw_flight->Rmk;
                        $maintenance->location_code = $arr_airport;
                        $maintenance->arrival_time = $start;
                        $maintenance->departure_time = $end;
                        //$maintenance->save();
                    }
                }
                else {
                    $flight = new Flight;

                    $flight->aircraft_id = $aircraft;

                   if (substr($fw_flight->Flight_Num,0,2) == 'SZ' || is_numeric($fw_flight->Flight_Num)){

                       if (is_numeric($fw_flight->Flight_Num))
                            $flight_int = $fw_flight->Flight_Num;
                       else
                            $flight_int = substr($fw_flight->Flight_Num,3);


                       $type_id = 1;
                       if ($flight_int == '001'){
                           $flight_number_check = FlightNumber::where('flight_number', $flight_int)
                                                                ->where('departure_airport', $dep_airport)
                                                                ->where('arrival_airport', $arr_airport)
                               ->whereNull("deleted_at")
                               ->first();
                           $type_id = 3;
                       }
                       else
                           $flight_number_check = FlightNumber::where('flight_number', $flight_int)
                               ->whereNull("deleted_at")
                               ->first();

                        if (empty($flight_number_check)){
                                $flightNumber = new FlightNumber;
                                $flightNumber->flight_number = ltrim($flight_int, "0");
                                $flightNumber->type_id = $type_id;
                                $flightNumber->departure_airport = $dep_airport;
                                $flightNumber->arrival_airport = $arr_airport;
                                $flightNumber->created_by  = Auth::user()->id;
                                $flightNumber->save();
                                $flightNumber_id = $flightNumber->id;
                        }
                        else
                            $flightNumber_id = $flight_number_check->id;
                    }

                    $ac = Aircraft::find($aircraft);

                    if (in_array($flight_int, [101,102])){
                        $flight->capacity_c = 16;
                        $flight->capacity_y = 130;
                    }
                    elseif (in_array($flight_int, [103, 104, 203, 204, 219, 220, 251, 252])) {
                        $flight->capacity_c = $ac->config_c;
                        $flight->capacity_y = $ac->config_y - 1;
                    }
                    else {
                        $flight->capacity_c = $ac->config_c;
                        $flight->capacity_y = $ac->config_y;
                    }

                    $flight->flight_number_id = $flightNumber_id;


                if (isset($fw_flight->Delay_Code) && $fw_flight->Delay_Code != "" && !is_null($fw_flight->Delay_Code)){
                    $delay = Delay::where('code', $fw_flight->Delay_Code)->first();
                    if (!empty($delay))
                        $flight->delay_id = $delay->id;
                }

                if (isset($fw_flight->Etd) && strtotime($fw_flight->Etd) != strtotime('00:00:00') && !is_null($fw_flight->Etd)){
                    $etd = date('Y-m-d H:i:s', strtotime($departure_date." ".$fw_flight->Etd));
                }

                if (isset($fw_flight->Atd) && strtotime($fw_flight->Atd) != strtotime('00:00:00') && !is_null($fw_flight->Atd)){
                    $atd = date('Y-m-d H:i:s', strtotime($departure_date." ".$fw_flight->Atd));
                }

                if (isset($fw_flight->Abn) && strtotime($fw_flight->Abn) != strtotime('00:00:00') && !is_null($fw_flight->Abn)){
                    $abn = date('Y-m-d H:i:s', strtotime($departure_date." ".$fw_flight->Abn));
                }

                if (isset($fw_flight->Eta) && strtotime($fw_flight->Eta) != strtotime('00:00:00') && !is_null($fw_flight->Eta)){
                    $eta = date('Y-m-d H:i:s', strtotime($arrival_date." ".$fw_flight->Eta));
                }

                if (isset($fw_flight->Tdn) && strtotime($fw_flight->Tdn) != strtotime('00:00:00') && !is_null($fw_flight->Tdn)){
                    $tdn = date('Y-m-d H:i:s', strtotime($arrival_date." ".$fw_flight->Tdn));
                }

                if (isset($fw_flight->Ata) && strtotime($fw_flight->Ata) != strtotime('00:00:00') && !is_null($fw_flight->Ata)){
                    $ata = date('Y-m-d H:i:s', strtotime($arrival_date." ".$fw_flight->Ata));
                }


                $flights_table_check = Flight::where('flight_number_id', $flightNumber_id)
                    ->whereRaw('DATE(std) = "'.date('Y-m-d',strtotime($std)).'"')
                    //->where('aircraft_id', $flight->aircraft_id)
                    ->first();

                    if (empty($flights_table_check)){
                        $notfound[] = $fw_flight;
                        $flight->std = isset($std) ? $std : null;
                        $flight->etd = isset($etd) ? $etd : null;
                        $flight->atd = isset($atd) ? $atd : null;
                        $flight->abn = isset($abn) ? $abn : null;
                        setFlightDepartureDate($flight);

                        $flight->sta = isset($sta) ? $sta : null;
                        $flight->eta = isset($eta) ? $eta : null;
                        $flight->tdn = isset($tdn) ? $tdn : null;
                        $flight->ata = isset($ata) ? $ata : null;
                        setFlightArrivalDate($flight);

                        $flight->pax_c_booked = isset($fw_flight->Pax_C) ? $fw_flight->Pax_C : null;
                        $flight->pax_y_booked = isset($fw_flight->Pax_Y) ? $fw_flight->Pax_Y : null;

                        $flight->pax_c_actual = isset($fw_flight->Pax_C_Actual) ? $fw_flight->Pax_C_Actual : null;
                        $flight->pax_y_actual = isset($fw_flight->Pax_Y_Actual) ? $fw_flight->Pax_Y_Actual : null;
                        $flight->pax_inf_actual = isset($fw_flight->Pax_Inf) ? $fw_flight->Pax_Inf : null;

                        $flight->baggage = isset($fw_flight->Baggage) ? $fw_flight->Baggage : null;
                        $flight->cargo = isset($fw_flight->Cargo) ? $fw_flight->Cargo : null;
                        $flight->mail = isset($fw_flight->Mails) ? $fw_flight->Mails : null;
                        $flight->deportees = isset($fw_flight->Deportees) ? $fw_flight->Deportees : null;
                        //$flight->remaining_fuel = $fw_flight->Remaining_Fuel;
                        $flight->gate_parking = isset($fw_flight->Gate_Parking) ? $fw_flight->Gate_Parking : null;

                        $flight->created_by = Auth::user()->id;
                        $flight->updated_by = Auth::user()->id;

                        //$flight->save();
                    }
                    else {
                        $flights_table_check->aircraft_id = $aircraft;

                        $flights_table_check->std = isset($std) ? $std : null;
                        $flights_table_check->etd = isset($etd) ? $etd : null;
                        $flights_table_check->atd = isset($atd) ? $atd : null;
                        $flights_table_check->abn = isset($abn) ? $abn : null;
                        setFlightDepartureDate($flights_table_check);

                        $flights_table_check->sta = isset($sta) ? $sta : null;
                        $flights_table_check->eta = isset($eta) ? $eta : null;
                        $flights_table_check->tdn = isset($tdn) ? $tdn : null;
                        $flights_table_check->ata = isset($ata) ? $ata : null;
                        setFlightArrivalDate($flights_table_check);

                        $flights_table_check->pax_c_booked = isset($fw_flight->Pax_C) ? $fw_flight->Pax_C : null;
                        $flights_table_check->pax_y_booked = isset($fw_flight->Pax_Y) ? $fw_flight->Pax_Y : null;

                        $flights_table_check->pax_c_actual = isset($fw_flight->Pax_C_Actual) ? $fw_flight->Pax_C_Actual : null;
                        $flights_table_check->pax_y_actual = isset($fw_flight->Pax_Y_Actual) ? $fw_flight->Pax_Y_Actual : null;
                        $flights_table_check->pax_inf_actual = isset($fw_flight->Pax_Inf) ? $fw_flight->Pax_Inf : null;

                        $flights_table_check->baggage = isset($fw_flight->Baggage) ? $fw_flight->Baggage : null;
                        $flights_table_check->cargo = isset($fw_flight->Cargo) ? $fw_flight->Cargo : null;
                        $flights_table_check->mail = isset($fw_flight->Mails) ? $fw_flight->Mails : null;
                        $flights_table_check->deportees = isset($fw_flight->Deportees) ? $fw_flight->Deportees : null;
                        //$flights_table_check->remaining_fuel = $fw_flight->Remaining_Fuel;
                        $flights_table_check->gate_parking = isset($fw_flight->Gate_Parking) ? $fw_flight->Gate_Parking : null;

                        $flights_table_check->created_by = Auth::user()->id;
                        $flights_table_check->updated_by = Auth::user()->id;

                        //$flights_table_check->save();
                    }

                }

                /*$capt_cc = array("Captain_1", "Captain_2",
                    "First_Officer_1", "First_Officer_2",
                    "DHC_Flightcrew_1", "DHC_Flightcrew_2", "DHC_Flightcrew_3", "DHC_Flightcrew_4", "DHC_Flightcrew_5", "DHC_Flightcrew_6",
                    "Cabin_Crew_1", "Cabin_Crew_2", "Cabin_Crew_3", "Cabin_Crew_4", "Cabin_Crew_5", "Cabin_Crew_6", "Cabin_Crew_7", "Cabin_Crew_8",
                    "DHC_1", "DHC_2","DHC_3","DHC_4","DHC_5","DHC_6","DHC_7","DHC_8","DHC_9","DHC_10"
                );
                $position_order = array(1, 2, 1, 2, 0,0,0,0,0,0,   1, 2, 3, 4, 5, 6 ,7 ,8, 0,0,0,0,0,0,0,0,0,0 );

                $capt_cc = array("Captain_1", "Captain_2",
                    "First_Officer_1", "First_Officer_2",

                    "Cabin_Crew_1", "Cabin_Crew_2", "Cabin_Crew_3", "Cabin_Crew_4", "Cabin_Crew_5", "Cabin_Crew_6", "Cabin_Crew_7", "Cabin_Crew_8",

                );
                $position_order = array(1, 2, 1, 2,   1, 2, 3, 4, 5, 6 ,7 ,8 );*/

                $capt_cc = array("Captain_1", "Captain_2",  "First_Officer_1", "First_Officer_2",
                    'Standby_Captain_1', 'Standby_Captain_2', 'Standby_First_Officer_1', 'Standby_First_Officer_2',
                    "DHC_Flightcrew_1", "DHC_Flightcrew_2", "DHC_Flightcrew_3", "DHC_Flightcrew_4", "DHC_Flightcrew_5", "DHC_Flightcrew_6",
                    "Cabin_Crew_1", "Cabin_Crew_2", "Cabin_Crew_3", "Cabin_Crew_4", "Cabin_Crew_5", "Cabin_Crew_6", "Cabin_Crew_7", "Cabin_Crew_8",
                    "DHC_1", "DHC_2","DHC_3","DHC_4","DHC_5","DHC_6","DHC_7","DHC_8","DHC_9","DHC_10","Standby_1","Standby_2","Standby_3","Standby_4");

                //$position_order = array(1, 2, 1, 2,   1, 2, 1, 2,    0,0,0,0,0,0,     1, 2, 3, 4, 5, 6 ,7 ,8,    0,0,0,0,0,0,0,0,0,0,   1,2,3,4);
                $position_order = array(  0, 1, 0, 1,   0, 1, 0, 1,    0,0,0,0,0,0,     0, 1, 2, 3, 4, 5, 6 ,7 ,   0,0,0,0,0,0,0,0,0,0,   0,1,2,3);

                $flight_id = empty($flights_table_check) ? $flight->id : $flights_table_check->id;

                $flightIds[] = $flight_id;

                foreach ($capt_cc as $index => $value) {
                    if ($fw_flight->$value != "") {
                        $id = $this->firstLastNameSeparator($fw_flight->$value);
                        if ($id != FALSE) {
                            $crew_search = FlightCrew::where('user_id', $id)
                                                      ->where('flight_id', $flight_id);

                            $flight_crew = new FlightCrew;
                            $flight_crew->flight_id = $flight_id;
                            $flight_crew->user_id = $id;

                            $position_id = UserDepartment::where('user_id', $id)->first(['position_id']);

                            if (count($position_id)) {
                                $crew_search->where('position_id',$position_id->position_id);
                                $flight_crew->position_id = $position_id->position_id;
                            }

                            $crew_search->where('position_order',$position_order[$index]);
                            $flight_crew->position_order = $position_order[$index];

                            if (strpos($value, 'Standby') !== FALSE) {
                                $crew_search->where('is_standby',1);
                                $flight_crew->is_standby = 1;
                            }
                            elseif (strpos($value, 'DHC') !== FALSE) {
                                $crew_search->where('is_dhc',1);
                                $flight_crew->is_dhc = 1;
                            }

                            $crew_found = $crew_search->first();
                            if (count($crew_found)){
                                // Do NOTHING
                            }
                            else {
                                $flight_crew->save();
                                $not_found[] = $fw_flight->$value;
                            }

                        } else {
                            $not_found_name[] = $fw_flight->$value;
                        }

                    }
                }

            }

            // Delete Flights Which Were NOt Found In Table
            //$this->DeleteNotFoundFlights($table, $flightIds);

            sort($not_found_name);
            debug($not_found_name);
            debug($notfound);

            return "FINISHED";

        }


    public function getFleetwatchcrewonly(){
        //$fw_flights = DB::table('fleetwatch2014')->get();
        $not_found = []; $not_found_flights = [];

        foreach($fw_flights as $j=>$fw_flight){

            $departure_date = $fw_flight->Departure_Date;
            $arrival_date = $fw_flight->Arrival_Date;

            if (isset($fw_flight->Std) && !is_null($fw_flight->Std))
                $std = $fw_flight->Std;

            if (isset($fw_flight->Sta) && !is_null($fw_flight->Sta))
                $sta = $fw_flight->Sta;

            if (isset($std))
                $std = date('Y-m-d H:i:s', strtotime($departure_date." ".$std));


            if (isset($sta)){
                $sta = date('Y-m-d H:i:s', strtotime($arrival_date." ".$sta));
            }

            if (isset($fw_flight->Rmk) && $fw_flight->Rmk != ""){
                continue;
            }
            else {
                $aircraft_id = $fw_flight->aircraft;

                if (substr($fw_flight->Flight_Num,0,2) == 'SZ' || is_numeric($fw_flight->Flight_Num)){

                    if (is_numeric($fw_flight->Flight_Num))
                        $flight_int = $fw_flight->Flight_Num;
                    else
                        $flight_int = substr($fw_flight->Flight_Num,3);

                    $dep_airport = $fw_flight->Departure_Airport;
                    $arr_airport = $fw_flight->Arrival_Airport;
                    $vip = null;
                    if ($flight_int == '001'){
                        $flight_number_check = FlightNumber::where('flight_number', $flight_int)
                            ->where('departure_airport', $dep_airport)
                            ->where('arrival_airport', $arr_airport)
                            ->whereNull("deleted_at")
                            ->first();
                    }
                    else
                        $flight_number_check = FlightNumber::where('flight_number', $flight_int)
                            ->whereNull("deleted_at")
                            ->first();

                }

                $flight = Flight::where('flight_number_id', $flight_number_check->id)
                    ->where('std', $std)
                    ->where('aircraft_id', $aircraft_id)
                    ->first();
            }


            if (count($flight)) {
                 $capt_cc = array("Captain_1", "Captain_2",  "First_Officer_1", "First_Officer_2",
                'Standby_Captain_1', 'Standby_Captain_2', 'Standby_First_Officer_1', 'Standby_First_Officer_2',
                "DHC_Flightcrew_1", "DHC_Flightcrew_2", "DHC_Flightcrew_3", "DHC_Flightcrew_4", "DHC_Flightcrew_5", "DHC_Flightcrew_6",
                "Cabin_Crew_1", "Cabin_Crew_2", "Cabin_Crew_3", "Cabin_Crew_4", "Cabin_Crew_5", "Cabin_Crew_6", "Cabin_Crew_7", "Cabin_Crew_8",
                "DHC_1", "DHC_2","DHC_3","DHC_4","DHC_5","DHC_6","DHC_7","DHC_8","DHC_9","DHC_10","Standby_1","Standby_2","Standby_3","Standby_4");

                $position_order = array(1, 2, 1, 2,   1, 2, 1, 2,    0,0,0,0,0,0,     1, 2, 3, 4, 5, 6 ,7 ,8,    0,0,0,0,0,0,0,0,0,0, 1,2,3,4);

                foreach ($capt_cc as $index => $value) {
                    if ($fw_flight->$value != "") {
                        $id = $this->firstLastNameSeparator($fw_flight->$value);
                        if (in_array($id, [330, 331, 332])) {
                            $crew_search = FlightCrew::where('user_id', $id)
                                           ->where('flight_id', $flight->id);

                            $flight_crew = new FlightCrew;
                            $flight_crew->flight_id = $flight->id;
                            $flight_crew->user_id = $id;

                            $position_id = UserDepartment::where('user_id', $id)->first(['position_id']);

                            if (count($position_id)) {
                                $crew_search->where('position_id',$position_id->position_id);
                                $flight_crew->position_id = $position_id->position_id;
                            }

                            if ($position_order[$index] != 0) {
                                $crew_search->where('position_order',$position_order[$index]);
                                $flight_crew->position_order = $position_order[$index];
                            }
                            if (strpos($value, 'Standby') !== FALSE) {
                                $crew_search->where('is_standby',1);
                                $flight_crew->is_standby = 1;
                            }
                            elseif (strpos($value, 'DHC') !== FALSE) {
                                $crew_search->where('is_dhc',1);
                                $flight_crew->is_dhc = 1;
                            }

                            $crew_found = $crew_search->first();
                            if (count($crew_found)){
                                // Do NOTHING
                            }
                            else {
                                $flight_crew->save();
                                //$not_found[] = $fw_flight->$value;
                            }

                        } else {
                            //$not_found[] = $fw_flight->$value;
                        }

                    }
                }
            }
            else {
                $not_found_flights[] = $fw_flight->Flight_Num."/STD: ".$std;
            }
        }
        $no_duplicates = array_unique($not_found);
        return print_r($not_found);

    }


    public function getFleetwatchcrew(){
        //$fw_flights = DB::table('fleetwatch2014')->get();
        //$fw_template = DB::table('fleet_watch')->first();
        //debug($fw_template);exit;

        $notfound = [];
        foreach($fw_flights as $j=>$fw_flight){

            $departure_date = $fw_flight->Departure_Date;
            $arrival_date = $fw_flight->Arrival_Date;

            if (isset($fw_flight->Std) && !is_null($fw_flight->Std))
                $std = $fw_flight->Std;

            if (isset($fw_flight->Sta) && !is_null($fw_flight->Sta))
                $sta = $fw_flight->Sta;

            if (isset($std))
                $std = date('Y-m-d H:i:s', strtotime($departure_date." ".$std));


            if (isset($sta)){
                $sta = date('Y-m-d H:i:s', strtotime($arrival_date." ".$sta));
            }

            if (isset($fw_flight->Rmk) && $fw_flight->Rmk != ""){
                continue;
            }
            else {
                $aircraft_id = $fw_flight->aircraft;

                if (substr($fw_flight->Flight_Num,0,2) == 'SZ' || is_numeric($fw_flight->Flight_Num)){

                    if (is_numeric($fw_flight->Flight_Num))
                        $flight_int = $fw_flight->Flight_Num;
                    else
                        $flight_int = substr($fw_flight->Flight_Num,3);

                    $dep_airport = $fw_flight->Departure_Airport;
                    $arr_airport = $fw_flight->Arrival_Airport;
                    $vip = null;
                    if ($flight_int == '001'){
                        $flight_number_check = FlightNumber::where('flight_number', $flight_int)
                            ->where('departure_airport', $dep_airport)
                            ->where('arrival_airport', $arr_airport)
                            ->whereNull("deleted_at")
                            ->first();
                    }
                    else
                        $flight_number_check = FlightNumber::where('flight_number', $flight_int)
                            ->whereNull("deleted_at")
                            ->first();

                }

                $flight = Flight::where('flight_number_id', $flight_number_check->id)
                    ->where('std', $std)
                    ->where('aircraft_id', $aircraft_id)
                    ->first();

                }

            /*$capt_cc = array("Captain_1", "Captain_2",
                "First_Officer_1", "First_Officer_2",
                "DHC_Flightcrew_1", "DHC_Flightcrew_2", "DHC_Flightcrew_3", "DHC_Flightcrew_4", "DHC_Flightcrew_5", "DHC_Flightcrew_6",
                "Cabin_Crew_1", "Cabin_Crew_2", "Cabin_Crew_3", "Cabin_Crew_4", "Cabin_Crew_5", "Cabin_Crew_6", "Cabin_Crew_7", "Cabin_Crew_8",
                "DHC_1", "DHC_2","DHC_3","DHC_4","DHC_5","DHC_6","DHC_7","DHC_8","DHC_9","DHC_10"
            );
            $position_order = array(1, 2, 1, 2, 0,0,0,0,0,0,   1, 2, 3, 4, 5, 6 ,7 ,8, 0,0,0,0,0,0,0,0,0,0 );

            $capt_cc = array("Captain_1", "Captain_2",
                "First_Officer_1", "First_Officer_2",

                "Cabin_Crew_1", "Cabin_Crew_2", "Cabin_Crew_3", "Cabin_Crew_4", "Cabin_Crew_5", "Cabin_Crew_6", "Cabin_Crew_7", "Cabin_Crew_8",

            );
            $position_order = array(1, 2, 1, 2,   1, 2, 3, 4, 5, 6 ,7 ,8 );*/

            $capt_cc = array("Captain_1", "Captain_2",  "First_Officer_1", "First_Officer_2",
                'Standby_Captain_1', 'Standby_Captain_2', 'Standby_First_Officer_1', 'Standby_First_Officer_2',
                "DHC_Flightcrew_1", "DHC_Flightcrew_2", "DHC_Flightcrew_3", "DHC_Flightcrew_4", "DHC_Flightcrew_5", "DHC_Flightcrew_6",
                "Cabin_Crew_1", "Cabin_Crew_2", "Cabin_Crew_3", "Cabin_Crew_4", "Cabin_Crew_5", "Cabin_Crew_6", "Cabin_Crew_7", "Cabin_Crew_8",
                "DHC_1", "DHC_2","DHC_3","DHC_4","DHC_5","DHC_6","DHC_7","DHC_8","DHC_9","DHC_10","Standby_1","Standby_2","Standby_3","Standby_4");

            $position_order = array(1, 2, 1, 2,   1, 2, 1, 2,    0,0,0,0,0,0,     1, 2, 3, 4, 5, 6 ,7 ,8,    0,0,0,0,0,0,0,0,0,0, 1,2,3,4);

            foreach ($capt_cc as $index=>$value){
                if ($fw_flight->$value != ""){
                    $id = $this->firstLastNameSeparator($fw_flight->$value);
                    if ($id != false){
                        $flightcrew = new FlightCrew;
                        $flightcrew->flight_id = $flight->id;

                        $flightcrew->user_id = $id;
                        $position_id = DB::table('users__departments')->where('user_id', $id)->first(['position_id']);

                        if (!empty($position_id))
                            $flightcrew->position_id =$position_id->position_id;
                        if ($position_order[$index] != 0)
                            $flightcrew->position_order = $position_order[$index];

                        if (strpos($value, 'Standby') !== FALSE){
                            $flightcrew->is_standby = 1;

                        }
                        elseif (strpos($value, 'DHC') !== FALSE){
                            $flightcrew->is_dhc = 1;
                        }
                        $flightcrew->save();
                    }
                    else
                        $notfound[] = $fw_flight->$value;

                }
            }


        }
        $no_duplicates = array_unique($notfound);

        return 'Hello';

    }


    public function getParentid(){

        $dateFrom = date("Y-01-01");
        $dateTo = date("Y-12-31");


        $flights = Flight::getParentFlights($dateFrom, $dateTo);

        foreach ($flights as $flight){
            if (is_numeric($flight->flight_number) && $flight->flight_number != '001'){
                $flight_num_inbound = FlightNumber::where('flight_number', intval($flight->flight_number + 1))
                    ->whereNull("deleted_at")
                    ->first();

                if (!empty($flight_num_inbound)){
                    $child = Flight::getChildFlight($flight_num_inbound->id, $flight->departure_date);

                    if (empty($child)){
                        if ($flight_num_inbound->flight_number != '202'){
                            $child = Flight::getChildFlight($flight_num_inbound->id, date('Y-m-d',strtotime("$flight->departure_date + 1 days")));

                            if (empty($child))
                                echo "Child Not found. PARENT = ".$flight->flight_number." | ".$flight->departure_date."<br/>";
                            else
                                Flight::where('id',$child->id)->first()->update(['parent_id'=>$flight->flight_id]);
                        }
                        else
                            echo "SZ 202 Not found. PARENT = ".$flight->flight_number." | ".$flight->departure_date."<br/>";
                    }
                    else {
                        Flight::where('id',$child->id)->first()->update(['parent_id'=>$flight->flight_id]);
                    }
                }
            }
        }
    }

    public function getReportTime(){
        $flightCrew = FlightCrew::with('flight')
            ->whereNotNull('report_time')
            ->get();

        foreach ($flightCrew as $i => $crew) {
            if ($crew->report_time == $crew->flight->std) {
                $crew->report_time = date('Y-m-d H:i:s', strtotime('- 1 hours - 15 minutes', strtotime($crew->report_time)));
                $crew->save();
            }
        }
        return "DONE";
    }

    public function getPassengerFlight(){
        DB::connection()->disableQueryLog();
        $notFound = 0;
        $type = 2;
        switch ($type){
            case 1:
                $passenger_flights = PassengerFlight::whereNull('updated_by')
                                                    ->whereNull('flight_id')
                                                    ->limit(300000)
                                                    ->get(['id', 'flight_number_id', 'departure']);
                foreach ($passenger_flights as $i=>$each) {
                    $flight = Flight::where('flight_number_id', $each->flight_number_id)
                                    ->where(DB::raw('DATE(std)'), date('Y-m-d', strtotime($each->departure)))
                                    ->first(['id']);
                    if ($flight) {
                        $passenger_flights[$i]->flight_id = $flight->id;
                    }
                    else{
                        $passenger_flights[$i]->updated_by = 404;
                        $notFound++;
                    }
                    $passenger_flights[$i]->save();
                }
            break;

            case 2:
                $passenger_flights = PassengerFlight::where('updated_by', 404)
                                                    ->whereNull('flight_id')
                                                    ->limit(300000)
                                                    ->get(['id', 'flight_number_id', 'departure']);
                foreach ($passenger_flights as $i=>$each) {
                    $departure = $each->departure;
                    $beforeDepDate = date('Y-m-d', strtotime('-1 day', strtotime($departure)));
                    $afterDepDate = date('Y-m-d', strtotime('+1 day', strtotime($departure)));

                    $flight = Flight::where('flight_number_id', $each->flight_number_id)
                        ->whereIn(DB::raw('DATE(std)'), [ $beforeDepDate, $afterDepDate ])
                        ->orderBy('std', 'ASC')
                        ->first(['id']);

                    if ($flight) {
                        $passenger_flights[$i]->flight_id = $flight->id;
                        $passenger_flights[$i]->updated_by = NULL;
                    } else {
                        $passenger_flights[$i]->updated_by = 505;
                        $notFound++;
                    }
                    $passenger_flights[$i]->save();
                }
            break;
        }

        debug($notFound);
        return "DONE";

    }

    protected function firstLastNameSeparator($name){
        $name_new = explode(" ",$name);
        $last_name = $name_new[0];
        if (isset($name_new[1])){
            $first_name = $name_new[1];
            if (substr($first_name, -1) == '.') {
                $first_name = substr($first_name, 0, strlen($first_name)-1);
            }

            $find_user = User::where("last_name", $last_name)
                ->where("first_name",'LIKE',"$first_name")
                ->get(['id']);

            if ($find_user->isEmpty()) {
                $find_user = User::where("last_name", $last_name)
                    ->where("first_name", 'LIKE', "$first_name%")
                    ->get(['id']);
            }

            if ($find_user->isEmpty() && strlen($first_name) > 3){
                $first_name_part = substr($first_name, 0, 3);
                $find_user = User::where("last_name", $last_name)
                    ->where("first_name",'LIKE',"$first_name_part%")
                    ->get(['id']);

                if ($find_user->isEmpty()){
                    $find_user = User::where("last_name",'LIKE', "$first_name%")
                        ->where("first_name",'LIKE',"$last_name")
                        ->get(['id']);
                }
            }

            if ($find_user->isEmpty()){
                $find_user = User::whereNotNull('last_name_prev')
                    ->whereNotNull('first_name_prev')
                    ->where("last_name_prev", $last_name)
                    ->where("first_name_prev",'LIKE',"$first_name%")
                    ->get(['id']);
            }
        }
        else
            $find_user = User::where("last_name",$last_name)->get(['id']);

        if ($find_user->count() > 1 || $find_user->isEmpty())
            return false;
        else
            return $find_user->first()->id;
    }

    public function getDelay(){
        $delay[1]="Lack of or late boarding busses"; //01;
        $delay[2]="Repercussion technical problem on previous flight or other aircraft in the fleet"; //02;
        $delay[5]="Stand-by delay code while delay code under investigation"; //05;
        $delay[6]="No gate/stand availability due to own airline activity"; //06;
        $delay[9]="Scheduled ground time less than declared minimum ground time"; //09;
        $delay[11]="Late Check-in, acceptance of passengers after deadline"; //11;
        $delay[12]="Late Check-in, congestion in check-in area"; //12;
        $delay[13]="Check-in error"; //13;
        $delay[14]="Oversales, booking errors"; //14;
        $delay[15]="Boarding, discrepancies and paging, missing checked-in passenger at gate"; //15;
        $delay[16]="Commercial Publicity, Passenger Convenience, VIP, Press, Ground meals and missing personal items"; //16;
        $delay[17]="Catering order, late or incorrect order given to supplier"; //17;
        $delay[18]="Baggage processing, sorting, etc."; //18;
        $delay[21]="Documentation, errors, etc."; //21;
        $delay[22]="Late positioning"; //22;
        $delay[23]="Late acceptance"; //23;
        $delay[24]="Inadequate packing"; //24;
        $delay[25]="Oversales, booking errors"; //25;
        $delay[26]="Late preparation in warehouse"; //26;
        $delay[27]="Mail Oversales, packing, etc."; //27;
        $delay[28]="Mail Late positioning"; //28;
        $delay[29]="Mail Late acceptance"; //29;
        $delay[31]="Aircraft documentation late or inaccurate, weight and balance (Loadsheet), general declaration, passenger manifest, etc."; //31;
        $delay[32]="Loading, Unloading, bulky/special load, cabin load, lack of loading staff"; //32;
        $delay[33]="Loading Equipment, lack of or breakdown, e.g. container pallet loader, lack of staff"; //33;
        $delay[34]="Servicing Equipment, lack of or breakdown, lack of staff, e.g. steps"; //34;
        $delay[35]="Aircraft Cleaning"; //35;
        $delay[36]="Fuelling, Defuelling, fuel supplier"; //36;
        $delay[37]="Catering, late delivery or loading"; //37;
        $delay[38]="ULD, Containers, pallets, lack of or breakdown"; //38;
        $delay[39]="Technical equipment, lack of or breakdown, lack of staff, e.g. push-back"; //39;
        $delay[41]="Aircraft defects"; //41;
        $delay[42]="Scheduled maintenance, late release"; //42;
        $delay[43]="Non-scheduled maintenance, special checks and / or additional works beyond normal maintenance"; //43;
        $delay[44]="Spares and maintenance equipment, lack of or breakdown"; //44;
        $delay[45]="AOG (Aircraft on ground for technical reasons) Spares, to be carried to another station"; //45;
        $delay[46]="Aircraft change for technical reasons"; //46;
        $delay[47]="Standby aircraft, lack of planned standby aircraft for technical reasons"; //47;
        $delay[48]="Scheduled cabin configuration and version adjustments"; //48;
        $delay[51]="Damage during flight operations, bird or lightning strike, turbulence, heavy oroverweight landing"; //51;
        $delay[52]="Damage during ground operations, collisions (other than during taxiing, loading/offloading damage, contamination, towing, extreme weather conditions"; //52;
        $delay[55]="Departure Control System, Check-in, weight and balance (loadcontrol), computer system error, baggage sorting, gate-reader error or problems"; //55;
        $delay[56]="Cargo preparation/documentation system"; //56;
        $delay[57]="Flight plans"; //57;
        $delay[58]="Other computer systems"; //58;
        $delay[61]="Flight plan, late completion or change of flight documentation"; //61;
        $delay[62]="Operational requirements, fuel, load alteration"; //62;
        $delay[63]="Late crew boarding or departure procedures"; //63;
        $delay[64]="Flight deck crew shortage, Crew rest"; //64;
        $delay[65]="Flight deck crew special request or error"; //65;
        $delay[66]="Late cabin crew boarding or departure procedures"; //66;
        $delay[67]="Cabin crew shortage"; //67;
        $delay[68]="Cabin crew error or special request"; //68;
        $delay[69]="Captain request for security check, extraordinary"; //69;
        $delay[71]="Departure station"; //71;
        $delay[72]="Destination station"; //72;
        $delay[73]="En-route or Alternate"; //73;
        $delay[75]="De-Icing of aircraft, removal of ice/snow, frost prevention"; //75;
        $delay[76]="Removal of snow/ice/water/sand from airport/runway"; //76;
        $delay[77]="Ground handling impaired by adverse weather conditions"; //77;
        $delay[81]="ATC restriction en-route or capacity"; //81;
        $delay[82]="ATC restriction due to staff shortage or equipment failure en-route"; //82;
        $delay[83]="ATC restriction at destination"; //83;
        $delay[84]="ATC restriction due to weather at destination"; //84;
        $delay[85]="Mandatory security"; //85;
        $delay[86]="Immigration, Customs, Health"; //86;
        $delay[87]="Airport Facilities, parking stands, ramp congestion, buildings, gate limitations, ..."; //87;
        $delay[88]="Restrictions at airport of destination, airport/runway closed due obstruction, industrial action, staff shortage, political unrest, noise abatement, night curfew, special flights, ..."; //88;
        $delay[89]="Restrictions at airport of departure, airport/runway closed due obstruction, industrial action, staff shortage, political unrest, noise abatement, night curfew, special flights,start-up and pushback, ..."; //89;
        $delay[91]="Passenger or Load Connection, awaiting load or passengers from another flight.Protection of stranded passengers onto a new flight."; //91;
        $delay[92]="Through Check-in error"; //92;
        $delay[93]="Aircraft rotation"; //93;
        $delay[94]="Cabin crew rotation"; //94;
        $delay[95]="Crew rotation (entire or cockpit crew)"; //95;
        $delay[96]="Operations control, rerouting, diversion, consolidation, aircraft change for reasons other than technical"; //96;
        $delay[97]="Industrial action within own airline"; //97;
        $delay[98]="Industrial action outside own airline"; //98;
        $delay[99]="Miscellaneous, not elsewhere specified"; //99;

        foreach ($delay as $index=>$value){
            $input = new Delay();
            $input->code = $index;
            $input->description = $value;
            $input->save();
        }

        return "Success";
    }


    public function nextAvailableSeat(&$seats, $cabin){
        foreach ($seats[$cabin] as $i => $each) {
            if ($each["status"] == 0){
                $seats[$cabin][$i]["status"] = 1;
                return $each["seat"];
            }
        }
        return false;
    }

    public function emptyOutSeats(&$seats){
        foreach ($seats as $i => $cabin) {
            foreach ($cabin as $j => $each) {
                $seats[$i][$j]["status"] = 0;
            }
        }
    }

    public  function baggagePcsAndWeight(){
        $pcs = [0,0,0,0,0,0,0, 1,1,1,1,1,1,1,1,1,1,1,1,1, 2,2,2,2,2,2,2,2,2,2, 3,3,3,3, 4,4, 5];
        $i = array_rand($pcs);

        $weight = rand($pcs[$i] * 10, $pcs[$i] * 20);

        // 000073547;000073548

        $tagNumber = null;
        if ($pcs[$i] > 0){
            $tagNumber = "";
            $random = rand(1000000, 9999999);
            for ($j = 1; $j <= $pcs[$i]; $j++){
                $tagNumber .= "00".$random++.";";
            }
            $tagNumber = rtrim($tagNumber, ";");
        }

        return [$pcs[$i], $weight, $tagNumber];
    }

    public function dobRandom(){
        $year = rand(1950, 1995);
        $month = rand(1, 12);
        $day = rand(1, 28);

        return $year."-".$month."-".$day;
    }

    public function genderRandom(){
        $gender = ['male', 'male','male','female'];
        $i = array_rand($gender);
        return $gender[$i];
    }

    public function getStaff(){
        $staffList = DB::table("users__staff")->get();

        debug($staffList);

        foreach ($staffList as $each) {
            $position = $userDep = $dep = null;

            $user = User::where("first_name", $each->first_name)
                            ->where("last_name", $each->last_name)
                            ->first();

            if (!$user){
                $user = new User();
            }

            $user->first_name = $each->first_name;
            $user->last_name = $each->last_name;
            $user->dob = $each->dob;
            $user->doj   = $each->doj;
            $user->staff_number = $each->staff_num;

            $user->cost_center = $each->cost_center;
            $user->min_hours = $each->min_contract_hours ? intval($each->min_contract_hours) : null;
            $user->max_hours = $each->max_hours ? intval($each->max_hours) : null;
            $user->company = $each->company;

            if ($each->location){
                $airport = Airport::where("iata", $each->location)
                                    ->first();

                if ($airport) {

                    $location = Location::where("airport_id", $airport->id)
                                        ->first();

                    if (!$location) {
                        $location = new Location();
                        $location->airport_id = $airport->id;
                        $location->city_id = $airport->city_id;
                        $location->save();
                    }

                    $user->location_id = $location->id;
                }
            }

            $user->save();

            if ($each->company){
                $dep = Department::where("name",$each->company)
                    ->first();

                if (!$dep){
                    $dep = new Department();
                    $dep->name = $each->company;
                    $dep->save();
                }
            }
            else {
                $dep = Department::find(7);
            }

            if ($each->position) {
                $position = Position::where("name", $each->position)
                    ->first();

                if (!$position) {
                    $position = new Position();
                    $position->name = $each->position;
                }

                $position->department_id = $dep->id;
                $position->save();
            }

            $userDep = UserDepartment::where('user_id', $user->id)
                                        ->first();



            if (!$userDep){
                $userDep = new UserDepartment();
                $userDep->user_id = $user->id;
            }

            $userDep->position_id = isset($position) ? $position->id : null;
            $userDep->department_id = $dep->id;
            $userDep->save();
        }

        return 1;
    }

    public function getFillInfo()
    {
        if (env("AIRLINE") != "Emirates"){
            return "NOT ALLOWED";
        }

        $departureDate = \request("departure_date");

        $flights = PassengerFlight::where("departure_date", $departureDate)
            ->groupBy("flight_id")
            ->get(['flight_id']);

        $seatEconomyLetters = ["A", "B", "C", "D", "E", "F"];
        $seatBusinessLetters = ["A", "C", "D", "F"];

        $boeingSeats = ["business" => [], "economy" => []];
        $airbusSeats = ["economy" => []];
        $embraerSeats = ["economy" => []];

        // BOEING
        for ($j = 1; $j <= 4; $j++) {
            foreach ($seatBusinessLetters as $letter) {
                $boeingSeats["business"][] = ["seat" => $j . $letter, "status" => 0];
            }
        }

        for ($j = 5; $j <= 32; $j++) {
            foreach ($seatEconomyLetters as $letter) {
                $boeingSeats["economy"][] = ["seat" => $j . $letter, "status" => 0];
            }
        }

        shuffle($boeingSeats["business"]);
        shuffle($boeingSeats["economy"]);

        // AIRBUS
        for ($j = 1; $j <= 32; $j++) {
            foreach ($seatEconomyLetters as $letter) {
                if ($j == 1 && in_array($letter, ["D", "E", "F"])) {
                    continue;
                }
                $airbusSeats["economy"][] = ["seat" => $j . $letter, "status" => 0];
            }
        }
        shuffle($airbusSeats["economy"]);

        // EMBRAER
        for ($j = 1; $j <= 24; $j++) {
            foreach ($seatEconomyLetters as $letter) {
                if ($j == 12 && in_array($letter, ["A", "F"])) {
                    continue;
                }
                $embraerSeats["economy"][] = ["seat" => $j . $letter, "status" => 0];
            }
        }
        shuffle($embraerSeats["economy"]);

        foreach ($flights as $each) {

            $this->emptyOutSeats($boeingSeats);
            $this->emptyOutSeats($airbusSeats);
            $this->emptyOutSeats($embraerSeats);

            shuffle($boeingSeats["business"]);
            shuffle($boeingSeats["economy"]);

            shuffle($airbusSeats["economy"]);

            shuffle($embraerSeats["economy"]);

            // Get all Passengers
            $passFlights = PassengerFlight::with(['passenger'])
                ->join('flights', 'passengers__flights.flight_id', '=', 'flights.id')
                ->join('aircraft', 'flights.aircraft_id', '=', 'aircraft.id')
                ->where("flight_id", $each->flight_id)
                ->whereNotIn('flight_order_status_id', [2, 7, 9])
                ->orderBy("fare", "desc")
                ->get(["passengers__flights.id", "aircraft_id", "passenger_id", "flight_cabin_id"]);

            foreach ($passFlights as $j => $pass) {

                // Boeing 737-900
                if (in_array($pass->aircraft_id, [1, 2])) {
                    // Business
                    if ($pass->flight_cabin_id == 2) {
                        $passFlights[$j]->seat_number = $this->nextAvailableSeat($boeingSeats, "business");
                    } // Economy
                    else if ($pass->flight_cabin_id == 1) {
                        $passFlights[$j]->seat_number = $this->nextAvailableSeat($boeingSeats, "economy");
                    } //Infant
                    else {
                        $passFlights[$j]->is_inf = 1;
                    }
                }
                // Airbus
                else if (in_array($pass->aircraft_id, [3, 4])) {
                    // Economy
                    if ($pass->flight_cabin_id == 1) {
                        $passFlights[$j]->seat_number = $this->nextAvailableSeat($airbusSeats, "economy");
                    } //Infant
                    else {
                        $passFlights[$j]->is_inf = 1;
                    }
                }
                // Embraer
                else if (in_array($pass->aircraft_id, [5, 6])) {
                    // Economy
                    if ($pass->flight_cabin_id == 1) {
                        $passFlights[$j]->seat_number = $this->nextAvailableSeat($embraerSeats, "economy");
                    } //Infant
                    else {
                        $passFlights[$j]->is_inf = 1;
                    }
                }

                if (!$passFlights[$j]->is_inf) {
                    list($pcs, $weight, $tn) = $this->baggagePcsAndWeight();
                    $passFlights[$j]->baggage_pcs = $pcs ? $pcs : null;
                    $passFlights[$j]->baggage_weight = $weight ? $weight : null;
                    $passFlights[$j]->tag_number = $tn ? $tn : null;
                }

                if (!$passFlights[$j]->is_inf && !$passFlights[$j]->seat_number){
                    $passFlights[$j]->seat_number = null;
                    $passFlights[$j]->baggage_pcs = null;
                    $passFlights[$j]->baggage_weight = null;
                    $passFlights[$j]->tag_number = null;
                    $passFlights[$j]->save();

                    continue;
                }

                $passFlights[$j]->save();

                if ($pass->passenger){
                    if (!$pass->passenger->dob || $pass->passenger->dob = "0000-00-00"){
                        $pass->passenger->dob = $this->dobRandom();
                    }
                    if (!$pass->passenger->gender){
                        $pass->passenger->gender = $this->genderRandom();
                    }
                    $pass->passenger->save();
                }
            }
        }

        return "DONE";
    }


    function getAircraftName(){
        $countryAircraftCodes = getCountryAircraftCodes();

        $aircraft = Aircraft::get();

        foreach ($aircraft as $j => $ac) {
            $name = partitionAircraftCode($ac->mvt_name, $countryAircraftCodes);
            if ($name){
                $aircraft[$j]->name = $name;
                $aircraft[$j]->save();
            }
        }
        return 1;
    }

}
