<?php namespace App\Http\Controllers;
/**
 * Created by PhpStorm.
 * User: CDP1
 */

use App\Models\FinancialReportCategory;
use App\Models\FinancialReportData;
use App\Models\FinancialReportVariable;

use App\Models\FlightNumber;
use App\Models\FinancialReport;

class FinanceController extends Controller {

    public function getIndex(){
        $flight_number = (\request("flight_number")) ? \request("flight_number") : null;
        $sector = (\request("sector")) ? \request("sector") : null;
        $month = (\request("month")) ? \request("month") : null;
        $year = (\request("year")) ? \request("year") : null;
        $period = (\request("period")) ? \request("period") : null;
        $airport = (\request("airport")) ? \request("airport") : null;

        $sectors      = FlightNumber::getArraySectors();
        $flight_numbers = FlightNumber::getArrayFlightNumbers();

        $date_from = (\request("from_date")) ? \request("from_date") : null;//date('Y-01-01');
        $date_to = (\request("to_date")) ? \request("to_date") : null;//date('Y-01-01');
        $period = (\request("period")) ? \request("period") : null;

        $report_type = (\request("report_type")) ? \request("report_type") : "None";//date('Y-01-01');
        $comparison_years = [2014, 2013];

        $reports = FinancialReport::orderBy('id')->pluck('name','id')->all();
        $reports = str_replace("_", " ", $reports);

        //$report_data = [];

        $report_data = FinancialReport::with('reportCategory')->orderBy('id')->get();

        // Index with Division by 2 Has Multiply to (x 1000)
        $sub_categories = [
            50=> [2 => 'Traffic_Revenue',   4 => 'Contribution_1',    6 => 'Contribution_2', 8 => 'Contribution_3'],
            60=> [2 => 'Traffic_Revenue',   4 => 'Contribution_1',    6 => 'Contribution_2', 8 => 'Contribution_3'],
            70=> [2 => 'Passenger_Revenue', 3 => 'Variance_Volume',   5 => 'Variance_Yield', 7 => 'Average_Fare',    9 => 'Yield_Per_RPK'],
            80=> [2 => 'Revenue_PAX_Km',    4 => 'Available_Seat_Km', 5 => 'Passenger_Seat_Factor'],
            110=>[1 => 'Passenger_Numbers', 3 => 'Excess_Baggage',    5 => 'Landings',       7 => 'Flight_Hours']
        ];

        $international = FlightNumber::arrayFlightNumbersRoutesByRegion('International', 'Scheduled', '0');
        $cis = FlightNumber::arrayFlightNumbersRoutesByRegion('CIS', 'Scheduled', '0');
        $domestic = FlightNumber::arrayFlightNumbersRoutesByRegion('Domestic', 'Scheduled');
        $charter = FlightNumber::arrayFlightNumbersRoutesByRegion('CIS', 'Charter', '0');
        $maintenance = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, '0', 'Maintenance');
        $tajikair = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, '0', 'Tajik Air');
        $vip = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, null, 'VIP');
        $all_flights = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, '0', null, 1);

        $flight_types = ['International' => $international, 'CIS' => $cis, 'Domestic' => $domestic, 'Charter' => $charter,
            'Technical' => $maintenance, 'Tajik_Air' => $tajikair, 'VIP_Charter' => $vip, 'All' => $all_flights];

        $this->viewData = [
            'sub_categories' =>$sub_categories,
            'flight_types' => $flight_types,
            'reports' => $reports,
            'sector' => $sector,
            'sectors' => $sectors,
            'airport' => $airport,
            'airports' => FlightNumber::distinct('departure_airport')
                                        ->whereNull("deleted_at")
                                        ->orderBy('departure_airport')
                                        ->pluck('departure_airport', 'departure_airport')
                                        ->all(),
            'flight_number' => $flight_number,
            'flight_numbers' => $all_flights,
            'comparison_years' => $comparison_years,
            'report_type'=>$report_type,
            'report_types'=>['None', 'Country', 'Route', 'POS'],
            'date_from'=>$date_from,
            'date_to'=>$date_to,
            'booked_flights' =>  isset($booked_flights) ? $booked_flights : null,
            'final_data' => isset($final_data) ? $final_data : null,
            'period' => isset($period) ? $period : 'None',
            'weekday' => ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
            'month' => isset($month) ? $month : null,
            'months' => [1 => "Jan", 2 => "Feb", 3 => "Mar", 4 => "Apr", 5 => "May", 6 => "Jun", 7 => "Jul", 8 => "Aug", 9 => "Sep", 10 => "Oct", 11 => "Nov", 12 => "Dec"],
            'month_names' => [1 => "January", 2 => "February", 3 => "March", 4 => "April", 5 => "May", 6 => "June", 7 => "July", 8 => "August", 9 => "September", 10 => "October", 11 => "November", 12 => "December"],
            'year' => isset($year) ? $year : null,
            'years' => [2014=>2014, 2013=>2013],
            'final_category' => (isset($final_category) ? $final_category : null),
            'report_data' => $report_data
        ];

        return view('finance.index', $this->viewData);
    }


    public function getReport(){
        $flight_number = (\request("flight_number")) ? \request("flight_number") : null;
        $sector = (\request("sector")) ? \request("sector") : null;
        $month = (\request("month")) ? \request("month") : null;
        $year = (\request("year")) ? \request("year") : null;
        $period = (\request("period")) ? \request("period") : null;
        $airport = (\request("airport")) ? \request("airport") : null;

        $sectors      = FlightNumber::getArraySectors();
        $flight_numbers = FlightNumber::getArrayFlightNumbers();

        $date_from = (\request("from_date")) ? \request("from_date") : null;//date('Y-01-01');
        $date_to = (\request("to_date")) ? \request("to_date") : null;//date('Y-01-01');
        $period = (\request("period")) ? \request("period") : null;

        $report_type = (\request("report_type")) ? \request("report_type") : "None";//date('Y-01-01');
        $comparison_years = [2014, 2013];

        $international = FlightNumber::arrayFlightNumbersRoutesByRegion('International', 'Scheduled', '0');
        $cis = FlightNumber::arrayFlightNumbersRoutesByRegion('CIS', 'Scheduled', '0');
        $domestic = FlightNumber::arrayFlightNumbersRoutesByRegion('Domestic', 'Scheduled');
        $charter = FlightNumber::arrayFlightNumbersRoutesByRegion('CIS', 'Charter', '0');
        $maintenance = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, '0', 'Maintenance');
        $tajikair = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, '0', 'Tajik Air');
        $vip = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, null, 'VIP');
        $all_flights = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, '0', null, 1);

        $flight_types = ['International' => $international, 'CIS'=>$cis, 'Domestic'=> $domestic, 'Charter'=>$charter,
            'Technical'=>$maintenance, 'Tajik_Air' =>$tajikair, 'VIP_Charter'=>$vip, 'All' => $all_flights];

        $reports = FinancialReport::orderBy('id')->pluck('name','id')->all();
        $reports = str_replace("_", " ", $reports);

        $report_final = [];
        foreach($reports as $id=>$report){
            $report_all = new \stdClass();
            $report_all->id = $id;
            $report_all->name = $report;
            $categories = FinancialReport::find($id)->reportCategory()->pluck('name','id')->all();
            $categories_final = [];
            foreach ($categories as $i=>$category) {
                $category_all = new \stdClass();
                $category_all->id = $i;
                $category_all->name = str_replace("_", " ", $category);
                if (in_array($report_all->id,[50, 70, 80, 110])){
                    $variables = $flight_types[$category];
                }
                else
                    $variables = FinancialReportCategory::find($i)->reportVariable()->orderBy('id')->pluck('name','id')->all();

                $variable_final = [];
                foreach ($variables as $j=>$variable) {
                    $variable_all = new \stdClass();
                    $variable_all->id = $j;
                    $variable_all->name = str_replace("_", " ", $variable);
                    $variable_final[] = $variable_all;
                }
                $category_all->variable = $variable_final;
                $categories_final[] = $category_all;
            }
            $categories_final = str_replace("_", " ", $categories_final);

            $report_all->category = $categories_final;
            $report_final[] = $report_all;
            //$reports = str_replace("_", " ", $reports);
        }

        $categories = FinancialReportCategory::orderBy('id')->pluck('name','id');
        $categories = str_replace("_", " ", $categories);

        $variables = FinancialReportVariable::orderBy('id')->pluck('name','id');
        $variables = str_replace("_", " ", $variables);


        $report_data = FinancialReport::orderBy('id')->pluck('name', 'id')->all();


        $sub_categories = [
            50=>['Traffic_Revenue', 'Contribution_1', 'Contribution_2', 'Contribution_3'],
            60=>['Traffic_Revenue', 'Contribution_1', 'Contribution_2', 'Contribution_3'],
            70=>['Passenger_Revenue','Variance_Volume', 'Variance_Yield', 'Average_Fare', 'Yield_Per_RPK'],
            80=>['Revenue_PAX_Km', 'Available_Seat_Km', 'Passenger_Seat_Factor'],
            110=>['Passenger_Numbers', 'Excess_Baggage', 'Landings', 'Flight_Hours']
        ];

        $this->viewData = [
            'period_labels' => [2=> 'Monthly', 1=>'Quarterly', 0=>'Yearly'],
            'categories' => $categories,
            'sub_categories' =>$sub_categories,
            'flight_types' => $flight_types,
            'reports' => $reports,
            'sector' => $sector,
            'sectors' => $sectors,
            'airport' => $airport,
            'airports' => FlightNumber::distinct('departure_airport')
                                        ->whereNull("deleted_at")
                                        ->orderBy('departure_airport')
                                        ->pluck('departure_airport', 'departure_airport')
                                        ->all(),
            'flight_number' => $flight_number,
            'flight_numbers' => $flight_numbers,
            'comparison_years' => $comparison_years,
            'report_type'=>$report_type,
            'report_types'=>['None', 'Country', 'Route', 'POS'],
            'date_from'=>$date_from,
            'date_to'=>$date_to,
            'booked_flights' =>  isset($booked_flights) ? $booked_flights : null,
            'final_data' => isset($final_data) ? $final_data : null,
            'period' => isset($period) ? $period : 'None',
            'weekday' => ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
            'month' => isset($month) ? $month : null,
            'months' => [1 => "Jan", 2 => "Feb", 3 => "Mar", 4 => "Apr", 5 => "May", 6 => "Jun", 7 => "Jul", 8 => "Aug", 9 => "Sep", 10 => "Oct", 11 => "Nov", 12 => "Dec"],
            'month_names' => [1 => "January", 2 => "February", 3 => "March", 4 => "April", 5 => "May", 6 => "June", 7 => "July", 8 => "August", 9 => "September", 10 => "October", 11 => "November", 12 => "December"],
            'year' => isset($year) ? $year : null,
            'years' => [2014=>2014, 2013=>2013],
            'final_category' => (isset($final_category) ? $final_category : null),
            'report_final' => $report_final
        ];

        return view('finance.report', $this->viewData);
    }

    public function getAjaxtypeselect(){
        $type_select = \request("type_select");
        $id = \request("id");

        if ($type_select == 'Report') {
            $selected = FinancialReportCategory::select(['id', 'name'])->whereIn('report_id', $id)->groupBy('name')->pluck('name', 'id')->all();
        }
        elseif ($type_select == 'Category'){
            $collection_ids = []; $selected_add = [];$selected = [];$i = 0;
            foreach ($id as $each_id){
                if(($each_id >= 20 && $each_id <= 52))
                    $collection_ids_fn[] = $each_id;
                else
                    $collection_ids[] = $each_id;
            }

            if (!empty($collection_ids)) {
                $select_1 = FinancialReportVariable::select(['id', 'name'])->whereIn('category_id', $collection_ids)->pluck('name', 'id')->all();
                $select_1cat = FinancialReportVariable::select(['category_id'])->whereIn('category_id', $collection_ids)->pluck('category_id')->all();
                foreach ($select_1cat as $each) {
                    $category_id[] = null;
                }
            }

            if (!empty($collection_ids_fn)) {
                foreach ($collection_ids_fn as $item_id) {
                    if (in_array($item_id, [20, 32, 39, 46])) // International
                        $selected_add[$i] = FlightNumber::arrayFlightNumbersRoutesByRegion('International', 'Scheduled', '0', null,1);
                    else if (in_array($item_id, [21, 33, 40, 47])) //CIS
                        $selected_add[$i] = FlightNumber::arrayFlightNumbersRoutesByRegion('CIS', 'Scheduled', '0', null,1);
                    else if (in_array($item_id, [41, 48, 22, 34])) //Domestic
                        $selected_add[$i] = FlightNumber::arrayFlightNumbersRoutesByRegion('Domestic', 'Scheduled', null,null, 1);
                    else if (in_array($item_id, [23, 42, 35, 49])) //Charter
                        $selected_add[$i] = FlightNumber::arrayFlightNumbersRoutesByRegion('CIS', 'Charter', '0', 1,1);
                    else if (in_array($item_id, [51, 44, 25, 37])) //technical
                        $selected_add[$i] = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, '0', 'Maintenance', 1);
                    else if (in_array($item_id, [52, 38, 26, 45])) //tajik air
                        $selected_add[$i] = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, '0', 'Tajik Air', 1);
                    else if (in_array($item_id, [43, 24, 50, 36])) //VIP
                        $selected_add[$i] = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, null, 'VIP', 1);
                    else if (in_array($item_id,[27,28,29]))
                        $selected_add[$i] = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, '0', null, 1);
                    else if (in_array($item_id,[30,31]))
                        $selected_add[$i] = FlightNumber::arrayFlightNumbersRoutesByRegion(null, null, '0', 'Tajik Air', 1);

                    foreach ($selected_add[$i] as $each) {
                        $category_id[] = $item_id;
                    }

                    $i++;
                }
            }

            if (!empty($selected_add)) {
                foreach ($selected_add as $each) {
                    foreach ($each as $id => $name)
                        $select_2['fn'.$id] = $name;
                }
            }

            //_debug($select_2);


            if (isset($select_1) && isset($select_2))
                $selected = $select_1 + $select_2;
            else {
                if (isset($select_1))
                    $selected = $select_1;
                else
                    $selected = $select_2;
            }
        }

        $selected = str_replace("_", " ", $selected);

        $data = [$selected];

        if (!empty($category_id))
            $data[] = $category_id;

        return response()->json($data);
    }


    /*
     * RETRIEVE DATA FROM FINANCE
     */
    public function postAjaxsearchdata(){
        $hasVariableId = false;
        $hasFlightNumber = false;
        $year = \request("year");
        $period = \request("period");
        $date = \request("date");
        $report = \request("report");
        $category = \request("category");
        $variable = \request("variable");
        $variable_category = \request("variable_category");

        $reportVariables = [
            10   => ['SUM(default_value) AS Revenue'],
            20   => ['SUM(default_value) AS Revenue'],
            21   => ['SUM(default_value) AS Revenue'],
            30   => ['SUM(default_value) AS Revenue'],
            40   => ['SUM(default_value) AS Revenue'],
            50   => ['SUM(traffic_revenue) AS Traffic_Revenue'    , 'SUM(contribution_1) AS Contribution_1', 'SUM(contribution_2) AS Contribution_2', 'SUM(contribution_3) AS Contribution_3'  ],
            60   => ['SUM(traffic_revenue) AS Traffic_Revenue'    , 'SUM(contribution_1) AS Contribution_1' , 'SUM(contribution_2) AS Contribution_2' , 'SUM(contribution_3) AS Contribution_3'  ],
            70   => ['SUM(passenger_revenue) AS Passenger_Revenue', 'SUM(variance_volume) AS Variance_Volume', 'variance_yield' , 'average_fare', 'yield_per_rpk'],
            80   => ['SUM(revenue_pax_km) AS RPK'                 , 'SUM(available_seat_km) AS ASK', 'passenger_seat_factor AS Passenger_SF'                                   ],
            110  => ['SUM(passenger_numbers) AS Passenger_No'     , 'SUM(excess_baggage) AS Excess_Baggage' , 'SUM(landings) AS Landings' , 'SUM(flight_hours) AS Flight_Hours'                 ]
        ];

        $selectVariables = [];
        foreach ($report as $id) {
            $selectVariables = array_merge($selectVariables, $reportVariables[$id]);
        }

        $select = ['s_finance__reports_data.report_id', 's_finance__reports_data.category_id','s_finance__reports_data.variable_id'];

        foreach ($variable_category as $i=>$each) {
            if ($each == 'null'){
                $hasVariableId = true;
                $containing_id[] = $variable[$i];
            }
            else{
                $hasFlightNumber = true;
                $flight_number[] = substr($variable[$i],2); // Flight Number comes with 'fn' - prefix thus cut first 2 chars
            }
        }

        $selectPeriod = 'date';
        $selectPeriod = groupSelectionNonComparison($period, 'date');
        switch ($period){
            case 2:
                $selectPeriod = "DATE_FORMAT(date, '%c, %Y')";
                break;
        }

        if ($hasVariableId){
            $data[] = FinancialReportData::selectRaw("name, $selectPeriod AS period, ".implode(', ', $select).",".implode(', ', $selectVariables))
                    ->leftJoin('finance__reports_variables', 'finance__reports_variables.id', '=', 'variable_id')
                    ->whereIn('variable_id', $containing_id)
                    ->whereIn('date', $date)
                    ->orderBy('period')
                    ->groupBy('period')
                    ->groupBy('name')
                    ->get()
                    ->toArray();
        }

        if ($hasFlightNumber){
            // All Flights Except VIP
            $data[] = FinancialReportData::selectRaw("CONCAT('SZ ', s_finance__reports_data.flight_number,' | ', departure_airport,'-', arrival_airport) as name , $selectPeriod AS period, ".implode(',', $select).", ".implode(',', $selectVariables))
                ->join('flights__numbers', 'flights__numbers.flight_number','=', 'finance__reports_data.flight_number')
                ->join('flights__types', 'flights__numbers.flight_type_id','=', 'flights__types.id')
                ->whereIn('date', $date)
                ->where("type", 'VIP Charter')
                ->whereIn('finance__reports_data.report_id',$report)
                ->whereIn('finance__reports_data.flight_number', $flight_number)
                ->orderBy('period')
                ->groupBy('period')
                ->groupBy('name')
                ->get()
                ->toArray();

            // VIP Flights SZ 001
            if (in_array('001', $flight_number)) {
                $data[] = FinancialReportData::selectRaw("'SZ 001 LITER' as name , $selectPeriod AS period, " . implode(',', $select) . ", " . implode(',', $selectVariables))
                    ->whereIn('date', $date)
                    ->where('finance__reports_data.flight_number', '001')
                    ->whereIn('finance__reports_data.report_id', $report)
                    ->orderBy('period')
                    ->groupBy('period')
                    ->groupBy('name')
                    ->get()
                    ->toArray();
            }
        }

        $records = [];
        $notIncluded = ['name', 'period', 'report_id', 'category_id', 'variable_id'];

        $availablePeriods = [];

        foreach ($data as $each_data) {
            foreach ($each_data as $each) {
                switch ($period){
                    case 2 :    // Monthly
                        $date = \DateTime::createFromFormat("d, Y", $each['period']);
                        $month = $date->format('j');
                        $year = $date->format('Y');
                        $availablePeriods[$month] = true;
                        break;
                    case 1 :    // Quarterly
                        $date = \DateTime::createFromFormat("d, Y", $each['period']);
                        $month = $date->format('j');
                        $year = $date->format('Y');
                        $availablePeriods[$month] = true;
                        break;
                    case 0 :    // Yearly
                        $date = \DateTime::createFromFormat("Y", $each['period']);
                        $month = 1;
                        $year = $date->format('Y');
                        $availablePeriods[$year] = true;
                        break;
                }

                foreach ($each as $variable => $value) {
                    if (!isset($record[$each['name']][$variable][$month][$year]) && !in_array($variable, $notIncluded)) {
                        $records[$each['name']][$variable][$month][$year] = $value;
                        $variableTypes[$variable] = true;

                        if (!is_null($value)) {
                            $variableTypesSelected[$variable] = true;
                        }

                    }
                }
            }
        }

        $availablePeriods = array_keys($availablePeriods);
        $variableTypes = array_keys($variableTypes);
        $variableTypesSelected = array_keys($variableTypesSelected);

        debug($variableTypesSelected);

        $variableTypes = array_values(array_intersect($variableTypes, $variableTypesSelected));


        /*foreach ($variableTypes as $i=>$type){
            $variableTypes[$i] = str_replace('_', ' ', $type);
        }*/

        debug($variableTypes);

        return response()->json([
            'records'           => $records,
            'availablePeriods'  => $availablePeriods,
            'variableTypes'     => $variableTypes,
        ]);
    }

    public function postAjaxsavedata()
    {
        //FinancialReportData::insert([['variable_id'=>1, 'category_id'=>2, 'report_id'=>3, 'name'=>'Hello', 'value'=>500], ['variable_id'=>1, 'category_id'=>2, 'report_id'=>3, 'name'=>'Hello', 'value'=>500], ['variable_id'=>1, 'category_id'=>2, 'report_id'=>3, 'name'=>'Hello', 'value'=>500], ['variable_id'=>1, 'category_id'=>2, 'report_id'=>3, 'name'=>'Hello', 'value'=>500], ['variable_id'=>1, 'category_id'=>2, 'report_id'=>3, 'name'=>'Hello', 'value'=>500]]);
        $finalData = \request("data");
        $columns = \request("columns");

        if (!(is_array($finalData) && count($finalData)))
        {
            return response()->json([
                "error"   => TRUE,
                "message" => "No found required params, please check you request data",
                "title"   => "Validation Errors:"
            ]);
        }

        $input_all = [];

        foreach($finalData as $each){
            $dates = $each['date'];
            //$date2 = $each['date'][1];

            $variable_id = (isset($each['variable_id'])) ? $each['variable_id']: null;
            $flight_number = (isset($each['flight_number'])) ? $each['flight_number']: null;

            foreach($dates as $j => $each_date) {
                $row = [];
                $row['date'] = $each_date;
                $row['report_id'] = $each['report_id'];
                $row['category_id'] = $each['category_id'];
                $row['variable_id'] = $variable_id;
                $row['flight_number'] = $flight_number;
                $findRecord = $row;

                $isValid = false;
                for ($i = $j; $i < $columns; $i+=2) { // i = 0, 2
                    $name = $each['name'][$i];
                    $value = $each['value'][$i];
                    if ($value != '') {
                        $row[$name] = $value;
                        $isValid = true;
                    }
                }

                if ($isValid) {
                    $data = FinancialReportData::where(function($query) use ($findRecord){
                        foreach ($findRecord as $index=>$item){
                            $query->where($index, $item);
                        }
                    })->first();
                    if (!empty($data)){
                        $data->update($row);
                    }
                    else{
                        $data = FinancialReportData::create($row);
                    }

                }
            }

        }

        /*if (!is_null($input_all))
            FinancialReportData::create($input_all);*/

        return response()->json([
            "success"    => TRUE,
        ]);
    }

}
