<?php namespace App\Http\Controllers;
use App\Models\Flight;


use Illuminate\Support\Facades\Response;
use Maatwebsite\Excel\Facades\Excel;

class ExportController extends Controller
{

    // Export View (though Table Styling Is not Exported)
    /*if($this->isPostRequest()){
        debug($crewHours);
        Excel::create('New file', function($excel) use ($crew, $crewHours, $crewType, $date, $conditions) {
            $excel->sheet('First sheet', function($sheet) use ($crew, $crewHours, $crewType, $date, $conditions) {
                $sheet->loadView('crew.report-excel-tab', compact(['crew', 'crewHours', 'date', 'crewType', 'conditions']));
            });
            $excel->sheet('Second sheet', function($sheet) use ($crew, $crewHours, $crewType, $date, $conditions) {
                $sheet->loadView('crew.report-excel-tab', compact(['crew', 'crewHours', 'date', 'crewType', 'conditions']));
            });
        })->download('pdf');
    }*/


    public function getExcelSheetRange(){
        $alphas = array('A');
        $current = 'A';
        while ($current != 'ZZZ') {
            $alphas[] = ++$current;
        }
        return $alphas;

    }

    public function generateColumnHeaders($sheet, $heading, $alphas, $row){
        $genColumns = [];
        foreach ($heading['columnNames'] as $j => $varRows) {
            $genColumns[$j] = [];
            if (is_array($varRows)) {
                foreach ($varRows as $var) {
                    if (is_object($var)) {
                        foreach ($var as $column => $colspan) {
                            $genColumns[$j][] = $column;
                            $columnStart = $alphas[count($genColumns[$j]) - 1] . $row;
                            for ($i = 0; $i < $colspan - 1; $i++) {
                                $genColumns[$j][] = "";
                            }
                            $columnEnd = $alphas[count($genColumns[$j]) - 1] . $row;
                            $sheet->mergeCells($columnStart . ':' . $columnEnd);
                            debug('123');
                            break;

                        }
                    } else {
                        $genColumns[$j][] = $var;
                        $columnStart = $alphas[count($genColumns[$j]) - 1] . $row;
                        $columnEnd = $alphas[count($genColumns[$j]) - 1] . ($row + 1);
                        if (count($heading['columnNames']) > 1 && $j == 0) {
                            $sheet->mergeCells($columnStart . ':' . $columnEnd);
                        }
                    }
                }
                $sheet->row($row++, $genColumns[$j]);
            }
        }

        return [--$row, count(end($genColumns)) - 1];
    }


    /**
     * Apply Header Style From => To Rows
     * @param $sheet
     * @param int $rowFrom
     * @param $rowTo
     */
    public function applyHeaderStyle($sheet, $rowFrom = 1, $rowTo){
        for($i = $rowFrom; $i <= $rowTo; $i++) {
            $sheet->row($i, function ($row) use ($i) {
                $row->setAlignment('center');
                $row->setBackground('#0088f4');

                $row->setFontColor('#FFFFFF');
                $row->setFontWeight('bold');
            });
        }

    }


    /**
     * Get Crew And Ops Reports
     * @return string
     */
    public function anyFleetwatchReport(){
        $reportType = \request()->get('reportType');
        $fromDate = \request()->get('fromDate');
        $toDate = \request()->get('toDate');
        $period = \request()->get('period');

        switch ($reportType){
            case 'ops':

                $dateSearch = [
                    'from' => $fromDate,
                    'to' => $toDate
                ];

                // Get All Flights (filter: Date, Flight Number)
                // $flights = Flight::getFlightsByDateFlightNumber($dateSearch);

                // Get Flights With Flight Crew
                $flights = Flight::flightsRange($fromDate.' 00:00:00', $toDate.' 23:59:59', ['flightNumber', 'Aircraft', 'flightCrew'], false, 'flights.aircraft_id');

                // Data Array
                $reportData['data'] = self::getOpsReportDataArray($flights, $period);


                // Export Type
                $reportData['exportType'] = 'xls';

                // File Name
                $reportData['fileName'] = "OPS Report From ".$fromDate." To ".$toDate;

                // Report Name
                $this->getReportName($reportData['reportName'], $fromDate, $toDate, $period);

//                debug($reportData);
//                return 123;

                // Column Names
                $reportData['columnNames'] = ['Date', 'Flt No.', 'From', 'To', 'Capt', 'A/C', 'STD', 'PTD', 'ATD', 'ABN', 'Parked', 'Delay Reason',
                    'Booked PAX', 'Actual PAX', 'Baggage', 'Mail', 'Cargo', 'STA', 'PTA', 'ATA', 'TDN', 'Deportees', 'Remaining Fuel' ];

                self::excelReady($reportData);

                break;
            case 'crew':
                // Get Flights With Flight Crew
                $flights = Flight::flightsRange($fromDate.' 00:00:00', $toDate.' 23:59:59', ['flightNumber', 'Aircraft', 'flightCrew'], false, 'flights.aircraft_id');

                // Data Array
                $reportData['data'] = self::getCrewReportDataArray($flights);

                // Export Type
                $reportData['exportType'] = 'xls';

                // File Name
                $reportData['fileName'] = "Crew Report From ".$fromDate." To ".$toDate;

                // Report Name
                for ($i = strtotime($fromDate), $l = strtotime($toDate); $i <= $l; $i = strtotime('+ 1 day', $i) ){
                    $reportData['reportName'][date('Y-m-d', $i)] = "Crew Report For ". date('d-M-Y', $i)." (UTC)";
                }
                // Column Names
                $reportData['columnNames'] = [ 'STD/ATD', 'STA/ATA', 'Flt No', 'Route', 'A/C', 'PAX BKD', 'Capt-1', 'Capt-2',
                    'F/O-1', 'F/O-2', 'PSR', 'CC-2', 'CC-3', 'CC-4', 'CC-5', 'CC-6', 'Sector Time'];

                self::excelReady($reportData);

                break;
        }
        return;
    }

    public function getReportName(&$reportName, $fromDate, $toDate, $period){

        if ($period != null && $period !== false){
            // 0=>'Yearly', 1=>'Quarterly', 2=> 'Monthly', 3=> 'Weekly', 4=> 'Weekdays', 5=>'Daily'
            switch($period){
                case 0:
                    for ($i = strtotime($fromDate), $l = strtotime($toDate); $i <= $l; $i = strtotime('+ 1 day', $i) ){
                        $index = "-".date('Y', $i)."-";
                        $reportName[$index] = "OPS Report For ". $index." (UTC)";
                    }
                    break;
                case 1:
                    for ($i = strtotime($fromDate), $l = strtotime($toDate); $i <= $l; $i = strtotime('+ 1 day', $i) ){
                        $index = "Quarter ".ceil(date("m", $i)/3).", ".date('Y', $i);
                        $reportName[$index] = "OPS Report For Quarter ". $index." (UTC)";
                    }
                    break;
                case 2:
                    for ($i = strtotime($fromDate), $l = strtotime($toDate); $i <= $l; $i = strtotime('+ 1 day', $i) ){
                        $index = date("F", $i).", ".date('Y', $i);
                        $reportName[$index] = "OPS Report For ". $index." (UTC)";
                    }
                    break;
                case 3:
                    for ($i = strtotime($fromDate), $l = strtotime($toDate); $i <= $l; $i = strtotime('+ 1 day', $i) ){
                        $index = "Week ".date("W", $i).", ".date('Y', $i);
                        $reportName[$index] = "OPS Report For Week ". $index." (UTC)";
                    }
                    break;
                case 4:
                    for ($i = strtotime($fromDate), $l = strtotime($toDate); $i <= $l; $i = strtotime('+ 1 day', $i) ){
                        $index = jddayofweek(date("w", $i), 1);
                        $reportName[$index] = "OPS Report For ". $index." (UTC)";
                    }
                    break;
                case 5:
                default:
                    for ($i = strtotime($fromDate), $l = strtotime($toDate); $i <= $l; $i = strtotime('+ 1 day', $i) ){
                        $reportName[date('Y-m-d', $i)] = "OPS Report For ". date('d-M-Y', $i)." (UTC)";
                    }
                    break;
            }
        }
        else {
            for ($i = strtotime($fromDate), $l = strtotime($toDate); $i <= $l; $i = strtotime('+ 1 day', $i) ){
                $reportName[date('Y-m-d', $i)] = "OPS Report For ". date('d-M-Y', $i)." (UTC)";
            }
        }

        return $reportName;
    }

    public function excelReady($reportData){
        $data = $reportData['data'];
        $type = $reportData['exportType'];
        $fileName = $reportData['fileName'];
        $heading['reportName']  = $reportData['reportName'];
        $heading['columnNames'] = $reportData['columnNames'];
        $alphas = $this->getExcelSheetRange();
        $row = 1;

        Excel::create($fileName, function($excel) use($data, $heading, $alphas, $row) {
            debug($data);
            foreach ($data as $i => $each) {
                $excel->sheet($i, function($sheet) use($each, $heading, $alphas, $row, $i) {
                    // First Header (Report/Table Name)

                    $columnCounter = count($heading['columnNames']);
                    if (isset($heading['reportName'][$i])) {
                        $headingMerged = [$heading['reportName'][$i]];
                        $rowCounter = isset($rowCounter) && $rowCounter ? $rowCounter : $row;
                        $startCell = isset($rowCounter) && $rowCounter ? $rowCounter : 1;
                        $mergeUntil = $alphas[$columnCounter - 1] . $startCell;
                        $startCellData = "A" . ($startCell + 2);
                        $startCell = "A" . $startCell;

                        $sheet->row($rowCounter++, $headingMerged);

                        $sheet->row($rowCounter++, $heading['columnNames']);

                        // Generate Header Columns
                        //list($genColumns, $row, $columnCounter) = $this->generateColumnHeaders($sheet, $heading, $alphas, $row);

                        // Merge Table Name Cell into 1
                        $sheet->mergeCells($startCell . ":" . $mergeUntil);

                        // Apply Header Background Color
                        $this->applyHeaderStyle($sheet, $rowCounter - 2, $rowCounter - 1);

                        // Body Data
                        $sheet->fromArray($each, null, $startCellData, true, false);

                        // Total Number Of Rows in The Table
                        $rowCounter += count($each);

                        // Apply Border to The Whole Table
                        $range = 'A1:' . $alphas[$columnCounter - 1] . ($rowCounter - 1);
                        $sheet->setBorder($range, 'thin');
                    }
                });
            }

            $excel->getActiveSheet()->getPageSetup()->setPaperSize(\PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $excel->getActiveSheet()->getPageSetup()->setOrientation(\PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $excel->getActiveSheet()->getPageSetup()->setFitToWidth();

        })->download($type);

        return Response::json([
            "message" => "Roster Generated Successfully",
            "success" => TRUE,
        ]);
    }


    /**
     * Get OPS Report Data Array
     * @param $flights
     * @param bool|false $period
     * @return array
     */
    public static function getOpsReportDataArray($flights, $period = false){
        $exportArray = [];

        foreach ($flights as $flight) {
            $totalDelay = $paxBookedTotal = $paxTotal = $paxInfTotal = 0;

            $flightNum = $flight->flightNumber;
            $flightCrew = $flight->flightCrewItems;
            $captain = '';
            $delays = "<span class='color-red'>";
            $delayTimes = "<span class='color-red'>";
            $aircraft = $flight->aircraft;

            $initialDepDateTime = getFlightDepartureInitialDate($flight);
            $initialDepDate = date("Y-m-d", strtotime($initialDepDateTime));

            $airlineID = getFlightAirlineID($flight);

            if ($flight->delays && count($flight->delays)) {
                foreach ($flight->delays as $eachDelay) {
                    $delays .= "DL ". ($airlineID == 253 ? $eachDelay->delay->alpha_code : $eachDelay->delay->code)." ".
                        str_limit($eachDelay->delay->description_ln ? $eachDelay->delay->description_ln : $eachDelay->delay->description, 50).
                        ",<br/>";


                    $delayTimes .= ($eachDelay->duration ? baseTimeFormat($eachDelay->duration) : "-").",<br/>";

                    $totalDelay += $eachDelay->duration ? TimeToMinutes($eachDelay->duration) : 0;
                    //$delays = implode('\n', $flight->delays);
                }
                $delays = rtrim($delays, ",<br/>");
                $delayTimes = rtrim($delayTimes, ",<br/>");
            }
            elseif (!$flight->created_by_email && $flight->atd && $flight->atd != EMPTY_DATETIME && $initialDepDateTime && Calculate_Duration($initialDepDateTime, $flight->atd) > 3) {
                $duration = Calculate_Duration($initialDepDateTime, $flight->atd, true);
                $delayTimes .= hoursToTime($duration, true);

                $totalDelay += $duration * 60;
            }

            $delayTimes.= "</span>";
            $delays.= "</span>";

            foreach ($flightCrew as $each) {
                if (in_array(trim($each->position_type), [FCM_CPT_TYPE_ID, FCM_FA_TYPE_ID])
                    && !($each->is_standby || $each->is_dhc)){
                    $captain = $each->user ? $each->user->first_name." ".$each->user->last_name : "";
                    break;
                }
            }

            $paxBooked = $flight->pax_c_booked ? $flight->pax_c_booked.'/' : "";
            $paxBooked .= $flight->pax_y_booked ? $flight->pax_y_booked : "";


            // Total Values
            $paxBookedTotal += $flight->pax_c_booked ? $flight->pax_c_booked : 0;
            $paxBookedTotal += $flight->pax_y_booked ? $flight->pax_y_booked : 0;

            $paxActual = $paxInf = "";
            if ($flight->pax_y_actual){
                $paxActual = $flight->pax_c_actual ? ($flight->pax_c_actual).'/' : "";
                $paxActual .= $flight->pax_y_actual ? ($flight->pax_y_actual) : "";
                $paxInf    = $flight->pax_inf_actual ? $flight->pax_inf_actual : "";

                // Total Values
                $paxTotal       += $flight->pax_c_actual      ? $flight->pax_c_actual     : 0;
                $paxTotal       += $flight->pax_y_actual      ? $flight->pax_y_actual     : 0;
                $paxInfTotal    += $flight->pax_inf_actual    ? $flight->pax_inf_actual   : 0;
            }
            else {
                if ($flight->pax_mvt_total){
                    $paxActual = $flight->pax_mvt_total;

                    // Total Values
                    $paxTotal += $flight->pax_mvt_total;
                }

                if ($flight->pax_mvt_inf){
                    $paxInf .= $flight->pax_mvt_inf;

                    // Total Values
                    $paxInfTotal += $flight->pax_mvt_inf;
                }
            }

            $divertedFlight = $flight->divertedAirport;

            if ($divertedFlight && $flight->departureAirport) {
                $depAirport = $flight->departureAirport->iata;
            }
            else {
                $depAirport = $flightNum->departureAirport ? $flightNum->departureAirport->iata : "";
            }

            if ($divertedFlight && $flight->arrivalAirport){
                $arrAirport = $flight->arrivalAirport->iata;
            }
            else {
                $arrAirport = $flightNum->arrivalAirport        ? $flightNum->arrivalAirport->iata : "";
            }

            $fn = "";
            if (env("CARRIER") == HANDLING){
                $fn = getAirlineCode($flightNum->airline)."-";
            }

            $fn .= $flight->flight_number  ? $flight->flight_number : $flightNum->flight_number;

            if ($flight->cancelled_at){
                $notes = "Cancelled at ". baseDateFormat($flight->cancelled_at, true, "-", true). " (".$flight->remark.")";
            }
            elseif($divertedFlight){
                $notes = "DIVERTED";
            }
            else {
                $notes = $flight->remark;
            }

            $data = [
                $divertedFlight ? "<span class='color-red'>{$initialDepDate}</span>" : $initialDepDate,
                $divertedFlight ? "<span class='color-red'>{$fn}</span>" : $fn,
                $divertedFlight ? "<span class='color-red'>{$depAirport}</span>" : $depAirport,
                $divertedFlight ? "<span class='color-red'>{$arrAirport}</span>" : $arrAirport,

                // Notes
                "<span class='color-red'>".$notes."</span>" ,

                $captain,
                $aircraft ? ($aircraft->name ? $aircraft->name : $aircraft->mvt_name) : "",
                $flight->std && $flight->std != EMPTY_DATETIME ? date('H:i', strtotime($flight->std)) : "",
                $flight->ptd && $flight->ptd != EMPTY_DATETIME ? date('H:i', strtotime($flight->ptd)) : "",
                $flight->atd && $flight->atd != EMPTY_DATETIME ? date('H:i', strtotime($flight->atd)) : "",
                $flight->abn && $flight->abn != EMPTY_DATETIME ? date('H:i', strtotime($flight->abn)) : "",
                $flight->gate_parking,
                $delays,
                $delayTimes,
                $paxBooked,
                $paxActual,
                $paxInf,
                $flight->baggage,
                $flight->mail,
                $flight->cargo,
                $flight->sta && $flight->sta != EMPTY_DATETIME ? date('H:i', strtotime($flight->sta)) : "",
                $flight->pta && $flight->pta != EMPTY_DATETIME ? date('H:i', strtotime($flight->pta)) : "",
                $flight->ata && $flight->ata != EMPTY_DATETIME ? date('H:i', strtotime($flight->ata)) : "",
                $flight->tdn && $flight->tdn != EMPTY_DATETIME ? date('H:i', strtotime($flight->tdn)) : "",
                $flight->deportees,
                $flight->in_tanks
            ];

            $periodVariable = $initialDepDate;

            if ($period != null && $period !== false){
                // 0=>'Yearly', 1=>'Quarterly', 2=> 'Monthly', 3=> 'Weekly', 4=> 'Weekdays', 5=>'Daily', 6=> 'Flight Number
                switch($period){
                    case 0:
                        $periodVariable = "-".date('Y', strtotime($initialDepDate))."-";
                        break;
                    case 1:
                        $periodVariable = "Quarter ".ceil(date("m", strtotime($initialDepDate))/3) .", ".date('Y', strtotime($initialDepDate));
                        break;
                    case 2:
                        $periodVariable = date('F', strtotime($initialDepDate)) .", ".date('Y', strtotime($initialDepDate));
                        break;
                    case 3:
                        $periodVariable = "Week ".date('W', strtotime($initialDepDate)) .", ".date('Y', strtotime($initialDepDate));
                        break;
                    case 4:
                        $periodVariable = jddayofweek(date('w', strtotime($initialDepDate)), 1);
                        break;
                    case 5:
                        $periodVariable = $initialDepDate;
                        break;
                    default:
                        $periodVariable = $initialDepDate;
                        break;
                }
            }

            $exportArray[$periodVariable][] = $data;

            if (!isset($exportArray[$periodVariable]["TOTAL"])){
                $exportArray[$periodVariable]["TOTAL"] = [
                    "TOTAL",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "delay"     => 0,
                    "booked"    => 0,
                    "actual"    => 0,
                    "inf"       => 0,
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                ];
            }

            $exportArray[$periodVariable]["TOTAL"]["delay"] += $totalDelay;
            $exportArray[$periodVariable]["TOTAL"]["booked"] += $paxBookedTotal;
            $exportArray[$periodVariable]["TOTAL"]["actual"] += $paxTotal;
            $exportArray[$periodVariable]["TOTAL"]["inf"] += $paxInfTotal;
        }

        return $exportArray;
    }


    const CREW_REPORT_MAX_CAPTAIN = 2,
        CREW_REPORT_MAX_FIRST_OFFICER = 2,
        CREW_REPORT_MAX_CABIN_CREW = 8,
        CREW_REPORT_MAX_SNY = 2;


    public static function getCrewReportDataArray($flights, $onePage = false){
        $max['captains'] = self::CREW_REPORT_MAX_CAPTAIN;
        $max['firstOfficers'] = self::CREW_REPORT_MAX_FIRST_OFFICER;
        $max['cabinCrew'] = self::CREW_REPORT_MAX_CABIN_CREW;
        $max['sup'] = self::CREW_REPORT_MAX_SNY;
        $exportArray = [];
        foreach ($flights as $flight) {
            $crew = [
                'captains'      => [],
                'firstOfficers' => [],
                'cabinCrew'     => [],
                'sup'           => [],
            ];

            $flightNum = $flight->flightNumber;

            $sector = getFlightSector($flight);

            $flightCrew = $flight->flightCrewItems;

            $date = date('Y-m-d', strtotime($flight->std));
            $aircraft = $flight->aircraft;

            $departureTime = getFlightDepartureDate($flight);
            $arrivalTime = getFlightArrivalDate($flight);

            $duration = hoursToTime(Calculate_Duration($departureTime, $arrivalTime), true);

            foreach ($flightCrew as $each) {
                if ($each->is_standby || $each->is_dhc) {
                    continue;
                }

                if ($each->is_sup) {
                    debug("HERE");
                    $crew['sup'][$each->position_order] = $each->full_name;
                }
                else {

                    if ($each->position_type == FCM_CPT_TYPE_ID)
                    {
                        $crew['captains'][$each->position_order] = $each->full_name;
                    }
                    else if ($each->position_type == FCM_FA_TYPE_ID)
                    {
                        $crew['firstOfficers'][$each->position_order] = $each->full_name;
                    }
                    else if (in_array($each->position_type, [CCM_PSR_TYPE_ID, CCM_CC_TYPE_ID]))
                    {
                        $crew['cabinCrew'][$each->position_order] = $each->full_name;
                    }

                }
            }

            // Add Empty Values To Array if It's Less Than MAX Number Defined
            foreach ($crew as $type => $item) {
                if (count($item) < $max[$type]){
                    for ($i = count($item); $i < $max[$type]; $i++) {
                        $crew[$type][] = '';
                    }
                }
            }

            // Sort Crew
            array_walk($crew, function(&$item){
                ksort($item);
            });

            $paxBooked = ($flight->pax_c_booked ? $flight->pax_c_booked.'/' : '').$flight->pax_y_booked;

            $depInitialDate =  getFlightDepartureInitialDate($flight);

            $finalArray = [
                date("d-M-Y", strtotime($depInitialDate)),
                date("H:i", strtotime($departureTime)),
                date("H:i", strtotime($arrivalTime)),
                $flightNum->flight_number,
                $sector,
                getAircraft($aircraft),
                $paxBooked
            ];

            // Merge Crew
            array_walk($crew, function($item) use (&$finalArray){
                $finalArray = array_merge($finalArray, $item);
            });

            $finalArray[] = $duration;

            if ($onePage){
                $exportArray[$depInitialDate][] = $finalArray;
            }
            else {
                $exportArray[$date][] = $finalArray;
            }
        }

        ksort($exportArray);

        if ($onePage){
            $result = [];
            foreach ($exportArray as $each) {
                if (is_array($each[0])){
                    foreach ($each as $item) {
                        $result[] = $item;
                    }
                    continue;
                }
                $result[] = $each;
            }

            return $result;
        }

        return $exportArray;

    }

    public function postExcel(){
        $data = json_decode(\request()->get('exportArray'));
        $reportDate = json_decode(\request()->get('reportDate'));
        $type = \request()->has('pdf') ? 'pdf' :'xls';
        $heading['reportName'] = json_decode(\request()->get('reportName'));
        $heading['columnNames'] =json_decode(\request()->get('columnNames'));
        $alphas = $this->getExcelSheetRange();

        debug($heading);
        debug($data);
        $row = 1;
        Excel::create($heading['reportName'][0]."($reportDate)", function($excel) use($data, $heading, $alphas, $row, $reportDate) {

            $excel->sheet('Sheetname', function($sheet) use($data, $heading, $alphas, $row, $reportDate) {
                // First Header (Report/Table Name)
                $headingMerged = [$heading['reportName'][0] ." as of ".$reportDate];
                $sheet->row($row++, $headingMerged);

                // Generate Header Columns
                list($row, $columnCounter) = $this->generateColumnHeaders($sheet, $heading, $alphas, $row);

                // Merge Table Name Cell into 1
                $sheet->mergeCells("A1:".$alphas[$columnCounter]."1");

                // Apply Header Background Color
                $this->applyHeaderStyle($sheet, 1, $row);

                // Start Cell For Body Data
                $startCell = 'A'.($row + 1);

                // Body Data
                $sheet->fromArray($data, null, $startCell, true, false);

                // Total Number Of Rows in The Table
                $rowCounter = count($data) + $row;

                // Apply Border to The Whole Table
                $range = 'A1:'.$alphas[$columnCounter].$rowCounter;
                $sheet->setBorder($range, 'thin');

            });
            $excel->getActiveSheet()->getPageSetup()->setPaperSize(\PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
            $excel->getActiveSheet()->getPageSetup()->setOrientation(\PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
            $excel->getActiveSheet()->getPageSetup()->setFitToWidth();

        })->download($type);

        return Response::json([
            "message" => "Roster Generated Successfully",
            "success" => TRUE,
        ]);
    }

}
