<?php namespace App\Http\Controllers;
use App\Models\Error;
use App\Repositories\Interfaces\IErrorRepository;
use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 12.08.14

 */
class ErrorController extends Controller
{
    // Permissible Video Extensions
    protected $permitted_video_extensions = ['mp4'];
    // Permitted Image Extensions
    protected $permitted_image_extensions = ['jpeg', 'JPEG', 'jpg', 'JPG', 'png', 'PNG', 'gif', 'GIF'];


    public function pageNotFound(){
        return view("smart/ajax/error404");
    }

    public function userReport(){

        $this->viewData = [
            'types'        => []
        ];

        return view('errors.user-report', $this->viewData);
    }

    public function viewUserReports(){
        $this->viewData = [
            'data'        => Error::all(),
        ];

        debug(env('DB_DATABASE'));

        return view('errors.view-user-reports', $this->viewData);
    }

    public function storeUserReport(IErrorRepository $errorRepository)
    {
        $extension = "";
        if (\request()->file('file')) {
            $extension = \request()->file('file')->getClientOriginalExtension(); // getting file extension
            // Check Extension of the uploaded file

            if (!(in_array($extension, $this->permitted_image_extensions) || in_array($extension, $this->permitted_image_extensions))) {
                flash()->error('File Format Not Compatible. \n' .
                    'Permitted Image Formats: ' . implode(', ', $this->permitted_image_extensions) . '\n' .
                    'Permitted Video Formats: ' . implode(', ', $this->permitted_video_extensions)
                );
                return redirect()->back()->withInput();
            }
        }

        $error = $errorRepository->createByAttributes([
            'type'              => \request("type"),
            'summary'           => \request("summary"),
            'notes'             => \request("notes"),
        ]);

        // Checking if File is Valid.
        if (\request()->file('file') && \request()->file('file')->isValid()) {
            // File Name is -> id of Video
            $fileName = $error->id . "." . $extension;


            if (in_array($extension, $this->permitted_video_extensions)){
                $error->is_video = true;
                Storage::disk('local')->put("errors/video/".$fileName, file_get_contents(\request()->file('file')->getRealPath()));
            }
            else {
                Storage::disk('local')->put("errors/img/".$fileName, file_get_contents(\request()->file('file')->getRealPath()));
            }
            $error->link = $fileName;
            $error->save();
        }

        flash()->success('Successfully saved.');

        return redirect()->to('error/user-report');

    }

    public function getImage($id)
    {
        $error = Error::find($id);
        if (!$error){
            return false;
        }

        $link = $error->link;
        $fileContents = Storage::get("errors/img/{$link}");

        $filename = basename($link);
        $file_extension = strtolower(substr(strrchr($filename,"."),1));

        switch( $file_extension ) {
            case "gif": $ctype="image/gif"; break;
            case "png": $ctype="image/png"; break;
            case "jpeg":
            case "jpg": $ctype="image/jpeg"; break;
            default:
                $ctype="image/jpeg"; break;
        }

        $response = Response::make($fileContents, 200);
        $response->header('Content-Type', $ctype);
        return $response;
    }

    public function getVideo($id)
    {
        $error = Error::find($id);
        if (!$error){
            return false;
        }

        $link = $error->link;
        $fileContents = Storage::get("errors/video/{$link}");
        $response = Response::make($fileContents, 200);
        $response->header('Content-Type', "video/mp4");
        return $response;
    }
}
