<?php

namespace App\Http\Controllers;

use App\Models\EmailNotification;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class EmailNotificationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $this->viewData = [
            "emailGroups"       => EmailNotification::with(["updatedBy", "createdBy"])
                                                        ->whereNull("deleted_at")
                                                        ->get(),
        ];


        return view("email-notification/index", $this->viewData);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view("email-notification/create", $this->viewData);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $search = EmailNotification::where("name", $request->get("name"))
                                    ->whereNull("deleted_at")
                                    ->first();

        if ($search){
            return redirect()->back()->withInput($request->all());
        }

        $emailGroup = new EmailNotification();
        $emailGroup->name = $request->get("name");
        $emailGroup->emails = $request->get("emails");
        $emailGroup->diverted_flights = $request->has("diverted_flights");
        $emailGroup->auto_created_flights = $request->has("auto_created_flights");

        $emailGroup->details = $request->get("details") ? $request->get("details") : null;
        $emailGroup->disabled = $request->has("disabled");
        $emailGroup->updated_by = Auth::user()->id;
        $emailGroup->created_by = Auth::user()->id;
        $emailGroup->save();

        return redirect()->to("email-notification");
    }



    /**
     * @param $email_notification
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit($email_notification)
    {
        $this->viewData = [
            "emailGroup"    => $email_notification,
        ];

        return view("email-notification/edit", $this->viewData);
    }

    /**
     * @param Request $request
     * @param $email_notification
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, $email_notification)
    {
        $email_notification->name = $request->get("name");
        $email_notification->emails = $request->get("emails");
        $email_notification->diverted_flights = $request->has("diverted_flights");
        $email_notification->auto_created_flights = $request->has("auto_created_flights");

        $email_notification->details = $request->get("details") ? $request->get("details") : null;
        $email_notification->disabled = $request->has("disabled");
        $email_notification->updated_by = Auth::user()->id;
        $email_notification->save();

        return redirect()->to("email-notification");
    }

    public function delete($email_notification)
    {
        $email_notification->deleted_at = date("Y-m-d H:i:s");
        $email_notification->updated_by = Auth::user()->id;
        $email_notification->save();

        return redirect()->to("email-notification");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
