<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 12.08.14

 */

use app\Classes\ProjectConstant;
use App\Models\Organization;
use App\Models\UserRole;
use App\Repositories\Interfaces\IDepartmentRepository;
use App\Repositories\Interfaces\IOrganizationRepository;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use App\Models\User;
use App\Models\Department;
use App\Forms\DepartmentForm;
use Illuminate\Support\Facades\URL;


class DepartmentController extends Controller
{

    public function index(Guard $auth)
    {
        $staffByDepartment = getStaffByDepartment();
        debug($staffByDepartment);

        $this->viewData = [
            "staffByDepartment"     => $staffByDepartment,
            "departments"           => getDepartmentObjectByRole($auth)
        ];

        return view("department/index", $this->viewData);
    }

    public function employees(IDepartmentRepository $department){
        $departmentId     = \request("departmentId");
        $subdepartmentId = \request("subdepartmentId");

        if (in_array(Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN])) {
            $departments = ['' => 'Select'] + Department::pluck('name', 'id')->all();

            if (\request("role_id") && \request("role_id")){

                $user_id = \request("user_id");
                $role_id = \request("role_id");

                if (in_array($role_id, [ROLE_ADMIN, SUPER_ADMIN])){
                    flash()->error("Global Admin Privileges are limited. Please choose 'Department Admin' role instead.");
                }
                else {
                    $findUser = User::find($user_id);
                    if ($findUser) {
                        $findUser->user_role_id = $role_id;
                        $findUser->save();

                        flash()->success("User Role Successfully Saved.");
                    }
                }
            }

            if (\request("reports_to_user_id") && \request("reports_to_user_id")){
                $user_id = \request("user_id");
                $reportsToUserId = \request("reports_to_user_id");
                $findUser = User::find($user_id);
                if ($findUser) {
                    $findUser->reports_to_user_id = $reportsToUserId ? $reportsToUserId : null;
                    $findUser->save();

                    flash()->success("Reports To Parameter Successfully set.");
                }
            }
        }

        $employees = User::getUsersByDepartment($departmentId, $subdepartmentId);

        $this->viewData = [
            "roles"         => UserRole::pluck("label", "id")->all(),
            'usersList'     => ['' => 'Select'] + User::getUsersList($departmentId, TRUE),
            'employees'     => $employees,
            'department'    => $department->find($departmentId)
        ];


        return view('department.employees', $this->viewData);
    }

    public function structure(){
        $id = \request("departmentId");
        return view('department.structure',[
            'department' => Department::find($id)
        ]);
    }


    /**
     * @param $department
     * @param IOrganizationRepository $organizationRepository
     * @return \Illuminate\View\View
     */
    public function organization($department = null){

        /*
        // Another Structure, Exclusively For CEO and Direct Reportees
        $structure = \request("structure");
        switch ($structure){
            case "A":
                $organization = $organizationRepository->listOrganization(['organization_level_id' => [WHERE_NOT_NULL], 'organization.support_staff' => 0, 'organization__level.name' => [WHERE_IN, ["CEO", "Director"]] ], 'left', ['level', 'name']);
                break;
            case "B":
                $organization = $organizationRepository->listOrganization(['organization_level_id' => [WHERE_NOT_NULL], 'organization.support_staff' => 0], 'left', ['level', 'name']);
                break;
            default:
                $organization = $organizationRepository->listOrganization(['organization.structure_department_id' => $department->id], 'left');
                break;
        }
        $undefinedHierarchyOrganization = $this->getUndefinedHierarchy($organization);
        $organizationNotAssigned = $this->organization->listOrganization(['organization_level_id' => null, 'organization.structure_department_id' => $id], 'left');
        */

        $result = [];
        $organization = initOrganizationChain($department);
        debug($organization);
        getPositionsOrganizationJsonForChart($result, $organization, true);
        debug($result);

        $this->viewData = [
            'department'                => $department,
            'personal'                  => false,
            'data'                      => json_encode($result), //getOrganizationJsonForChart($organization),
            'undefinedHierarchy'        => null, //$undefinedHierarchyOrganization,
            'organizationNotAssigned'   => null,//$organizationNotAssigned
        ];

        debug($this->viewData["data"]);

        return view('department/organization', $this->viewData);
    }


    /**
     * Add action
     */
    public function add()
    {
        $form = new DepartmentForm();
        if ($form->isPosted())
        {
            if ($form->isValidForAdd())
            {
                Department::create([
                    "name" => \request("name"),
                    "lang" => createLangString(\request("name")),

                ]);
                return redirect()->to("department");
            }

            return redirect()->to("department/add")
                ->withInput([
                    "name"   => \request("name"),
                    "errors" => $form->getErrors()
                ]);
        }

        return view("department/add", [
            "form" => $form
        ]);
    }

    /**
     * @param Request $request
     * @return $this|\Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function edit(Request $request)
    {
        $form       = new DepartmentForm();
        $department = Department::findOrFail(\request("id"));
        $url        = URL::full();

        debug($department);
        debug($request->all());

        if ($form->isPosted())
        {
            debug("POST");

            if ($form->isValidForEdit())
            {
                debug("VALID FOR EDIT");

                $department->name                   = \request("name");
                $department->lang                   = createLangString(\request("name"));
                $department->has_subdepartment      = \request("has_subdepartment") ? true : null;
                $department->has_library            = \request("has_library") ? true : null;
                $department->save();
                /*
                $department->users()
                    ->sync(\request()->get("user_id", []));
                $department->resources()
                    ->sync(\request()->get("resource_id", []));
                */
                return redirect()->to("department");
            }

            return redirect()->to($url)
                ->withInput([
                    "name"   => \request("name"),
                    "errors" => $form->getErrors(),
                    "url"    => $url
                ]);
        }

        return view("department/edit", [
            "form"       => $form,
            "department" => $department,
            "users"      => User::all(),
//            "resources"  => Resource::where("secure", TRUE)->get()
        ]);
    }

    /**
     * Delete action
     * @return mixed
     */
    public function delete()
    {
        $form = new DepartmentForm();
        if ($form->isValidForDelete())
        {
            $department = Department::findOrFail(\request("id"));

            // Audit Deleted
            auditDeleted($department);
//            $department->delete();
        }
        return redirect()->to("department");
    }

    /**
     * Get child
     * @return \Illuminate\Http\JsonResponse
     */
    public function children()
    {
        // only AJAX is available
        if (!\request()->ajax())
        {
            App::abort(404);
        }

        // if department ID is given select subdivisions or positions
        if (\request("department_id"))
        {
            $department = Department::find(\request("department_id"));

            if (!$department)
            {
                return response()->json([
                    "error"   => 1,
                    "message" => "Not found department by given ID"
                ]);
            }
            if (!$department->has_subdepartment)
            {
                $data["child"] = $department->position()
                    ->get();
                $data["type"]  = "positions";
            }
            else
            {
                $data["child"] = $department->subDepartment()
                    ->get();
                $data["type"]  = "subdepartments";
            }

            return response()->json([
                    "success" => TRUE,
                ] + $data);
        }

        return response()->json([
            "error"   => 1,
            "message" => "Not found required param"
        ]);
    }

    public function positions()
    {
        // only AJAX is available
        if (!\request()->ajax())
        {
            App::abort(404);
        }

        // if department ID is given select subdivisions or positions
        if ($departmentIDs = \request("department_id"))
        {
            $departments = Department::whereIn("id", $departmentIDs)->get();

            if (!$departments->count())
            {
                return response()->json([
                    "error"   => 1,
                    "message" => "Not found department by given ID"
                ]);
            }

            $data = [
                "type"  => "positions",
                "child" => []
            ];

            foreach ($departments as $department) {
                foreach ($department->position()->get() as $item){
                    $data["child"][] = [
                        "id"        => $item->id,
                        "name"      => $item->name,
                    ];
                }
            }

            return response()->json([
                    "success" => TRUE,
                ] + $data);
        }

        return response()->json([
            "error"   => 1,
            "message" => "Not found required param"
        ]);
    }


}
