<?php

namespace App\Http\Controllers;

use App\Imports\Schedule;
use App\Models\Airline;
use App\Models\Delay;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Collections\SheetCollection;
use Maatwebsite\Excel\Facades\Excel;

class DelayUploadController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $this->viewData = [
            "staffExistList" => $request->get("staffExistList"),
            "messageType"    => $request->get("message_type"),
            "message"        => $request->get("message"),
        ];

        return view("delay-upload/index", $this->viewData);
    }

    public function store(Request $request)
    {
        if ($request->hasFile('file')) {

            $file = $request->file('file');
            // Load Excel File

            if (!in_array($file->getClientOriginalExtension(), ['xls', 'xlsx'])) {
                flash()->error('Wrong Format(' . $file->getClientOriginalExtension() . '). Please Make Sure The Format is XLS or XLSX.');
            } else {

                $airlines = Airline::listHandlingAirlines("id", "iata");

                $loadObject = Excel::toCollection(new Schedule, $file);

                if (!$loadObject || !count($loadObject)) {
                    $this->viewData = [
                        'message_type'  => "danger",
                        'message'       => 'File Is Empty. Found No Data To Upload.',
                    ];
                }

                $data = [];
                foreach ($loadObject as $sheet){

                    $pageData = $this->GetUploadedArray($sheet, $airlines);
                    foreach ($pageData as $each) {
                        if ($each && count($each)) {
                            $data[] = $each;
                        }
                    }
                }

                $staffExistList = [];
                debug($data);

                foreach ($data as $each) {
                    Delay::createUpdate($each);
                }

                $this->viewData = [
                    "staffExistList"    => $staffExistList,
                    'message_type'      => "success",
                    'message'           => 'Successfully Uploaded.',
                ];
            }
        } else {
            $this->viewData = [
                'message_type'  => "danger",
                'message'       => 'No File Uploaded. Please select Excel sheet and press upload.',
            ];
        }

        return redirect()->to("delay-upload")->withInput($this->viewData);
    }

    public function GetUploadedArray($loadObject, $airlines){
        $finalData = [];
        // Starting Index
        $k = 0;

        $fieldCount = 6;
        $minHeaderFieldRequired = 2;
        $headerFound = false;

        $airlineModule = env(CARRIER) == AIRLINE;

        foreach ($loadObject as $i => $object) {
            // Do Not Include Header Row
            // Find Starting Index $k
            if (!$headerFound){
                foreach ($object as $j => $title) {
                    if ($title){
                        $fieldExists = 0;
                        for($s = $j; $s < $j + $fieldCount; $s++){
                            if (isset($object[$s]) && $object[$s] != ""){
                                $fieldExists++;
                            }
                        }
                        if ($fieldExists > $minHeaderFieldRequired){
                            $headerFound = true;
                            $k = $j;
                            break;
                        }
                    }
                }
                continue;
            }

            // For AIRLINE MODULE
            // Airline column could be blank
            // we check only Delay Code(Numeric Alpha column)
            if ($airlineModule) {
                if (!isset($object[$k + 1]) || $object[$k + 1] == ""){
                    continue;
                }
            }
            else {
                // If both Numeric & Alpha is null
                if ((!isset($object[$k]) || $object[$k] == "") &&
                    (!isset($object[$k + 1]) || $object[$k + 1] == "")){
                    debug($object);
                    continue;
                }

                if (!isset($airlines[$object[$k]])){
                    continue;
                }
            }

            foreach ($object as $m => $item) {
                if ($item){
                    $object[$m] = trim($item);
                }
            }

            $finalData[] = [
                'airline'           => $airlineModule ? null : $airlines[$object[$k]],
                'code'              => $object[$k + 1],
                'alpha_code'        => isset($object[$k + 2]) && $object[$k + 2] ?  $object[$k + 2] : null,
                'group'             => isset($object[$k + 3]) && $object[$k + 3] ?  $object[$k + 3] : null,
                'description'       => isset($object[$k + 4]) && $object[$k + 4] ?  $object[$k + 4] : null,
                'explanation'       => isset($object[$k + 5]) && $object[$k + 5] ?  $object[$k + 5] : null,

                'group_ln'          => isset($object[$k + 6]) && $object[$k + 6] ?  $object[$k + 6] : null,
                'description_ln'    => isset($object[$k + 7]) && $object[$k + 7] ?  $object[$k + 7] : null,
                'explanation_ln'    => isset($object[$k + 8]) && $object[$k + 8] ?  $object[$k + 8] : null,
            ];

        }


        return $finalData;
    }

    public function GetDate($string){
        if ($string){
            if (contains($string, ".")){
                $symbol = ".";
            }
            elseif (contains($string, "/")){
                $symbol = "/";
            }
            else {
                $symbol = "-";
            }

            if (strlen($string) == 10){
                return \DateTime::createFromFormat("m{$symbol}d{$symbol}Y", $string)->format("Y-m-d");
            }
            elseif (strlen($string) == 8){

                preg_match('/(\d{2})'.$symbol.'(\d{2})'.$symbol.'(\d{2})/', $string, $match);

                if ($match){
                    $currYear = intval(date("y"));
                    if (isset($match[3]) && $match[3] && $match[3] > $currYear){
                        $match[3] = "19".$match[3];
                        $date = \DateTime::createFromFormat("m{$symbol}d{$symbol}Y", $match[1]."-".$match[2]."-".$match[3]);
                        return $date->format("Y-m-d");
                    }

                    return \DateTime::createFromFormat("m{$symbol}d{$symbol}y", $string)->format("Y-m-d");
                }

            }
        }

        return null;
    }

}
