<?php namespace App\Http\Controllers;

class CurrencyController extends Controller {

    protected $_launchDate = '2008-01-01';

    public function getEcbHistoricalRates(){
        $XML=simplexml_load_file("http://www.ecb.europa.eu/stats/eurofxref/eurofxref-hist-90d.xml");
        $historicalData = [];
        foreach($XML->Cube->Cube as $time){
            $date = $time["time"];
            if (strtotime($date) >= strtotime($this->_launchDate)){
                foreach($time->Cube as $_rate){
                    $historicalData[(string)$date][(string)$_rate["currency"]] =  $_rate["rate"];
                }
            }
        }

        foreach ($historicalData as $_date => $currencies) {
            $usd_rate = $currencies['USD'] ;
            foreach ($currencies as $_currency => $rate) {
                $historicalData[$_date][$_currency] = $historicalData[$_date]['USD'];
            }

        }

        debug($historicalData);

        return 'Done';
    }

}
