<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 */
use App\Models\Language;
use App\Repositories\Interfaces\ILocationRepository;

use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\Condition;

class CrewQueryController extends Controller
{
    const USER_TYPE_FLIGHT_CREW = 2;
    const USER_TYPE_CABIN_CREW = 1;
    const CONDITION_AVAILABLE = "available";

    /**
     * $keyLocationId
     * @param ILocationRepository $locationRepository
     * @return \Illuminate\View\View
     */
    public function index(ILocationRepository $locationRepository)
    {
        $crewType = \request("crew_type");

        debug(request()->all());

        if (\request("_token"))
        {
            $users    = $this->GetQueryUsers($crewType);

            $condition = \request("condition");
            $fromDate = (\request("from")) ? \request("from") : date("Y-m-d");
            $toDate   = (\request("to")) ? \request("to") : date("Y-m-d");

            // if language checkbox selected filter result array by language
            $users = $this->filterUsersByLanguage($users);

            // Check Users' Condition if Set, Return Resulting User Ids
            $usersIds = self::checkConditionRequirement($users, $condition, $fromDate, $toDate);

            // get users flight hours
            $counterType = ['last7days', 'monthToDate', 'yearToDate'];
            $crewHours = CrewController::getCrewHoursFlightHistoryDHCStandby($users, date('Y-m-d'), $counterType, false, false, $usersIds );

            //$users         = $this->getUsersFlightsHours($users, $userType);
        }


        $data = [
            "crewType"       => $crewType,
            "conditions"     => [self::CONDITION_AVAILABLE => "Available" ] + Condition::pluck("name", "id")->all(),
            'locations'      => ["" => "All"] + $locationRepository->locationAirports(true),
            'users'          => isset($users) ? $users : [],
            "userTypes"      => ["somonair" => "Direct", "contract" => "Contract", "resigned" => "Terminated"],
            "crewTypes"      => ['ccm' => 'Cabin Crew', 'fcm' => 'Flight Crew'],
            "ccmTypes"       => [
                                    PURSER => "Purser",
                                    FLIGHT_ATTENDANT_N2 => "Business Class Crew",
                                    FLIGHT_ATTENDANT => "Flight Attendant",
                                    "" => "All"
                                ],
            "languages"      => Language::orderBy("language")->pluck("language", "id")->all(),
            'crewHours'      => isset($crewHours) ? $crewHours : []
        ] ;

        return view("crew-query/index", $data);
    }

    /**
     * Check Condition and Unset $users array if Not , Return Users Ids
     * @param $users
     * @param $condition
     * @param $fromDate
     * @param $toDate
     * @return array
     */
    public static function checkConditionRequirement(&$users, $condition, $fromDate, $toDate){
        $usersIds = [];
        foreach ($users as $i => $user) {
            if ($condition) {
                if (in_array(self::CONDITION_AVAILABLE, $condition)) {
                    $conditionFound = 1;
                    foreach ($user->userHistory as $history) {
                        if (!(strtotime($history->condition_to) < strtotime($toDate) || strtotime($history->condition_from) > strtotime($fromDate))) {
                            unset($users[$i]);
                            $conditionFound = 0;
                            break;
                        }
                    }

                } else {
                    $conditionFound = 0;
                    foreach ($user->userHistory as $history) {
                        if (in_array($history->condition_id, $condition)) {
                            debug($history);
                            if (strtotime($history->condition_to) < strtotime($fromDate) || strtotime($history->condition_from) > strtotime($toDate)) {
                                $conditionFound = 0;
                            } else {
                                $conditionFound = 1;
                                break;
                            }
                        }
                    }
                }

                // Check if Found otherwise Unset
                if (!$conditionFound)
                    unset($users[$i]);
                else
                    $usersIds[] = $user->user_id;

                continue;
            }
            $usersIds[] = $user->user_id;
        }
        return $usersIds;
    }
    /**
     * Get query users
     * @param $crewType
     * @return array
     */
    public function GetQueryUsers($crewType)
    {
        $tableName = ($crewType == CCM_CREW) ? "crew__cabin" : "crew__flight";
        if ($crewType == CCM_CREW)
        {
            $select = [
                "$tableName.is_purser",
                "$tableName.is_business_crew",
            ];
        }
        else
        {
            $select = [
                "$tableName.english_level"
            ];
        }

        $users = User::with(['userHistory', 'languages'])
            ->join($tableName, $tableName.'.user_id', '=', 'users.id')
            ->select(array_merge_recursive($select, [
                "users.id",
                "$tableName.user_id",
                "$tableName.cmc_to",
                "users.location_id",
                "users.first_name",
                "users.last_name",
                "users.is_contractor",
                "users.resigned_date",
                "users.thumb",
                DB::raw("a.name AS position")
            ]))
            ->leftJoin(DB::raw("(SELECT p.name, d.user_id
                               FROM s_structure__positions AS p
                               JOIN s_users__departments AS d ON p.id = d.position_id) AS a"), function ($query)
            {
                $query->on(DB::raw("a.user_id"), "=", "users.id");
            });


        // if condition selected add condition query
        if (\request("condition") && \request("condition"))
        {
            $condition = \request("condition");
            $startDate = (\request("from")) ? \request("from") : date("Y-m-d");
            $endDate   = (\request("to")) ? \request("to") : date("Y-m-d");
           /* if ($condition == self::CONDITION_AVAILABLE)
            {
                $users->join("users__history","users.id", "=", "users__history.user_id");
                /*$users->where(function($sql) use ($startDate, $endDate) {
                    $sql->where("users__history.from", ">", $startDate)
                        ->orWhere("users__history.to", "<", $endDate);
                });
            }
            else
            {
                $users->join("users__history", function ($join) use ($condition, $startDate, $endDate)
                {
                    $join->on("users.id", "=", "users__history.user_id")
                        ->where("users__history.condition_id", "=", $condition);
                        ->where("users__history.from", "<", $startDate)
                        ->where("users__history.to", ">", $endDate);
                });
            }*/
        }
        if (\request("first_name") && \request("first_name"))
        {
            $users->where("users.first_name", "like", "%" . \request("first_name") . "%");
        }
        if (\request("last_name") && \request("last_name"))
        {
            $users->where("users.last_name", "like", "%" . \request("last_name") . "%");
        }
        if (\request("location") && \request("location") !== "")
        {
            $users->where("users.location_id", "=", \request("location"));
        }
        if ($crewType == CCM_CREW)
        {
            if (\request("user_type") && is_array(\request("user_type")))
            {
                $userTypes = \request("user_type");

                if (count($userTypes) > 1)
                {
                    $users->where(function ($query) use ($userTypes)
                    {
                        foreach ($userTypes as $type)
                        {
                            if ($type == "somonair")
                            {
                                $query->orWhereNull("is_contractor");
                            }
                            else if ($type == "contract")
                            {
                                $query->orWhere("is_contractor", "=", 1);
                            }
                            else
                            {
                                $query->orWhereNotNull("users.resigned_date");
                            }
                        }
                    });
                }
                else
                {
                    if ($userTypes[0] == "somonair")
                    {
                        $users->whereNull("is_contractor");
                    }
                    else if ($userTypes[0] == "contract")
                    {
                        $users->where("is_contractor", "=", 1);
                    }
                    else
                    {
                        $users->whereNotNull("users.resigned_date");
                    }
                }
            }
            if (\request("ccm_type") && \request("ccm_type"))
            {
                if (\request("ccm_type") == PURSER) {
                    $users->where("is_purser", TRUE);
                }
                elseif (\request("ccm_type") == FLIGHT_ATTENDANT_N2) {
                    $users->where("is_business_crew", TRUE);
                }
                else {
                    $users->whereNull("is_purser");
                }
            }
        }
        else
        {
            if (\request("english_level") && \request("english_level"))
            {
                $users->whereIn("english_level", \request("english_level"));
            }
        }

        if (!isset($userTypes) || !in_array('resigned', $userTypes)) {
            $users->where(function ($sql) {
                $sql->whereNull("users.resigned_date")
                    ->orWhere("users.resigned_date", EMPTY_DATE)
                    ->orWhere("users.resigned_date", ">", date("Y-m-d"));
            });
        }

        $users->whereNull("users.deleted_at");

        return $users->get();
    }

    /**
     * Filtering users array by languages
     * @param $users
     * @return mixed
     */
    public function filterUsersByLanguage($users)
    {
        if (\request("lang") && is_array(\request("lang")) && count($users))
        {
            $languages = \request("lang");
            $countLanguages = count($languages);
            debug($languages);
            foreach ($users as $key => &$user)
            {
                $count = count($user->languages);
                if ($count > 0 && $count >= $countLanguages) {
                    $checkLanguages = $user->languages->keyBy('id')->keys()->toArray();

                    $intersection = array_intersect($checkLanguages, $languages);
                    if (array_values($intersection) == array_values($languages)){
                        continue;
                    }
                }
                unset($users[$key]);
            }
        }
        return $users;
    }

    /**
     * Get users flights hours
     * @param $users
     * @return array
     */
    public function GetUsersFlightsHours($users)
    {
        if (!is_array($users) || !count($users))
        {
            return $users;
        }
        $usersIds = [];
        array_walk($users, function ($user) use (&$usersIds)
        {
            $usersIds[] = $user->user_id;
        });

        $startDate7Days          = date("Y-m-d 00:00:00", strtotime('- 7 days'));
        $endDate7Days            = date("Y-m-d 23:59:59");
        $last7daysUsersFlightHours = FlightCrew::flightCrewUsersFlightsHours($usersIds, $startDate7Days, $endDate7Days);
        debug($last7daysUsersFlightHours);


        $startDateMonth          = date("Y-m-01 00:00:00");
        $endDateMonth            = date("Y-m-d 23:59:59");
        $monthlyUsersFlightHours = FlightCrew::flightCrewUsersFlightsHours($usersIds, $startDateMonth, $endDateMonth);

        $startDateYear          = date("Y-01-01 00:00:00");
        $endDateYear            = date("Y-m-d 23:59:59");
        $yearlyUsersFlightHours = FlightCrew::flightCrewUsersFlightsHours($usersIds, $startDateYear, $endDateYear);



        array_walk($users, function ($user) use ($last7daysUsersFlightHours, $monthlyUsersFlightHours, $yearlyUsersFlightHours)
        {
            $user->last7days = convertToHoursMinutes($last7daysUsersFlightHours[$user->user_id]);
            $user->monthly_hours = convertToHoursMinutes($monthlyUsersFlightHours[$user->user_id]);
            $user->yearly_hours  = convertToHoursMinutes($yearlyUsersFlightHours[$user->user_id]);
        });

        return $users;
    }
}
