<?php namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Repositories\Interfaces\ILocationRepository;
use App\Repositories\Interfaces\IUserHistoryRepository;
use Illuminate\Http\Request;

class CrewDetailsController extends Controller {


	public function index(IUserHistoryRepository $userHistory, ILocationRepository $location)
	{
		// Get All Crew Trainings
		$trainings = $userHistory->getCrewConditions(FCM_CREW, CONDITION_TRAINING);

		// Set Picture
		$this->setProfilePicture($trainings);

		// Calculated FDP Daily And Total
		$this->calculateFdp($trainings);

		// Get Office Duties
		$office_duty = $userHistory->getCrewConditions(FCM_CREW, CONDITION_OFFICE_DUTY);

		// Set Picture
		$this->setProfilePicture($office_duty);

		// Calculated FDP Daily And Total
		$this->calculateFdp($office_duty);


		debug($trainings);

		$this->viewData = [
			'trainings'				=> $trainings,
			'office_duty'			=> $office_duty,
			'locations'				=> ["" => "Select"] + $location->locationAirports()
		];

		return view('crew-details/index', $this->viewData);
	}


	public function setProfilePicture(&$trainings){
		if ($trainings && count($trainings)){
			foreach ($trainings as &$each) {
				// Set Thumb
				$each->thumb = $each->thumb ? asset("storage/users/". $each->thumb) : asset("/assets/img/profile_picture.png");
			}
		}
	}

	public function calculateFdp(&$trainings){
		if ($trainings && count($trainings)){
			foreach ($trainings as &$each) {
				if ($each->duty_from && $each->duty_to){
					// Daily Duty Hours
					$dutyHours = (strtotime($each->duty_to) - strtotime($each->duty_from)) / 3600;

					debug($dutyHours);

					// Total Days
					$dutyDays = (strtotime($each->condition_to) - strtotime($each->condition_from)) / (60 * 60 * 24);

					$dutyDays = $dutyDays < 1 ? 1 : round($dutyDays);

					$each->fdp_daily = hoursToTime($dutyHours, true);
					$each->fdp_total = hoursToTime($dutyDays * $dutyHours, true);
				}
			}
		}
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		//
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		//
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

}
