<?php namespace App\Http\Controllers;

use App\Classes\Graph;
use App\Http\Requests;
use App\Models\Chart;
use App\Models\Flight;
use App\Models\Organization;
use App\Models\WBIncomeLevel;
use App\Models\WBIncomeLevels;
use App\Models\WBRegion;
use App\Repositories\Interfaces\IIndicatorCategoryRepository;
use App\Repositories\Interfaces\IIndicatorRepository;
use App\Repositories\Interfaces\IUserIndicatorRepository;
use App\Repositories\Interfaces\IWBIncomeLevelRepository;
use App\Repositories\Interfaces\IWBRegionRepository;
use Illuminate\Support\Facades\File;

use Illuminate\Support\Facades\URL;
use App\Repositories\Interfaces\IAgencyCodeRepository;
use App\Repositories\Interfaces\ICountryRepository;
use App\Repositories\Interfaces\IFlightCabinRepository;
use App\Repositories\Interfaces\IFlightFareBasisRepository;
use App\Repositories\Interfaces\IFlightOrderStatusRepository;
use App\Repositories\Interfaces\IFlightRbdRepository;
use App\Repositories\Interfaces\IFlightTypeRepository;
use App\Repositories\Interfaces\IRegionRepository;
use App\Repositories\Interfaces\IReportTypeRepository;
use App\Repositories\Interfaces\ISalesChannelRepository;

class CountryController extends Controller {

    /*public function __construct(IIndicatorRepository $indicator,
                                IIndicatorCategoryRepository $indicatorCategory){
        $this->indicator = $indicator;
        $this->indicatorCategory = $indicatorCategory;
    }*/

	/**
	 * Display a listing of the resource.
	 *
	 * @return Response
	 */
	public function index()
	{
        // Get all countries
        $countries = $this->country->get([], ['country']);

        // Country List with info for Chart
        $countryChart = $this->getCountryListForChart($countries);

        // Country Flags for Linkage
        $countryFlags = $this->getCountryFlags($countries);

        $chartArray = [];
        $maxPopulation = 0;
        foreach ($countryFlags as $each) {
            $maxPopulation = $each['population'] > $maxPopulation ? $each['population'] : $maxPopulation;
            $chartArray[$each['iso']] = $each['population'] ? $each['population'] : 0;
        }

        $this->viewData = [
            'countries'         => Country::pluck("country", "id")->all(),
            'countryChart'      => $countryChart,
            'countryFlags'      => $countryFlags,
            'chartArray'        => $chartArray,
            'maxPopulation'     => $maxPopulation,
        ];

        return view('country/index', $this->viewData);
	}


    public function search(){
        $countryId = \request("country");
        if ($countryId){
            $country = $this->country->find($countryId);
            if ($country) {
                return redirect("country/{$countryId}");
            }
        }

        flash()->error('Country Profile Not Found');
        return redirect("country");
    }

    /**
     * Country List With Flags(if Exists)
     * @param $countries
     * @return array
     */
    protected function getCountryFlags($countries){
        $countryFlags = [];
        foreach($countries as $i => $each) {
            $thumb = public_path("/assets/img/icons/flags/32/{$each->country}.png");
            $thumbSrc = asset("/assets/img/icons/flags/32/{$each->country}.png");
            $pictureSrc = asset("/assets/img/icons/flags/256/rectangle/{$each->country}.png");

            $imageCheck = File::exists($thumb);

            if ($imageCheck) {
                $countryFlags[] = [
                    'id'                => $each->id,
                    'country'           => $each->country,
                    'iso'               => $each->abbr,
                    'area'              => $each->area,
                    'population'        => $each->population,
                    'density'           => $each->population_density,
                    'thumb'             => $thumbSrc,
                    'picture'           => $pictureSrc,
                ];
            }
        }
        return $countryFlags;
    }

    /**
     * Country List For Google Chart
     * @param $countries
     * @return array
     */
    protected function getCountryListForChart($countries){
        $countryChart = [];
        foreach ($countries as $i => $each) {
            if ($i == 0){
                $countryChart[] = [
                    'Country',
                    'Population',
                    'Population Density',
                    // 'Area (sq.km)',
                ];
            }
            $countryChart[] = [
                $each->country,
                $each->population,
                $each->population_density,
                // $each->area,
            ];

        }
        return $countryChart;
    }

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		//
	}

    /**
     * @param $id
     * @param IIndicatorRepository $indicator
     * @param IIndicatorCategoryRepository $indicatorCategory
     * @param IWBRegionRepository $worldBankRegions
     * @param IWBIncomeLevelRepository $worldBankIncomeLevels
     * @param IUserIndicatorRepository $userIndicator
     * @param IFlightTypeRepository $flightTypeRep
     * @param IFlightFareBasisRepository $flightFareBasisRep
     * @param IFlightOrderStatusRepository $flightOrderStatusRep
     * @param IFlightCabinRepository $flightCabinRep
     * @param IFlightRbdRepository $flightRbdRep
     * @param IReportTypeRepository $reportTypeRep
     * @param ISalesChannelRepository $salesChannelRep
     * @return \Illuminate\View\View
     */
	public function show($id, IIndicatorRepository $indicator, IIndicatorCategoryRepository $indicatorCategory,
                                IWBRegionRepository $worldBankRegions, IWBIncomeLevelRepository $worldBankIncomeLevels,
                                IUserIndicatorRepository $userIndicator,
                                IFlightTypeRepository $flightTypeRep, IFlightFareBasisRepository $flightFareBasisRep,
                                IFlightOrderStatusRepository $flightOrderStatusRep, IFlightCabinRepository $flightCabinRep,
                                IFlightRbdRepository $flightRbdRep, IReportTypeRepository $reportTypeRep,
                                ISalesChannelRepository $salesChannelRep)
	{
        $country = $this->country->find($id);
        $previousYear = date('Y', strtotime(' - 2 years'));
        $charts = [];

        // Charts
        $defaultCharts = [
            'NY.GDP.MKTP.CD', // GDP (current US$)
            'NY.GDP.PCAP.CD', // GDP Per Capita  (current US$)
            'NY.GNP.MKTP.CD', // GNI  (current US$)
            'NY.GNS.ICTR.ZS', // Gross savings (% of GDP)
            'FI.RES.TOTL.CD',
            'SP.POP.GROW',
        ];


        // Period
        $period = [
            'start' => 2004,
            'end'   => $previousYear
        ];

        // Prepare Default Charts
        $this->PrepareDefaultIndicatorsCharts($charts, $defaultCharts, $country, $indicator, $period);

        // Get Country Base Info
        $countryBaseInfo = json_decode(file_get_contents($this->worldBankApiGenerator($country->abbr)));

        $country->baseInfo = isset($countryBaseInfo[1][0]) ? $countryBaseInfo[1][0] : null;

        // Get Saved Queries Array List
        $savedQueries = $this->getSavedQueryArray($userIndicator, $indicator, $indicatorCategory, $worldBankIncomeLevels, $worldBankRegions);

        // Get All Major Cities With Population >= 500 thous.
        $cities[] = ['City', 'Population'];
        foreach ($country->cityLimit as $city) {
            $population = $city->population ? $city->population : 0;
            $cities[] = [$city->city.', '.$country->country, $population];
        }

        // Label Google Map on Home Page
        $countryMap[] = ['Country', 'Population'];
        $countryMap[] = [$country->country, $country->population];

        $zoomLevel = $this->getCountryMapZoomLevel($country->area);

        // Get Country Manager And Reportees
        list($countryManager, $reportees) = $this->GetCountryManagerAndReportees($country);

        $this->viewData = Flight::FlightQueryModule($flightTypeRep, $flightFareBasisRep, $flightOrderStatusRep, $flightCabinRep,
                            $flightRbdRep, $reportTypeRep, $salesChannelRep, $this->region,$this->country, $this->city, $this->agency, $this->agencyCode) +
        [
            'period'            => $this->getYearPeriodManually(2000, $previousYear, TRUE ),
            'countries'         => $this->country->listModelVariable(['country','id']),
		    'country'           => $country,
		    'countryMap'        => json_encode($countryMap),
            'zoomLevel'         => $zoomLevel,
		    'countryManager'    => $countryManager,
            'reportees'         => $reportees,
            'cities'            => json_encode($cities),
            'categories'        => $indicatorCategory->listModelVariable(['category','id'], TRUE),
            'regions'           => $worldBankRegions->listModelVariable(['name', 'code']),
            'incomeLevels'      => $worldBankIncomeLevels->listModelVariable(['name', 'code']),
            'indicators'        => $indicator->listModelVariable(['indicator_name', 'id'], TRUE),
            'charts'            => $charts,
            'savedQueries'      => $savedQueries,
        ];

        return view('country/show', $this->viewData);
	}

    /**
     * @param $charts
     * @param $defaultCharts
     * @param $country
     * @param $indicator
     * @param $period
     */
    protected function PrepareDefaultIndicatorsCharts(&$charts, $defaultCharts, $country, $indicator, $period){
        foreach ($defaultCharts as $i => $chart) {
            $ind = $indicator->findByAttributes(['series_code' => $chart]);
            $jsonUrl = $this->worldBankApiGenerator($country->abbr, $chart, $period);
            $data = json_decode(file_get_contents($jsonUrl));


            $charts[] = [
                'title'     => $ind ? $ind->indicator_name : "",
                'div_id'    => "chart_".$i,
                'data'      => Chart::worldBankApiCharts($data[1], $i, "ChartJS-Single") // [1]-contains Data, [0]-contains Page Info Thus Ignored
            ];
        }
    }

    protected function GetCountryManagerAndReportees($country){
        $countryManager = $this->organization->findByAttributes([
            'organization__level.name' => 'Country',
            'organization__details.table_value_id' => $country->id
        ],
            [],
            [],
            [
                ['organization__level', 'organization__level.id', '=', 'organization.organization_level_id'],
                ['organization__details', 'organization__details.organization_id', '=', 'organization.id'],
                ['tables', 'tables.id', '=', 'organization__details.table_id'],
            ]);

        $reportees = $countryManager ? $this->organization->getAllReportToEmployees(false, $countryManager->user_id) : null;

        return [$countryManager, $reportees];
    }


    protected function getCountryMapZoomLevel($area){
        if (!$area)
            return 4;

        if ($area > 10000000){
            return 3;
        }
        else if ($area > 7000000){
            return 4;
        }
        else if ($area > 1500000){
            return 5;
        }
        else if ($area > 300000){
            return 6;
        }
        else if ($area > 50000){
            return 7;
        }
        else if ($area > 10000){
            return 8;
        }
        else if ($area > 2000){
            return 9;
        }
        else if ($area > 400){
            return 10;
        }
        else if ($area > 80){
            return 11;
        }
        else if ($area > 15){
            return 12;
        }
        else if ($area > 3){
            return 13;
        }
        else
            return 14;
    }

    /**
     * Pick Priority Array(1. Income levels, 2.Regions, 3.Countries)
     * @param $incomeLevels
     * @param $regions
     * @param $countries
     * @return array
     */
    protected function pickPriorityArray($incomeLevels, $regions, $countries){
        if ($incomeLevels) {
            if ($countries)
                return ['priority' => 'countries', 'data' => $countries];
            else
                return ['priority' => 'incomeLevels', 'data' => $incomeLevels];
        }
        else {
            if ($regions) {
                if ($countries)
                    return ['priority' => 'countries', 'data' => $countries];
                else
                    return ['priority' => 'regions', 'data' => $regions];
            }
            else {
                if ($countries) {
                    return ['priority' => 'countries', 'data' => $countries];
                }
                else {
                    return ['priority' => '', 'data' => []];
                }
            }
        }
    }


    public function chart(IIndicatorRepository $indicator, IIndicatorCategoryRepository $indicatorCategory,
                          IWBRegionRepository $worldBankRegions, IWBIncomeLevelRepository $worldBankIncomeLevels,
                            IUserIndicatorRepository $userIndicator){

        $countries = \request("countries");

        $regions = \request("regions");

        $incomeLevels = \request("incomeLevels");

        // Pick One Priority Out Of 3.
        $priorityList = $this->pickPriorityArray($incomeLevels, $regions, $countries);

        $previousYear = date('Y', strtotime(' - 2 years'));

        if (\request("periodTo")) {
            $period = [\request("periodFrom"), \request("periodTo")];
        }
        else {
            $period  = \request("periodFrom");
        }

        $ind = $indicator->find(\request("indicator_id"));

        $title = $ind ? $ind->indicator_name : '';

        $charts = [];

        if ($priorityList['data'] && count($priorityList['data'])) {
            foreach ($priorityList['data'] as $i => $each) {
                if ($priorityList['priority'] == 'countries'){
                    $country = $this->country->find($each);
                    $find = $country->abbr;
                }
                else{
                    $find = $each;
                }

                $jsonUrl = $this->worldBankApiGenerator($find, $ind->series_code, $period);
                $data = json_decode(file_get_contents($jsonUrl));

                if (isset($data[1])) {
                    $charts[] = [
                        'title'     => (isset($country) && $country ? $country->name." | ": ""). $title,
                        'div_id'    => "chart_".$i,
                        'data'      => Chart::worldBankApiCharts($data[1], $i, 'ChartJS-Single') // [1]-contains Data, [0]-contains Page Info Thus Ignored
                    ];
                }
            }
            // Combine Multiple Country Chart Data Into 1 Array For Combined Chart
//            $chart['data'] = $this->combineMultipleCountryChartData($itemChart);
        }

        // Get Saved Queries Array List
        $savedQueries = $this->getSavedQueryArray($userIndicator, $indicator, $indicatorCategory, $worldBankIncomeLevels, $worldBankRegions);

        debug($charts);
        //
        $this->viewData = [
            'period'            => $this->getYearPeriodManually(2000, $previousYear, TRUE ),
            'countries'         => $this->country->listModelVariable(['country','id']),
            'incomeLevels'      => $worldBankIncomeLevels->listModelVariable(['name', 'code']),
            'regions'           => $worldBankRegions->listModelVariable(['name', 'code']),
            'categories'        => $indicatorCategory->listModelVariable(['category', 'id'], TRUE),
            'indicators'        => $indicator->listModelVariable(['indicator_name', 'id'], TRUE),
            'charts'            => $charts,
            'savedQueries'      => $savedQueries,
            'userIndicatorId'   => \request("user_indicator_id")
        ];

        return view('country/chart', $this->viewData);

    }


    /**
     * Get Saved Queries Array List
     * @param $userIndicator
     * @param $indicator
     * @param $indicatorCategory
     * @param $worldBankIncomeLevels
     * @param $worldBankRegions
     * @return array
     */
    protected function getSavedQueryArray($userIndicator, $indicator, $indicatorCategory, $worldBankIncomeLevels, $worldBankRegions){
        $userIndicators = $userIndicator->findAllByAttributes(['user_id' => $this->authObject->user()->id]);
        $savedQueries = [];
        if (count($userIndicators)) {
            foreach ($userIndicators as $each) {
                $indLink = [
                    'indicator_id' => $each->indicator_id,
                    'category' => $each->indicator_category_id,
                    'periodFrom' => $each->period_from,
                    'periodTo' => $each->period_to
                ];

                $indUrl = route("homepage")."#". url('country/chart')."?user_indicator_id={$each->id}".
                    "&indicator_id={$each->indicator_id}".
                    "&category={$each->indicator_category_id}".
                    "&periodFrom={$each->period_from}".
                    "&periodTo={$each->period_to}";

                $indData = [
                    'indicator_id' => $indicator->find($each->indicator_id)->indicator_name,
                    'category' => $each->indicator_category_id ? $indicatorCategory->find($each->indicator_category_id)->category : '',
                    'periodFrom' => $each->period_from,
                    'periodTo' => $each->period_to
                ];

                $details = $each->details;
                foreach ($details as $item) {
                    if ($item->country_id) {
                        $indLink['countries'][] = $item->country_id;
                        $indData['countries'][] = $this->country->find($item->country_id)->country;
                        $indUrl .= "&countries[]={$item->country_id}";
                    }
                    if ($item->wb_income_level_id) {
                        $indLink['incomeLevels'][] = $item->wb_income_level_id;
                        $indData['incomeLevels'][] = $worldBankIncomeLevels->find($item->wb_income_level_id)->name;
                        $indUrl .= "&incomeLevels[]={$item->wb_income_level_id}";

                    }
                    if ($item->wb_region_id) {
                        $indLink['regions'][] = $item->wb_region_id;
                        $indData['regions'][] = $worldBankRegions->find($item->wb_region_id)->name;
                        $indUrl .= "&regions[]={$item->wb_region_id}";
                    }
                }

                $savedQueries[] = [
                    'id'   => $each->id,
                    'url'  => $indUrl,
                    'link' => $indLink,
                    'data' => $indData
                ];
            }
        }

        return $savedQueries;
    }


    /**
     * Combine Multiple Country Chart Data Into 1 Array For Combined Chart
     * @param $chartData
     * @return array
     */
    protected function combineMultipleCountryChartData($chartData){
        debug($chartData);
        $finalChart = [];
        foreach ($chartData as $i => $each) {
            foreach ($each as $j => $attr) {
                if ($j == 0) {
                    if (!isset($finalChart[$j])) {
                        $finalChart[$j] = [$attr];
                    } else {
                        if (!in_array($attr, $finalChart[$j])) {
                            $finalChart[$j][] = $attr;
                        }
                    }
                } else {
                    if (!isset($finalChart[$j][0])) {
                        $finalChart[$j][] = $attr;
                    }
                    if ($j > 0) {
                        $finalChart[$j][] = $attr;
                    }
                }
            }
        }
        return $finalChart;
    }

    /**
     * Make Manual Range Period Array For Select Boxes
     * @param $from
     * @param $to
     * @param bool $select
     * @return mixed
     */
    protected function getYearPeriodManually($from, $to, $select = FALSE){
        if ($select)
            $period[''] = 'Select';

        for ($i = $from; $i <= $to; $i++){
            $period[$i] =  $i ;
        }
        return $period;
    }


    /**
     * World Bank API For World Development Indicators
     * @param string $countryRegionIncomeLevel
     * @param bool $indicators
     * @param bool $date
     * @param bool $incomeLevelsOnly
     * @param bool $lendingTypesOnly
     * @param string $format
     * @param int $perPage
     * @return string
     */
    protected function worldBankApiGenerator($countryRegionIncomeLevel = 'all',
                                             $indicators = false,
                                             $date = false,
                                             $incomeLevelsOnly = false,
                                             $lendingTypesOnly = false,
                                             $format = 'json',
                                             $perPage = 1000){

        if ($incomeLevelsOnly){
            $apiUrl = "http://api.worldbank.org/incomeLevels";
        }
        else if ($lendingTypesOnly){
            $apiUrl = "http://api.worldbank.org/lendingTypes";
        }
        else {
            $apiUrl = "http://api.worldbank.org/countries/";

            // If Region Or Income Level Is Selected -> Priority 1
            if (is_array($countryRegionIncomeLevel)) {
                $countryRegionIncomeLevel = implode(';', $countryRegionIncomeLevel);
            }
            $apiUrl .= "{$countryRegionIncomeLevel}";

            // Indicator Selection
            if ($indicators) {
                $apiUrl .= "/indicators/{$indicators}";
            }

            $apiUrl .= "?";

            // Date Selection
            if ($date) {
                if (is_array($date))
                    $date = implode(':', $date);

                $apiUrl .= "date={$date}&";
            }
        }

        // Format Selection
        $apiUrl .= "format={$format}&per_page={$perPage}";

        return $apiUrl;
    }

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

}
