<?php

namespace App\Http\Controllers;

use App\Repositories\Interfaces\IAgencyCodeRepository;
use App\Repositories\Interfaces\IAgencyRepository;
use App\Repositories\Interfaces\ICityRepository;
use App\Repositories\Interfaces\ICountryRepository;
use App\Repositories\Interfaces\IDepartmentRepository;
use App\Repositories\Interfaces\IDivisionRepository;
use App\Repositories\Interfaces\IHomeChartRepository;
use App\Repositories\Interfaces\IModuleRepository;
use App\Repositories\Interfaces\IOrganizationLevelDetailsRepository;
use App\Repositories\Interfaces\IOrganizationLevelRepository;
use App\Repositories\Interfaces\IOrganizationRepository;
use App\Repositories\Interfaces\IPassengerRepository;
use App\Repositories\Interfaces\IPositionRepository;
use App\Repositories\Interfaces\IRegionRepository;
use App\Repositories\Interfaces\ITableRepository;
use App\Repositories\Interfaces\IUserDepartmentRepository;
use App\Repositories\Interfaces\IUserRepository;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;


class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected $authObject;

    protected $viewData = [];

    protected $gender = ['' => 'Select', 'male' => 'Male', 'female' => 'Female'];

    protected $businessCabinRbd = ['C', 'I', 'J', 'D', 'Z'];

    public function getAuthObject(Guard $auth){
        return $auth->authObject;
    }

    public function __construct(Guard $auth,
//                                IDivisionRepository $division,
                                IRegionRepository $region,
                                ICountryRepository $country,
                                ICityRepository $city,
//                                IPassengerRepository $passenger,
//                                IAgencyRepository $agency,
//                                IAgencyCodeRepository $agencyCode,
                                IOrganizationRepository $organization,
                                IOrganizationLevelRepository $organizationLevel,
                                IOrganizationLevelDetailsRepository $organizationLevelDetails,
                                ITableRepository $table,
                                IUserRepository $user,
                                IDepartmentRepository $department,
                                IPositionRepository $position,
                                IUserDepartmentRepository $userDepartment,
                                IModuleRepository $module,
                                IHomeChartRepository $homeChart){

        $this->authObject                   = $auth;
        $this->region                       = $region;
        $this->country                      = $country;
        $this->city                         = $city;
//        $this->division                     = $division;
//        $this->agency                       = $agency;
//        $this->agencyCode                   = $agencyCode;
//        $this->passenger                    = $passenger;
        $this->organization                 = $organization;
        $this->organizationLevel            = $organizationLevel;
        $this->organizationLevelDetails     = $organizationLevelDetails;
        $this->table                        = $table;
        $this->user                         = $user;
        $this->department                   = $department;
        $this->position                     = $position;
        $this->userDepartment               = $userDepartment;
        $this->module                       = $module;
        $this->homeChart                    = $homeChart;
    }

    protected function testOutput($data){
        return 123;
    }

    /**
     * Setup the layout used by the controller.
     * @return void
     */
    protected function setupLayout()
    {
        if (!is_null($this->layout))
        {
            $this->layout = view($this->layout);
        }
    }

    /**
     * Check request method for POST type
     * @return bool
     */
    protected function isPostRequest()
    {
        return request()->server("REQUEST_METHOD") == "POST";
    }
}
