<?php

namespace App\Http\Controllers;

use App\Models\Flight;
use App\Repositories\Interfaces\IFlightCrewRepository;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CheckInController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $this->viewData = [
            'user'          => null,
            'picture'       => asset('/assets/img/default-user-picture.png')
        ];

        return view('check-in/index', $this->viewData);
    }


    public function check(Request $request, IFlightCrewRepository $flightCrewRepository)
    {
        $credentials = $this->getLoginCredentials($request);
        if (Auth::attempt($credentials)) {
            flash()->success('Successfully Logged');
            $user =  Auth::user();

            if (checkIfCrew($user)){
                $now = date('Y-m-d H:i:s');
//                $crewFlights = $flightCrewRepository->findAllByAttributes(['user_id' => $user->id],[],[]);
                $crewFlights = Flight::join('flights__crew', 'flights__crew.flight_id', '=', 'flights.id')
                                    ->where('user_id', $user->id)
                                    ->where('std', '>=', $now)
                                    ->whereNull('flights.deleted_at')
                                    ->whereNull('flights__crew.deleted_at');

                debug($crewFlights);
            }

            return view('check-in/index', [
                'user'          => $user,
                'picture'       => asset("storage/users/{$user->picture}")
            ]);
        }

        flash()->error('Credentials invalid');
        return redirect()->back()
                    ->withInput();
    }

    protected function getLoginCredentials(Request $request)
    {
        return [
            "email"         => $request->get("email"),
            "password"      => $request->get("password")
        ];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
