<?php namespace App\Http\Controllers;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Models\Chart;
use Illuminate\Http\Request;


class ChartController extends Controller {

	/**
	 * Display a listing of the resource.
	 * @return Response
	 */
	public function index()
	{

	}

    /**
     * Display the specified resource.
     * @param Chart $chart
     * @return \Illuminate\View\View
     */
    public function show(Chart $chart)
    {
        $dateYesterday = date('Y-m-d', strtotime(" - 1 days"));
        $this->viewData = [
            'dateFrom'          => \request("dateFrom") ? \request("dateFrom") : $dateYesterday,
            'dateTo'            => \request("dateTo") ? \request("dateTo") : $dateYesterday,
            'selectedCharts'    => [$chart->id],
            'charts'            => Chart::pluck('chart', 'id')->all(),
            'chart'             => $chart,
            'chartData'         => Chart::getChartByName($chart->constant)
        ];
        return view('chart/show', $this->viewData);
    }

    /**
     * Get All Charts Submitted In Index Page
     */
    public function search(){
        $dateYesterday = date('Y-m-d', strtotime(" - 1 days"));

        $chartData = [];
        $maxRevenue = 0;
        $chartArray = [];

        if (count(request()->all())){
            $chartIds = \request("chart");
            $chartIds = is_array($chartIds) ? $chartIds : [$chartIds];
            foreach ($chartIds as $i => $id) {
                $chart = Chart::find($id);
                if ($chart) {
                    $group = \request("group") ? true : false;
                    $dateFrom = \request("dateFrom") ? \request("dateFrom") : $dateYesterday;
                    $dateTo = \request("dateTo") ? \request("dateTo") : $dateYesterday;
                    $revenueType = \request("revenue_type") ? \request("revenue_type") : "flown";
                    $label = "Period";
                    $data = Chart::getChartJSByName($chart->constant, false, $dateFrom, $dateTo, $revenueType, $label, $group);
                    $preparedData = [
                        'skip'          => $chart->constant == CHART_REVENUE_BY_COUNTRY ? 1 : 0,
                        'data'          => $data,
                        'keys'          => array_keys($data),
                        'chart_type'    => $chart->chartType->constant,
                        'div_id'        => $chart->constant . '_' . $i,
                        'title'         => $chart->chart,
                        'name'          => $chart->constant,
                        'image'         => $chart->image,
                    ];

                    if ($chart->constant == CHART_REVENUE_BY_COUNTRY){
                        $countryChart = $preparedData;
                    }
                    else {
                        $chartData[] = $preparedData;
                    }

                    if ($chart->constant == CHART_REVENUE_BY_COUNTRY) {
                        foreach ($data as $each) {
                            if ($each['abbr']) {
                                $maxRevenue = $each['revenue'] > $maxRevenue ? $each['revenue'] : $maxRevenue;
                                $chartArray[$each['abbr']] = $each['revenue'] ? $each['revenue'] : 0;
                            }
                        }
                    }

                }
            }
        }

        debug($chartData);

        $this->viewData = [
            'dateFrom'          => \request("dateFrom") ? \request("dateFrom") : $dateYesterday,
            'dateTo'            => \request("dateTo") ? \request("dateTo") : $dateYesterday,
            'selectedCharts'    => \request("chart") ? \request("chart") : [],
            'charts'            => Chart::pluck('chart', 'id')->all(),
            'chartData'         => $chartData,
            'countryChart'      => isset($countryChart) ? $countryChart : [],
            'chartArray'        => $chartArray,
            'maxRevenue'        => $maxRevenue,
        ];

        return view('chart/search', $this->viewData);
    }

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
		//
	}



	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
		//
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
	{
		//
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

}
